/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.Constant;
import com.yy.audioengine.IFilePlayerNotify;

public class FilePlayer {
    private IFilePlayerNotify mNotify = null;
    private long mPlayerCtx = this.nativeCreateFilePlayer(this);

    public void registerNotify(IFilePlayerNotify notify) {
        this.mNotify = notify;
    }

    public boolean open(String fileName) {
        return this.nativeOpen(this.mPlayerCtx, fileName);
    }

    public void destroy() {
        this.mPlayerCtx = this.nativeDestroy(this.mPlayerCtx);
    }

    public void play() {
        this.nativePlay(this.mPlayerCtx);
    }

    public void stop() {
        this.nativeStop(this.mPlayerCtx);
    }

    public void pause() {
        this.nativePause(this.mPlayerCtx);
    }

    public void fakePause() {
        this.nativeFakePause(this.mPlayerCtx);
    }

    public void resume() {
        this.nativeResume(this.mPlayerCtx);
    }

    public void enableLoopPlay(boolean enable) {
        this.nativeEnableLoopPlay(this.mPlayerCtx, enable);
    }

    public void seek(long targetMS) {
        this.nativeSeek(this.mPlayerCtx, targetMS);
    }

    public void seekSaver(long targetMS) {
        this.nativeSeekSaver(this.mPlayerCtx, targetMS);
    }

    public void setPlayerVolume(long volume) {
        this.nativeSetPlayerVolume(this.mPlayerCtx, volume);
    }

    public void enableVolumeNotify(boolean enable) {
        this.nativeEnableVolumeNotify(this.mPlayerCtx, enable);
    }

    public void setFeedBackToMicMode(FilePlayerMixerType mode) {
        long modeLong = mode.ordinal();
        this.nativeSetFeedBackToMicMode(this.mPlayerCtx, modeLong);
    }

    public void enableEffect(boolean enable) {
        this.nativeEnableEffect(this.mPlayerCtx, enable);
    }

    public void enableReverbEx(boolean enable) {
        this.nativeEnableReverbEx(this.mPlayerCtx, enable);
    }

    public void enableReverbFv3(boolean enable) {
        this.nativeEnableReverbFv3(this.mPlayerCtx, enable);
    }

    public void enableEqualizerEx(boolean enable) {
        this.nativeEnableEqualizerEx(this.mPlayerCtx, enable);
    }

    public void enableCompressor(boolean enable) {
        this.nativeEnableCompressor(this.mPlayerCtx, enable);
    }

    public void enableLimiter(boolean enable) {
        this.nativeEnableLimiter(this.mPlayerCtx, enable);
    }

    public void setReverbParameter(float[] parameterArray) {
        this.nativeSetReverbParameter(this.mPlayerCtx, parameterArray);
    }

    public void setEqualizerParameter(float[] parameterArray) {
        this.nativeSetEqualizerParameter(this.mPlayerCtx, parameterArray);
    }

    public void setCompressorParameter(int[] parameterArray) {
        this.nativeSetCompressorParam(this.mPlayerCtx, parameterArray);
    }

    public void setLimiterParam(float[] parameterArray) {
        this.nativeSetLimiterParam(this.mPlayerCtx, parameterArray);
    }

    public void setToneSelValue(int sel) {
        this.nativeSetToneSelValue(this.mPlayerCtx, sel);
    }

    public void setTrebleBassVal(int val) {
        this.nativeSetTrebleBassVal(this.mPlayerCtx, val);
    }

    public long getFileTimeMs() {
        return this.nativeGetTotalPlayLengthMS(this.mPlayerCtx);
    }

    public long getCurrentPlayTimeMS() {
        return this.nativeGetCurrentPlayTimeMS(this.mPlayerCtx);
    }

    public long getTotalPlayLengthMS() {
        return this.nativeGetTotalPlayLengthMS(this.mPlayerCtx);
    }

    public boolean startSaver(String fileName) {
        return this.nativeStartSaver(this.mPlayerCtx, fileName);
    }

    public boolean stopSaver() {
        return this.nativeStopSaver(this.mPlayerCtx);
    }

    public void enableMute(boolean enable) {
        this.nativeEnableMute(this.mPlayerCtx, enable);
    }

    public void enableEtb(boolean enable) {
        this.nativeEnableEtb(this.mPlayerCtx, enable);
    }

    public void enableDrc(boolean enable) {
        this.nativeEnableDrc(this.mPlayerCtx, enable);
    }

    public void enableDenoiser(boolean enable) {
        this.nativeEnableDenoiser(this.mPlayerCtx, enable);
    }

    public void setDenoiseType(Constant.DenoiseModuleType aecImproveNsType) {
        this.nativeSetDenoiseType(this.mPlayerCtx, aecImproveNsType.ordinal());
    }

    public boolean selectAudioTrack(int audioTrack) {
        return this.nativeSelectAudioTrack(this.mPlayerCtx, audioTrack);
    }

    public int getAudioTrackCount() {
        return this.nativeGetAudioTrackCount(this.mPlayerCtx);
    }

    public void setDspExEnable(boolean enable) {
        this.nativeSetDspExEnable(this.mPlayerCtx, enable);
    }

    public void setDspExReverbEnable(boolean enable) {
        this.nativeSetDspExReverbEnable(this.mPlayerCtx, enable);
    }

    public void setDspExLimiterEnable(boolean enable) {
        this.nativeSetDspExLimiterEnable(this.mPlayerCtx, enable);
    }

    public void setDspExEqEnable(boolean enable) {
        this.nativeSetDspExEqEnable(this.mPlayerCtx, enable);
    }

    public void setDspExReverbParam(float[] parameterArray) {
        this.nativeSetDspExReverbParam(this.mPlayerCtx, parameterArray);
    }

    public void setDspExLimiterParameter(float[] parameterArray) {
        this.nativeSetDspExLimiterParameter(this.mPlayerCtx, parameterArray);
    }

    public void setDspExEqGain(float[] parameterArray) {
        this.nativeSetDspEqualizerParameter(this.mPlayerCtx, parameterArray);
    }

    private void onPlayerEndEvent() {
        if (this.mNotify != null) {
            this.mNotify.onPlayerEnd();
        }
    }

    private void onPlayerVolumeEvent(int volume, long currentTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.onPlayerVolume(volume, currentTime, totalTime);
        }
    }

    private native long nativeCreateFilePlayer(Object var1);

    private native boolean nativeOpen(long var1, String var3);

    private native long nativeDestroy(long var1);

    private native void nativePlay(long var1);

    private native void nativeStop(long var1);

    private native void nativePause(long var1);

    private native void nativeFakePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeSeek(long var1, long var3);

    private native void nativeSeekSaver(long var1, long var3);

    private native void nativeSetPlayerVolume(long var1, long var3);

    private native void nativeSetFeedBackToMicMode(long var1, long var3);

    private native long nativeGetTotalPlayLengthMS(long var1);

    private native long nativeGetCurrentPlayTimeMS(long var1);

    private native void nativeSetToneSelValue(long var1, int var3);

    private native void nativeSetTrebleBassVal(long var1, int var3);

    private native void nativeEnableVolumeNotify(long var1, boolean var3);

    private native void nativeEnableLoopPlay(long var1, boolean var3);

    private native void nativeEnableEffect(long var1, boolean var3);

    private native void nativeEnableReverbEx(long var1, boolean var3);

    private native void nativeEnableReverbFv3(long var1, boolean var3);

    private native void nativeEnableEqualizerEx(long var1, boolean var3);

    private native void nativeEnableCompressor(long var1, boolean var3);

    private native void nativeEnableLimiter(long var1, boolean var3);

    private native void nativeSetReverbParameter(long var1, float[] var3);

    private native void nativeSetEqualizerParameter(long var1, float[] var3);

    private native void nativeSetCompressorParam(long var1, int[] var3);

    private native void nativeSetLimiterParam(long var1, float[] var3);

    private native boolean nativeStartSaver(long var1, String var3);

    private native boolean nativeStopSaver(long var1);

    private native void nativeEnableMute(long var1, boolean var3);

    private native void nativeEnableEtb(long var1, boolean var3);

    private native void nativeEnableDrc(long var1, boolean var3);

    private native void nativeEnableDenoiser(long var1, boolean var3);

    private native void nativeSetDenoiseType(long var1, int var3);

    private native boolean nativeSelectAudioTrack(long var1, int var3);

    private native int nativeGetAudioTrackCount(long var1);

    private native void nativeSetDspExEnable(long var1, boolean var3);

    private native void nativeSetDspExReverbEnable(long var1, boolean var3);

    private native void nativeSetDspExLimiterEnable(long var1, boolean var3);

    private native void nativeSetDspExEqEnable(long var1, boolean var3);

    private native void nativeSetDspExReverbParam(long var1, float[] var3);

    private native void nativeSetDspExLimiterParameter(long var1, float[] var3);

    private native void nativeSetDspEqualizerParameter(long var1, float[] var3);

    public static enum FilePlayerMixerType {
        LocalPlay,
        OverrideMic,
        MixWithMic;

    }
}

