/*
 * Decompiled with CFR 0.152.
 */
package com.yy.audioengine;

import com.yy.audioengine.AudioEngine;
import com.yy.audioengine.AudioFileMixer;
import com.yy.audioengine.AudioFileMixerPoint;
import com.yy.audioengine.Constant;
import com.yy.audioengine.FilePlayer;
import com.yy.audioengine.IAudioPlayBackAndMixNotify;
import com.yy.audioengine.IFileMixerNotify;
import com.yy.audioengine.IFilePlayerNotify;
import com.yy.audioengine.MainHandler;
import com.yy.audioengine.YALog;

public class AudioPlayBackAndMix
implements IFilePlayerNotify,
IFileMixerNotify {
    private static String TAG = "[AudioPlayBackAndMix]";
    private IAudioPlayBackAndMixNotify mNotify;
    private AudioEngine mAudioEngine;
    private FilePlayer mVoicePlayer;
    private FilePlayer mAccompanyFilePlayer;
    private AudioFileMixer mAudioFileMixer;
    private AudioFileMixerPoint mVoicePoint;
    private AudioFileMixerPoint mAccompanyPoint;
    private String mAacOutPath;

    public void initWithOutputAACPath(String aacOutPath) {
        YALog.info(TAG + "initWithOutputAACPath: " + aacOutPath);
        this.mAacOutPath = aacOutPath;
        this.mAudioEngine = new AudioEngine();
        this.mAudioEngine.startAudioEngine(Constant.AudioEngineMode.Broadcast);
        this.mVoicePlayer = new FilePlayer();
        this.mAccompanyFilePlayer = new FilePlayer();
        this.mVoicePlayer.enableVolumeNotify(true);
        this.mAccompanyFilePlayer.enableVolumeNotify(true);
        this.mAudioFileMixer = new AudioFileMixer();
        this.mAudioFileMixer.registerNotify(this);
    }

    public void destroy() {
        YALog.info(TAG + "destroy....");
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.destroy();
            this.mAccompanyFilePlayer = null;
        }
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.destroy();
            this.mVoicePlayer = null;
        }
        if (this.mVoicePoint != null) {
            this.mVoicePoint.close();
            this.mVoicePoint = null;
        }
        if (this.mAccompanyPoint != null) {
            this.mAccompanyPoint.close();
            this.mVoicePoint = null;
        }
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.destroy();
            this.mAudioFileMixer = null;
        }
        if (this.mAudioEngine != null) {
            this.mAudioEngine.destroy();
            this.mAudioEngine = null;
        }
        this.mNotify = null;
    }

    public void setAudioPlayBackAndMixNotify(IAudioPlayBackAndMixNotify iAudioPlayBackAndMixNotify) {
        this.mNotify = iAudioPlayBackAndMixNotify;
    }

    public void startPlay() {
        YALog.info(TAG + "startPlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.play();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.play();
        }
    }

    public void pausePlay() {
        YALog.info(TAG + "pausePlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.pause();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.pause();
        }
    }

    public void resumePlay() {
        YALog.info(TAG + "resumePlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.resume();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.resume();
        }
    }

    public void stopPlay() {
        YALog.info(TAG + "stopPlay....");
        if (this.mVoicePlayer != null) {
            this.mVoicePlayer.stop();
        }
        if (this.mAccompanyFilePlayer != null) {
            this.mAccompanyFilePlayer.stop();
        }
    }

    public void startMixVoice() {
        YALog.info(TAG + "startMixVoice....");
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.start(this.mAacOutPath);
        }
    }

    public void stopMixVoice() {
        YALog.info(TAG + "stopMixVoice....");
        if (this.mAudioFileMixer != null) {
            this.mAudioFileMixer.stop();
        }
    }

    public void setVoiceFilePath(String voicePath) {
        AudioFileMixerPoint point;
        YALog.info(TAG + "setVoiceFilePath....: " + voicePath);
        this.mVoicePlayer.open(voicePath);
        this.mVoicePlayer.registerNotify(this);
        if (this.mVoicePoint != null) {
            this.mVoicePoint.close();
            this.mVoicePoint = null;
        }
        if ((point = this.mAudioFileMixer.createMixerPoint()).open(voicePath)) {
            this.mVoicePoint = point;
        } else {
            point.close();
        }
    }

    public void setAccompanyFilePath(String accompanyFilePath) {
        AudioFileMixerPoint point;
        YALog.info(TAG + "setAccompanyFilePath....: " + accompanyFilePath);
        this.mAccompanyFilePlayer.open(accompanyFilePath);
        if (this.mAccompanyPoint != null) {
            this.mAccompanyPoint.close();
            this.mAccompanyPoint = null;
        }
        if ((point = this.mAudioFileMixer.createMixerPoint()).open(accompanyFilePath)) {
            this.mAccompanyPoint = point;
        } else {
            point.close();
        }
    }

    @Override
    public void onFileMixerState(long curTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.fileMixerProgress(curTime, totalTime);
        }
    }

    @Override
    public void onFinishMixer() {
        YALog.info(TAG + "OnFinishMixer....");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioPlayBackAndMix.this.mNotify != null) {
                    AudioPlayBackAndMix.this.mNotify.finishMixer();
                }
            }
        });
    }

    @Override
    public void onPlayerEnd() {
        YALog.info(TAG + "OnPlayerEnd....");
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (AudioPlayBackAndMix.this.mNotify != null) {
                    AudioPlayBackAndMix.this.mNotify.playBackEnd();
                }
            }
        });
    }

    @Override
    public void onPlayerVolume(int volume, long currentTime, long totalTime) {
        if (this.mNotify != null) {
            this.mNotify.playBackProgress(volume, currentTime, totalTime);
        }
    }
}

