/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.opengl.EGLContext;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.TextureView;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.List;
import org.extra.tools.Lifecycle;
import org.extra.tools.LifecycleListener;
import org.libpag.PAGComposition;
import org.libpag.PAGFile;
import org.libpag.PAGImage;
import org.libpag.PAGLayer;
import org.libpag.PAGPlayer;
import org.libpag.PAGSurface;
import org.libpag.PAGText;

public class PAGView
extends TextureView
implements TextureView.SurfaceTextureListener,
LifecycleListener {
    private static final String TAG = "PAGView";
    private TextureView.SurfaceTextureListener mListener;
    private PAGPlayer pagPlayer;
    private PAGSurface pagSurface;
    private PAGFile pagFile;
    private ValueAnimator animator;
    private boolean _isPlaying = false;
    private Boolean _isAnimatorPreRunning = null;
    private String filePath = "";
    private boolean isAttachedToWindow = false;
    private EGLContext sharedContext = null;
    private boolean mSaveVisibleState;
    private SparseArray<PAGText> textReplacementMap = new SparseArray();
    private SparseArray<PAGImage> imageReplacementMap = new SparseArray();
    private boolean isSync = false;
    private static final Object g_HandlerLock = new Object();
    private static PAGViewHandler g_PAGViewHandler = null;
    private static HandlerThread g_PAGViewThread = null;
    private static volatile int g_HandlerThreadCount = 0;
    private static final int MSG_FLUSH = 0;
    private static final int MSG_SURFACE_DESTROY = 1;
    private static final int MSG_HANDLER_THREAD_QUITE = 2;
    private static final int ANDROID_SDK_VERSION_O = 26;
    private ArrayList<PAGViewListener> mViewListeners = new ArrayList();
    private ArrayList<PAGFlushListener> mPAGFlushListeners = new ArrayList();
    private volatile long currentPlayTime;
    private final ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            PAGView.this.currentPlayTime = animation.getCurrentPlayTime();
            PAGView.NeedsUpdateView(PAGView.this);
        }
    };
    private final AnimatorListenerAdapter mAnimatorListenerAdapter = new AnimatorListenerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationStart(Animator animator) {
            ArrayList arrayList;
            super.onAnimationStart(animator);
            PAGView pAGView = PAGView.this;
            synchronized (pAGView) {
                arrayList = new ArrayList(PAGView.this.mViewListeners);
            }
            for (PAGViewListener listener : arrayList) {
                listener.onAnimationStart(PAGView.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            int repeatCount = ((ValueAnimator)animation).getRepeatCount();
            if (repeatCount >= 0 && PAGView.this.currentPlayTime / animation.getDuration() > (long)repeatCount) {
                ArrayList arrayList;
                PAGView pAGView = PAGView.this;
                synchronized (pAGView) {
                    arrayList = new ArrayList(PAGView.this.mViewListeners);
                }
                for (PAGViewListener listener : arrayList) {
                    listener.onAnimationEnd(PAGView.this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationCancel(Animator animator) {
            ArrayList arrayList;
            super.onAnimationCancel(animator);
            PAGView pAGView = PAGView.this;
            synchronized (pAGView) {
                arrayList = new ArrayList(PAGView.this.mViewListeners);
            }
            for (PAGViewListener listener : arrayList) {
                listener.onAnimationCancel(PAGView.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAnimationRepeat(Animator animator) {
            ArrayList arrayList;
            super.onAnimationRepeat(animator);
            PAGView pAGView = PAGView.this;
            synchronized (pAGView) {
                arrayList = new ArrayList(PAGView.this.mViewListeners);
            }
            for (PAGViewListener listener : arrayList) {
                listener.onAnimationRepeat(PAGView.this);
            }
        }
    };
    private Runnable mAnimatorStartRunnable = new Runnable(){

        @Override
        public void run() {
            if (PAGView.this.isAttachedToWindow) {
                PAGView.this.animator.start();
            } else {
                Log.e((String)PAGView.TAG, (String)"AnimatorStartRunnable: PAGView is not attached to window");
            }
        }
    };
    private Runnable mAnimatorCancelRunnable = new Runnable(){

        @Override
        public void run() {
            PAGView.this.currentPlayTime = PAGView.this.animator.getCurrentPlayTime();
            PAGView.this.animator.cancel();
        }
    };
    private boolean preAggregatedVisible = true;

    private static synchronized void StartHandlerThread() {
        ++g_HandlerThreadCount;
        if (g_PAGViewThread == null) {
            g_PAGViewThread = new HandlerThread("pag-renderer");
            g_PAGViewThread.start();
        }
        if (g_PAGViewHandler == null) {
            g_PAGViewHandler = new PAGViewHandler(g_PAGViewThread.getLooper());
        }
    }

    private static synchronized void DestroyHandlerThread() {
        if (--g_HandlerThreadCount != 0) {
            return;
        }
        if (g_PAGViewHandler == null || g_PAGViewThread == null) {
            return;
        }
        if (!g_PAGViewThread.isAlive()) {
            return;
        }
        PAGView.SendMessage(2, null);
    }

    private static void SendMessage(int msgId, Object obj) {
        if (g_PAGViewHandler == null) {
            return;
        }
        Message message = g_PAGViewHandler.obtainMessage();
        message.arg1 = msgId;
        if (obj != null) {
            message.obj = obj;
        }
        g_PAGViewHandler.sendMessage(message);
    }

    private static void NeedsUpdateView(PAGView pagView) {
        if (pagView.isSync) {
            pagView.updateView();
            return;
        }
        if (g_PAGViewHandler == null) {
            return;
        }
        g_PAGViewHandler.needsUpdateView(pagView);
    }

    private static void HandlerThreadQuit() {
        if (g_HandlerThreadCount != 0) {
            return;
        }
        if (g_PAGViewHandler == null || g_PAGViewThread == null) {
            return;
        }
        if (!g_PAGViewThread.isAlive()) {
            return;
        }
        g_PAGViewHandler.removeCallbacksAndMessages(null);
        if (Build.VERSION.SDK_INT > 18) {
            g_PAGViewThread.quitSafely();
        } else {
            g_PAGViewThread.quit();
        }
        g_PAGViewThread = null;
        g_PAGViewHandler = null;
    }

    public PAGView(Context context) {
        super(context);
        this.setupSurfaceTexture();
    }

    public PAGView(Context context, EGLContext sharedContext) {
        super(context);
        this.sharedContext = sharedContext;
        this.setupSurfaceTexture();
    }

    public PAGView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupSurfaceTexture();
    }

    public PAGView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupSurfaceTexture();
    }

    private void setupSurfaceTexture() {
        Lifecycle.getInstance().addListener(this);
        this.setOpaque(false);
        this.pagPlayer = new PAGPlayer();
        this.setSurfaceTextureListener(this);
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.setRepeatCount(0);
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animator.addUpdateListener(this.mAnimatorUpdateListener);
    }

    private void updateTextureView() {
        this.post(new Runnable(){

            @Override
            public void run() {
                boolean opaque = PAGView.this.isOpaque();
                PAGView.this.setOpaque(!opaque);
                PAGView.this.setOpaque(opaque);
            }
        });
    }

    private void updateView() {
        if (!this.isAttachedToWindow) {
            return;
        }
        this.flush();
        this.updateTextureView();
        if (!this.mPAGFlushListeners.isEmpty()) {
            this.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList arrayList;
                    PAGView pAGView = PAGView.this;
                    synchronized (pAGView) {
                        arrayList = new ArrayList(PAGView.this.mPAGFlushListeners);
                    }
                    for (PAGFlushListener listener : arrayList) {
                        listener.onFlush();
                    }
                }
            });
        }
    }

    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        if (listener == this) {
            super.setSurfaceTextureListener(listener);
        } else {
            this.mListener = listener;
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (this.pagSurface != null) {
            this.pagSurface.release();
            this.pagSurface = null;
        }
        this.pagSurface = PAGSurface.FromSurfaceTexture(surface, this.sharedContext);
        this.pagPlayer.setSurface(this.pagSurface);
        if (this.pagSurface == null) {
            return;
        }
        this.pagSurface.clearAll();
        PAGView.NeedsUpdateView(this);
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        if (this.pagSurface != null) {
            this.pagSurface.updateSize();
            this.pagSurface.clearAll();
            PAGView.NeedsUpdateView(this);
        }
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureSizeChanged(surfaceTexture, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.pagPlayer.setSurface(null);
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureDestroyed(surface);
        }
        if (this.pagSurface != null) {
            this.pagSurface.freeCache();
        }
        boolean surfaceDestroy = true;
        if (g_PAGViewHandler != null && surface != null) {
            PAGView.SendMessage(1, surface);
            surfaceDestroy = false;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = g_HandlerLock;
            synchronized (object) {
                PAGView.DestroyHandlerThread();
            }
        }
        return surfaceDestroy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        this.isAttachedToWindow = true;
        super.onAttachedToWindow();
        this.animator.addListener((Animator.AnimatorListener)this.mAnimatorListenerAdapter);
        Object object = g_HandlerLock;
        synchronized (object) {
            PAGView.StartHandlerThread();
        }
        this.resumeAnimator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        this.isAttachedToWindow = false;
        super.onDetachedFromWindow();
        if (this.pagSurface != null) {
            this.pagSurface.release();
            this.pagSurface = null;
        }
        this.pauseAnimator();
        if (Build.VERSION.SDK_INT < 26) {
            Object object = g_HandlerLock;
            synchronized (object) {
                PAGView.DestroyHandlerThread();
            }
        }
        this.animator.removeListener((Animator.AnimatorListener)this.mAnimatorListenerAdapter);
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureUpdated(surface);
        }
    }

    public boolean isPlaying() {
        if (this.animator != null) {
            return this.animator.isRunning();
        }
        return false;
    }

    public void play() {
        this._isPlaying = true;
        this._isAnimatorPreRunning = null;
        if ((double)this.animator.getAnimatedFraction() == 1.0) {
            this.setProgress(0.0);
        }
        this.doPlay();
    }

    private void doPlay() {
        this.pagPlayer.prepare();
        if (!this.isAttachedToWindow) {
            Log.e((String)TAG, (String)"doPlay: PAGView is not attached to window");
            return;
        }
        Log.i((String)TAG, (String)"doPlay");
        this.animator.setCurrentPlayTime(this.currentPlayTime);
        this.startAnimator();
    }

    public void stop() {
        Log.i((String)TAG, (String)"stop");
        this._isPlaying = false;
        this._isAnimatorPreRunning = null;
        this.cancelAnimator();
    }

    private boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    private void startAnimator() {
        if (this.isMainThread()) {
            this.animator.start();
        } else {
            this.removeCallbacks(this.mAnimatorCancelRunnable);
            this.post(this.mAnimatorStartRunnable);
        }
    }

    private void cancelAnimator() {
        if (this.isMainThread()) {
            this.currentPlayTime = this.animator.getCurrentPlayTime();
            this.animator.cancel();
        } else {
            this.removeCallbacks(this.mAnimatorStartRunnable);
            this.post(this.mAnimatorCancelRunnable);
        }
    }

    public void setRepeatCount(int value) {
        if (value < 0) {
            value = 0;
        }
        this.animator.setRepeatCount(value - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PAGViewListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mViewListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PAGViewListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mViewListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPAGFlushListener(PAGFlushListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mPAGFlushListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePAGFlushListener(PAGFlushListener listener) {
        PAGView pAGView = this;
        synchronized (pAGView) {
            this.mPAGFlushListeners.remove(listener);
        }
    }

    public String getPath() {
        return this.filePath;
    }

    public boolean setPath(String path) {
        PAGFile pagFile = path != null && path.startsWith("assets://") ? PAGFile.Load(this.getContext().getAssets(), path.substring(9)) : PAGFile.Load(path);
        this.setComposition(pagFile);
        this.filePath = path;
        return pagFile != null;
    }

    public PAGComposition getComposition() {
        return this.pagPlayer.getComposition();
    }

    public void setComposition(PAGComposition newComposition) {
        this.filePath = null;
        this.pagFile = null;
        this.pagPlayer.setComposition(newComposition);
        long duration = this.pagPlayer.duration();
        this.animator.setDuration(duration / 1000L);
    }

    public boolean videoEnabled() {
        return this.pagPlayer.videoEnabled();
    }

    public void setVideoEnabled(boolean enable) {
        this.pagPlayer.setVideoEnabled(enable);
    }

    public boolean cacheEnabled() {
        return this.pagPlayer.cacheEnabled();
    }

    public void setCacheEnabled(boolean value) {
        this.pagPlayer.setCacheEnabled(value);
    }

    public float cacheScale() {
        return this.pagPlayer.cacheScale();
    }

    public void setCacheScale(float value) {
        this.pagPlayer.setCacheScale(value);
    }

    public float maxFrameRate() {
        return this.pagPlayer.maxFrameRate();
    }

    public void setMaxFrameRate(float value) {
        this.pagPlayer.setMaxFrameRate(value);
    }

    public int scaleMode() {
        return this.pagPlayer.scaleMode();
    }

    public void setScaleMode(int mode) {
        this.pagPlayer.setScaleMode(mode);
    }

    public Matrix matrix() {
        return this.pagPlayer.matrix();
    }

    public void setMatrix(Matrix matrix) {
        this.pagPlayer.setMatrix(matrix);
    }

    public long duration() {
        return this.pagPlayer.duration();
    }

    public double getProgress() {
        return this.animator.getAnimatedFraction();
    }

    public void setProgress(double value) {
        value = Math.max(0.0, Math.min(value, 1.0));
        this.currentPlayTime = (long)(value * (double)this.animator.getDuration());
        this.animator.setCurrentPlayTime(this.currentPlayTime);
    }

    public boolean isSync() {
        return this.isSync;
    }

    public void setSync(boolean isSync) {
        this.isSync = isSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() {
        ArrayList<PAGViewListener> arrayList;
        this.pagPlayer.setProgress(this.animator.getAnimatedFraction());
        boolean result = this.pagPlayer.flush();
        PAGView pAGView = this;
        synchronized (pAGView) {
            arrayList = new ArrayList<PAGViewListener>(this.mViewListeners);
        }
        for (PAGViewListener listener : arrayList) {
            listener.onAnimationUpdate(this);
        }
        return result;
    }

    public PAGLayer[] getLayersUnderPoint(float x, float y) {
        return this.pagPlayer.getLayersUnderPoint(x, y);
    }

    public void freeCache() {
        if (this.pagSurface != null) {
            this.pagSurface.freeCache();
        }
    }

    public void setBackgroundDrawable(Drawable background) {
        if (Build.VERSION.SDK_INT < 24 && background != null) {
            super.setBackgroundDrawable(background);
        }
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (this.preAggregatedVisible == isVisible) {
            return;
        }
        this.preAggregatedVisible = isVisible;
        Log.i((String)TAG, (String)("onVisibilityAggregated isVisible=" + isVisible));
        if (isVisible) {
            this.resumeAnimator();
        } else {
            this.pauseAnimator();
        }
    }

    @Override
    public void onResume() {
        if (this.isAttachedToWindow && this.getVisibility() == 0) {
            this.setVisibility(4);
            this.setVisibility(0);
        }
    }

    private void pauseAnimator() {
        if (this._isAnimatorPreRunning == null) {
            this._isAnimatorPreRunning = this.animator.isRunning();
        }
        if (this.animator.isRunning()) {
            this.cancelAnimator();
        }
    }

    private void resumeAnimator() {
        if (!this._isPlaying || this.animator.isRunning() || this._isAnimatorPreRunning != null && !this._isAnimatorPreRunning.booleanValue()) {
            this._isAnimatorPreRunning = null;
            this.updateTextureView();
            return;
        }
        this._isAnimatorPreRunning = null;
        this.doPlay();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.animator.removeUpdateListener(this.mAnimatorUpdateListener);
    }

    public static interface PAGFlushListener {
        public void onFlush();
    }

    public static interface PAGViewListener {
        public void onAnimationStart(PAGView var1);

        public void onAnimationEnd(PAGView var1);

        public void onAnimationCancel(PAGView var1);

        public void onAnimationRepeat(PAGView var1);

        public void onAnimationUpdate(PAGView var1);
    }

    static class PAGViewHandler
    extends Handler {
        private final Object lock = new Object();
        private List<PAGView> needsUpdateViews = new ArrayList<PAGView>();

        PAGViewHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void needsUpdateView(PAGView pagView) {
            Object object = this.lock;
            synchronized (object) {
                if (this.needsUpdateViews.isEmpty()) {
                    Message message = this.obtainMessage();
                    message.arg1 = 0;
                    this.sendMessage(message);
                }
                this.needsUpdateViews.add(pagView);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.arg1) {
                case 0: {
                    ArrayList<PAGView> tempList;
                    Object object = this.lock;
                    synchronized (object) {
                        tempList = new ArrayList<PAGView>(this.needsUpdateViews);
                        this.needsUpdateViews.clear();
                    }
                    ArrayList<PAGView> flushedViews = new ArrayList<PAGView>();
                    for (Object e : tempList) {
                        PAGView pagView;
                        if (!(e instanceof PAGView) || flushedViews.contains(pagView = (PAGView)e)) continue;
                        pagView.updateView();
                        flushedViews.add(pagView);
                    }
                    break;
                }
                case 1: {
                    if (!(msg.obj instanceof SurfaceTexture)) {
                        return;
                    }
                    SurfaceTexture surfaceTexture = (SurfaceTexture)msg.obj;
                    surfaceTexture.release();
                    break;
                }
                case 2: {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            PAGView.HandlerThreadQuit();
                        }
                    });
                    break;
                }
            }
        }
    }
}

