/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.QCloudHttpRequest;

public class COSXmlSigner
implements QCloudSigner {
    static final String COS_SESSION_TOKEN = "x-cos-security-token";

    @Override
    public void sign(QCloudHttpRequest request, QCloudCredentials credentials) throws QCloudClientException {
        if (credentials == null) {
            throw new QCloudClientException(new QCloudAuthenticationException("Credentials is null."));
        }
        COSXmlSignSourceProvider sourceProvider = (COSXmlSignSourceProvider)request.getSignProvider();
        if (sourceProvider == null) {
            throw new QCloudClientException(new QCloudAuthenticationException("No sign provider for cos xml signer."));
        }
        StringBuilder authorization = new StringBuilder();
        QCloudLifecycleCredentials lifecycleCredentials = (QCloudLifecycleCredentials)credentials;
        String keyTime = lifecycleCredentials.getKeyTime();
        sourceProvider.setSignTime(keyTime);
        String signature = this.signature(sourceProvider.source(request), lifecycleCredentials.getSignKey());
        authorization.append("q-sign-algorithm").append("=").append("sha1").append("&").append("q-ak").append("=").append(credentials.getSecretId()).append("&").append("q-sign-time").append("=").append(keyTime).append("&").append("q-key-time").append("=").append(lifecycleCredentials.getKeyTime()).append("&").append("q-header-list").append("=").append(sourceProvider.getRealHeaderList().toLowerCase()).append("&").append("q-url-param-list").append("=").append(sourceProvider.getRealParameterList().toLowerCase()).append("&").append("q-signature").append("=").append(signature);
        String auth = authorization.toString();
        request.removeHeader("Authorization");
        request.addHeader("Authorization", auth);
        if (credentials instanceof SessionQCloudCredentials) {
            SessionQCloudCredentials sessionCredentials = (SessionQCloudCredentials)credentials;
            request.removeHeader(COS_SESSION_TOKEN);
            request.addHeader(COS_SESSION_TOKEN, sessionCredentials.getToken());
        }
        sourceProvider.onSignRequestSuccess(request, credentials, auth);
    }

    private String signature(String source, String signKey) {
        byte[] sha1Bytes = Utils.hmacSha1(source, signKey);
        String signature = "";
        if (sha1Bytes != null) {
            signature = new String(Utils.encodeHex(sha1Bytes));
        }
        return signature;
    }
}

