/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BasicLifecycleCredentialProvider
implements QCloudCredentialProvider {
    private volatile QCloudLifecycleCredentials credentials;
    private ReentrantLock lock = new ReentrantLock();

    @Override
    public QCloudCredentials getCredentials() throws QCloudClientException {
        QCloudLifecycleCredentials cred = this.safeGetCredentials();
        if (cred == null || !cred.isValid()) {
            this.refresh();
            return this.safeGetCredentials();
        }
        return cred;
    }

    @Override
    public void refresh() throws QCloudClientException {
        block10: {
            boolean locked = false;
            try {
                locked = this.lock.tryLock(20L, TimeUnit.SECONDS);
                if (!locked) {
                    throw new QCloudClientException(new QCloudAuthenticationException("lock timeout, no credential for sign"));
                }
                QCloudLifecycleCredentials cred = this.safeGetCredentials();
                if (cred != null && cred.isValid()) break block10;
                this.safeSetCredentials(null);
                try {
                    QCloudLifecycleCredentials newCredentials = this.fetchNewCredentials();
                    this.safeSetCredentials(newCredentials);
                }
                catch (Exception e) {
                    if (e instanceof QCloudClientException) {
                        throw e;
                    }
                    throw new QCloudClientException("fetch credentials error happens", new QCloudAuthenticationException(e.getMessage()));
                }
            }
            catch (InterruptedException e) {
                throw new QCloudClientException("interrupt when try to get credential", new QCloudAuthenticationException(e.getMessage()));
            }
            finally {
                if (locked) {
                    this.lock.unlock();
                }
            }
        }
    }

    private synchronized void safeSetCredentials(QCloudLifecycleCredentials credentials) {
        this.credentials = credentials;
    }

    private synchronized QCloudLifecycleCredentials safeGetCredentials() {
        return this.credentials;
    }

    protected abstract QCloudLifecycleCredentials fetchNewCredentials() throws QCloudClientException;
}

