/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.signaling;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageOfflinePushInfo;
import com.tencent.imsdk.signaling.SignalingInfo;
import com.tencent.imsdk.signaling.SignalingListener;
import java.util.List;

public class SignalingManager {
    private static String TAG = "SignalingManager";
    private SignalingListener mInternalSignalingListener;
    private SignalingListener mSignalingListener;

    public static SignalingManager getInstance() {
        return SignalingManagerHolder.signalingManager;
    }

    public void init() {
        this.initSignalingListener();
    }

    private void initSignalingListener() {
        if (this.mInternalSignalingListener == null) {
            this.mInternalSignalingListener = new SignalingListener(){

                @Override
                public void onReceiveNewInvitation(final String inviteID, final String inviter, final String groupID, final List<String> inviteeList, final String data) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (SignalingManager.this.mSignalingListener != null) {
                                SignalingManager.this.mSignalingListener.onReceiveNewInvitation(inviteID, inviter, groupID, inviteeList, data);
                            }
                        }
                    });
                }

                @Override
                public void onInviteeAccepted(final String inviteID, final String invitee, final String data) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (SignalingManager.this.mSignalingListener != null) {
                                SignalingManager.this.mSignalingListener.onInviteeAccepted(inviteID, invitee, data);
                            }
                        }
                    });
                }

                @Override
                public void onInviteeRejected(final String inviteID, final String invitee, final String data) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (SignalingManager.this.mSignalingListener != null) {
                                SignalingManager.this.mSignalingListener.onInviteeRejected(inviteID, invitee, data);
                            }
                        }
                    });
                }

                @Override
                public void onInvitationCancelled(final String inviteID, final String inviter, final String data) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (SignalingManager.this.mSignalingListener != null) {
                                SignalingManager.this.mSignalingListener.onInvitationCancelled(inviteID, inviter, data);
                            }
                        }
                    });
                }

                @Override
                public void onInvitationTimeout(final String inviteID, final List<String> inviteeList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (SignalingManager.this.mSignalingListener != null) {
                                SignalingManager.this.mSignalingListener.onInvitationTimeout(inviteID, inviteeList);
                            }
                        }
                    });
                }

                @Override
                public void onInvitationModified(final String inviteID, final String data) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (SignalingManager.this.mSignalingListener != null) {
                                SignalingManager.this.mSignalingListener.onInvitationModified(inviteID, data);
                            }
                        }
                    });
                }
            };
        }
        this.nativeSetSignalingObserver(this.mInternalSignalingListener);
    }

    public void setSignalingListener(SignalingListener listener) {
        this.mSignalingListener = listener;
    }

    public String invite(String invitee, String data, boolean onlineUserOnly, MessageOfflinePushInfo offlinePushInfo, int timeout, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return null;
        }
        return this.nativeInvite(invitee, data, onlineUserOnly, offlinePushInfo, timeout, callback);
    }

    public String inviteInGroup(String groupID, List<String> inviteeList, String data, boolean onlineUserOnly, int timeout, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return null;
        }
        return this.nativeInviteInGroup(groupID, inviteeList, data, onlineUserOnly, timeout, callback);
    }

    public void cancel(String inviteID, String data, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCancel(inviteID, data, callback);
    }

    public void accept(String inviteID, String data, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAccept(inviteID, data, callback);
    }

    public void reject(String inviteID, String data, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeReject(inviteID, data, callback);
    }

    public SignalingInfo getSignalingInfo(Message message) {
        if (!BaseManager.getInstance().isInited()) {
            IMLog.e(TAG, "getSignalingInfo error, sdk not init");
            return null;
        }
        return this.nativeGetSignalingInfo(message);
    }

    public void addInvitedSignaling(SignalingInfo signalingInfo, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            IMLog.e(TAG, "addInvitedSignaling error, sdk not init");
            return;
        }
        this.nativeAddInvitedSignaling(signalingInfo, callback);
    }

    public void modifyInvitation(String inviteID, String data, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            IMLog.e(TAG, "modifyInvitation error, sdk not init");
            return;
        }
        this.nativeModifyInvitation(inviteID, data, callback);
    }

    protected native void nativeSetSignalingObserver(SignalingListener var1);

    protected native String nativeInvite(String var1, String var2, boolean var3, MessageOfflinePushInfo var4, int var5, IMCallback var6);

    protected native String nativeInviteInGroup(String var1, List<String> var2, String var3, boolean var4, int var5, IMCallback var6);

    protected native void nativeCancel(String var1, String var2, IMCallback var3);

    protected native void nativeAccept(String var1, String var2, IMCallback var3);

    protected native void nativeReject(String var1, String var2, IMCallback var3);

    protected native SignalingInfo nativeGetSignalingInfo(Message var1);

    protected native void nativeAddInvitedSignaling(SignalingInfo var1, IMCallback var2);

    protected native void nativeModifyInvitation(String var1, String var2, IMCallback var3);

    private static class SignalingManagerHolder {
        private static final SignalingManager signalingManager = new SignalingManager();

        private SignalingManagerHolder() {
        }
    }
}

