/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.common;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Debug;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.imsdk.common.CpuUsageMeasurer;
import com.tencent.imsdk.common.IMContext;
import java.io.File;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.regex.Pattern;

public class SystemUtil {
    private static final String TAG = SystemUtil.class.getSimpleName();
    private static final int TIME_INTERVAL = 15000;
    private static boolean mFirstTimeRun = true;
    private static boolean sRunningMemCheck = false;
    private static int lastMemUsage = 0;
    private static float lastAppCpu = 0.0f;
    private static float lastSysCpu = 0.0f;
    private static long lastMemCheckTimeStamps = 0L;
    private static long lastAppCpuTime = 0L;
    private static long lastSysCpuTime = 0L;
    private static CpuUsageMeasurer sCpuUsageMeasurer;
    private static String buildBrand;
    private static String buildManufacturer;
    private static String buildModel;
    private static String buildVersionRelease;
    private static int buildVersionSDKInt;
    private static String currentProcessName;
    private static final String DEVICE_INFO = "DeviceInfo";
    private static final String DEVICE_ID = "DeviceID";
    private static boolean sIsLoadLibrarySuccess;
    private static boolean sIsLoadQuicLibrarySuccess;
    private static boolean sIsLoadAdvancedEncryptionLibrarySuccess;

    public static boolean isQuicPluginLibraryLoaded() {
        return sIsLoadQuicLibrarySuccess;
    }

    public static boolean loadIMLibrary() {
        return SystemUtil.loadIMLibrary(null);
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    public static boolean loadIMLibrary(String libraryDirPath) {
        if (!sIsLoadLibrarySuccess) {
            sIsLoadLibrarySuccess = SystemUtil.loadIMSDKLibrary(libraryDirPath);
        }
        if (!sIsLoadQuicLibrarySuccess) {
            sIsLoadQuicLibrarySuccess = SystemUtil.loadPluginLibrary(libraryDirPath, "TIMQuicPlugin");
        }
        if (!sIsLoadAdvancedEncryptionLibrarySuccess) {
            sIsLoadAdvancedEncryptionLibrarySuccess = SystemUtil.loadPluginLibrary(libraryDirPath, "TIMAdvancedEncryptionPlugin");
        }
        return sIsLoadLibrarySuccess;
    }

    private static boolean loadIMSDKLibrary(String libraryDirPath) {
        try {
            if (!TextUtils.isEmpty((CharSequence)libraryDirPath)) {
                String libraryName = "libImSDK.so";
                String libraryFullPath = libraryDirPath + File.separator + libraryName;
                System.load(libraryFullPath);
                Log.i((String)TAG, (String)("system load so library success: " + libraryFullPath));
            } else {
                System.loadLibrary("ImSDK");
                Log.i((String)TAG, (String)"system load so library success, libImSDK.so");
            }
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)("system load so library failed, " + e.getMessage()));
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("system load so library failed, " + e.getMessage()));
            return false;
        }
        return true;
    }

    private static boolean loadPluginLibrary(String libraryDirPath, String libraryName) {
        if (TextUtils.isEmpty((CharSequence)libraryName)) {
            return false;
        }
        String libraryFullName = "lib" + libraryName + ".so";
        try {
            if (!TextUtils.isEmpty((CharSequence)libraryDirPath)) {
                String libraryFullPath = libraryDirPath + File.separator + libraryFullName;
                System.load(libraryFullPath);
                Log.i((String)TAG, (String)("system load so library success: " + libraryFullPath));
            } else {
                System.loadLibrary(libraryName);
                Log.i((String)TAG, (String)("system load so library success, " + libraryFullName));
            }
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void setBuildModel(String model) {
        buildModel = model;
    }

    public static void setBuildBrand(String brand) {
        buildBrand = brand;
    }

    public static void setBuildManufacturer(String manufacturer) {
        buildManufacturer = manufacturer;
    }

    public static void setBuildVersionRelease(String versionRelease) {
        buildVersionRelease = versionRelease;
    }

    public static void setBuildVersionSDKInt(int versionSDKInt) {
        buildVersionSDKInt = versionSDKInt;
    }

    public static String getDeviceType() {
        if (TextUtils.isEmpty((CharSequence)buildModel)) {
            buildModel = Build.MODEL;
        }
        return buildModel;
    }

    public static String getSystemVersion() {
        if (TextUtils.isEmpty((CharSequence)buildVersionRelease)) {
            buildVersionRelease = Build.VERSION.RELEASE;
        }
        return buildVersionRelease;
    }

    public static int getSDKVersion() {
        if (buildVersionSDKInt == 0) {
            buildVersionSDKInt = Build.VERSION.SDK_INT;
        }
        return buildVersionSDKInt;
    }

    public static String getDeviceID() {
        Context context = IMContext.getInstance().getApplicationContext();
        if (null == context) {
            return "";
        }
        String deviceId = "";
        boolean isNeedSave = false;
        SharedPreferences preferences = context.getSharedPreferences(DEVICE_INFO, 0);
        if (!preferences.contains(DEVICE_ID)) {
            deviceId = UUID.randomUUID().toString();
            isNeedSave = true;
        } else {
            String pattern = "\\w{8}(-\\w{4}){3}-\\w{12}";
            deviceId = preferences.getString(DEVICE_ID, "");
            boolean isMatch = Pattern.matches(pattern, deviceId);
            if (!isMatch || TextUtils.isEmpty((CharSequence)deviceId)) {
                deviceId = UUID.randomUUID().toString();
                isNeedSave = true;
            }
        }
        if (isNeedSave) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(DEVICE_ID, deviceId);
            editor.apply();
        }
        return deviceId;
    }

    public static int getInstanceType() {
        int vendorId = 2002;
        if (SystemUtil.isBrandXiaoMi()) {
            vendorId = 2000;
        } else if (SystemUtil.isBrandNewHonor()) {
            vendorId = 2006;
        } else if (SystemUtil.isBrandHuawei()) {
            vendorId = 2001;
        } else if (SystemUtil.isBrandMeizu()) {
            vendorId = 2003;
        } else if (SystemUtil.isBrandOppo()) {
            vendorId = 2004;
        } else if (SystemUtil.isBrandVivo()) {
            vendorId = 2005;
        } else if (SystemUtil.isBrandNIO()) {
            return 2007;
        }
        return vendorId;
    }

    static boolean isBrandXiaoMi() {
        String brandXiaoMi = "xiaomi";
        return brandXiaoMi.equalsIgnoreCase(SystemUtil.getBuildBrand()) || brandXiaoMi.equalsIgnoreCase(SystemUtil.getBuildManufacturer());
    }

    static boolean isBrandHuawei() {
        String brandHuaWei = "huawei";
        String brandHonor = "honor";
        return brandHuaWei.equalsIgnoreCase(SystemUtil.getBuildBrand()) || brandHuaWei.equalsIgnoreCase(SystemUtil.getBuildManufacturer()) || brandHonor.equalsIgnoreCase(SystemUtil.getBuildBrand());
    }

    static boolean isBrandMeizu() {
        String brandMeiZu = "meizu";
        return brandMeiZu.equalsIgnoreCase(SystemUtil.getBuildBrand()) || brandMeiZu.equalsIgnoreCase(SystemUtil.getBuildManufacturer());
    }

    static boolean isBrandOppo() {
        return "oppo".equalsIgnoreCase(SystemUtil.getBuildBrand()) || "oppo".equalsIgnoreCase(SystemUtil.getBuildManufacturer()) || "realme".equalsIgnoreCase(SystemUtil.getBuildBrand()) || "realme".equalsIgnoreCase(SystemUtil.getBuildManufacturer()) || "oneplus".equalsIgnoreCase(SystemUtil.getBuildBrand()) || "oneplus".equalsIgnoreCase(SystemUtil.getBuildManufacturer());
    }

    static boolean isBrandVivo() {
        String brandVivo = "vivo";
        return brandVivo.equalsIgnoreCase(SystemUtil.getBuildBrand()) || brandVivo.equalsIgnoreCase(SystemUtil.getBuildManufacturer());
    }

    static boolean isBrandNewHonor() {
        return "honor".equalsIgnoreCase(SystemUtil.getBuildBrand()) && "honor".equalsIgnoreCase(SystemUtil.getBuildManufacturer());
    }

    static boolean isBrandNIO() {
        return "nio".equalsIgnoreCase(SystemUtil.getBuildBrand()) && "nio".equalsIgnoreCase(SystemUtil.getBuildManufacturer());
    }

    private static String getBuildBrand() {
        if (TextUtils.isEmpty((CharSequence)buildBrand)) {
            buildBrand = Build.BRAND;
        }
        return buildBrand;
    }

    private static String getBuildManufacturer() {
        if (TextUtils.isEmpty((CharSequence)buildManufacturer)) {
            buildManufacturer = Build.MANUFACTURER;
        }
        return buildManufacturer;
    }

    public static String getSDKInitPath() {
        Context context = IMContext.getInstance().getApplicationContext();
        if (null == context) {
            return "";
        }
        String initPath = context.getFilesDir().toString();
        String mainProcessName = context.getPackageName();
        String currentProcessName = SystemUtil.getCurrentProcessName();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName) && !mainProcessName.equals(currentProcessName)) {
            try {
                String pathSuffix = currentProcessName;
                int index = currentProcessName.lastIndexOf(":");
                if (index < 0) {
                    index = currentProcessName.lastIndexOf(".");
                }
                if (index >= 0) {
                    pathSuffix = currentProcessName.substring(index + 1);
                }
                initPath = initPath + File.separator + pathSuffix + File.separator;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getSDKInitPath exception = " + e));
            }
        }
        Log.d((String)TAG, (String)("SDK Init Path: " + initPath));
        return initPath;
    }

    public static String getSDKLogPath() {
        Context context = IMContext.getInstance().getApplicationContext();
        if (null == context) {
            return "";
        }
        String logPath = "";
        File filesDir = context.getExternalFilesDir(null);
        logPath = filesDir == null ? "/sdcard/Android/data/" + context.getPackageName() + "/log/tencent/imsdk" : filesDir.getAbsolutePath() + File.separator + "log" + File.separator + "tencent" + File.separator + "imsdk";
        File file = new File(logPath);
        if (!file.exists() && !file.mkdirs()) {
            file = context.getFilesDir();
            Log.e((String)TAG, (String)"create log folder failed");
        }
        logPath = file.getAbsolutePath() + File.separator;
        String mainProcessName = context.getPackageName();
        String currentProcessName = SystemUtil.getCurrentProcessName();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName) && !mainProcessName.equals(currentProcessName)) {
            try {
                String pathSuffix = currentProcessName;
                int index = currentProcessName.lastIndexOf(":");
                if (index < 0) {
                    index = currentProcessName.lastIndexOf(".");
                }
                if (index >= 0) {
                    pathSuffix = currentProcessName.substring(index + 1);
                }
                logPath = logPath + pathSuffix + File.separator;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getSDKLogPath exception = " + e));
            }
        }
        Log.d((String)TAG, (String)("SDK LOG Path: " + logPath));
        return logPath;
    }

    public static String md5(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result = result + temp;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static float getAppCpuUsage() {
        float appCpuUsagePercent;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - lastAppCpuTime < 15000L) {
            return lastAppCpu;
        }
        int[] cpuUsage = SystemUtil.getProcessCPURate();
        int appCpuUsage = cpuUsage[0] / 10;
        lastAppCpu = appCpuUsagePercent = (float)appCpuUsage / 100.0f;
        lastAppCpuTime = currentTimeMillis;
        return appCpuUsagePercent;
    }

    public static float getSysCpuUsage() {
        float systemCpuUsagePercent;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - lastSysCpuTime < 15000L) {
            return lastSysCpu;
        }
        int[] cpuUsage = SystemUtil.getProcessCPURate();
        int systemCpuUsage = cpuUsage[1] / 10;
        lastSysCpu = systemCpuUsagePercent = (float)systemCpuUsage / 100.0f;
        lastSysCpuTime = currentTimeMillis;
        return systemCpuUsagePercent;
    }

    static int[] getProcessCPURate() {
        if (sCpuUsageMeasurer == null) {
            sCpuUsageMeasurer = new CpuUsageMeasurer();
        }
        if (mFirstTimeRun) {
            mFirstTimeRun = false;
            sCpuUsageMeasurer.getCpuUsage();
            return new int[]{0, 0};
        }
        return sCpuUsageMeasurer.getCpuUsage();
    }

    public static float getAppMemory() {
        final long currentTimeMillis = System.currentTimeMillis();
        if (sRunningMemCheck || lastMemCheckTimeStamps != 0L && currentTimeMillis - lastMemCheckTimeStamps < 15000L) {
            return lastMemUsage;
        }
        sRunningMemCheck = true;
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                int totalPss = 0;
                long ts = System.currentTimeMillis();
                sRunningMemCheck = false;
                try {
                    Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
                    Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
                    totalPss = memoryInfo.getTotalPss();
                    lastMemCheckTimeStamps = currentTimeMillis;
                    lastMemUsage = totalPss / 1024;
                }
                catch (Exception e) {
                    totalPss = 0;
                }
            }
        });
        return lastMemUsage;
    }

    public static String getCurrentProcessName() {
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            currentProcessName = Application.getProcessName();
            return currentProcessName;
        }
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                currentProcessName = (String)invoke;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return currentProcessName;
    }

    public static String getAppName() {
        String appName = "";
        Context context = IMContext.getInstance().getApplicationContext();
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            packageManager.getApplicationLabel(applicationInfo);
            CharSequence labelCharSequence = applicationInfo.loadLabel(packageManager);
            if (labelCharSequence != null && labelCharSequence.length() > 0) {
                appName = labelCharSequence.toString();
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("getAppName exception:" + e.getMessage()));
        }
        return appName;
    }

    static {
        buildBrand = "";
        buildManufacturer = "";
        buildModel = "";
        buildVersionRelease = "";
        buildVersionSDKInt = 0;
        currentProcessName = "";
        sIsLoadLibrarySuccess = false;
        sIsLoadQuicLibrarySuccess = false;
        sIsLoadAdvancedEncryptionLibrarySuccess = false;
    }
}

