package com.tencent.imsdk.relationship;

import com.tencent.imsdk.officialaccount.OfficialAccountInfo;

import java.util.List;

public abstract class FriendshipListener {
    public void onSelfInfoUpdated(UserInfo userInfo) {}

    public void onFriendInfoChanged(List<FriendInfo> friendInfoList) {}

    public void onFriendListAdded(List<FriendInfo> friendInfoList) {}

    public void onFriendListDeleted(List<String> userIDList) {}

    public void onBlackListAdded(List<FriendInfo> friendInfoList) {}

    public void onBlackListDeleted(List<String> userIDList) {}

    public void onFriendApplicationListAdded(List<FriendApplication> applicationList) {}

    public void onFriendApplicationListDelete(List<String> userIDList) {}

    public void onFriendApplicationListRead() {}

    public void onUserStatusChanged(List<UserStatus> userStatusList) {}

    public void onUserInfoChanged(List<UserInfo> userInfoList) {}

    public void onAllReceiveMessageOptChanged(ReceiveMessageOptInfo option) {}

    public void onMyFollowingListChanged(List<UserInfo> userInfoList, boolean isAdd) {}

    public void onMyFollowersListChanged(List<UserInfo> userInfoList, boolean isAdd) {}

    public void onMutualFollowersListChanged(List<UserInfo> userInfoList, boolean isAdd) {}

    public void onOfficialAccountSubscribed(OfficialAccountInfo officialAccountInfo) {}

    public void onOfficialAccountUnsubscribed(String officialAccountID) {}

    public void onOfficialAccountDeleted(String officialAccountID) {}

    public void onOfficialAccountInfoChanged(OfficialAccountInfo officialAccountInfo) {}
}
