package com.tencent.imsdk.message;

import com.tencent.imsdk.v2.V2TIMMessage;
import java.util.ArrayList;
import java.util.List;

public class MergerElement extends MessageBaseElement {
    private String compatibleText;
    private String title;
    private List<String> abstractList = new ArrayList<>();
    private List<Message> messageList = new ArrayList<>();
    private String relayPbKey;
    private String relayJsonKey;
    private byte[] relayBuffer;
    private int messageNumber;
    private boolean layerOverLimit = false;

    public MergerElement() {
        setElementType(V2TIMMessage.V2TIM_ELEM_TYPE_MERGER);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCompatibleText() {
        return compatibleText;
    }

    public void setCompatibleText(String compatibleText) {
        this.compatibleText = compatibleText;
    }

    public List<String> getAbstractList() {
        return abstractList;
    }

    public void setAbstractList(List<String> abstractList) {
        this.abstractList = abstractList;
    }

    protected void addAbstract(String abstractContent) {
        if (abstractList != null && abstractContent != null) {
            abstractList.add(abstractContent);
        }
    }

    public void setMessageList(List<Message> messageList) {
        this.messageList = messageList;
    }

    public boolean isLayerOverLimit() {
        return layerOverLimit;
    }
}
