package com.tencent.imsdk.community;

import android.text.TextUtils;

import java.io.UnsupportedEncodingException;

public class PermissionGroupInfo {
    public static long MODIFY_FLAG_NONE = 0;
    public static long MODIFY_FLAG_PERMISSION_GROUP_NAME = 0x1;
    public static long MODIFY_FLAG_PERMISSION_GROUP_PERMISSION = 0x1 << 1;
    public static long MODIFY_FLAG_PERMISSION_GROUP_CUSTOM_STRING = 0x1 << 2;

    private String groupID;
    private String permissionGroupID;
    private byte[] permissionGroupNameBytes;
    private long groupPermission;
    private String customData;
    private long memberCount;

    public String getGroupID() {
        return groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public String getPermissionGroupID() {
        return permissionGroupID;
    }

    public void setPermissionGroupID(String permissionGroupID) {
        this.permissionGroupID = permissionGroupID;
    }

    public String getPermissionGroupName() {
        String permissionGroupName = "";
        if (permissionGroupNameBytes != null && permissionGroupNameBytes.length > 0) {
            try {
                permissionGroupName = new String(permissionGroupNameBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        return permissionGroupName;
    }

    public void setPermissionGroupName(String permissionGroupName) {
        if (!TextUtils.isEmpty(permissionGroupName)) {
            try {
                this.permissionGroupNameBytes = permissionGroupName.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public long getGroupPermission() {
        return groupPermission;
    }

    public void setGroupPermission(long groupPermission) {
        this.groupPermission = groupPermission;
    }

    public String getCustomData() {
        return customData;
    }

    public void setCustomData(String customData) {
        this.customData = customData;
    }

    public long getMemberCount() {
        return memberCount;
    }

}
