/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.crashreport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tencent.bugly.BuglyStrategy;
import com.tencent.bugly.CrashModule;
import com.tencent.bugly.crashreport.common.info.a;
import com.tencent.bugly.crashreport.crash.BuglyBroadcastReceiver;
import com.tencent.bugly.crashreport.crash.c;
import com.tencent.bugly.crashreport.crash.d;
import com.tencent.bugly.crashreport.crash.h5.H5JavaScriptInterface;
import com.tencent.bugly.crashreport.crash.h5.b;
import com.tencent.bugly.crashreport.crash.jni.NativeCrashHandler;
import com.tencent.bugly.proguard.q;
import com.tencent.bugly.proguard.w;
import com.tencent.bugly.proguard.x;
import com.tencent.bugly.proguard.z;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CrashReport {
    private static Context a;

    public static void enableBugly(boolean bl) {
        com.tencent.bugly.b.a = bl;
    }

    public static void initCrashReport(Context context) {
        a = context;
        com.tencent.bugly.b.a(CrashModule.getInstance());
        com.tencent.bugly.b.a(context);
    }

    public static void initCrashReport(Context context, UserStrategy userStrategy) {
        a = context;
        com.tencent.bugly.b.a(CrashModule.getInstance());
        com.tencent.bugly.b.a(context, userStrategy);
    }

    public static void initCrashReport(Context context, String string, boolean bl) {
        BuglyStrategy buglyStrategy = null;
        if (context != null) {
            a = context;
            com.tencent.bugly.b.a(CrashModule.getInstance());
            com.tencent.bugly.b.a(context, string, bl, buglyStrategy);
        }
    }

    public static void initCrashReport(Context context, String string, boolean bl, UserStrategy userStrategy) {
        if (context == null) {
            return;
        }
        a = context;
        com.tencent.bugly.b.a(CrashModule.getInstance());
        com.tencent.bugly.b.a(context, string, bl, userStrategy);
    }

    public static String getBuglyVersion(Context context) {
        if (context == null) {
            x.d("Please call with context.", new Object[0]);
            return "unknown";
        }
        com.tencent.bugly.crashreport.common.info.a.a(context);
        return com.tencent.bugly.crashreport.common.info.a.c();
    }

    public static void testJavaCrash() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not test Java crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        a a2 = com.tencent.bugly.crashreport.common.info.a.b();
        if (a2 != null) {
            a2.b(24096);
        }
        throw new RuntimeException("This Crash create for Test! You can go to Bugly see more detail!");
    }

    public static void testNativeCrash() {
        CrashReport.testNativeCrash(false, false, false);
    }

    public static void testNativeCrash(boolean bl, boolean bl2, boolean bl3) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not test native crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        x.a("start to create a native crash for test!", new Object[0]);
        c.a().a(bl, bl2, bl3);
    }

    public static void testANRCrash() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not test ANR crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        x.a("start to create a anr crash for test!", new Object[0]);
        c.a().j();
    }

    public static void postException(Thread thread, int n2, String string, String string2, String string3, Map<String, String> map) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        d.a(thread, n2, string, string2, string3, map);
    }

    public static void postException(int n2, String string, String string2, String string3, Map<String, String> map) {
        CrashReport.postException(Thread.currentThread(), n2, string, string2, string3, map);
    }

    public static void postCatchedException(Throwable throwable) {
        Thread thread = Thread.currentThread();
        CrashReport.postCatchedException(throwable, thread, false);
    }

    public static void postCatchedException(Throwable throwable, Thread thread) {
        CrashReport.postCatchedException(throwable, thread, false);
    }

    public static void postCatchedException(Throwable throwable, Thread thread, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (throwable == null) {
            x.d("throwable is null, just return", new Object[0]);
            return;
        }
        if (thread == null) {
            thread = Thread.currentThread();
        }
        c.a().a(thread, throwable, false, null, null, bl);
    }

    public static void closeNativeReport() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not close native report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().f();
    }

    public static void startCrashReport() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not start crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().c();
    }

    public static void closeCrashReport() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not close crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().d();
    }

    public static void closeBugly() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not close bugly because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (a == null) {
            return;
        }
        Object object = BuglyBroadcastReceiver.getInstance();
        if (object != null) {
            object.unregister(a);
        }
        CrashReport.closeCrashReport();
        com.tencent.bugly.crashreport.biz.b.a(a);
        object = w.a();
        if (object != null) {
            ((w)object).b();
        }
    }

    public static void setUserSceneTag(Context context, int n2) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set tag caught because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"setTag args context should not be null");
            return;
        }
        if (n2 <= 0) {
            x.d("setTag args tagId should > 0", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(n2);
        x.b("[param] set user scene tag: %d", n2);
    }

    public static int getUserSceneTagId(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get user scene tag because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserSceneTagId args context should not be null");
            return -1;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).H();
    }

    public static String getUserData(Context context, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserDataValue args context should not be null");
            return "unknown";
        }
        if (z.a(string)) {
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).g(string);
    }

    public static void putUserData(Context context, String string, String string2) {
        Object object;
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not put user data because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)x.a, (String)"putUserData args context should not be null");
            return;
        }
        if (string == null) {
            x.d("putUserData args key should not be null or empty", new Object[0]);
            return;
        }
        if (string2 == null) {
            x.d("putUserData args value should not be null", new Object[0]);
            return;
        }
        if (!string.matches("[a-zA-Z[0-9]]+")) {
            x.d("putUserData args key should match [a-zA-Z[0-9]]+  {" + string + "}", new Object[0]);
            return;
        }
        if (string2.length() > 200) {
            x.d("user data value length over limit %d, it will be cutted!", 200);
            string2 = string2.substring(0, 200);
        }
        if (((a)(object = com.tencent.bugly.crashreport.common.info.a.a(context))).E().contains(string)) {
            object = NativeCrashHandler.getInstance();
            if (object != null) {
                ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
            }
            com.tencent.bugly.crashreport.common.info.a.a(context).b(string, string2);
            x.c("replace KV %s %s", string, string2);
            return;
        }
        if (((a)object).D() >= 10) {
            x.d("user data size is over limit %d, it will be cutted!", 10);
            return;
        }
        if (string.length() > 50) {
            x.d("user data key length over limit %d , will drop this new key %s", 50, string);
            string = string.substring(0, 50);
        }
        if ((object = NativeCrashHandler.getInstance()) != null) {
            ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).b(string, string2);
        x.b("[param] set user data: %s - %s", string, string2);
    }

    public static String removeUserData(Context context, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not remove user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            Log.e((String)x.a, (String)"removeUserData args context should not be null");
            return "unknown";
        }
        if (z.a(string)) {
            return null;
        }
        x.b("[param] remove user data: %s", string);
        return com.tencent.bugly.crashreport.common.info.a.a(context).f(string);
    }

    public static Set<String> getAllUserDataKeys(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get all keys of user data because bugly is disable.");
            return new HashSet<String>();
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getAllUserDataKeys args context should not be null");
            return new HashSet<String>();
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).E();
    }

    public static int getUserDatasSize(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get size of user data because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserDatasSize args context should not be null");
            return -1;
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).D();
    }

    public static String getAppID() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get App ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).f();
    }

    public static void setUserId(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        CrashReport.setUserId(a, string);
    }

    public static void setUserId(Context context, String object) {
        Object object2;
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"Context should not be null when bugly has not been initialed!");
            return;
        }
        if (object == null) {
            x.d("userId should not be null", new Object[0]);
            return;
        }
        if (((String)object).length() > 100) {
            object2 = ((String)object).substring(0, 100);
            x.d("userId %s length is over limit %d substring to %s", object, 100, object2);
            object = object2;
        }
        if (((String)object).equals(com.tencent.bugly.crashreport.common.info.a.a(context).g())) {
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).b((String)object);
        x.b("[user] set userId : %s", object);
        object2 = NativeCrashHandler.getInstance();
        if (object2 != null) {
            ((NativeCrashHandler)object2).setNativeUserId((String)object);
        }
        if (CrashModule.getInstance().hasInitialized()) {
            com.tencent.bugly.crashreport.biz.b.a();
        }
    }

    public static String getUserId() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get user ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a(a).g();
    }

    public static String getAppVer() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get app version because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).j;
    }

    public static String getAppChannel() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get App channel because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).l;
    }

    public static void setContext(Context context) {
        a = context;
    }

    public static boolean isLastSessionCrash() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"The info 'isLastSessionCrash' is not accurate because bugly is disable.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return false;
        }
        return c.a().b();
    }

    public static void setSdkExtraData(Context context, String string, String string2) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not put SDK extra data because bugly is disable.");
            return;
        }
        if (context == null || z.a(string) || z.a(string2)) {
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(string, string2);
    }

    public static Map<String, String> getSdkExtraData() {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).A;
    }

    public static Map<String, String> getSdkExtraData(Context context) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return null;
        }
        return com.tencent.bugly.crashreport.common.info.a.a((Context)context).A;
    }

    private static void putSdkData(Context context, String string, String string2) {
        if (context == null || z.a(string) || z.a(string2)) {
            return;
        }
        if ((string = string.replace("[a-zA-Z[0-9]]+", "")).length() > 100) {
            Log.w((String)x.a, (String)String.format("putSdkData key length over limit %d, will be cutted.", 50));
            string = string.substring(0, 50);
        }
        if (string2.length() > 500) {
            Log.w((String)x.a, (String)String.format("putSdkData value length over limit %d, will be cutted!", 200));
            string2 = string2.substring(0, 200);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).c(string, string2);
        x.b(String.format("[param] putSdkData data: %s - %s", string, string2), new Object[0]);
    }

    public static void setIsAppForeground(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set 'isAppForeground' because bugly is disable.");
            return;
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            x.c("App is in foreground.", new Object[0]);
        } else {
            x.c("App is in background.", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(bl);
    }

    public static void setIsDevelopmentDevice(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set 'isDevelopmentDevice' because bugly is disable.");
            return;
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            x.c("This is a development device.", new Object[0]);
        } else {
            x.c("This is not a development device.", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).y = bl;
    }

    public static void setSessionIntervalMills(long l2) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set 'SessionIntervalMills' because bugly is disable.");
            return;
        }
        com.tencent.bugly.crashreport.biz.b.a(l2);
    }

    public static void setAppVersion(Context object, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App version because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppVersion args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App version is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)object).j = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppVersion(string);
        }
    }

    public static void setAppChannel(Context object, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App channel because Bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppChannel args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App channel is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)object).l = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppChannel(string);
        }
    }

    public static void setAppPackage(Context object, String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppPackage args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App package is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)object).c = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppPackage(string);
        }
    }

    public static void setCrashFilter(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set crash stack filter: " + string));
        c.n = string;
    }

    public static void setCrashRegularFilter(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set crash stack filter: " + string));
        c.o = string;
    }

    public static void setHandleNativeCrashInJava(boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Should handle native crash in Java profile after handled in native profile: " + bl));
        NativeCrashHandler.setShouldHandleInJava(bl);
    }

    public static void setBuglyDbName(String string) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set DB name because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set Bugly DB name: " + string));
        q.a = string;
    }

    public static void enableObtainId(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set DB name because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)x.a, (String)"enableObtainId args context should not be null");
            return;
        }
        Log.i((String)x.a, (String)("Enable identification obtaining? " + bl));
        com.tencent.bugly.crashreport.common.info.a.a(context).b(bl);
    }

    public static void setAuditEnable(Context context, boolean bl) {
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)x.a, (String)"setAppPackage args context should not be null");
            return;
        }
        Log.i((String)x.a, (String)("Set audit enable: " + bl));
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).B = bl;
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean bl) {
        return CrashReport.setJavascriptMonitor(webView, bl, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebView object, boolean bl, boolean bl2) {
        if (object == null) {
            Log.w((String)x.a, (String)"WebView is null.");
            return false;
        }
        object = new WebViewInterface((WebView)object){
            private /* synthetic */ WebView a;
            {
                this.a = webView;
            }

            @Override
            public final String getUrl() {
                return this.a.getUrl();
            }

            @Override
            public final void setJavaScriptEnabled(boolean bl) {
                WebSettings webSettings = this.a.getSettings();
                if (!webSettings.getJavaScriptEnabled()) {
                    webSettings.setJavaScriptEnabled(true);
                }
            }

            @Override
            public final void loadUrl(String string) {
                this.a.loadUrl(string);
            }

            @Override
            public final void addJavascriptInterface(H5JavaScriptInterface h5JavaScriptInterface, String string) {
                this.a.addJavascriptInterface((Object)h5JavaScriptInterface, string);
            }

            @Override
            public final CharSequence getContentDescription() {
                return this.a.getContentDescription();
            }
        };
        return CrashReport.setJavascriptMonitor((WebViewInterface)object, bl, bl2);
    }

    public static boolean setJavascriptMonitor(WebViewInterface webViewInterface, boolean bl) {
        return CrashReport.setJavascriptMonitor(webViewInterface, bl, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebViewInterface webViewInterface, boolean bl, boolean n2) {
        if (webViewInterface == null) {
            Log.w((String)x.a, (String)"WebViewInterface is null.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            x.e("CrashReport has not been initialed! please to call method 'initCrashReport' first!", new Object[0]);
            return false;
        }
        x.a("Set Javascript exception monitor of webview.", new Object[0]);
        if (!com.tencent.bugly.b.a) {
            Log.w((String)x.a, (String)"Can not set JavaScript monitor because bugly is disable.");
            return false;
        }
        x.c("URL of webview is %s", webViewInterface.getUrl());
        if (!n2 && (n2 = Build.VERSION.SDK_INT) < 19) {
            x.e("This interface is only available for Android 4.4 or later.", new Object[0]);
            return false;
        }
        x.a("Enable the javascript needed by webview monitor.", new Object[0]);
        webViewInterface.setJavaScriptEnabled(true);
        H5JavaScriptInterface h5JavaScriptInterface = H5JavaScriptInterface.getInstance(webViewInterface);
        if (h5JavaScriptInterface != null) {
            x.a("Add a secure javascript interface to the webview.", new Object[0]);
            webViewInterface.addJavascriptInterface(h5JavaScriptInterface, "exceptionUploader");
        }
        if (bl) {
            x.a("Inject bugly.js(v%s) to the webview.", b.b());
            String string = b.a();
            if (string == null) {
                x.e("Failed to inject Bugly.js.", b.b());
                return false;
            }
            webViewInterface.loadUrl("javascript:" + string);
        }
        return true;
    }

    public static interface WebViewInterface {
        public String getUrl();

        public void setJavaScriptEnabled(boolean var1);

        public void loadUrl(String var1);

        public void addJavascriptInterface(H5JavaScriptInterface var1, String var2);

        public CharSequence getContentDescription();
    }

    public static class CrashHandleCallback
    extends BuglyStrategy.a {
    }

    public static class UserStrategy
    extends BuglyStrategy {
        private CrashHandleCallback a;

        public UserStrategy(Context context) {
        }

        @Override
        public synchronized CrashHandleCallback getCrashHandleCallback() {
            return this.a;
        }

        public synchronized void setCrashHandleCallback(CrashHandleCallback crashHandleCallback) {
            this.a = crashHandleCallback;
        }
    }
}

