/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.internal.JsonFormatter;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\u0002j\u0002`\u0003H\u0016J\u0014\u0010\t\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/squareup/wire/internal/DurationJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "Ljava/time/Duration;", "Lcom/squareup/wire/Duration;", "<init>", "()V", "toStringOrNumber", "", "value", "fromString", "wire-runtime"})
public final class DurationJsonFormatter
implements JsonFormatter<Duration> {
    @NotNull
    public static final DurationJsonFormatter INSTANCE = new DurationJsonFormatter();

    private DurationJsonFormatter() {
    }

    @NotNull
    public String toStringOrNumber(@NotNull Duration value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        long seconds = value.getSeconds();
        int nanos = value.getNano();
        String prefix = "";
        if (seconds < 0L) {
            if (seconds == Long.MIN_VALUE) {
                prefix = "-922337203685477580";
                seconds = 8L;
            } else {
                prefix = "-";
                seconds = -seconds;
            }
            if (nanos != 0) {
                --seconds;
                nanos = 1000000000 - nanos;
            }
        }
        if (nanos == 0) {
            String string2 = "%s%ds";
            Object[] objectArray = new Object[]{prefix, seconds};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else if (nanos % 1000000 == 0) {
            String string4 = "%s%d.%03ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000000L};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else if (nanos % 1000 == 0) {
            String string6 = "%s%d.%06ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000L};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        } else {
            String string8 = "%s%d.%09ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1L};
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public Duration fromString(@NotNull String value) {
        int nanosDigits;
        int i;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int sIndex = StringsKt.indexOf$default((CharSequence)value, (char)'s', (int)0, (boolean)false, (int)6, null);
        if (sIndex != value.length() - 1) {
            throw new NumberFormatException();
        }
        int dotIndex = StringsKt.indexOf$default((CharSequence)value, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex == -1) {
            String string = value.substring(0, sIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            long seconds = Long.parseLong(string);
            Duration duration = Duration.ofSeconds(seconds);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            return duration;
        }
        String string = value.substring(0, dotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        long seconds = Long.parseLong(string);
        String string2 = value.substring(dotIndex + 1, sIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        long nanos = Long.parseLong(string2);
        if (StringsKt.startsWith$default((String)value, (String)"-", (boolean)false, (int)2, null)) {
            nanos = -nanos;
        }
        for (i = nanosDigits = sIndex - (dotIndex + 1); i < 9; ++i) {
            nanos *= (long)10;
        }
        for (i = 9; i < nanosDigits; ++i) {
            nanos /= (long)10;
        }
        Duration duration = Duration.ofSeconds(seconds, nanos);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return duration;
    }
}

