/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.thunder.livesdk.ExternalVideoSource;
import com.thunder.livesdk.ThunderAPI;
import com.thunder.livesdk.ThunderDefaultCamera;
import com.thunder.livesdk.ThunderPlayerView;
import com.thunder.livesdk.ThunderPreviewConfig;
import com.thunder.livesdk.ThunderPreviewView;
import com.thunder.livesdk.ThunderPublisher;
import com.thunder.livesdk.ThunderRtcConstant;
import com.thunder.livesdk.ThunderScreenCapture;
import com.thunder.livesdk.ThunderVideoCapture;
import com.thunder.livesdk.helper.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.helper.UidMap;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.video.ThunderVideoConfig;
import com.thunder.livesdk.video.ThunderVideoHiidoUtil;
import com.thunder.livesdk.video.ThunderVideoPlayListener;
import com.thunder.livesdk.video.VideoFrameYuvCapture;
import com.thunder.livesdk.video.serviceConfig.VideoConfigManager;
import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.PublishVideoConfig;
import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThunderVideoEngineImp
implements IPublishListener,
ITextureListener {
    public static final int YYPUBLISH_VIDEO_STATE_NONE = 0;
    public static final int YYPUBLISH_VIDEO_STATE_PREVIEW = 1;
    public static final int YYPUBLISH_VIDEO_STATE_ENCODE = 2;
    ConcurrentHashMap<String, ThunderPlayerView> mVideoViewMap;
    ConcurrentHashMap<String, Long> mVideoViewStreamKeyAndIdMap;
    ConcurrentHashMap<String, Integer> mVideoScaleModeMap;
    HashMap<String, IVideoDecodeObserver> mVideoFrameObserverMap;
    ConcurrentHashMap<String, Boolean> mVideoFrameObserverEnableMap;
    ConcurrentHashMap<String, Boolean> mVideoViewDecodeType;
    HashMap<Long, Long> mStreamIdAndDecoderPtsMap;
    HashMap<String, HighLowStreamInfo> mHighLowStreamMap;
    ConcurrentHashMap<String, ThunderPlayerView> mRecoverVideoViewMap;
    private VideoPublish mPublisher = null;
    private long mCallBackPtr = 0L;
    private boolean bMixMode = false;
    private ThunderVideoCapture mCapture;
    private OrangeFilterWrapper mOrangeFilterWrapper;
    private ThunderVideoHiidoUtil mThunderVideoHiidoUtil;
    private static final int VIDEO_STAT_FPS = 0;
    private static final int VIDEO_STAT_BITRATE = 1;
    private static final int VIDEO_STATE_RESOLUTION = 2;
    private VideoConfigManager mVideoConfigManager;
    private int mVideoPublishState = 0;
    private int mVideoPreviewState = 0;
    private YVideoPublishVideoConfig mCurrentVideoConfig = null;
    private Handler mUiHandler = null;
    private Map<String, WeakReference> mPlayViewAndStreamKeyMap = new HashMap<String, WeakReference>();
    private VideoFrameYuvCapture mVideoFrameCapture = VideoFrameYuvCapture.getInstance();
    private ThunderVideoPlayListener mThunderVideoPlayListener = null;
    private boolean mIsEnableWebSdkCompatibility = false;
    private Boolean mScreenCaptureInited = false;
    private Boolean mOriginYuvCaptureInited = false;

    public ThunderVideoEngineImp() {
        final CountDownLatch waitSync = new CountDownLatch(1);
        Runnable runTestVideoEncoderCrash = new Runnable(){

            @Override
            public void run() {
                try {
                    YYVideoCodec.testVideoEncoderCrash();
                }
                catch (Exception e) {
                    ThunderLog.error("ThunderVideoEngineImp", "testVideoEncoderCrash crash " + e.toString());
                }
                waitSync.countDown();
            }
        };
        new Thread(runTestVideoEncoderCrash).start();
        try {
            waitSync.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ThunderLog.error("ThunderVideoEngineImp", "testVideoEncoderCrash waitSync crash " + e.toString());
        }
    }

    public void init() {
        this.mVideoViewMap = new ConcurrentHashMap();
        this.mVideoScaleModeMap = new ConcurrentHashMap();
        this.mVideoViewStreamKeyAndIdMap = new ConcurrentHashMap();
        this.mVideoFrameObserverMap = new HashMap();
        this.mVideoFrameObserverEnableMap = new ConcurrentHashMap();
        this.mVideoViewDecodeType = new ConcurrentHashMap();
        this.mRecoverVideoViewMap = new ConcurrentHashMap();
        this.mStreamIdAndDecoderPtsMap = new HashMap();
        this.mHighLowStreamMap = new HashMap();
        this.mPublisher = VideoPublish.getInstance();
        this.mVideoConfigManager = VideoConfigManager.instance();
        this.mThunderVideoHiidoUtil = new ThunderVideoHiidoUtil(YYVideoLibMgr.instance().getAppContext());
        this.mThunderVideoHiidoUtil.register();
        this.mThunderVideoPlayListener = new ThunderVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this);
        YYVideoLibMgr.instance().setVideoInfoListener((IVideoLibInfoExt)this.mThunderVideoPlayListener);
        YYVideoLibMgr.instance().setVideoInfoCallback((IVideoInfoCallback)this.mThunderVideoPlayListener);
        this.mUiHandler = new Handler(Looper.getMainLooper());
        ThunderVideoConfig config = new ThunderVideoConfig();
        config.AsyncLoad();
    }

    public void setPreviewScaleMode(int scaleMode) {
        if (this.mPublisher != null) {
            this.mPublisher.setScaleMode(scaleMode);
        }
    }

    public static String getVideoEngineVersion() {
        return "Android: 200.0.21&200.1.2.5";
    }

    private void prepareView(final ThunderPlayerView view, final int decoderType) {
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                view.prepareView(decoderType);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
        }
    }

    public int updatePlayVideoStream(final String streamKey, final long streamId, final int streamType, final boolean bSoftDecode) {
        ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream streamKey:" + streamKey + " streamId:" + streamId + " streamType:" + streamType + " bSoftDecode:" + bSoftDecode);
        final int[] result = new int[]{-1};
        if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
            result[0] = this.updatePlayVideoStreamUI(streamKey, streamId, streamType, bSoftDecode);
        } else {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    result[0] = ThunderVideoEngineImp.this.updatePlayVideoStreamUI(streamKey, streamId, streamType, bSoftDecode);
                }
            });
        }
        return result[0];
    }

    public void setLowDelayMode(boolean mode) {
        if (this.mCurrentVideoConfig != null && this.mCurrentVideoConfig.bLowLatency != mode) {
            this.mPublisher.setLowDelayMode(mode);
            this.mCurrentVideoConfig.bLowLatency = mode;
        }
        ThunderLog.info("ThunderVideoEngineImp", "setLowDelayMode new mode " + mode + " old :" + (this.mCurrentVideoConfig != null ? Boolean.valueOf(this.mCurrentVideoConfig.bLowLatency) : "null"));
    }

    public int setDecodeType(String streamKey, int streamType) {
        int scaleMode;
        final int decodeType = this.mVideoConfigManager.getPlayViewTypeFromStream(streamType);
        ThunderLog.info("ThunderVideoEngineImp", "setDecodeType streamKey " + streamKey + " type:" + streamType);
        if (this.mVideoConfigManager == null) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoConfigManager == null!");
            return -1;
        }
        int n = scaleMode = this.mVideoScaleModeMap.get(streamKey) == null ? -1 : this.mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find scaleMode in map :" + this.mVideoScaleModeMap.size());
            return -1;
        }
        final ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (this.mVideoViewMap.get(streamKey) == null) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoScaleModeMap can't find view in map :" + this.mVideoViewMap.size());
            return -1;
        }
        if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
            view.prepareView(decodeType);
        } else {
            final CountDownLatch barrier = new CountDownLatch(1);
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    view.prepareView(decodeType);
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                ThunderLog.error("ThunderVideoEngineImp", "setDecodeType .barrier.await" + e.toString());
            }
        }
        view.setScaleMode(scaleMode);
        ThunderLog.info("ThunderVideoEngineImp", streamKey + " setDecodeType success : scaleMode" + scaleMode + ", decodeType: " + decodeType);
        return decodeType == 1 ? 1 : 0;
    }

    public boolean startVideoEngine() {
        return true;
    }

    public boolean stopVideoEngine() {
        if (this.mThunderVideoHiidoUtil != null) {
            this.mThunderVideoHiidoUtil.unRegister();
        }
        return true;
    }

    public void setVideoEngineCallBack(long ptr) {
        this.mCallBackPtr = ptr;
    }

    private boolean isUsingDefaultCamera() {
        return !this.bMixMode && this.mCapture != null && this.mCapture instanceof ThunderDefaultCamera;
    }

    public void attachVideoCapture(Object capture) {
        if (this.mVideoPublishState == 2) {
            if (this.mCapture != null && this.mCapture instanceof ThunderScreenCapture) {
                this.mPublisher.stopPublishScreenVideo();
            } else if (this.mCapture != null && this.mCapture.getClass() == ExternalVideoSource.class) {
                this.mPublisher.stopPublishLiveVideo();
            } else if (this.mCapture == null || this.mCapture instanceof ThunderDefaultCamera) {
                this.mPublisher.stopPublishLiveVideo();
            }
        }
        ThunderLog.info("ThunderVideoEngineImp", "detach capture: " + (this.mCapture == null ? "ThunderDefaultCamera" : this.mCapture.toString()) + " mVideoPublishState" + this.mVideoPublishState);
        this.mCapture = (ThunderVideoCapture)capture;
        ThunderLog.info("ThunderVideoEngineImp", "attach capture: " + this.mCapture.toString());
        if (this.mVideoPublishState == 2) {
            int mid;
            VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(this.mCurrentVideoConfig.playType, this.mCurrentVideoConfig.mode);
            ArrayList<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<ResolutionModifyConfig>();
            if (this.mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture)this.mCapture).isLandscap()) {
                mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;
                this.copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else if ((this.mCapture == null || this.mCapture.getClass() == ThunderDefaultCamera.class) && ((ThunderPreviewConfig)this.mCapture.getCaptureConfig()).captureOrientation == 1) {
                mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;
                this.copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else {
                this.copyResolutionModifyConfig(resolutionModifyConfigs);
            }
            newEncoderConfig.mLowDelay = this.mCurrentVideoConfig.bLowLatency;
            this.mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs, this.mVideoConfigManager.getCurrentIntervalSecs());
            if (this.mCapture instanceof ThunderScreenCapture) {
                if (!this.mScreenCaptureInited.booleanValue()) {
                    ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture)this.mCapture;
                    this.mPublisher.initScreenLiveSession(thunderScreenCapture.getMediaProjection(), (IPublishListener)this, thunderScreenCapture.isLandscap());
                    this.mScreenCaptureInited = true;
                }
                this.mPublisher.startPublishScreenVideo("general", null, (Object)newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishScreenVideo %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), this.mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay);
            } else if (this.mCapture != null && this.mCapture.getClass() == ExternalVideoSource.class) {
                if (!this.mOriginYuvCaptureInited.booleanValue()) {
                    ThunderLog.warn("ThunderVideoEngineImp", "startOriginDataCapture !");
                    this.mPublisher.startOriginDataCapture((IPublishListener)this);
                    this.mCapture.startCapture(new ThunderPublisher.IVideoPublisher(){

                        @Override
                        public void pushVideoData(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                            ThunderVideoEngineImp.this.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
                        }

                        @Override
                        public void pushVideoData(byte[] encodedData, ThunderRtcConstant.ThunderVideoEncodeType type, long dts, long pts) {
                        }
                    });
                    this.mOriginYuvCaptureInited = true;
                }
                this.mPublisher.startPublishLiveVideo("general", null, (Object)newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishLiveVideo yuv %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), this.mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay);
            } else {
                this.mPublisher.startPublishLiveVideo("general", null, (Object)newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishLiveVideo %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), this.mCurrentVideoConfig.bMirrorFrontCamera, newEncoderConfig.mLowDelay);
            }
        }
    }

    private CameraPreviewConfig getCameraPreviewConfigByType(int playType, int previewMode) {
        CameraPreviewConfig result = this.mVideoConfigManager.getCameraPreviewConfigByType(playType, previewMode);
        ThunderLog.info("ThunderVideoEngineImp", "getCameraPreviewConfigByType:" + result.toString());
        return result;
    }

    private int getBeautyLevelInCurrentConfig() {
        int result = 0;
        if (this.mVideoConfigManager != null) {
            result = this.mVideoConfigManager.getCurrentBeautifyLevel();
        }
        ThunderLog.info("ThunderVideoEngineImp", "getBeautyLevelInCurrentConfig:" + result);
        return result;
    }

    private VideoEncoderConfig getVideoEncoderConfigByType(int playType, int mode) {
        VideoEncoderConfig result = this.mVideoConfigManager.getVideoEncodeConfigByType(playType, mode);
        ThunderLog.info("ThunderVideoEngineImp", "getVideoEncoderConfigByType:" + result.toString());
        return result;
    }

    private boolean checkLowDelayByType(int playType) {
        return this.mVideoConfigManager.checkLowDelayByType(playType);
    }

    private CameraPreviewConfig toCamerePreviewConfig(ThunderPreviewConfig config) {
        CameraPreviewConfig newConf = new CameraPreviewConfig(0);
        newConf.mCaptureResolutionWidth = config.captureResolutionWidth;
        newConf.mCaptureResolutionHeight = config.captureResolutionHeight;
        newConf.mCameraPosition = config.cameraPosition;
        newConf.mCaptureFrameRate = config.captureFrameRate;
        newConf.mCaptureOrientation = config.captureOrientation;
        return newConf;
    }

    public YVideoPublishVideoConfig setOrientation(int orientatin) {
        ThunderLog.info("ThunderVideoEngineImp", " setOrientation " + orientatin);
        if (this.mCapture != null && this.mCapture instanceof ThunderScreenCapture) {
            ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture)this.mCapture;
            if (thunderScreenCapture.isLandscap() && orientatin != 1 || !thunderScreenCapture.isLandscap() && orientatin != 0) {
                this.stopEncodeVideo();
                thunderScreenCapture.setIslandScape(orientatin == 1);
                this.startEncodeVideo(this.mCurrentVideoConfig.bMirrorFrontCamera, this.mCurrentVideoConfig.bLowLatency, this.mCurrentVideoConfig.playType, this.mCurrentVideoConfig.mode);
            }
            return this.mCurrentVideoConfig;
        }
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        ThunderPreviewConfig config = (ThunderPreviewConfig)camera.getCaptureConfig();
        if (orientatin != config.captureOrientation) {
            config.captureOrientation = orientatin;
            config.captureResolutionWidth += config.captureResolutionHeight;
            config.captureResolutionHeight = config.captureResolutionWidth - config.captureResolutionHeight;
            config.captureResolutionWidth -= config.captureResolutionHeight;
            camera.setCaptureConfig(config);
            if (this.mVideoFrameCapture != null) {
                this.mVideoFrameCapture.updateVideoCaptureFrameInfo(config.captureResolutionWidth, config.captureResolutionHeight);
            }
        }
        if (this.mCapture != null && this.mCapture instanceof ThunderScreenCapture && this.mVideoPublishState == 2 && this.mVideoPreviewState == 1 || this.mCapture == null && this.mVideoPublishState != 2 && this.mVideoPreviewState == 1) {
            this.mPublisher.updateCameraPreviewParam(this.toCamerePreviewConfig(config));
        } else {
            boolean recover = this.mVideoPublishState == 2;
            this.stopEncodeVideo();
            this.mPublisher.updateCameraPreviewParam(this.toCamerePreviewConfig(config));
            if (this.mCurrentVideoConfig != null && recover) {
                this.startEncodeVideo(this.mCurrentVideoConfig.bMirrorFrontCamera, this.mCurrentVideoConfig.bLowLatency, this.mCurrentVideoConfig.playType, this.mCurrentVideoConfig.mode);
            }
        }
        if (this.mCurrentVideoConfig != null) {
            this.mCurrentVideoConfig.orientation = orientatin;
            this.mCurrentVideoConfig.encodeResolutionWidth += this.mCurrentVideoConfig.encodeResolutionHeight;
            this.mCurrentVideoConfig.encodeResolutionHeight = this.mCurrentVideoConfig.encodeResolutionWidth - this.mCurrentVideoConfig.encodeResolutionHeight;
            this.mCurrentVideoConfig.encodeResolutionWidth -= this.mCurrentVideoConfig.encodeResolutionHeight;
        }
        if (this.mVideoPublishState == 2) {
            return this.mCurrentVideoConfig;
        }
        return null;
    }

    public void setLocalVideoView(Object toView) {
        ThunderPreviewView previewView = (ThunderPreviewView)((Object)toView);
        ThunderLog.info("ThunderVideoEngineImp", "setLocalVideoView " + this.mVideoPreviewState + " view " + (toView != null ? ((ThunderPreviewView)((Object)toView)).getSurfaceView() : "null"));
        if (this.mVideoPreviewState == 1 && previewView != null) {
            this.mPublisher.setPreviewSurfaceView(previewView.getSurfaceView());
        }
    }

    public int startPreview(int playType, int publishMode) {
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        ThunderPreviewConfig config = (ThunderPreviewConfig)camera.getCaptureConfig();
        this.mPublisher.setPhonePerformanceLevel(this.getBeautyLevelInCurrentConfig());
        CameraPreviewConfig newConfig = this.getCameraPreviewConfigByType(playType, publishMode);
        newConfig.mCameraPosition = ((ThunderPreviewConfig)camera.getCaptureConfig()).cameraPosition;
        if (config.captureOrientation == 1) {
            int mid = newConfig.mCaptureResolutionWidth;
            newConfig.mCaptureResolutionWidth = newConfig.mCaptureResolutionHeight;
            newConfig.mCaptureResolutionHeight = mid;
        }
        if (this.mVideoFrameCapture != null) {
            this.mVideoFrameCapture.updateVideoCaptureFrameInfo(newConfig.mCaptureResolutionWidth, newConfig.mCaptureResolutionHeight);
        }
        newConfig.mCaptureOrientation = config.captureOrientation;
        this.mPublisher.startPreview(newConfig, (IPublishListener)this);
        if (camera.getCameraDataCallback() != null) {
            ThunderLog.info("ThunderVideoEngineImp", "setTextureListener %s %s", camera.getCameraDataCallback().toString(), this.toString());
            this.mPublisher.setTextureListener((ITextureListener)this);
        }
        this.mOrangeFilterWrapper = this.mPublisher.getOrangeFilterWrapperObject();
        config.captureFrameRate = newConfig.mCaptureFrameRate;
        config.captureResolutionHeight = newConfig.mCaptureResolutionHeight;
        config.captureResolutionWidth = newConfig.mCaptureResolutionWidth;
        camera.setCaptureConfig(config);
        this.mVideoPreviewState = 1;
        if (this.mCapture != null && this.mCapture.getClass() == ThunderDefaultCamera.class && this.mVideoPublishState == 2) {
            ThunderLog.info("ThunderVideoEngineImp", "startPreview attach camera SO publish:" + playType + ":" + publishMode);
            this.startEncodeVideo(false, false, playType, publishMode);
        }
        return 0;
    }

    public void setOriginFrameToEncode(byte[] data, int format, int width, int height, int rotation, long timestamp) {
        if (this.mPublisher != null) {
            this.mPublisher.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
        }
    }

    public int stopPreview() {
        if (this.mVideoPreviewState != 1) {
            ThunderLog.info("ThunderVideoEngineImp", "stopPreview previewState wrong:" + this.mVideoPublishState);
        }
        this.mVideoPreviewState = 0;
        return this.mPublisher.stopPreview();
    }

    public YVideoPublishVideoConfig startEncodeVideo(boolean bMirrorFrontCamera, boolean bLowLatency, int playType, int mode) {
        int mid;
        VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(playType, mode);
        ArrayList<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<ResolutionModifyConfig>();
        if (this.mCapture != null && this.mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture)this.mCapture).isLandscap()) {
            mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;
            this.copyResolutionModifyConfigReverse(resolutionModifyConfigs);
        } else if ((this.mCapture == null || this.mCapture.getClass() == ThunderDefaultCamera.class) && ((ThunderPreviewConfig)ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation == 1) {
            mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;
            this.copyResolutionModifyConfigReverse(resolutionModifyConfigs);
        } else {
            this.copyResolutionModifyConfig(resolutionModifyConfigs);
        }
        newEncoderConfig.mLowDelay = this.mIsEnableWebSdkCompatibility ? true : this.checkLowDelayByType(playType);
        ThunderLog.info("ThunderVideoEngineImp", "startPublishVideo %dx%d %d %d %s %b %b", newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate, newEncoderConfig.mEncodeType.name(), bMirrorFrontCamera, newEncoderConfig.mLowDelay);
        if (this.mCapture != null && this.mCapture.getClass() == ThunderScreenCapture.class && !this.mScreenCaptureInited.booleanValue()) {
            ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture)this.mCapture;
            this.mPublisher.initScreenLiveSession(thunderScreenCapture.getMediaProjection(), (IPublishListener)this, thunderScreenCapture.isLandscap());
            this.mScreenCaptureInited = true;
        }
        this.mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs, this.mVideoConfigManager.getCurrentIntervalSecs());
        int ret = -1;
        ret = this.mCapture != null && this.mCapture instanceof ThunderScreenCapture ? this.mPublisher.startPublishScreenVideo("general", null, (Object)newEncoderConfig) : this.mPublisher.startPublishLiveVideo("general", null, (Object)newEncoderConfig);
        if (ret == 0) {
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }
            int videoLevel = this.mVideoConfigManager.getCurrentVideoLevel();
            if (this.mCurrentVideoConfig == null) {
                this.mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }
            this.mCurrentVideoConfig.bLowLatency = newEncoderConfig.mLowDelay;
            this.mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
            this.mCurrentVideoConfig.playType = playType;
            this.mCurrentVideoConfig.mode = videoLevel;
            this.mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            this.mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            this.mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            this.mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            this.mCurrentVideoConfig.bHardwareEncoder = hard;
            this.mCurrentVideoConfig.encodeType = encodeType;
            int n = this.mCurrentVideoConfig.orientation = this.mCurrentVideoConfig.encodeResolutionWidth > this.mCurrentVideoConfig.encodeResolutionHeight ? 1 : 0;
        }
        if (this.mVideoPublishState != 1) {
            ThunderLog.info("ThunderVideoEngineImp", "startPublishVideo videoState wrong:" + this.mVideoPublishState);
        }
        this.mVideoPublishState = 2;
        return this.mCurrentVideoConfig;
    }

    public int stopEncodeVideo() {
        ThunderLog.info("ThunderVideoEngineImp", "stopEncodeVideo ....");
        if (this.mVideoPublishState != 2) {
            ThunderLog.info("ThunderVideoEngineImp", "stopEncodeVideo videoState wrong:" + this.mVideoPublishState);
        }
        this.mVideoPublishState = 0;
        this.mPublisher.stopPublishVideo();
        if (this.mOriginYuvCaptureInited.booleanValue()) {
            this.mPublisher.stopOriginDataCapture();
            this.mCapture.stopCapture();
            this.mOriginYuvCaptureInited = false;
        }
        if (this.mScreenCaptureInited.booleanValue()) {
            this.mPublisher.deInitScreenLiveSession();
            this.mScreenCaptureInited = false;
        }
        return 0;
    }

    public void changeScreenLiveMode(boolean pictureMode, Object bitmap) {
        this.mPublisher.changeScreenLiveMode(Boolean.valueOf(pictureMode), (Bitmap)bitmap);
    }

    public int startPlayVideoStream(final String streamKey, final Object toView, final boolean bSoftDecode, final int scaleMode) {
        ThunderLog.info("ThunderVideoEngineImp", "startPlayVideoStream streamKey:" + streamKey + " toView:" + toView + " bSoftDecode:" + bSoftDecode + " scaleMode:" + scaleMode);
        if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
            this.startPlayVideoStreamUI(streamKey, toView, bSoftDecode, scaleMode);
        } else {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    ThunderVideoEngineImp.this.startPlayVideoStreamUI(streamKey, toView, bSoftDecode, scaleMode);
                }
            });
        }
        return 0;
    }

    public int stopPlayVideoStream(String streamKey) {
        ThunderLog.info("ThunderVideoEngineImp", "stopPlayVideoStream streamKey:" + streamKey);
        if (Thread.currentThread().getId() == this.mUiHandler.getLooper().getThread().getId()) {
            this.stopPlayVideoStreamUI(streamKey);
        } else {
            final String f_streamKey = streamKey;
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    ThunderVideoEngineImp.this.stopPlayVideoStreamUI(f_streamKey);
                }
            });
        }
        return 0;
    }

    public void setPlayVideoViewScaleMode(Object toView, int scaleMode) {
        String streamKey = null;
        if (toView == null) {
            return;
        }
        Set<Map.Entry<String, ThunderPlayerView>> entrySet = this.mVideoViewMap.entrySet();
        for (Map.Entry<String, ThunderPlayerView> me : entrySet) {
            if (!toView.equals((Object)me.getValue())) continue;
            streamKey = me.getKey();
            this.mVideoScaleModeMap.put(streamKey, scaleMode);
            me.getValue().setScaleMode(scaleMode);
            return;
        }
        ThunderLog.warn("ThunderVideoEngineImp", "setPlayVideoViewScaleMode toView is not found! view:" + toView);
    }

    public void setVideoFrameObserver(String uid, Object observer) {
        if (observer == null) {
            ThunderLog.info("ThunderVideoEngineImp", "setVideoFrameObserver remove " + uid + " ->" + observer);
            this.mVideoFrameObserverMap.remove(uid);
            this.mVideoFrameObserverEnableMap.remove(uid);
        } else {
            ThunderLog.info("ThunderVideoEngineImp", "setVideoFrameObserver " + uid + " ->" + observer);
            this.mVideoFrameObserverMap.put(uid, (IVideoDecodeObserver)observer);
        }
    }

    public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return false;
        }
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            return false;
        }
        if (!((Object)((Object)view)).equals(toView)) {
            ThunderLog.warn("ThunderVideoEngineImp", "may toView is change!");
            return false;
        }
        this.mVideoScaleModeMap.put(streamKey, scaleMode);
        ThunderLog.debug("ThunderVideoEngineImp", "update play scale mode: " + scaleMode);
        return view.setScaleMode(scaleMode);
    }

    private void copyResolutionModifyConfig(List<ResolutionModifyConfig> dst) {
        if (this.mVideoConfigManager.getCurrentModifyConfig() != null && this.mVideoConfigManager.getCurrentModifyConfig().size() > 0) {
            for (int i = 0; i < this.mVideoConfigManager.getCurrentModifyConfig().size(); ++i) {
                ResolutionModifyConfig tmp = new ResolutionModifyConfig(this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).width, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).height, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).minCodeRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).maxCodeRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).minFrameRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).maxFrameRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).videoEncoderType, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).encoderParams);
                dst.add(tmp);
            }
        }
    }

    private void copyResolutionModifyConfigReverse(List<ResolutionModifyConfig> dst) {
        if (this.mVideoConfigManager.getCurrentModifyConfig() != null && this.mVideoConfigManager.getCurrentModifyConfig().size() > 0) {
            for (int i = 0; i < this.mVideoConfigManager.getCurrentModifyConfig().size(); ++i) {
                ResolutionModifyConfig tmp = new ResolutionModifyConfig(this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).height, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).width, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).minCodeRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).maxCodeRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).minFrameRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).maxFrameRate, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).videoEncoderType, this.mVideoConfigManager.getCurrentModifyConfig().get((int)i).encoderParams);
                dst.add(tmp);
            }
        }
    }

    public YVideoPublishVideoConfig updatePublishVideoConfig(boolean bMirrorFrontCamera, boolean bLowLatency, int playType, int mode) {
        if (this.mCurrentVideoConfig == null || playType != this.mCurrentVideoConfig.playType || mode != this.mCurrentVideoConfig.mode) {
            int mid;
            VideoEncoderConfig newEncoderConfig = this.getVideoEncoderConfigByType(playType, mode);
            ArrayList<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<ResolutionModifyConfig>();
            if (this.mCapture != null && this.mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture)this.mCapture).isLandscap()) {
                mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;
                this.copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else if ((this.mCapture == null || this.mCapture.getClass() == ThunderDefaultCamera.class) && ((ThunderPreviewConfig)ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation == 1) {
                mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;
                this.copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else {
                this.copyResolutionModifyConfig(resolutionModifyConfigs);
            }
            PublishVideoConfig videoConfig = new PublishVideoConfig();
            videoConfig.assign(newEncoderConfig);
            videoConfig.mLowDelay = this.mIsEnableWebSdkCompatibility ? true : this.checkLowDelayByType(playType);
            if (videoConfig.mLowDelay != bLowLatency) {
                ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig %b :%d", bLowLatency, playType);
            }
            this.mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs, this.mVideoConfigManager.getCurrentIntervalSecs());
            this.mPublisher.stopPublishVideo();
            if (this.mCapture != null && this.mCapture.getClass() == ThunderScreenCapture.class) {
                this.mPublisher.startPublishScreenVideo("general", null, (Object)videoConfig);
            } else if (this.mCapture != null && this.mCapture.getClass() == ExternalVideoSource.class) {
                this.mPublisher.updateOriginPublishVideoConfig(videoConfig);
            } else {
                this.mPublisher.updateLivePublishVideoConfig(videoConfig);
            }
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }
            int videoLevel = this.mVideoConfigManager.getCurrentVideoLevel();
            if (this.mCurrentVideoConfig == null) {
                this.mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000, newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }
            this.mCurrentVideoConfig.playType = playType;
            this.mCurrentVideoConfig.mode = videoLevel;
            this.mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            this.mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            this.mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            this.mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            this.mCurrentVideoConfig.bHardwareEncoder = hard;
            this.mCurrentVideoConfig.encodeType = encodeType;
            this.mCurrentVideoConfig.orientation = this.mCapture == null || this.mCapture.getClass() == ThunderDefaultCamera.class ? ((ThunderPreviewConfig)ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).captureOrientation : 0;
            this.mCurrentVideoConfig.bLowLatency = videoConfig.mLowDelay;
        }
        if (bMirrorFrontCamera != this.mCurrentVideoConfig.bMirrorFrontCamera) {
            this.mPublisher.enableMirror(bMirrorFrontCamera);
            this.mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
        }
        if (2 != this.mVideoPublishState) {
            this.mVideoPublishState = 2;
            ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig state:2");
        }
        return this.mCurrentVideoConfig;
    }

    public boolean setCameraPosition(int position) {
        ((ThunderPreviewConfig)ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera().getCaptureConfig()).cameraPosition = position;
        return this.mPublisher.setCameraPosition(position);
    }

    public int setPubWatermark(float x, float y, Object image) {
        return this.mPublisher.setWatermark((Bitmap)image, (int)x, (int)y);
    }

    public int setPubFaceBeautyLevel(float level) {
        if (this.mOrangeFilterWrapper != null) {
            this.mOrangeFilterWrapper.setBeautyParam(level);
        }
        return 0;
    }

    private String getVideoViewStreamKey(long streamId) {
        String StreamKey = null;
        for (Map.Entry<String, Long> entry : this.mVideoViewStreamKeyAndIdMap.entrySet()) {
            if (entry.getValue() != streamId) continue;
            StreamKey = entry.getKey();
        }
        return StreamKey;
    }

    private boolean isSubStream(String streamKey, long streamId, long linkedStreamId) {
        String lowStreamUid = UidMap.getStringUid(streamId >> 32);
        String highStreamUid = UidMap.getStringUid(linkedStreamId >> 32);
        ThunderLog.info("ThunderVideoEngineImp", "isSubStream from:" + linkedStreamId + " to:" + streamId);
        if (!lowStreamUid.equals(highStreamUid)) {
            ThunderLog.warn("ThunderVideoEngineImp", "isSubStream: HighLow stream UID un-match: L(%s) - H(%s)", lowStreamUid, highStreamUid);
            return false;
        }
        String linkedStreamKey = this.getVideoViewStreamKey(linkedStreamId);
        if (linkedStreamKey == null || linkedStreamKey.isEmpty()) {
            ThunderLog.warn("ThunderVideoEngineImp", "isSubStream: get Linked streamKey failed. " + linkedStreamId + ": " + linkedStreamKey);
            return false;
        }
        boolean isHighStreamOk = ThunderAPI.sharedInstance().getPlayer().isHighStream(linkedStreamKey);
        boolean isLowStreamOk = ThunderAPI.sharedInstance().getPlayer().isLowStream(streamKey);
        ThunderLog.info("ThunderVideoEngineImp", "isSubStream from:" + linkedStreamKey + " to:" + streamKey);
        return isHighStreamOk && isLowStreamOk;
    }

    public int onVideoStreamArrive(String streamKey, long streamId) {
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp", "onVideoStreamArrive: cannot find video view for stream:%s", streamKey);
            return -1;
        }
        ThunderLog.info("ThunderVideoEngineImp", "onVideoStreamArrive:%s, %d", streamKey, streamId);
        long linkedStreamId = view.getLinkedStream();
        ThunderLog.warn("ThunderVideoEngineImp", "onVideoStreamArrive: view:" + (Object)((Object)view));
        if (this.isSubStream(streamKey, streamId, linkedStreamId)) {
            view.linkToSubStream(streamId);
            HighLowStreamInfo info = new HighLowStreamInfo();
            info.highStreamId = linkedStreamId;
            info.lowStreamId = streamId;
            info.highStreamKey = this.getVideoViewStreamKey(linkedStreamId);
            info.lowStreamKey = streamKey;
            info.highStreamName = ThunderAPI.sharedInstance().getPlayer().getHighStreamName(info.highStreamKey);
            info.lowStreamName = ThunderAPI.sharedInstance().getPlayer().getLowStreamName(info.lowStreamKey);
            this.mHighLowStreamMap.put(UidMap.getStringUid(streamId >> 32), info);
            ThunderAPI.sharedInstance().getPlayer().notifyLowStreamArrive();
            ThunderLog.info("ThunderVideoEngineImp", "link high low stream: %s", info);
        } else {
            view.linkToStream(streamId);
        }
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback((IVideoInfoCallback)this.mThunderVideoPlayListener);
        }
        this.mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
        this.mVideoFrameObserverEnableMap.put(UidMap.getStringUid(streamId >> 32), true);
        return 0;
    }

    public int onVideoStreamStop(String streamKey, long streamId) {
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        ThunderPlayerView tmpView = null;
        if (view != null && (tmpView = this.mRecoverVideoViewMap.put(streamKey, view)) != null && !((Object)((Object)tmpView)).equals((Object)view)) {
            tmpView.unLinkFromStream();
            this.mRecoverVideoViewMap.remove(streamKey);
            ThunderLog.info("ThunderVideoEngineImp", "recover unlink stream:%s-%d", streamKey, streamId);
            return 0;
        }
        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp", "onVideoStreamStop: cann't find video view for stream:%s", streamKey);
            return -1;
        }
        ThunderLog.info("ThunderVideoEngineImp", "unlink stream:%s-%d", streamKey, streamId);
        if (ThunderAPI.sharedInstance().getPlayer().isHighStream(streamKey)) {
            String uid = UidMap.getStringUid(streamId >> 32);
            HighLowStreamInfo info = this.mHighLowStreamMap.get(uid);
            if (info != null && info.highStreamId == streamId) {
                view.unLinkFromSubStream(info.lowStreamId);
            }
            this.mHighLowStreamMap.clear();
            this.mVideoViewMap.remove(streamKey);
            ThunderAPI.sharedInstance().getPlayer().clearHighLowStream();
            ThunderLog.info("ThunderVideoEngineImp", " onVideoStreamStop stop High stream success. ");
        } else {
            view.unLinkFromStream(streamId);
        }
        this.mVideoFrameObserverEnableMap.put(UidMap.getStringUid(streamId >> 32), false);
        this.mRecoverVideoViewMap.remove(streamKey);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(null);
        }
        return 0;
    }

    public int onRequestIFrame() {
        this.mPublisher.requestEncodeIFrame();
        return 0;
    }

    public int onDynamicBitrate(long bitrate) {
        this.mPublisher.setNetworkBitrateSuggest((int)bitrate * 1000);
        return 0;
    }

    public String getAnchorHiidoStatInfo(long streamId) {
        String anchorStat = "";
        if (this.mThunderVideoHiidoUtil != null) {
            ThunderVideoEngineImp thunderVideoEngineImp = this;
            anchorStat = thunderVideoEngineImp.mThunderVideoHiidoUtil.getAnchorStatInfo();
        }
        return VideoDataStat.getInstance().getAnchorVideoData(streamId) + anchorStat;
    }

    public String getAudienceHiidoStatInfo(long streamId) {
        String audienceStat = "";
        if (this.mThunderVideoHiidoUtil != null) {
            ThunderVideoEngineImp thunderVideoEngineImp = this;
            audienceStat = thunderVideoEngineImp.mThunderVideoHiidoUtil.getAudienceStatInfo();
        }
        return VideoPlayerDataStat.getInstance().getAudienceVideoData(streamId) + audienceStat;
    }

    public int getPublishRuntimeInfo(int type) {
        switch (type) {
            case 0: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.FRAME);
            }
            case 1: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.BITRATE);
            }
            case 2: {
                return this.mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.RESOLUTION);
            }
        }
        return 0;
    }

    public long getPlayRuntimeInfo(long streamId, int type) {
        switch (type) {
            case 0: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
            }
            case 1: {
                break;
            }
            case 2: {
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
            }
        }
        return 0L;
    }

    public int setPublisherPtsAdjustVal(int adjustVal) {
        if (this.mPublisher != null) {
            ThunderLog.debug("ThunderVideoEngineImp", "setPublisherPtsAdjustVal " + adjustVal);
            this.mPublisher.setDeltaYYPtsMillions((long)adjustVal);
        }
        return 0;
    }

    public void onEncodeFrameData(byte[] data, int len, long pts, long dts, int frameType, VideoEncoderType encoderType, int svcTid, int svcSid) {
        int encodeType = 1;
        boolean bHardware = false;
        switch (encoderType) {
            case SOFT_ENCODER_X264: {
                bHardware = false;
                encodeType = 1;
                break;
            }
            case HARD_ENCODER_H264: {
                bHardware = true;
                encodeType = 1;
                break;
            }
            case SOFT_ENCODER_H265: {
                bHardware = false;
                encodeType = 2;
                break;
            }
            case HARD_ENCODER_H265: {
                bHardware = true;
                encodeType = 2;
                break;
            }
            case DEFAULT: 
            case ERROR: {
                ThunderLog.warn("yvideo-Java", "unknown encoder type" + encoderType.toString());
            }
        }
        if (this.mCallBackPtr != 0L) {
            this.onVideoEncodedFrame(this.mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware, svcTid, svcSid);
        }
    }

    public int onTextureCallback(int textureId, int width, int height) {
        if (!this.isUsingDefaultCamera()) {
            return textureId;
        }
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        if (camera.getCameraDataCallback() == null) {
            return textureId;
        }
        return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
    }

    void onVideoRenderNotify(ArrayList<VideoRenderNotify> notifications) {
        if (this.mCallBackPtr != 0L) {
            ThunderNative.onVideoRenderEvent(this.mCallBackPtr, notifications);
        }
    }

    private void checkAndChangeHighLowStream(long streamId, long pts) {
        if (!ThunderAPI.sharedInstance().getPlayer().isNeedHighLowStreamChange()) {
            return;
        }
        String streamKey = this.getVideoViewStreamKey(streamId);
        if (streamKey == null) {
            return;
        }
        if (!ThunderAPI.sharedInstance().getPlayer().isHighStream(streamKey) && !ThunderAPI.sharedInstance().getPlayer().isLowStream(streamKey)) {
            return;
        }
        this.mStreamIdAndDecoderPtsMap.put(streamId, pts);
        String uid = UidMap.getStringUid(streamId >> 32);
        HighLowStreamInfo info = this.mHighLowStreamMap.get(uid);
        if (info == null) {
            return;
        }
        if (!this.mStreamIdAndDecoderPtsMap.containsKey(info.highStreamId) || !this.mStreamIdAndDecoderPtsMap.containsKey(info.lowStreamId)) {
            return;
        }
        boolean isForceSwitch = ThunderAPI.sharedInstance().getPlayer().forceSwitch();
        long highStreamPts = this.mStreamIdAndDecoderPtsMap.get(info.highStreamId);
        long lowStreamPts = this.mStreamIdAndDecoderPtsMap.get(info.lowStreamId);
        if (lowStreamPts > highStreamPts || Math.abs(highStreamPts - lowStreamPts) <= 100L || isForceSwitch) {
            ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
            if (view == null) {
                ThunderLog.warn("ThunderVideoEngineImp", "onUpdateDecoderPts: cannot find video view for stream:%s", streamKey);
                return;
            }
            view.switchToSubStream(info.lowStreamId);
            this.onHighLowStreamChangeSuccess(info);
        }
    }

    private void onHighLowStreamChangeSuccess(HighLowStreamInfo info) {
        this.mStreamIdAndDecoderPtsMap.clear();
        ThunderAPI.sharedInstance().getPlayer().onHighLowStreamChangeFinish(info.highStreamName, info.lowStreamName);
        ThunderLog.info("ThunderVideoEngineImp", " onHighLowStreamChangeSuccess :" + info);
    }

    void onUpdateDecoderPts(long streamId, long pts) {
        this.checkAndChangeHighLowStream(streamId, pts);
    }

    void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        ThunderLog.info("ThunderVideoEngineImp", "onHardwareDecodeErrorNotify %d", errorType);
        ThunderNative.enableHardwareDecoder(false, 1);
        ThunderNative.enableHardwareDecoder(false, 2);
        if (this.mVideoConfigManager != null) {
            this.mVideoConfigManager.disableHardDecode(true);
        }
    }

    public boolean queryOnlyDecoded(int uid) {
        IVideoDecodeObserver observer = this.mVideoFrameObserverMap.get(UidMap.getStringUid(uid));
        return observer != null;
    }

    public void onDecodedFrameData(long uid, int w, int h, byte[] data, int dateLen, long renderTimeMs) {
        IVideoDecodeObserver observer = this.mVideoFrameObserverMap.get(UidMap.getStringUid(uid));
        if (observer == null) {
            ThunderLog.info("ThunderVideoEngineImp", "onVideoDecodedFrame not found uid " + uid);
            return;
        }
        if (this.mVideoFrameObserverEnableMap.get(UidMap.getStringUid(uid)) != null && this.mVideoFrameObserverEnableMap.get(UidMap.getStringUid(uid)).booleanValue()) {
            observer.onVideoDecodeFrame(UidMap.getStringUid(uid), w, h, data, dateLen, renderTimeMs);
        }
    }

    private native void onVideoEncodedFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9, int var10, boolean var11, int var12, int var13);

    public void stopAndRecoverVideoEncode(boolean stop) {
        if (this.mPublisher != null && this.mVideoPublishState != 0) {
            this.mPublisher.stopAndRecoverStream(Boolean.valueOf(stop));
        }
    }

    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec, int eatenFrames) {
        ThunderNative.onFirstFrameRenderNotify(userGroupId, streamId, currentSystemMilliSecond, firstFrameToRenderInMilliSec, eatenFrames);
    }

    public void onUpdateVideoSizeChanged(long streamId, int width, int height) {
        ThunderNative.onUpdateVideoSizeChanged(streamId, width, height);
    }

    public void setWebSdkCompatibility(boolean enable) {
        this.mIsEnableWebSdkCompatibility = enable;
        this.setLowDelayMode(enable);
        ThunderNative.enableLowLatency(enable);
    }

    public int setLocalVideoMirrorMode(int mode) {
        if (this.mPublisher == null) {
            return -1;
        }
        switch (mode) {
            case 0: {
                this.mPublisher.enablePreviewMirror(true);
                this.mPublisher.enableMirror(false);
                break;
            }
            case 1: {
                this.mPublisher.enablePreviewMirror(true);
                this.mPublisher.enableMirror(true);
                break;
            }
            case 2: {
                this.mPublisher.enablePreviewMirror(false);
                this.mPublisher.enableMirror(false);
                break;
            }
            case 3: {
                this.mPublisher.enablePreviewMirror(false);
                this.mPublisher.enableMirror(true);
                break;
            }
            default: {
                ThunderLog.info("ycall-Java", "invalid mirror mode");
                return -1;
            }
        }
        return 0;
    }

    private int startPlayVideoStreamUI(String streamKey, Object toView, boolean bSoftDecode, int scaleMode) {
        if (streamKey == null || streamKey.isEmpty()) {
            return -1;
        }
        ThunderPlayerView view = (ThunderPlayerView)((Object)toView);
        boolean isSoftDecode = this.mVideoViewDecodeType.get(streamKey) == null ? bSoftDecode : this.mVideoViewDecodeType.get(streamKey);
        int decoderType = isSoftDecode ? 0 : 1;
        long oldStreamId = this.mVideoViewStreamKeyAndIdMap.get(streamKey) == null ? -1L : this.mVideoViewStreamKeyAndIdMap.get(streamKey);
        ThunderPlayerView existedView = this.mVideoViewMap.get(streamKey);
        if (view != null) {
            if (existedView != null) {
                if (!((Object)((Object)view)).equals((Object)existedView)) {
                    existedView.unLinkFromStream();
                    existedView.unPrepareView();
                } else if (bSoftDecode && existedView.getViewType() != 0) {
                    existedView.unLinkFromStream();
                    existedView.unPrepareView();
                }
                this.mVideoViewMap.remove(streamKey);
            }
            if (!view.isPrepared()) {
                view.unLinkFromStream();
                view.prepareView(decoderType);
                if (oldStreamId != -1L) {
                    view.linkToStream(oldStreamId);
                }
            }
            this.mVideoViewMap.put(streamKey, view);
        }
        ThunderLog.info("ThunderVideoEngineImp", "startPlayVideoStream " + streamKey + " toView:" + toView + " bSoftDecode:" + bSoftDecode + " scaleMode:" + scaleMode + " streamId:" + oldStreamId);
        this.mVideoScaleModeMap.put(streamKey, scaleMode);
        return 0;
    }

    private int updatePlayVideoStreamUI(String streamKey, long streamId, int streamType, boolean bSoftDecode) {
        int scaleMode;
        ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream bSoftDecode ==" + Boolean.toString(bSoftDecode) + " streamId  " + streamId);
        int result = -1;
        String UID = UidMap.getStringUid(streamId >> 32);
        long highLowStreamUid = ThunderAPI.sharedInstance().getPlayer().getHighLowStreamUid();
        if (ThunderAPI.sharedInstance().getPlayer().isNeedHighLowStreamChange() && UID != null && UID.equals(UidMap.getStringUid(highLowStreamUid))) {
            return 0;
        }
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp", "updatePlayVideoStream: cann't find video view for stream:%s", streamKey);
        } else {
            this.mRecoverVideoViewMap.put(streamKey, view);
        }
        if (view != null) {
            long oldStreamId;
            if (!view.isPrepared()) {
                int scaleMode2;
                int decoderType = bSoftDecode ? 0 : 1;
                this.prepareView(view, decoderType);
                view.linkToStream(streamId);
                int n = scaleMode2 = this.mVideoScaleModeMap.get(streamKey) == null ? -1 : this.mVideoScaleModeMap.get(streamKey);
                if (scaleMode2 != -1) {
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream setScaleMode " + scaleMode2 + " streamKey " + streamKey);
                    view.setScaleMode(scaleMode2);
                } else {
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream scaleMode == -1, streamKey " + streamKey);
                }
                return -1;
            }
            long l = oldStreamId = this.mVideoViewStreamKeyAndIdMap.get(streamKey) == null ? -1L : this.mVideoViewStreamKeyAndIdMap.get(streamKey);
            if (bSoftDecode && view.getViewType() != 0) {
                ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream bSoftDecode == true, view == hard,need change");
                if (oldStreamId != -1L) {
                    view.unLinkFromStream();
                }
                view.prepareView(0);
                view.linkToStream(streamId);
                this.mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
                ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);
            } else if (bSoftDecode && view.getViewType() == 0) {
                if (oldStreamId != streamId) {
                    view.unLinkFromStream();
                    view.linkToStream(streamId);
                    this.mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream overrid stream:%s, %d ->%d", streamKey, oldStreamId, streamId);
                } else {
                    view.unLinkFromStream();
                    view.linkToStream(streamId);
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream same streamId stream:%s, %d", streamKey, streamId);
                }
            } else if (!bSoftDecode) {
                if (view.getViewType() == 1) {
                    view.unLinkFromStream();
                    view.linkToStream(streamId);
                    this.mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream override stream:%s, %d ->%d", streamKey, oldStreamId, streamId);
                } else if (view.getViewType() != 1) {
                    view.prepareView(1);
                    view.linkToStream(streamId);
                    this.mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream hard link stream:%s, %d", streamKey, streamId);
                }
            } else {
                ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream someThing wrong streamId stream:%s ,%d, type:%d", streamKey, streamId, view.getViewType());
            }
        }
        this.mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
        this.mVideoFrameObserverEnableMap.put(UidMap.getStringUid(streamId >> 32), true);
        this.mVideoViewDecodeType.put(streamKey, bSoftDecode);
        int n = scaleMode = this.mVideoScaleModeMap.get(streamKey) == null ? -1 : this.mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream mVideoScaleModeMap can't find scaleMode in map :" + this.mVideoScaleModeMap.size());
            if (view != null) {
                result = view.getViewType() == 1 ? 1 : 0;
            }
            return result;
        }
        if (view != null) {
            view.setScaleMode(scaleMode);
            result = view.getViewType() == 1 ? 1 : 0;
        }
        return result;
    }

    private int stopPlayVideoStreamUI(String streamKey) {
        ThunderPlayerView view = this.mVideoViewMap.get(streamKey);
        ThunderLog.info("ThunderVideoEngineImp", "stopPlayVideoStreamUI streamKey:" + streamKey + " view:" + (Object)((Object)view));
        if (view == null) {
            return -1;
        }
        boolean isHighStream = ThunderAPI.sharedInstance().getPlayer().isHighStream(streamKey);
        if (!isHighStream) {
            view.unLinkFromStream();
            view.unPrepareView();
            this.mVideoViewMap.remove(streamKey);
        }
        this.mVideoViewStreamKeyAndIdMap.remove(streamKey);
        ThunderLog.info("ThunderVideoEngineImp", "stopPlayVideoStreamUI remain mVideoViewMap:" + this.mVideoViewMap.size() + " mVideoViewStreamKeyAndIdMap:" + this.mVideoViewStreamKeyAndIdMap.size());
        return 0;
    }

    private class HighLowStreamInfo {
        public long highStreamId;
        public long lowStreamId;
        public String highStreamKey;
        public String lowStreamKey;
        public String highStreamName;
        public String lowStreamName;

        private HighLowStreamInfo() {
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(" high stream :");
            b.append(this.highStreamKey);
            b.append(" id :");
            b.append(this.highStreamId);
            b.append(" low stream :");
            b.append(this.lowStreamKey);
            b.append(" id :");
            b.append(this.lowStreamId);
            return b.toString();
        }
    }

    private static class YVideoPublishVideoConfig {
        int encodeFrameRate;
        int encodeBitrate;
        int encodeResolutionWidth;
        int encodeResolutionHeight;
        int encodeType;
        boolean bHardwareEncoder;
        int mode;
        boolean bMirrorFrontCamera;
        boolean bLowLatency;
        int playType;
        int orientation;

        public YVideoPublishVideoConfig(int encodeFrameRate, int encodeBitrate, int encodeResolutionWidth, int encodeResolutionHeight, int encodeType, boolean bHardwareEncoder, int mode) {
            this.encodeFrameRate = encodeFrameRate;
            this.encodeBitrate = encodeBitrate;
            this.encodeResolutionWidth = encodeResolutionWidth;
            this.encodeResolutionHeight = encodeResolutionHeight;
            this.encodeType = encodeType;
            this.bHardwareEncoder = bHardwareEncoder;
            this.mode = mode;
        }

        public String toString() {
            String tmp = "" + this.encodeResolutionWidth + "x" + this.encodeResolutionHeight + "@" + this.encodeFrameRate + " " + this.encodeBitrate + " hard:" + this.bHardwareEncoder + " mode:" + this.mode;
            return tmp;
        }
    }
}

