/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.video;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;
import com.thunder.livesdk.helper.ThunderLog;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.glesunder43.EglCore;
import com.yy.videoplayer.glesunder43.WindowSurface;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGLSurface;

public class ThunderVideoConfig {
    private static Support h264HwDecoderSupport = Support.SUPPORTED;
    private static Support h265HwDecoderSupport = Support.SUPPORTED;
    private static boolean bRooted = false;
    private static boolean bWindowSurfaceSupported = false;
    private static final Object testWindowSurfaceLocker = new Object();

    void AsyncLoad() {
        LoadThread lt = new LoadThread();
        Thread th = new Thread((Runnable)lt, "YY_LoadVideoConfig_Thread");
        th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testWindowSurfaceCreation() {
        boolean ret;
        AtomicBoolean result = new AtomicBoolean(false);
        TestWindowSurfaceTask task = new TestWindowSurfaceTask(result);
        Thread thread = new Thread((Runnable)task, "YY_TestWindowSurface_Thread");
        Object object = testWindowSurfaceLocker;
        synchronized (object) {
            try {
                thread.start();
                testWindowSurfaceLocker.wait(500L);
                ret = result.get();
            }
            catch (Exception e) {
                ret = false;
            }
        }
        ThunderLog.info("yvideo-Java", "testWindowSurfaceCreation ret:" + ret);
        return ret;
    }

    private boolean testRooted() {
        boolean isRooted;
        String binPath = "/system/bin/su";
        String xBinPath = "/system/xbin/su";
        try {
            isRooted = new File(binPath).exists() && this.testFileExecutable(binPath) || new File(xBinPath).exists() && this.testFileExecutable(xBinPath);
        }
        catch (Throwable e) {
            isRooted = false;
        }
        ThunderLog.info("yvideo-Java", "testRooted: " + isRooted);
        return isRooted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testFileExecutable(String filePath) {
        Process p = null;
        try {
            char flag;
            p = Runtime.getRuntime().exec("ls -l " + filePath);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String str = in.readLine();
            ThunderLog.info("yvideo-Java", "testFileExecutable " + str);
            if (str != null && str.length() >= 4 && ((flag = str.charAt(3)) == 's' || flag == 'x')) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            ThunderLog.info("yvideo-Java", "testFileExecutable failed:" + e.getMessage());
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return false;
    }

    public static boolean isRooted() {
        return bRooted;
    }

    public static boolean isWindowSurfaceSupport() {
        return bWindowSurfaceSupported;
    }

    public static boolean isHw264DecodeEnabled() {
        return h264HwDecoderSupport != Support.UNSUPPORTED && H264DecRender.IsAvailable();
    }

    public static boolean isHw265DecodeEnabled() {
        return h265HwDecoderSupport != Support.UNSUPPORTED && H265DecRender.IsAvailable();
    }

    private static class TestWindowSurfaceTask
    implements Runnable {
        private AtomicBoolean mResult = null;

        TestWindowSurfaceTask(AtomicBoolean waiter) {
            this.mResult = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                if (this.mResult == null) {
                    return;
                }
                try {
                    Surface surface;
                    SurfaceTexture st;
                    EglCore eglCore;
                    block11: {
                        this.mResult.set(false);
                        eglCore = new EglCore();
                        st = new SurfaceTexture(1);
                        surface = new Surface(st);
                        EGLSurface envSurface = null;
                        try {
                            WindowSurface videoWindowSurface = new WindowSurface(eglCore, surface, false);
                            videoWindowSurface.release();
                            envSurface = eglCore.createOffscreenSurface(320, 240);
                            eglCore.makeCurrent(envSurface);
                            eglCore.makeNothingCurrent();
                            this.mResult.set(true);
                            if (envSurface == null) break block11;
                        }
                        catch (Throwable t) {
                            block13: {
                                try {
                                    this.mResult.set(false);
                                    ThunderLog.error("yvideo-Java", "test WindowSurface createEngine error:" + t.getMessage());
                                    if (envSurface == null) break block13;
                                }
                                catch (Throwable throwable) {
                                    if (envSurface != null) {
                                        eglCore.releaseSurface(envSurface);
                                        envSurface = null;
                                    }
                                    surface.release();
                                    st.release();
                                    eglCore.release();
                                    ThunderLog.info("yvideo-Java", "test WindowSurface createEngine finish:" + this.mResult.get());
                                    throw throwable;
                                }
                                eglCore.releaseSurface(envSurface);
                                envSurface = null;
                            }
                            surface.release();
                            st.release();
                            eglCore.release();
                            ThunderLog.info("yvideo-Java", "test WindowSurface createEngine finish:" + this.mResult.get());
                            break block12;
                        }
                        eglCore.releaseSurface(envSurface);
                        envSurface = null;
                    }
                    surface.release();
                    st.release();
                    eglCore.release();
                    ThunderLog.info("yvideo-Java", "test WindowSurface createEngine finish:" + this.mResult.get());
                }
                catch (Throwable t) {
                    ThunderLog.error("yvideo-Java", "test WindowSurface init error:" + t.getMessage());
                }
            }
            Object object = testWindowSurfaceLocker;
            synchronized (object) {
                testWindowSurfaceLocker.notifyAll();
            }
        }
    }

    private class LoadThread
    implements Runnable {
        private LoadThread() {
        }

        @Override
        public void run() {
            try {
                bRooted = ThunderVideoConfig.this.testRooted();
                bWindowSurfaceSupported = ThunderVideoConfig.testWindowSurfaceCreation();
                ThunderLog.info("yvideo-Java", "load finish - build version:" + Build.VERSION.SDK_INT + ", h264HwDecoderSupport:" + h264HwDecoderSupport.name() + ", h265HwDecoderSupport:" + h265HwDecoderSupport.name() + ", isRooted:" + bRooted + ", isWindowSurfaceSupported:" + bWindowSurfaceSupported);
            }
            catch (Exception e) {
                ThunderLog.error("yvideo-Java", "load error:" + e.getMessage());
            }
        }
    }

    private static enum Support {
        SUPPORTED,
        UNSUPPORTED,
        UNCERTAIN;

    }
}

