/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.helper;

import com.thunder.livesdk.ThunderAPI;
import com.thunder.livesdk.helper.ThunderLog;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class ThunderHttpsRequestHandler {
    private static final String TAG = "HttpsRequestHandler";
    private static final int ERR_NONE = 0;
    private static final int ERR_MALFORMED_URL = 10;
    private static final int ERR_PROTOCOL = 11;
    private static final int ERR_IOEXCEPTION = 12;

    public void send(final String reqUrl, final int target) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThunderLog.info(ThunderHttpsRequestHandler.TAG, "fetching...");
                HttpURLConnection connection = null;
                try {
                    URL url = new URL(reqUrl);
                    connection = (HttpsURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    int statusCode = connection.getResponseCode();
                    if (statusCode == 200) {
                        ThunderHttpsRequestHandler.this.onHttpsResponse((HttpsURLConnection)connection, reqUrl, statusCode, target);
                    } else {
                        ThunderHttpsRequestHandler.this.onHttpsFailed(reqUrl, statusCode, 0, target);
                    }
                }
                catch (MalformedURLException e) {
                    ThunderHttpsRequestHandler.this.onHttpsFailed(reqUrl, 0, 10, target);
                    e.printStackTrace();
                }
                catch (ProtocolException e) {
                    ThunderHttpsRequestHandler.this.onHttpsFailed(reqUrl, 0, 11, target);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    ThunderHttpsRequestHandler.this.onHttpsFailed(reqUrl, 0, 12, target);
                    e.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }).start();
    }

    private void onHttpsResponse(HttpsURLConnection connection, String reqUrl, int statusCode, int target) {
        String contentType = connection.getContentType();
        int contentLength = connection.getContentLength();
        ThunderLog.info(TAG, "contentType=" + contentType + " contentLength=" + contentLength);
        if (contentType.indexOf("text") != -1) {
            try {
                String line;
                StringBuffer sb = new StringBuffer();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while (null != (line = responseReader.readLine())) {
                    sb.append(line);
                }
                responseReader.close();
                ThunderAPI.sharedInstance().setHttpsTextResponse(reqUrl, sb.toString(), statusCode, 0, target);
            }
            catch (IOException e) {
                this.onHttpsFailed(reqUrl, 0, 12, target);
            }
        } else {
            try {
                InputStream is = connection.getInputStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[contentLength];
                int len = -1;
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                is.close();
                os.close();
                ThunderAPI.sharedInstance().setHttpsBinaryResponse(reqUrl, os.toByteArray(), statusCode, 0, target);
            }
            catch (IOException e) {
                this.onHttpsFailed(reqUrl, 0, 12, target);
            }
        }
    }

    private void onHttpsFailed(String reqUrl, int statusCode, int errCode, int target) {
        ThunderLog.warn(TAG, "onHttpsFailed statusCode=" + statusCode + " errCode=" + errCode + " target=" + target);
        ThunderAPI.sharedInstance().setHttpsTextResponse(reqUrl, "", statusCode, errCode, target);
    }
}

