/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.helper;

import android.content.Context;
import com.thunder.livesdk.helper.ThunderLog;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.HttpDnsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GSLBMethod {
    private static final String TAG = "GSLBMethod";
    private HttpDnsService mService = null;

    public void init() {
    }

    public void initService(Object context) {
        this.mService = HttpDnsService.getService((Context)((Context)context), (String)"60345f3e-d0ca-4f0b-bcef-5cb3862f12a6", null, null, null);
        ThunderLog.warn(TAG, "initService %s", this.mService);
    }

    public void destroyService() {
        ThunderLog.warn(TAG, "destroyService");
        HttpDnsService.destroyService();
        this.mService = null;
    }

    public byte[] dnsGetByNameWithHost(String host) {
        String ret = new String();
        if (this.mService == null) {
            ThunderLog.warn(TAG, "dnsGetByNameWithHost GSLB service not init");
            return ret.getBytes();
        }
        ThunderLog.info(TAG, "dnsGetByNameWithHost host=%s", host);
        DnsResultInfo res = this.mService.getIpsByHost(host);
        if (res.mErrorCode == 0) {
            ret = ret + "success|";
            for (String ip : res.mIps) {
                ret = ret + ip + ",";
            }
        } else {
            ret = ret + "fail|" + res.mErrorCode;
        }
        ThunderLog.info(TAG, "dnsGetByNameWithHost ret=%s", ret);
        return ret.getBytes();
    }

    public void dnsSetPreResolveHosts(String hosts) {
        if (this.mService == null) {
            ThunderLog.warn(TAG, "dnsSetPreResolveHosts GSLB service not init");
            return;
        }
        String[] hostArray = hosts.split("\\|");
        List<String> hostList = Arrays.asList(hostArray);
        this.mService.setPreResolveHosts(new ArrayList<String>(hostList));
        ThunderLog.info(TAG, "dnsSetPreResolveHosts host=%s", hosts);
    }
}

