/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk.helper;

import android.os.Build;
import com.thunder.livesdk.helper.ThunderLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CpuTool {
    private static final String kCpuInfoMaxFreqFilePath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
    private static final String TAG = "CPUTool";
    public static final String OS_VERSION = Build.VERSION.RELEASE;
    public static final String[] TOP = new String[]{"/system/bin/top", "-d", "1", "-m", "6"};
    public static int mTopPeriod = 9;
    public static final int HZ = 100;
    public static int count = 0;
    public static int mRefDeviceJiffies = 0;
    public static int mAppCpuRate = 0;
    public static int mDeviceCpuRate = 0;
    public static int selfProcessPid = android.os.Process.myPid();
    public static int maxCpuFreq = 0;
    public static int minCpuFreq = 0;
    private static CpuUpTimeInfo mCpuUpTimeInfo = new CpuUpTimeInfo();
    private static JiffiesCount mJiffiesCount = new JiffiesCount();
    private static JiffiesCount mJiffiesTopCount = new JiffiesCount();
    public static int mCpuCores = CpuTool.getCpuCores();

    public static int getCpuCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static float getAppCpuRateAverage() {
        float AppCpuRateAverage = (float)CpuTool.getAppCpuRate(15) / (float)mCpuCores;
        return AppCpuRateAverage;
    }

    public static int getAppCpuRate(int topPeriod) {
        if (topPeriod > 0 && topPeriod != mTopPeriod) {
            mTopPeriod = topPeriod;
        }
        long deltaJiffiesPerSecond = 0L;
        if (mJiffiesCount.isInit()) {
            CpuTool.mJiffiesCount.lastJiffies = CpuTool.getCurrentCpuJiffies();
            CpuTool.mJiffiesCount.lastTimeCount = System.currentTimeMillis();
            return 0;
        }
        CpuTool.mJiffiesCount.curJiffies = CpuTool.getCurrentCpuJiffies();
        CpuTool.mJiffiesCount.deltaJiffies = CpuTool.mJiffiesCount.curJiffies - CpuTool.mJiffiesCount.lastJiffies;
        CpuTool.mJiffiesCount.lastJiffies = CpuTool.mJiffiesCount.curJiffies;
        CpuTool.mJiffiesCount.curTimeCount = System.currentTimeMillis();
        CpuTool.mJiffiesCount.deltaTimeCount = CpuTool.mJiffiesCount.curTimeCount - CpuTool.mJiffiesCount.lastTimeCount;
        CpuTool.mJiffiesCount.lastTimeCount = CpuTool.mJiffiesCount.curTimeCount;
        if (CpuTool.mJiffiesCount.deltaTimeCount != 0L) {
            deltaJiffiesPerSecond = CpuTool.mJiffiesCount.deltaJiffies * 1000L / CpuTool.mJiffiesCount.deltaTimeCount;
            ThunderLog.info(TAG, "appCpu deltaJiffiesPerSecond: " + deltaJiffiesPerSecond);
            long referJiffies = CpuTool.getReferDeviceJiffies();
            if (referJiffies != 0L) {
                int cpuRate = (int)(deltaJiffiesPerSecond * 100L * CpuTool.mJiffiesTopCount.deltaTimeCount / referJiffies / 1000L);
                ThunderLog.info(TAG, "refJiffies by top:" + referJiffies + " cpuRate " + cpuRate);
                return cpuRate;
            }
            return 0;
        }
        return 0;
    }

    public static long getCurrentCpuJiffies() {
        FileReader fr = null;
        BufferedReader localBufferReader = null;
        File file = null;
        int pid = android.os.Process.myPid();
        String cpuPath = "/proc/" + pid + "/stat";
        String cpuProcessInfo = "";
        String[] result = new String[3];
        long curJiffies = 0L;
        file = new File(cpuPath);
        if (!file.exists() || !file.canRead()) {
            ThunderLog.error(TAG, "file not exist or have not permission:" + cpuPath);
            return 0L;
        }
        try {
            String[] cpuSpilt;
            fr = new FileReader(file);
            localBufferReader = new BufferedReader(fr);
            cpuProcessInfo = localBufferReader.readLine();
            if (cpuProcessInfo != null && (cpuSpilt = cpuProcessInfo.split(" ")) != null) {
                result[0] = cpuSpilt[1];
                result[1] = cpuSpilt[13];
                result[2] = cpuSpilt[14];
                long userSpaceTime = Long.parseLong(result[1]);
                long kernelSpaceTime = Long.parseLong(result[2]);
                curJiffies = userSpaceTime + kernelSpaceTime;
            }
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "exception: " + e);
        }
        if (localBufferReader != null) {
            try {
                localBufferReader.close();
            }
            catch (IOException e) {
                ThunderLog.error(TAG, "exception: " + e);
            }
        }
        return curJiffies;
    }

    private static long getReferDeviceJiffies() {
        CpuTool.mJiffiesTopCount.lastJiffies = CpuTool.getCurrentCpuJiffies();
        CpuTool.mJiffiesTopCount.lastTimeCount = System.currentTimeMillis();
        int[] cpuRate = CpuTool.getCpuRateByTop();
        if (cpuRate != null && cpuRate[0] != 0) {
            CpuTool.mJiffiesTopCount.curJiffies = CpuTool.getCurrentCpuJiffies();
            CpuTool.mJiffiesTopCount.curTimeCount = System.currentTimeMillis();
            CpuTool.mJiffiesTopCount.deltaJiffies = CpuTool.mJiffiesTopCount.curJiffies - CpuTool.mJiffiesTopCount.lastJiffies;
            CpuTool.mJiffiesTopCount.deltaTimeCount = CpuTool.mJiffiesTopCount.curTimeCount - CpuTool.mJiffiesTopCount.lastTimeCount;
            mRefDeviceJiffies = (int)(100L * CpuTool.mJiffiesTopCount.deltaJiffies / (long)cpuRate[0]);
            ThunderLog.info(TAG, "top cpu device jiffies:" + mRefDeviceJiffies + " mJiffiesTopCount.deltaJiffies:" + CpuTool.mJiffiesTopCount.deltaJiffies + " top:" + cpuRate);
            return mRefDeviceJiffies;
        }
        return mRefDeviceJiffies;
    }

    public static int[] getCpuRateByTop() {
        String[] cpuRate = null;
        int[] cpuRateData = new int[2];
        boolean deviceCpu = false;
        if (OS_VERSION.compareTo("8.0") >= 0) {
            if (count == 0 && (cpuRate = CpuTool.getCpuRateByRunTop(selfProcessPid)) != null) {
                try {
                    cpuRateData[0] = (int)Float.parseFloat(cpuRate[0]);
                    mAppCpuRate = cpuRateData[0];
                    cpuRateData[1] = (int)Float.parseFloat(cpuRate[1]);
                    mDeviceCpuRate = cpuRateData[1];
                }
                catch (Exception e) {
                    ThunderLog.error(TAG, "Exception " + e);
                }
                ThunderLog.error(TAG, "getAppRateByTop appCpuRate:" + mAppCpuRate + " deviceCpuRate " + mDeviceCpuRate);
            }
            count = count == mTopPeriod - 1 ? 0 : ++count;
        }
        return cpuRateData;
    }

    public static String[] getCpuRateByRunTop(int process) {
        String[] parseResult = new String[]{"0", "0"};
        long start = System.currentTimeMillis();
        String topResult = CpuTool.run(TOP, process);
        long exhaustTime = System.currentTimeMillis() - start;
        if (topResult != null) {
            CpuTool.parseTopCpuInfo(topResult, parseResult);
            return parseResult;
        }
        return null;
    }

    private static String run(String[] cmd, int pid) {
        String line = null;
        String result = null;
        StringBuilder resultBuilder = new StringBuilder();
        InputStream inputStream = null;
        int limit = 10;
        BufferedReader bufReader = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec(cmd);
            inputStream = proc.getInputStream();
            bufReader = new BufferedReader(new InputStreamReader(inputStream));
            do {
                if (null == (line = bufReader.readLine())) {
                    ThunderLog.error(TAG, "return null");
                    break;
                }
                if (line == null || pid == 0 || !line.contains(String.valueOf(pid))) continue;
                resultBuilder.append(line);
                break;
            } while (--limit > 0);
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufReader != null) {
                bufReader.close();
            }
        }
        catch (IOException e) {
            ThunderLog.error(TAG, "top Exception:" + e);
        }
        result = resultBuilder.toString();
        return result;
    }

    public static int parseTopCpuInfo(String line, String[] parseResult) {
        String cpuAppRate = null;
        String deviceRate = null;
        String[] cpuInfo = line.split(" ");
        if (parseResult != null && parseResult.length == 2 && cpuInfo != null) {
            for (int i = 0; i < cpuInfo.length; ++i) {
                String[] cpuData;
                if (cpuInfo[i].toUpperCase().equals("R") || cpuInfo[i].toUpperCase().equals("S")) {
                    cpuAppRate = cpuInfo[i + 1];
                    if (cpuAppRate == " ") {
                        cpuAppRate = cpuInfo[i + 2];
                    }
                    parseResult[0] = cpuAppRate;
                }
                if (!cpuInfo[i].toLowerCase().contains("%idle") || i <= 0 || (cpuData = cpuInfo[i].split("%")) == null || cpuData.length <= 0) continue;
                float cpuIdle = Float.parseFloat(cpuData[0]);
                float cpuDeviceRate = (float)(mCpuCores * 100) - cpuIdle;
                parseResult[1] = deviceRate = String.valueOf(cpuDeviceRate);
            }
            return 0;
        }
        return -1;
    }

    public static class JiffiesCount {
        public long lastJiffies = 0L;
        public long curJiffies = 0L;
        public long deltaJiffies = 0L;
        public long lastTimeCount = 0L;
        public long curTimeCount = 0L;
        public long deltaTimeCount = 0L;

        public JiffiesCount() {
            this.reset();
        }

        public void reset() {
            this.lastJiffies = 0L;
            this.curJiffies = 0L;
            this.deltaJiffies = 0L;
        }

        public boolean isInit() {
            return this.lastJiffies == 0L;
        }
    }

    public static class CpuUpTimeInfo {
        public double lastActiveTime = 0.0;
        public double curActiveTime = 0.0;
        public double deltaActiveTime = 0.0;
        public double lastIdleTime = 0.0;
        public double curIdleTime = 0.0;
        public double deltaIdleTime = 0.0;
        public long lastTimeCount = 0L;
        public long curTimeCount = 0L;
        public long deltaTimeCount = 0L;

        public CpuUpTimeInfo() {
            this.reset();
        }

        public void reset() {
            this.lastActiveTime = 0.0;
            this.curActiveTime = 0.0;
            this.deltaActiveTime = 0.0;
            this.lastIdleTime = 0.0;
            this.curIdleTime = 0.0;
            this.deltaIdleTime = 0.0;
        }

        public boolean isInit() {
            return this.lastActiveTime != 0.0;
        }
    }
}

