/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk;

import com.thunder.livesdk.ThunderGroup;
import com.thunder.livesdk.ThunderStream;
import com.thunder.livesdk.helper.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.video.ThunderVideoLogCallback;
import com.yy.videoplayer.utils.YMFLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThunderPlayer {
    public ArrayList<ThunderStream> subscribeStreams = null;
    private ConcurrentLinkedQueue<ThunderStream> highStreams = null;
    private ConcurrentLinkedQueue<ThunderStream> lowStreams = null;
    private IHighLowStreamChangeObserver streamChangeObserver = null;
    private final Object streamLock = new Object();
    private long lowStreamArriveTime = 0L;
    private final long highLowStreamSwitchTimeout = 8000L;

    ThunderPlayer() {
        YMFLog.registerLogger((Object)ThunderVideoLogCallback.sharedInstance());
        this.subscribeStreams = new ArrayList(0);
        this.highStreams = new ConcurrentLinkedQueue();
        this.lowStreams = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startPlayStreams(ArrayList<ThunderStream> streamList, ArrayList<ThunderGroup> groupList) {
        if (streamList == null) {
            streamList = new ArrayList(0);
        }
        if (groupList == null) {
            groupList = new ArrayList(0);
        }
        if (streamList.size() == 0 && groupList.size() == 0) {
            ThunderLog.warn("ycall-Java", "startPlayStreams both stream list and group list is empty");
            return -1;
        }
        for (ThunderStream oneStream : streamList) {
            if (!oneStream.bVideo) continue;
            oneStream.startSubscribeTime = System.currentTimeMillis();
            Object object = this.streamLock;
            synchronized (object) {
                Iterator<ThunderStream> iter = this.subscribeStreams.iterator();
                while (iter.hasNext()) {
                    ThunderStream rmStream = iter.next();
                    if (!rmStream.streamName.equals(oneStream.streamName) || rmStream.appId != oneStream.appId) continue;
                    iter.remove();
                }
                this.subscribeStreams.add(oneStream);
            }
            ThunderLog.release("ycall-Java", "startPlayStreams video streamName " + oneStream.streamName + "spkUid:" + oneStream.speakerUid + "toVideo: " + oneStream.toView);
        }
        ThunderLog.release("ycall-Java", "startPlayStreams list size: %d %d", streamList.size(), groupList.size());
        return ThunderNative.startPlayStreams(streamList, groupList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopPlayStreams(ArrayList<ThunderStream> streamList, ArrayList<ThunderGroup> groupList) {
        if (streamList == null) {
            streamList = new ArrayList(0);
        }
        if (groupList == null) {
            groupList = new ArrayList(0);
        }
        if (streamList.size() == 0 && groupList.size() == 0) {
            ThunderLog.warn("ycall-Java", "stopPlayStreams both stream list and group list is empty");
            return -1;
        }
        for (ThunderStream oneStream : streamList) {
            if (!oneStream.bVideo) continue;
            Object object = this.streamLock;
            synchronized (object) {
                Iterator<ThunderStream> iter = this.subscribeStreams.iterator();
                while (iter.hasNext()) {
                    ThunderStream rmStream = iter.next();
                    if (!rmStream.streamName.equals(oneStream.streamName) || rmStream.appId != oneStream.appId) continue;
                    iter.remove();
                }
            }
        }
        ThunderLog.release("ycall-Java", "stopPlayStreams list size: %d %d", streamList.size(), groupList.size());
        return ThunderNative.stopPlayStreams(streamList, groupList);
    }

    public void setHighLowStream(ArrayList<ThunderStream> high, ArrayList<ThunderStream> low) {
        if (high == null || low == null) {
            return;
        }
        this.lowStreamArriveTime = 0L;
        this.highStreams.clear();
        this.lowStreams.clear();
        this.highStreams.addAll(high);
        this.lowStreams.addAll(low);
        String highStreamName = "";
        for (ThunderStream stream : this.highStreams) {
            highStreamName = stream.streamName;
        }
        String lowStreamName = "";
        for (ThunderStream stream : this.lowStreams) {
            lowStreamName = stream.streamName;
        }
        ThunderLog.release("ycall-Java", "setHighLowStream high :" + highStreamName + " low " + lowStreamName);
    }

    public long getHighLowStreamUid() {
        Iterator<ThunderStream> iterator = this.highStreams.iterator();
        if (iterator.hasNext()) {
            ThunderStream stream = iterator.next();
            return stream.speakerUid;
        }
        return -1L;
    }

    public void clearHighLowStream() {
        this.highStreams.clear();
        this.lowStreams.clear();
    }

    public boolean isHighStream(String streamKey) {
        for (ThunderStream stream : this.highStreams) {
            if (!streamKey.equals(stream.packStreamKey())) continue;
            return true;
        }
        return false;
    }

    public boolean isLowStream(String streamKey) {
        for (ThunderStream stream : this.lowStreams) {
            if (!streamKey.equals(stream.packStreamKey())) continue;
            return true;
        }
        return false;
    }

    public String getHighStreamName(String streamKey) {
        for (ThunderStream stream : this.highStreams) {
            if (!streamKey.equals(stream.packStreamKey())) continue;
            return stream.streamName;
        }
        return null;
    }

    public String getLowStreamName(String streamKey) {
        for (ThunderStream stream : this.lowStreams) {
            if (!streamKey.equals(stream.packStreamKey())) continue;
            return stream.streamName;
        }
        return null;
    }

    public void notifyLowStreamArrive() {
        this.lowStreamArriveTime = System.currentTimeMillis();
        ThunderLog.release("ycall-Java", "notifyLowStreamArrive time :" + this.lowStreamArriveTime);
    }

    public boolean forceSwitch() {
        long currentTime = System.currentTimeMillis();
        if (this.lowStreamArriveTime != 0L && currentTime - this.lowStreamArriveTime >= 8000L) {
            this.lowStreamArriveTime = 0L;
            ThunderLog.release("ycall-Java", "high low stream forceSwitch true .");
            return true;
        }
        return false;
    }

    public boolean isNeedHighLowStreamChange() {
        return this.highStreams.size() > 0 && this.lowStreams.size() > 0;
    }

    public void onHighLowStreamChangeFinish(String highStreamName, String lowStreamName) {
        if (this.streamChangeObserver != null) {
            this.streamChangeObserver.onHighLowStreamChangeFinish(highStreamName, lowStreamName);
        }
    }

    public boolean enableHardwareDecoder(boolean enable) {
        ThunderLog.release("ycall-Java", "enableHardwareDecoder:%b", enable);
        return ThunderNative.enableHardwareDecoder(enable, 1);
    }

    public boolean enableMute(boolean enable, ThunderStream stream) {
        if (stream == null) {
            return false;
        }
        ThunderLog.release("ycall-Java", "enableMute %b for stream %s", enable, stream.streamName);
        return ThunderNative.enableMuteStream(enable, stream);
    }

    public boolean enableMute(boolean enable, String uid) {
        ThunderLog.release("ycall-Java", "enableMute %b for %s", enable, uid);
        return ThunderNative.enableMuteStringUid(enable, uid);
    }

    public boolean enableAllMute(boolean enable) {
        ThunderLog.release("ycall-Java", "enableAllMute %b", enable);
        ThunderNative.enableAllMute(enable);
        return true;
    }

    public boolean setPlayVolume(int volume, ThunderStream stream) {
        if (stream == null) {
            return false;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.release("ycall-Java", "setPlayVolume %d for stream %s", volume, stream.streamName);
        return ThunderNative.setStreamPlayVolume(volume, stream);
    }

    public boolean setRemoteUidVoicePosition(int azimuth, int gain, ThunderStream stream) {
        if (stream == null) {
            return false;
        }
        if (azimuth < -90 || azimuth > 90 || gain < 0 || gain > 100) {
            ThunderLog.error("ycall-Java", "setRemoteUidVoicePosition fail, parameters error!");
            return false;
        }
        ThunderLog.release("ycall-Java", "setRemoteStreamVoicePosition azimuth\uff1a%d, gain: %d, for stream %s", azimuth, gain, stream.streamName);
        return ThunderNative.setRemoteUidVoicePosition(azimuth, gain, stream);
    }

    public boolean setSpeakerVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.release("ycall-Java", "setSpeakerVolume %d", volume);
        return ThunderNative.setSpeakerVolume(volume);
    }

    public void enableLoudSpeaker(boolean enable) {
        ThunderLog.release("ycall-Java", "enableLoudSpeaker %b", enable);
        ThunderNative.enableLoudSpeaker(enable);
    }

    public boolean getLoudSpeakerEnabled() {
        ThunderLog.release("ycall-Java", "getLoudSpeakerEnabled");
        return ThunderNative.getLoudSpeakerEnabled();
    }

    public boolean isSupportPlayH265() {
        return ThunderNative.getH265SupportMode() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscribeStreamWHByUid(long uid, int _width, int _height) {
        Object object = this.streamLock;
        synchronized (object) {
            for (ThunderStream oneStream : this.subscribeStreams) {
                if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
                oneStream.width = _width;
                oneStream.height = _height;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThunderStream getSubscribeStreamByUid(long uid) {
        Object object = this.streamLock;
        synchronized (object) {
            for (ThunderStream oneStream : this.subscribeStreams) {
                if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
                return oneStream;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscribeStreamByUid(long uid) {
        ThunderStream findStream = null;
        Object object = this.streamLock;
        synchronized (object) {
            for (ThunderStream oneStream : this.subscribeStreams) {
                if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
                findStream = oneStream;
            }
            if (findStream != null) {
                this.subscribeStreams.remove(findStream);
            }
        }
    }

    public void setVideoFrameObserver(String uid, IVideoDecodeObserver observer) {
        ThunderNative.setVideoFrameObserver(uid, observer);
    }

    public void setHighLowStreamChangeObserver(IHighLowStreamChangeObserver observer) {
        this.streamChangeObserver = observer;
    }

    public static interface IHighLowStreamChangeObserver {
        public void onHighLowStreamChangeFinish(String var1, String var2);
    }
}

