/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk;

import android.os.AsyncTask;
import android.support.annotation.RequiresApi;
import com.thunder.livesdk.helper.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;
import com.yy.audioengine.MainHandler;

public class ThunderAudioFilePlayer
implements Comparable<ThunderAudioFilePlayer> {
    private IThunderAudioFilePlayerCallback mCallback = null;
    private long nativeCtx = ThunderNative.createAudioFilePlayer(this);
    private boolean mIsDestroy = false;
    private String mFilePath = null;
    private final int FILE_PLAY_VOLUME = 1;
    private final int PLAY_EVENT_END = 2;
    private final int PLAY_EVENT_ERROR = 3;

    public synchronized void setPlayerNotify(IThunderAudioFilePlayerCallback callback) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerNotify");
        if (this.mIsDestroy) {
            return;
        }
        this.mCallback = callback;
    }

    public synchronized void enableVolumeIndication(boolean enable, int interval) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer enableVolumeNotify enable = %b, interval=%d ", enable, interval);
        if (this.mIsDestroy) {
            return;
        }
        if (interval <= 0) {
            interval = 200;
        }
        ThunderNative.enableAudioFileVolumeCallback(this.nativeCtx, enable, interval);
    }

    @RequiresApi(api=11)
    public boolean open(final String path) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer open path = %s", path);
        this.mFilePath = path;
        if (this.mIsDestroy || path == null) {
            return false;
        }
        final int[] ret = new int[]{-1};
        if (this.mFilePath.toLowerCase().startsWith("http://") || this.mFilePath.toLowerCase().startsWith("https://")) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ret[0] = (int)ThunderNative.audioFileOpen(ThunderAudioFilePlayer.this.nativeCtx, path);
                }
            });
            return true;
        }
        ret[0] = (int)ThunderNative.audioFileOpen(this.nativeCtx, path);
        return ret[0] == 1;
    }

    public void close() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer close");
        if (this.mIsDestroy || this.mFilePath == null) {
            return;
        }
        if (this.mFilePath.toLowerCase().startsWith("http://") || this.mFilePath.toLowerCase().startsWith("https://")) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThunderNative.audioFileClose(ThunderAudioFilePlayer.this.nativeCtx);
                }
            });
        } else {
            ThunderNative.audioFileClose(this.nativeCtx);
        }
    }

    @RequiresApi(api=11)
    public void play() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer play");
        if (this.mIsDestroy || this.mFilePath == null) {
            return;
        }
        if (this.mFilePath.toLowerCase().startsWith("http://") || this.mFilePath.toLowerCase().startsWith("https://")) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThunderNative.audioFilePlay(ThunderAudioFilePlayer.this.nativeCtx);
                }
            });
        } else {
            ThunderNative.audioFilePlay(this.nativeCtx);
        }
    }

    public void stop() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer stop");
        if (this.mIsDestroy || this.mFilePath == null) {
            return;
        }
        if (this.mFilePath.toLowerCase().startsWith("http://") || this.mFilePath.toLowerCase().startsWith("https://")) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThunderNative.audioFileStop(ThunderAudioFilePlayer.this.nativeCtx);
                }
            });
        } else {
            ThunderNative.audioFileStop(this.nativeCtx);
        }
    }

    public void pause() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer pause");
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFilePause(this.nativeCtx);
    }

    public void resume() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer resume");
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFileResume(this.nativeCtx);
    }

    public void seek(long timeMS) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer seek timems = %d ", timeMS);
        if (this.mIsDestroy || this.mFilePath == null) {
            return;
        }
        if (this.mFilePath.toLowerCase().startsWith("http://") || this.mFilePath.toLowerCase().startsWith("https://")) {
            return;
        }
        ThunderNative.audioFileSeek(this.nativeCtx, timeMS);
    }

    public long getTotalPlayTimeMS() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getTotalPlayTimeMS ");
        if (this.mIsDestroy) {
            return 0L;
        }
        return ThunderNative.audioFileGetTotalTime(this.nativeCtx);
    }

    public long getCurrentPlayTimeMS() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getCurrentPlayTimeMS ");
        if (this.mIsDestroy) {
            return 0L;
        }
        return ThunderNative.audioFileGetCurrentPlayTime(this.nativeCtx);
    }

    public void setPlayVolume(int volume) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayVolume volume = %d", volume);
        if (this.mIsDestroy) {
            return;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderNative.audioFileSetPlayVolume(this.nativeCtx, volume);
    }

    public int setPlayerLocalVolume(int volume) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerLocalVolume volume = %d", volume);
        if (this.mIsDestroy || volume < 0 || volume > 100) {
            return -1;
        }
        ThunderNative.audioFileSetPlayerLocalVolume(this.nativeCtx, volume);
        return 0;
    }

    public int setPlayerPublishVolume(int volume) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setPlayerPublishVolume volume = %d", volume);
        if (this.mIsDestroy || volume < 0 || volume > 100) {
            return -1;
        }
        ThunderNative.audioFileSetPlayerPublishVolume(this.nativeCtx, volume);
        return 0;
    }

    public int getPlayerLocalVolume() {
        return (int)ThunderNative.audioFileGetPlayerLocalVolume(this.nativeCtx);
    }

    public int getPlayerPublishVolume() {
        return (int)ThunderNative.audioFileGetPlayerPublishVolume(this.nativeCtx);
    }

    public int getAudioTrackCount() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer getAudioTrackCount ");
        if (this.mIsDestroy) {
            return 0;
        }
        return (int)ThunderNative.audioFileGetAudioTrackCount(this.nativeCtx);
    }

    public int selectAudioTrack(int audioTrack) {
        long ret;
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer selectAudioTrack audioTrack = %d", audioTrack);
        if (this.mIsDestroy) {
            return -1;
        }
        int trackCount = this.getAudioTrackCount();
        if (trackCount == 0 || audioTrack < 0) {
            return -1;
        }
        if (audioTrack >= trackCount) {
            audioTrack = trackCount - 1;
        }
        return (ret = ThunderNative.audioFileSelectAudioTrack(this.nativeCtx, audioTrack)) == 1L ? 0 : -1;
    }

    public void setSemitone(int val) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setSemitone val = %d", val);
        if (this.mIsDestroy) {
            return;
        }
        if (val < -5) {
            val = -5;
        } else if (val > 5) {
            val = 5;
        }
        float tone = val;
        ThunderNative.audioFileSetSemitone(this.nativeCtx, tone);
    }

    public int setLooping(int cycle) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer setLooping cycle = %d", cycle);
        if (this.mIsDestroy) {
            return -1;
        }
        return (int)ThunderNative.audioFileSetLooping(this.nativeCtx, cycle);
    }

    public void enablePublish(boolean enable) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer enablePublish: enable=%b", enable);
        if (this.mIsDestroy) {
            return;
        }
        ThunderNative.audioFileEnablePublish(this.nativeCtx, enable);
    }

    public void onPlayEvent(final int event, final int errorCode) {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer onPlayEvent event = %d, errorCode = %d", event, errorCode);
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (ThunderAudioFilePlayer.this.mIsDestroy) {
                    return;
                }
                if (ThunderAudioFilePlayer.this.mCallback == null) {
                    return;
                }
                switch (event) {
                    case 2: {
                        ThunderAudioFilePlayer.this.mCallback.onAudioFilePlayEnd();
                        break;
                    }
                    case 3: {
                        ThunderAudioFilePlayer.this.mCallback.onAudioFilePlayError(errorCode);
                        break;
                    }
                }
            }
        });
    }

    public synchronized void onAudioFileVolume(final long volume, final long currentMs, final long totalMs) {
        MainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                if (ThunderAudioFilePlayer.this.mIsDestroy) {
                    return;
                }
                if (ThunderAudioFilePlayer.this.mCallback != null) {
                    ThunderAudioFilePlayer.this.mCallback.onAudioFileVolume(volume, currentMs, totalMs);
                }
            }
        });
    }

    void destroyAudioFilePlayer() {
        ThunderLog.release("ycall-Java", "ThunderAudioFilePlayer destroyAudioFilePlayer");
        this.setPlayerNotify(null);
        ThunderNative.destroyAudioFilePlayer(this.nativeCtx);
        this.mIsDestroy = true;
        this.nativeCtx = 0L;
    }

    protected void finalize() {
        this.destroyAudioFilePlayer();
    }

    @Override
    public int compareTo(ThunderAudioFilePlayer audioFilePlayer) {
        if (audioFilePlayer == null) {
            throw new NullPointerException();
        }
        if (this == audioFilePlayer) {
            return 0;
        }
        return 1;
    }

    public static interface IThunderAudioFilePlayerCallback {
        public void onAudioFilePlayEnd();

        public void onAudioFileVolume(long var1, long var3, long var5);

        public void onAudioFilePlayError(int var1);
    }
}

