/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import com.thunder.livesdk.IThunderLogCallback;
import com.thunder.livesdk.LiveTranscoding;
import com.thunder.livesdk.LiveTranscodingParams;
import com.thunder.livesdk.ThunderDeviceInfo;
import com.thunder.livesdk.ThunderNotification;
import com.thunder.livesdk.ThunderPlayer;
import com.thunder.livesdk.ThunderPublishRoom;
import com.thunder.livesdk.ThunderPublishRoomImp;
import com.thunder.livesdk.ThunderPublisher;
import com.thunder.livesdk.ThunderStream;
import com.thunder.livesdk.audio.IAudioFrameObserver;
import com.thunder.livesdk.helper.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.system.ThunderForeBackgroundListener;
import com.thunder.livesdk.system.ThunderNetStateService;
import com.yy.argo.Argo;
import com.yy.gslbsdk.HttpDnsService;
import com.yy.mediaframework.VideoLibAPI;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class ThunderAPI {
    private ThunderPlayer mPlayer = null;
    private ThunderPublisher mPublisher = null;
    private ThunderPublishRoom mPubRoom = null;
    private ThunderNetStateService mNetStateService = null;
    private ThunderForeBackgroundListener mForeBackgroundListener = null;
    private String mVersion = null;
    private int mVersionInt = 0;
    private ThunderNative.NotificationDispatcher mNotificationDispatcher = null;
    private boolean mIsInited = false;
    private boolean m32BitUid = false;
    private HashSet<String> mSrcStreamUrlSet = new HashSet();
    private HashMap<String, HashSet<String>> mTranscodingStreamUrlMap = new HashMap();
    private HashMap<String, LiveTranscodingParams> mTranscodingParamsMap = new HashMap();
    private HashMap<String, HashSet<String>> mTranscodingStreamNotify = new HashMap();
    private HashMap<String, String> mSubscribeUid2RoomId = new HashMap();
    private String mRoomId = null;

    private ThunderAPI() {
        try {
            System.loadLibrary("yyvideoplayer");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            System.loadLibrary("thunder");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        this.mPlayer = new ThunderPlayer();
        this.mPublisher = new ThunderPublisher();
        this.mPubRoom = new ThunderPublishRoomImp();
    }

    public static ThunderAPI sharedInstance() {
        if (SingletonHolder.INSTANCE == null) {
            SingletonHolder.INSTANCE = new ThunderAPI();
        }
        return SingletonHolder.INSTANCE;
    }

    public static void enableLog(boolean enable, int level, String logPath, IThunderLogCallback callback) {
        ThunderAPI.sharedInstance();
        ThunderNative.enableLog(enable, callback, level, logPath);
        ThunderLog.release("ycall-Java", "enableLog enable:%b level:%d", enable, level);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public int getVersionInt() {
        return this.mVersionInt;
    }

    public boolean initWithAppId(long appId, long sceneId, Context appContext, Handler handler) {
        if (this.mIsInited) {
            return false;
        }
        ThunderLog.release("ycall-Java", "init appId:%d sceneId:%d appContext:%s", appId, sceneId, appContext.toString());
        if (this.mNetStateService != null) {
            this.mNetStateService.fini();
        }
        if (this.mForeBackgroundListener != null) {
            this.mForeBackgroundListener.fini();
        }
        this.mNotificationDispatcher = new ThunderNative.NotificationDispatcher(){
            private final HashSet<Handler> mNotificationHandlers = new HashSet();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNotificationHandler(Handler handler) {
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    this.mNotificationHandlers.add(handler);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNotificationHandler(Handler handler) {
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    this.mNotificationHandlers.remove(handler);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object[] collectNotificationHandlers() {
                Object[] handlers = null;
                HashSet<Handler> hashSet = this.mNotificationHandlers;
                synchronized (hashSet) {
                    if (this.mNotificationHandlers.size() > 0) {
                        handlers = this.mNotificationHandlers.toArray();
                    }
                }
                return handlers;
            }
        };
        this.registerNotificationHandler(handler);
        Argo.init((Context)appContext);
        HttpDnsService.getService((Context)appContext, (String)"thundersdk", null, (String)"", (String)Locale.getDefault().getCountry());
        YYServiceCore.loadLib((Context)appContext);
        ThunderDeviceInfo info = new ThunderDeviceInfo(appContext);
        YYVideoLibMgr.instance().init(appContext, "1.0", "YYLiveDemo", Build.VERSION.RELEASE, Build.MODEL, null);
        int ret = ThunderNative.init(appId, sceneId, appContext, info, this.mNotificationDispatcher);
        if (ret < 0) {
            ThunderLog.error("ycall-Java", "init failed!");
            return false;
        }
        this.mNetStateService = new ThunderNetStateService(appContext);
        this.mForeBackgroundListener = new ThunderForeBackgroundListener(appContext);
        this.mNetStateService.init();
        this.mForeBackgroundListener.init();
        VideoLibAPI.instance().initVideoLib(appId, sceneId, appContext);
        YYVideoLibMgr.instance().init(appContext, "1.0", "YYLiveDemo", Build.VERSION.RELEASE, Build.MODEL, null);
        this.mVersion = ThunderNative.getVersion();
        this.mVersionInt = ThunderNative.getVersionInt();
        this.mIsInited = true;
        ThunderLog.release("ycall-Java", "init succeeded, version %s", this.mVersion, " versionInt %u", this.mVersionInt);
        return true;
    }

    public void deInit() {
        if (!this.mIsInited) {
            return;
        }
        this.mIsInited = false;
        if (this.mNetStateService != null) {
            this.mNetStateService.fini();
        }
        if (this.mForeBackgroundListener != null) {
            this.mForeBackgroundListener.fini();
        }
        ThunderNative.fini();
        this.mNetStateService = null;
        this.mForeBackgroundListener = null;
        this.mVersion = null;
        this.mVersionInt = 0;
        SingletonHolder.INSTANCE = null;
        ThunderLog.release("ycall-Java", "[call] ThunderAPI.deInit success");
    }

    public void registerNotificationHandler(Handler handler) {
        ThunderLog.release("ycall-Java", "registerNotificationHandler %s", handler.toString());
        this.mNotificationDispatcher.registerNotificationHandler(handler);
    }

    public void unregisterNotificationHandler(Handler handler) {
        ThunderLog.release("ycall-Java", "unregisterNotificationHandler %s", handler.toString());
        this.mNotificationDispatcher.unregisterNotificationHandler(handler);
    }

    public void setAreaType(int areaType) {
        ThunderLog.release("ycall-Java", "setAreaType %d", areaType);
        ThunderNative.setAreaType(areaType);
    }

    public void enableVad(boolean enable) {
        ThunderLog.release("ycall-Java", "enableVad %b", enable);
        ThunderNative.enableVad(enable);
    }

    public void setSceneId(long sceneId) {
        ThunderLog.release("ycall-Java", "setSceneId %d", sceneId);
        ThunderNative.setSceneId(sceneId);
    }

    public void updateToken(byte[] token) {
        if (token == null) {
            return;
        }
        ThunderLog.release("ycall-Java", "updateToken sToken %d", token.length);
        ThunderNative.updateToken(token, null);
    }

    public void joinMedia(long uid) {
        ThunderLog.release("ycall-Java", "joinMedia %d", uid);
        ThunderNative.joinMedia(uid, 0L, 0L);
    }

    public void joinMedia(long uid, long sid, long subSid) {
        ThunderLog.release("ycall-Java", "joinMedia %d %d %d", uid, sid, subSid);
        ThunderNative.joinMedia(uid, sid, subSid);
    }

    public void joinMedia(String uid, long sid, long subSid) {
        String _uid = uid != null ? uid : new String();
        ThunderLog.release("ycall-Java", "joinMedia %s %d %d", _uid, sid, subSid);
        ThunderNative.joinMedia(_uid, sid, subSid);
    }

    public void leaveMedia() {
        ThunderLog.release("ycall-Java", "leaveMedia");
        ThunderNative.leaveMedia();
    }

    public boolean joinRoom(String roomId, String uid, int userRole, boolean is32BitUid) {
        if (roomId == null || uid == null) {
            ThunderLog.info("ycall-Java", "joinRoom param error");
            return false;
        }
        this.mRoomId = roomId;
        ThunderLog.info("ycall-Java", "joinRoom %s %s %d", roomId, uid, userRole);
        ThunderNative.joinChannel(roomId, uid, is32BitUid, userRole);
        return true;
    }

    public void leaveRoom() {
        this.resetParamsStatus();
        ThunderLog.info("ycall-Java", "leaveRoom");
        ThunderNative.leaveChannel();
    }

    public void set32BitUid(boolean is32Bit) {
        ThunderLog.release("ycall-Java", "set32BitUid %b", is32Bit);
        this.m32BitUid = is32Bit;
    }

    public void setUserRole(int role) {
        ThunderLog.release("ycall-Java", "setUserRole %d", role);
        ThunderNative.setUserRole(role);
    }

    public void enableLowLatency(boolean enable) {
        ThunderLog.release("ycall-Java", "enableLowLatency %b", enable);
        ThunderNative.enableLowLatency(enable);
    }

    public void setRoomConfig(int profile) {
        ThunderLog.release("ycall-Java", "setRoomConfig %d", profile);
        ThunderNative.setRoomConfig(profile);
    }

    public void setPlayVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        ThunderNative.setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public void setCaptureVolumeInterval(int interval, int moreThanThd, int lessThanThd) {
        ThunderNative.setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
    }

    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        return ThunderNative.startAudioSaver(fileName, saverMode, fileMode);
    }

    public boolean stopAudioSaver() {
        return ThunderNative.stopAudioSaver();
    }

    public ThunderPublisher getPublisher() {
        return this.mPublisher;
    }

    public ThunderPublishRoom getPublishRoom() {
        return this.mPubRoom;
    }

    public ThunderPlayer getPlayer() {
        return this.mPlayer;
    }

    public void setExternalAudioProcessor(long eap) {
        ThunderLog.release("ycall-Java", "setExternalAudioProcessor %d", eap);
        ThunderNative.setExternalAudioProcessor(eap);
    }

    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderNative.enableAudioPlaySepctrum(enable);
    }

    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderNative.setAudioPlaySepctrumInfo(spectrumLen, notifyIntervalMS);
    }

    public void setPlayerMixerCompValue(int value) {
        ThunderNative.setAudioPlayerMixerCompValue(value);
    }

    public void enableAudioDataIndication(boolean enable) {
        ThunderNative.enableAudioDataIndication(enable);
    }

    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderNative.enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        if (!(sampleRate != -1 && sampleRate != 8000 && sampleRate != 16000 && sampleRate != 441000 && sampleRate != 480000 || channel != -1 && channel != 1 && channel != 2)) {
            ThunderNative.enableRenderPcmDataCallBack(enable, sampleRate, channel);
            return true;
        }
        return false;
    }

    public void enableVoicePosition(boolean enable) {
        ThunderNative.enableVoicePosition(enable);
    }

    public void enableDebugLoopDelay(boolean enable) {
        ThunderNative.enableDebugLoopDelay(enable);
    }

    public void sendUserAppMsgData(byte[] msgData) {
        if (msgData == null) {
            return;
        }
        ThunderNative.sendUserAppMsgData(msgData);
    }

    public void setArgoConfig(HashMap<Integer, Integer> cfg) {
        if (this.mIsInited) {
            ThunderNative.setArgoConfig(cfg);
        }
    }

    public void setHttpsBinaryResponse(String reqUrl, byte[] response, int statusCode, int errCode, int target) {
        if (this.mIsInited) {
            ThunderNative.setHttpsBinaryResponse(reqUrl, response, statusCode, errCode, target);
        }
    }

    public void setHttpsTextResponse(String reqUrl, String response, int statusCode, int errCode, int target) {
        if (this.mIsInited) {
            ThunderNative.setHttpsTextResponse(reqUrl, response, statusCode, errCode, target);
        }
    }

    public int setPreviewRenderMode(int mode) {
        return ThunderNative.setPreviewRenderMode(mode);
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        ThunderNative.registerAudioFrameObserver(observer);
        return 0;
    }

    public int setRecordingAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        ThunderNative.setRecordingAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
        return 0;
    }

    public int setPlaybackAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        ThunderNative.setPlaybackAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
        return 0;
    }

    public int updateSrcStreamUrlSet(boolean bAdd, String url) {
        boolean ret = false;
        ret = bAdd ? this.mSrcStreamUrlSet.add(url) : this.mSrcStreamUrlSet.remove(url);
        ThunderNative.updatePublishStreamUrl(this.mSrcStreamUrlSet);
        return ret ? 0 : -1;
    }

    public int addSubscribe(String roomId, String uid) {
        this.mSubscribeUid2RoomId.put(uid, roomId);
        ThunderNative.subscribeBroadcast(roomId, uid, true);
        HashSet<String> rooms = new HashSet<String>();
        rooms.add(roomId);
        ThunderNative.queryTransCodingChannelStream(rooms);
        return 0;
    }

    public int removeSubscribe(String roomId, String uid) {
        this.mSubscribeUid2RoomId.remove(uid);
        if (!this.isSetTranscodingTask(roomId)) {
            ThunderNative.subscribeBroadcast(roomId, uid, false);
        }
        return 0;
    }

    public int updateTranscodingStreamUrlMap(String taskId, boolean bAdd, String url) {
        if (!this.isValidTranscoingTaskId(taskId)) {
            return -2;
        }
        boolean ret = false;
        HashSet<String> urlSet = this.mTranscodingStreamUrlMap.get(taskId);
        if (bAdd) {
            if (urlSet == null) {
                urlSet = new HashSet();
            }
            ret = urlSet.add(url);
            this.mTranscodingStreamUrlMap.put(taskId, urlSet);
        } else {
            if (urlSet == null) {
                return -3;
            }
            ret = this.mTranscodingStreamUrlMap.get(taskId).remove(url);
        }
        if (this.mTranscodingParamsMap.get(taskId) != null) {
            ret = true;
            this.mTranscodingParamsMap.get((Object)taskId).transcodingStreamUrls = this.mTranscodingStreamUrlMap.get(taskId);
            ThunderLog.info("yrtc", "updateTranscodingStreamUrlMap user %s", this.mTranscodingParamsMap.get(taskId).userToString());
            ThunderNative.updateTranscodingParams(this.mTranscodingParamsMap);
        }
        return ret ? 0 : -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int updateTranscodingMap(String taskId, boolean bRemove, LiveTranscoding transcoding) {
        if (!this.isValidTranscoingTaskId(taskId)) {
            return -2;
        }
        boolean ret = true;
        if (bRemove) {
            ret = this.mTranscodingParamsMap.containsKey(taskId);
            if (!ret) {
                ThunderLog.info("ycall-Java", "can not find taskId %s", taskId.toString());
                return -3;
            }
            this.updateTranscodingQuerySubScribe(true, this.mTranscodingParamsMap.get((Object)taskId).usersLayout);
            this.mTranscodingParamsMap.put(taskId, new LiveTranscodingParams());
            ThunderNative.updateTranscodingParams(this.mTranscodingParamsMap);
            this.mTranscodingParamsMap.remove(taskId);
        } else {
            LiveTranscodingParams params = new LiveTranscodingParams();
            params.transcodingCofig = this.getTranscodingConfigJsonFromArgo(transcoding.getTransCodingMode());
            params.transcodingStreamUrls = this.mTranscodingStreamUrlMap.get(taskId);
            params.usersLayout = transcoding.getUsers();
            if (this.mTranscodingParamsMap.containsKey(taskId)) {
                LiveTranscodingParams originParams = this.mTranscodingParamsMap.get(taskId);
                ArrayList<LiveTranscoding.TranscodingUser> removeUsers = new ArrayList<LiveTranscoding.TranscodingUser>();
                if (params.usersLayout == null || params.usersLayout.size() == 0) {
                    removeUsers.addAll(originParams.usersLayout);
                } else {
                    for (int i = 0; i < originParams.usersLayout.size(); ++i) {
                        int j;
                        LiveTranscoding.TranscodingUser oriUser = originParams.usersLayout.get(i);
                        for (j = 0; j < params.usersLayout.size(); ++j) {
                            LiveTranscoding.TranscodingUser newUser = params.usersLayout.get(j);
                            if (newUser.roomId.equals(oriUser.roomId) && newUser.uid.equals(oriUser.uid)) break;
                        }
                        if (j != params.usersLayout.size()) continue;
                        removeUsers.add(oriUser);
                    }
                }
                this.updateTranscodingQuerySubScribe(true, removeUsers);
            }
            this.updateTranscodingQuerySubScribe(false, params.usersLayout);
            ThunderLog.info("yrtc", "user layout %s", params.userToString());
            this.mTranscodingParamsMap.put(taskId, params);
            ThunderNative.updateTranscodingParams(this.mTranscodingParamsMap);
        }
        if (!ret) return -1;
        return 0;
    }

    public void handleTrancodingQuerySubscribeStream(ThunderNotification.StreamsNotify streamInfo) {
        HashSet<String> querySubscribeStream = new HashSet<String>();
        for (Map.Entry<String, HashSet<String>> entry : this.mTranscodingStreamNotify.entrySet()) {
            String key = entry.getKey();
            String[] uidAndChannel = key.split("@");
            String uid = uidAndChannel[0];
            String channelId = uidAndChannel[1];
            if (!streamInfo.getRoomId().equals(channelId)) continue;
            for (ThunderStream stream : streamInfo.getStreams()) {
                String strUid = stream.strUid.isEmpty() ? String.valueOf(stream.speakerUid) : stream.strUid;
                if (!uid.equals(strUid) || entry.getValue().contains(stream.streamName)) continue;
                querySubscribeStream.add(stream.streamName);
                entry.getValue().add(stream.streamName);
            }
        }
        if (!querySubscribeStream.isEmpty()) {
            ThunderNative.updateTranscodingUserStreams(querySubscribeStream);
        }
    }

    private void updateTranscodingQuerySubScribe(boolean bRemove, ArrayList<LiveTranscoding.TranscodingUser> users) {
        String key = null;
        HashSet<String> channelSet = new HashSet<String>();
        for (LiveTranscoding.TranscodingUser user : users) {
            String uid = user.uid;
            String channelId = user.roomId;
            key = uid + "@" + channelId;
            if (!bRemove) {
                if (this.mTranscodingStreamNotify.containsKey(key)) continue;
                HashSet streamName = new HashSet();
                this.mTranscodingStreamNotify.put(key, streamName);
                ThunderNative.subscribeBroadcast(channelId, uid, true);
                channelSet.add(channelId);
                continue;
            }
            if (!this.mTranscodingStreamNotify.containsKey(key)) continue;
            this.mTranscodingStreamNotify.remove(key);
            if (this.mSubscribeUid2RoomId.containsValue(channelId) || channelId.equals(this.mRoomId)) continue;
            ThunderNative.subscribeBroadcast(channelId, uid, false);
        }
        if (!channelSet.isEmpty()) {
            ThunderNative.queryTransCodingChannelStream(channelSet);
        }
    }

    private String getTranscodingConfigJsonFromArgo(int transcodinMode) {
        String ret = ThunderNative.getTranscodingCfgByMode(transcodinMode);
        if (ret != null && ret.length() > 0) {
            ThunderLog.info("yrtc", "getTranscodingConfigJsonFromArgo %s", ret.toString());
        }
        return ret;
    }

    private void resetParamsStatus() {
        this.mSrcStreamUrlSet.clear();
        this.mTranscodingStreamUrlMap.clear();
        this.mTranscodingParamsMap.clear();
        this.mTranscodingStreamNotify.clear();
    }

    private boolean isValidTranscoingTaskId(String taskId) {
        if (taskId == null || taskId.isEmpty()) {
            return false;
        }
        int length = taskId.length();
        if (length > 20) {
            return false;
        }
        int validCharCount = 0;
        for (int i = 0; i < length; ++i) {
            int codePoint = Character.codePointAt(taskId, i);
            if (!(codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 90) && (codePoint < 97 || codePoint > 122)) continue;
            ++validCharCount;
        }
        return validCharCount == length;
    }

    private boolean isSetTranscodingTask(String roomId) {
        if (this.mTranscodingParamsMap != null && !this.mTranscodingParamsMap.isEmpty()) {
            for (Map.Entry<String, LiveTranscodingParams> entry : this.mTranscodingParamsMap.entrySet()) {
                ArrayList<LiveTranscoding.TranscodingUser> userList;
                LiveTranscodingParams params = entry.getValue();
                if (params == null || (userList = params.usersLayout) == null || userList.isEmpty()) continue;
                for (LiveTranscoding.TranscodingUser user : userList) {
                    if (!user.roomId.equals(roomId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static class SingletonHolder {
        private static ThunderAPI INSTANCE = new ThunderAPI();

        private SingletonHolder() {
        }
    }
}

