/*
 * Decompiled with CFR 0.152.
 */
package com.thunder.livesdk;

import com.thunder.livesdk.ThunderCustomVideoSource;
import com.thunder.livesdk.ThunderPublisher;
import com.thunder.livesdk.ThunderVideoCapture;
import com.thunder.livesdk.ThunderVideoCaptureConfig;
import com.thunder.livesdk.ThunderVideoFrameConsumer;
import com.thunder.livesdk.helper.ThunderLog;

public class ExternalVideoSource
extends ThunderVideoCapture {
    ThunderCustomVideoSource mVideoSource = null;
    ThunderPublisher.IVideoPublisher mPublisher = null;

    public ExternalVideoSource(ThunderCustomVideoSource videoSource) {
        this.mVideoSource = videoSource;
    }

    @Override
    public void startCapture(ThunderPublisher.IVideoPublisher proxy) {
        this.mPublisher = proxy;
        if (this.mVideoSource != null) {
            this.mVideoSource.onInitialize(new ThunderVideoFrameConsumer(){

                @Override
                public void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation, long timestamp) {
                    if (ExternalVideoSource.this.mPublisher != null) {
                        ExternalVideoSource.this.mPublisher.pushVideoData(data, format, width, height, rotation, timestamp);
                    }
                }
            });
            this.mVideoSource.onStart();
        } else {
            ThunderLog.info("yrtc", "warning,  need set videoSource...");
        }
    }

    @Override
    public void stopCapture() {
        if (this.mVideoSource != null) {
            this.mVideoSource.onStop();
            this.mVideoSource.onDispose();
        } else {
            ThunderLog.info("yrtc", "warning,  need set videoSource...");
        }
    }

    @Override
    public ThunderVideoCaptureConfig getCaptureConfig() {
        return null;
    }
}

