package com.thunder.livesdk.video;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.provider.Settings;

import com.thunder.livesdk.helper.ThunderLog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ThunderVideoHiidoUtil {

    private final static String TAG = "ThunderVideoHiidoUtil";

    private Context mContext;
    private BatteryMonitor batteryMonitor;
    private IntentFilter filter;
    private static ContentResolver contentResolver;
    private static int current = 0;
    private static LinkedHashMap<String, Object> mAudienceHashMap = new LinkedHashMap<String, Object>();
    private static LinkedHashMap<String, Object> mAnchorHashMap = new LinkedHashMap<String, Object>();
    private boolean mBatteryReceiverRegistered = false;
    private Object syncLock = new Object();

    private interface AnchorHiidoStatInfoKey {
        String BatteryState = "dr39";//电池状态
        String ScreenBrightness = "dr40";//屏幕亮度
    }

    private interface AudienceHiidoStatInfoKey {
        String BatteryState = "dr39";//电池状态
        String ScreenBrightness = "dr40";//屏幕亮度
    }

    public ThunderVideoHiidoUtil(Context context) {
        this.mContext = context;
        this.contentResolver = mContext.getContentResolver();
    }

    public void register() {
        IntentFilter filter = new IntentFilter(Intent.ACTION_BATTERY_CHANGED);
        batteryMonitor = new BatteryMonitor();
        if (mContext != null) {
            synchronized (syncLock) {
                mContext.registerReceiver(batteryMonitor, filter);
                mBatteryReceiverRegistered = true;
            }
        }
    }

    public void unRegister() {
        if (mContext != null) {
            synchronized (syncLock) {
                if (mBatteryReceiverRegistered) {
                    mContext.unregisterReceiver(batteryMonitor);
                    mBatteryReceiverRegistered = false;
                }
            }
        }
        batteryMonitor = null;
        contentResolver = null;
        filter = null;
    }

    public static String getAnchorStatInfo() {
        // ThunderLog.info(TAG,
        //         "putAnchorPowerInfo:" + getCurrentBatteryState() + " " + getSystemBrightness());
        mAnchorHashMap.put(AudienceHiidoStatInfoKey.BatteryState, getCurrentBatteryState());
        mAnchorHashMap.put(AudienceHiidoStatInfoKey.ScreenBrightness, getSystemBrightness());
        return getParamsOrderByKey(mAudienceHashMap);
    }

    public static String getAudienceStatInfo() {
        // ThunderLog.info(TAG,
        //         "putAudiencePowerInfo:" + getCurrentBatteryState() + " " + getSystemBrightness());
        mAudienceHashMap.put(AudienceHiidoStatInfoKey.BatteryState, getCurrentBatteryState());
        mAudienceHashMap.put(AudienceHiidoStatInfoKey.ScreenBrightness, getSystemBrightness());
        return getParamsOrderByKey(mAudienceHashMap);
    }

    /**
     * 按照key排序得到参数列表字符串
     *
     * @param paramValues 参数map对象
     * @return 参数列表字符串
     */
    private static String getParamsOrderByKey(Map<String, Object> paramValues) {
        String params = "";
        if (paramValues != null) {
            List<String> paramNames = new ArrayList<String>(paramValues.size());
            paramNames.addAll(paramValues.keySet());
            Collections.sort(paramNames);
            for (String paramName : paramNames) {
                params += "&" + paramName + "=" + paramValues.get(paramName);
            }
        }
        return params;
    }

    private static int getCurrentBatteryState() {
        if (current < 0) {
            return 0;
        }
        return current;
    }

    private static int getSystemBrightness() {
        int systemBrightness = 0;
        try {
            if (contentResolver != null) {
                systemBrightness = Settings.System.getInt(contentResolver, Settings.System.SCREEN_BRIGHTNESS);
            }
        } catch (Settings.SettingNotFoundException e) {
            ThunderLog.release(TAG, "get SCREEN_BRIGHTNESS:" + e.getMessage());
        }
        return systemBrightness;
    }

    private class BatteryMonitor extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            current = intent.getExtras().getInt("level");
        }
    }
}
