package com.thunder.livesdk.video;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.provider.Contacts;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

import com.thunder.livesdk.ThunderPlayer;
import com.yy.mediaframework.CameraPreviewConfig;
import com.yy.mediaframework.IPublishListener;
import com.yy.mediaframework.ITextureListener;
import com.yy.mediaframework.PublishVideoConfig;
import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYVideoCodec;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.thunder.livesdk.BuildConfig;
import com.thunder.livesdk.ExternalVideoSource;
import com.thunder.livesdk.ThunderAPI;
import com.thunder.livesdk.ThunderRtcConstant.*;
import com.thunder.livesdk.ThunderDefaultCamera;
import com.thunder.livesdk.ThunderScreenCapture;
import com.thunder.livesdk.ThunderVideoCapture;
import com.thunder.livesdk.ThunderPreviewConfig;
import com.thunder.livesdk.ThunderPlayerView;
import com.thunder.livesdk.ThunderPreviewView;
import com.thunder.livesdk.ThunderPublisher;
import com.thunder.livesdk.helper.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.helper.UidMap;
import com.thunder.livesdk.video.serviceConfig.VideoConfigManager;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

import static com.thunder.livesdk.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_NO_MIRROR_PUBLISH_MIRROR;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_MIRROR;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_NO_MIRROR;

/**
 * Created by xiaojun on 2018/1/4.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

/* 对应 C++ 代码的 ThunderVideoEngineImp 类 */
public class ThunderVideoEngineImp implements IPublishListener, ITextureListener {

    public static final int YYPUBLISH_VIDEO_STATE_NONE = 0;
    public static final int YYPUBLISH_VIDEO_STATE_PREVIEW = 1;
    public static final int YYPUBLISH_VIDEO_STATE_ENCODE = 2;

    ConcurrentHashMap<String, ThunderPlayerView> mVideoViewMap;
    ConcurrentHashMap<String, Long> mVideoViewStreamKeyAndIdMap;
    ConcurrentHashMap<String, Integer> mVideoScaleModeMap;
    HashMap<String, IVideoDecodeObserver> mVideoFrameObserverMap;
    ConcurrentHashMap<String, Boolean> mVideoFrameObserverEnableMap;
    ConcurrentHashMap<String, Boolean> mVideoViewDecodeType;
    HashMap<Long, Long> mStreamIdAndDecoderPtsMap;
    HashMap<String, HighLowStreamInfo> mHighLowStreamMap;  // key:uid value:high&low stream
    //当用户在快速调用startPlayView和stop的时候防止覆盖掉老的view（老的view未回收）
    ConcurrentHashMap<String, ThunderPlayerView> mRecoverVideoViewMap;
    private VideoPublish mPublisher = null;
    private long mCallBackPtr = 0;
    private boolean bMixMode = false;
    private ThunderVideoCapture mCapture;
    private OrangeFilterWrapper mOrangeFilterWrapper;
    private ThunderVideoHiidoUtil mThunderVideoHiidoUtil;

    private final static int VIDEO_STAT_FPS = 0;
    private final static int VIDEO_STAT_BITRATE = 1;
    private final static int VIDEO_STATE_RESOLUTION = 2;
    private VideoConfigManager mVideoConfigManager;
    private int mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
    private int mVideoPreviewState = YYPUBLISH_VIDEO_STATE_NONE;
    private YVideoPublishVideoConfig mCurrentVideoConfig = null;
    private Handler mUiHandler = null;
    private Map<String, WeakReference> mPlayViewAndStreamKeyMap = new HashMap<>();
    private VideoFrameYuvCapture mVideoFrameCapture = VideoFrameYuvCapture.getInstance();
    private ThunderVideoPlayListener mThunderVideoPlayListener = null;
    private boolean mIsEnableWebSdkCompatibility = false;
    private Boolean mScreenCaptureInited = false;
    private Boolean mOriginYuvCaptureInited = false;

    public ThunderVideoEngineImp() {
        //比拉取配置要早,异步检查硬编兼容性
        final CountDownLatch waitSync = new CountDownLatch(1);
        Runnable runTestVideoEncoderCrash = new Runnable() {
            @Override
            public void run() {
                try {
                    YYVideoCodec.testVideoEncoderCrash();
                } catch (Exception e) {
                    ThunderLog.error("ThunderVideoEngineImp", "testVideoEncoderCrash crash " + e.toString());
                }
                waitSync.countDown();
            }
        };
        new Thread(runTestVideoEncoderCrash).start();

        try {
            waitSync.await(500, TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            ThunderLog.error("ThunderVideoEngineImp", "testVideoEncoderCrash waitSync crash " + e.toString());
        }

    }

    public void init() {
        mVideoViewMap = new ConcurrentHashMap<String, ThunderPlayerView>();
        mVideoScaleModeMap = new ConcurrentHashMap<String, Integer>();
        mVideoViewStreamKeyAndIdMap = new ConcurrentHashMap<String, Long>();
        mVideoFrameObserverMap = new HashMap<String, IVideoDecodeObserver>();
        mVideoFrameObserverEnableMap = new ConcurrentHashMap<String, Boolean>();
        mVideoViewDecodeType = new ConcurrentHashMap<String, Boolean>();
        mRecoverVideoViewMap = new ConcurrentHashMap<String, ThunderPlayerView>();
        mStreamIdAndDecoderPtsMap = new HashMap<Long, Long>();
        mHighLowStreamMap = new HashMap<String, HighLowStreamInfo>();
        mPublisher = VideoPublish.getInstance();
        mVideoConfigManager = VideoConfigManager.instance();
        mThunderVideoHiidoUtil = new ThunderVideoHiidoUtil(YYVideoLibMgr.instance().getAppContext());
        mThunderVideoHiidoUtil.register();
        mThunderVideoPlayListener = new ThunderVideoPlayListener(YYVideoLibMgr.instance().getAppContext(), this);
        YYVideoLibMgr.instance().setVideoInfoListener(mThunderVideoPlayListener);
        YYVideoLibMgr.instance().setVideoInfoCallback(mThunderVideoPlayListener);
        mUiHandler = new android.os.Handler(Looper.getMainLooper());
        ThunderVideoConfig config = new ThunderVideoConfig();
        //YYVideoSDK.getInstance().enbaleSTLibrary(false);
        config.AsyncLoad();
    }

    public void setPreviewScaleMode(int scaleMode) {
        if (mPublisher != null) {
            mPublisher.setScaleMode(scaleMode);
        }
    }

    public static String getVideoEngineVersion() {
        return "Android: " + BuildConfig.YY_VIDEOLIB_VERSION
                + "&" + BuildConfig.YY_VIDEOPLAYER_VERSION;
    }


    private void prepareView(final ThunderPlayerView view, final int decoderType) {
        //新建程流
        final CountDownLatch barrier = new CountDownLatch(1);
        mUiHandler.post(new Runnable() {
            @Override
            public void run() {
                view.prepareView(decoderType);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        } catch (InterruptedException e) {
            ThunderLog.error("ThunderVideoEngineImp", "updatePlayVideoStream .barrier.await" + e.toString());
        }
    }

    /**
     *  更新 View 以及绑定流ID到对应的View
     * @param streamKey  流KEY
     * @param streamId   流ID
     * @param streamType 流类型
     * @param bSoftDecode 是否软解
     * @return  0 : update to software decoder  1 : update to hardware decoder   -1 : un-change
     */
    public int updatePlayVideoStream(final String streamKey, final long streamId, final int streamType, final boolean bSoftDecode) {
        ThunderLog.info("ThunderVideoEngineImp",
                        "updatePlayVideoStream streamKey:" + streamKey +
                         " streamId:" + streamId +
                         " streamType:" + streamType +
                         " bSoftDecode:" + bSoftDecode);

        final int[] result = {-1};
        if (Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()) {
            result[0] = updatePlayVideoStreamUI(streamKey, streamId, streamType, bSoftDecode);
        } else {
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    result[0] = updatePlayVideoStreamUI(streamKey, streamId, streamType, bSoftDecode);
                }
            });
        }
        return result[0];
    }

    public void setLowDelayMode(boolean mode) {
        if (mCurrentVideoConfig != null && mCurrentVideoConfig.bLowLatency != mode) {
            mPublisher.setLowDelayMode(mode);
            mCurrentVideoConfig.bLowLatency = mode;
        }

        ThunderLog.info("ThunderVideoEngineImp", "setLowDelayMode new mode " + mode + " old :" +
                (mCurrentVideoConfig != null ? mCurrentVideoConfig.bLowLatency : "null"));
    }

    public int setDecodeType(String streamKey, final int streamType) {
        final int decodeType = mVideoConfigManager.getPlayViewTypeFromStream(streamType);
        ThunderLog.info("ThunderVideoEngineImp", "setDecodeType streamKey " + streamKey + " type:" + streamType);
        if (mVideoConfigManager == null) {
            ThunderLog.error("ThunderVideoEngineImp", "setDecodeType mVideoConfigManager == null!");
            return -1;
        }
        int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            ThunderLog.error("ThunderVideoEngineImp",
                    "setDecodeType mVideoScaleModeMap can't find scaleMode in map :" + mVideoScaleModeMap.size());
            return -1;
        }

        final ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (mVideoViewMap.get(streamKey) == null) {
            ThunderLog.error("ThunderVideoEngineImp",
                    "setDecodeType mVideoScaleModeMap can't find view in map :" + mVideoViewMap.size());
            return -1;
        }
        if (Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()) {
            view.prepareView(decodeType);
        } else {
            final CountDownLatch barrier = new CountDownLatch(1);
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    view.prepareView(decodeType);
                    barrier.countDown();
                }
            });
            try {
                barrier.await();
            } catch (InterruptedException e) {
                ThunderLog.error("ThunderVideoEngineImp", "setDecodeType .barrier.await" + e.toString());
            }

        }
        view.setScaleMode(scaleMode);
        ThunderLog.info("ThunderVideoEngineImp",
                streamKey + " setDecodeType success : scaleMode" + scaleMode + ", decodeType: " + decodeType);

        return (decodeType == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 ? 1 : 0);
    }

    public boolean startVideoEngine() {
        return true;
    }

    public boolean stopVideoEngine() {
        if (mThunderVideoHiidoUtil != null) {
            mThunderVideoHiidoUtil.unRegister();
        }
        return true;
    }

    public void setVideoEngineCallBack(long ptr) {
        mCallBackPtr = ptr;
    }

    private boolean isUsingDefaultCamera() {
        return !bMixMode && (mCapture == null ? false : mCapture instanceof ThunderDefaultCamera);
    }

    public void attachVideoCapture(Object capture) {

        if (mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE) {
            if (mCapture != null && mCapture instanceof ThunderScreenCapture) {
                mPublisher.stopPublishScreenVideo();
            } else if (mCapture != null && mCapture.getClass() == ExternalVideoSource.class) {
                mPublisher.stopPublishLiveVideo();
            } else if (mCapture == null || mCapture instanceof ThunderDefaultCamera) {
                mPublisher.stopPublishLiveVideo();
            }
        }

        ThunderLog.info("ThunderVideoEngineImp",
                "detach capture: " + (mCapture == null ? "ThunderDefaultCamera" : mCapture.toString()) +
                        " mVideoPublishState" + mVideoPublishState);

        mCapture = (ThunderVideoCapture) capture;
        ThunderLog.info("ThunderVideoEngineImp", "attach capture: " + mCapture.toString());

        if (mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE) {
            //这里编码参数以startEncoder和update为准,和IOS对齐
//            int playType = mCurrentVideoConfig.playType;
//            if(mCapture instanceof ThunderScreenCapture){
//                playType = VideoLiveConfig.Type.SCREEN_CAPTURE;
//            }

            VideoEncoderConfig newEncoderConfig =
                    getVideoEncoderConfigByType(mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);

            List<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<>();
            if (mCapture.getClass() == ThunderScreenCapture.class && ((ThunderScreenCapture) mCapture).isLandscap()) {
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else if ((mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) &&
                    ((ThunderPreviewConfig) mCapture.getCaptureConfig()).captureOrientation ==
                            ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
                //横屏模式
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else {
                copyResolutionModifyConfig(resolutionModifyConfigs);
            }
//            mPublisher.enableMirror(mCurrentVideoConfig.bMirrorFrontCamera);
            newEncoderConfig.mLowDelay = mCurrentVideoConfig.bLowLatency;

            mPublisher
                    .setResolutionModifyConfigs(resolutionModifyConfigs, mVideoConfigManager.getCurrentIntervalSecs());

            if (mCapture instanceof ThunderScreenCapture) {
                if (mScreenCaptureInited == false) {
                    ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture) mCapture;
                    mPublisher.initScreenLiveSession(thunderScreenCapture.getMediaProjection(), this,
                            thunderScreenCapture.isLandscap());
                    mScreenCaptureInited = true;
                }

                mPublisher.startPublishScreenVideo("general", null, newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishScreenVideo %dx%d %d %d %s %b %b",
                        newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate,
                        newEncoderConfig.mBitRate,
                        newEncoderConfig.mEncodeType.name(), mCurrentVideoConfig.bMirrorFrontCamera,
                        newEncoderConfig.mLowDelay);
            } else if (mCapture != null && mCapture.getClass() == ExternalVideoSource.class) {
                if (mOriginYuvCaptureInited == false) {
                    ThunderLog.warn("ThunderVideoEngineImp", "startOriginDataCapture !");
                    mPublisher.startOriginDataCapture(this);
                    mCapture.startCapture(new ThunderPublisher.IVideoPublisher() {
                        @Override
                        public void pushVideoData(byte[] data, int format, int width, int height, int rotation,
                                                  long timestamp) {
                            setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
                        }

                        @Override
                        public void pushVideoData(byte[] encodedData, ThunderVideoEncodeType type,
                                                  long dts, long pts) {

                        }
                    });
                    mOriginYuvCaptureInited = true;
                }

                mPublisher.startPublishLiveVideo("general", null, newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishLiveVideo yuv %dx%d %d %d %s %b %b",
                        newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate,
                        newEncoderConfig.mBitRate,
                        newEncoderConfig.mEncodeType.name(), mCurrentVideoConfig.bMirrorFrontCamera,
                        newEncoderConfig.mLowDelay);

            } else {
                mPublisher.startPublishLiveVideo("general", null, newEncoderConfig);
                ThunderLog.info("ThunderVideoEngineImp", "startPublishLiveVideo %dx%d %d %d %s %b %b",
                        newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate,
                        newEncoderConfig.mBitRate,
                        newEncoderConfig.mEncodeType.name(), mCurrentVideoConfig.bMirrorFrontCamera,
                        newEncoderConfig.mLowDelay);

            }
        }
    }

    private CameraPreviewConfig getCameraPreviewConfigByType(int playType, int previewMode) {
        CameraPreviewConfig result = mVideoConfigManager.getCameraPreviewConfigByType(playType, previewMode);
        ThunderLog.info("ThunderVideoEngineImp", "getCameraPreviewConfigByType:" + result.toString());
        return result;
    }

    private int getBeautyLevelInCurrentConfig() {
        int result = 0;
        if (mVideoConfigManager != null) {
            result = mVideoConfigManager.getCurrentBeautifyLevel();
        }

        ThunderLog.info("ThunderVideoEngineImp", "getBeautyLevelInCurrentConfig:" + result);
        return result;
    }

    private VideoEncoderConfig getVideoEncoderConfigByType(int playType, int mode) {
        VideoEncoderConfig result = mVideoConfigManager.getVideoEncodeConfigByType(playType, mode);
        ThunderLog.info("ThunderVideoEngineImp", "getVideoEncoderConfigByType:" + result.toString());
        return result;
    }

    private boolean checkLowDelayByType(int playType) {
        return mVideoConfigManager.checkLowDelayByType(playType);
    }

    private CameraPreviewConfig toCamerePreviewConfig(ThunderPreviewConfig config) {
        CameraPreviewConfig newConf = new CameraPreviewConfig(CameraPreviewConfig.PREVIEW_MODE_NORMAL);
        newConf.mCaptureResolutionWidth = config.captureResolutionWidth;
        newConf.mCaptureResolutionHeight = config.captureResolutionHeight;
        newConf.mCameraPosition = config.cameraPosition;
        newConf.mCaptureFrameRate = config.captureFrameRate;
        newConf.mCaptureOrientation = config.captureOrientation;
        return newConf;
    }

    public YVideoPublishVideoConfig setOrientation(int orientatin) {
        ThunderLog.info("ThunderVideoEngineImp", " setOrientation " + orientatin);
        if (mCapture != null && mCapture instanceof ThunderScreenCapture) {
            ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture) mCapture;
            if ((thunderScreenCapture.isLandscap() && orientatin !=
                    ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) ||
                    (!thunderScreenCapture.isLandscap()) && (orientatin !=
                            ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT)) {
                stopEncodeVideo();
                thunderScreenCapture.setIslandScape(orientatin ==
                        ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE);
                startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency,
                        mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
            }

            return mCurrentVideoConfig;
        } else {

            ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
            ThunderPreviewConfig config = (ThunderPreviewConfig) camera.getCaptureConfig();
            if (orientatin != config.captureOrientation) {
                //横竖屏变换
                config.captureOrientation = orientatin;
                config.captureResolutionWidth = config.captureResolutionWidth + config.captureResolutionHeight;
                config.captureResolutionHeight = config.captureResolutionWidth - config.captureResolutionHeight;
                config.captureResolutionWidth = config.captureResolutionWidth - config.captureResolutionHeight;
                camera.setCaptureConfig(config);
                if (mVideoFrameCapture != null) {
                    mVideoFrameCapture
                            .updateVideoCaptureFrameInfo(config.captureResolutionWidth, config.captureResolutionHeight);
                }
            }

            if ((mCapture != null && mCapture instanceof ThunderScreenCapture &&
                    mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE &&
                    mVideoPreviewState == YYPUBLISH_VIDEO_STATE_PREVIEW) ||
                    (mCapture == null && mVideoPublishState != YYPUBLISH_VIDEO_STATE_ENCODE &&
                            mVideoPreviewState == YYPUBLISH_VIDEO_STATE_PREVIEW)) {
                //预览开启，但是开播为录屏，此时只更新预览; 或者预览开启
                mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
            } else {

                boolean recover = mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE ? true : false;

                stopEncodeVideo();
                mPublisher.updateCameraPreviewParam(toCamerePreviewConfig(config));
                if (mCurrentVideoConfig != null && recover) {
                    startEncodeVideo(mCurrentVideoConfig.bMirrorFrontCamera, mCurrentVideoConfig.bLowLatency,
                            mCurrentVideoConfig.playType, mCurrentVideoConfig.mode);
                }
            }

            if (mCurrentVideoConfig != null) {
                mCurrentVideoConfig.orientation = orientatin;
                mCurrentVideoConfig.encodeResolutionWidth =
                        mCurrentVideoConfig.encodeResolutionWidth + mCurrentVideoConfig.encodeResolutionHeight;
                mCurrentVideoConfig.encodeResolutionHeight =
                        mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
                mCurrentVideoConfig.encodeResolutionWidth =
                        mCurrentVideoConfig.encodeResolutionWidth - mCurrentVideoConfig.encodeResolutionHeight;
            }

            if (mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE) {
                return mCurrentVideoConfig;
            } else {
                return null;
            }
        }
    }

    public void setLocalVideoView(Object toView) {
        ThunderPreviewView previewView = (ThunderPreviewView) toView;
        ThunderLog.info("ThunderVideoEngineImp", "setLocalVideoView " + mVideoPreviewState +
                " view " + (toView != null ? ((ThunderPreviewView) toView).getSurfaceView() : "null"));

        if (mVideoPreviewState == YYPUBLISH_VIDEO_STATE_PREVIEW && previewView != null) {
            mPublisher.setPreviewSurfaceView(previewView.getSurfaceView());
        }
    }

    public int startPreview(int playType, int publishMode) {
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        ThunderPreviewConfig config = (ThunderPreviewConfig) camera.getCaptureConfig();

        mPublisher.setPhonePerformanceLevel(getBeautyLevelInCurrentConfig());
        CameraPreviewConfig newConfig = getCameraPreviewConfigByType(playType, publishMode);
        newConfig.mCameraPosition = ((ThunderPreviewConfig) camera.getCaptureConfig()).cameraPosition;
        if (config.captureOrientation ==
                ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
            //横屏模式
            int mid = newConfig.mCaptureResolutionWidth;
            newConfig.mCaptureResolutionWidth = newConfig.mCaptureResolutionHeight;
            newConfig.mCaptureResolutionHeight = mid;

        }

        if (mVideoFrameCapture != null) {
            mVideoFrameCapture
                    .updateVideoCaptureFrameInfo(newConfig.mCaptureResolutionWidth, newConfig.mCaptureResolutionHeight);
        }

        newConfig.mCaptureOrientation = config.captureOrientation;
        mPublisher.startPreview(newConfig, this);

        if (camera.getCameraDataCallback() != null) {
            ThunderLog.info("ThunderVideoEngineImp", "setTextureListener %s %s",
                    camera.getCameraDataCallback().toString(), this.toString());
            mPublisher.setTextureListener(this);
        }
        mOrangeFilterWrapper = mPublisher.getOrangeFilterWrapperObject();

        //同步当前camera的config
        config.captureFrameRate = newConfig.mCaptureFrameRate;
        config.captureResolutionHeight = newConfig.mCaptureResolutionHeight;
        config.captureResolutionWidth = newConfig.mCaptureResolutionWidth;
        camera.setCaptureConfig(config);

        mVideoPreviewState = YYPUBLISH_VIDEO_STATE_PREVIEW;

        if (mCapture != null && mCapture.getClass() == ThunderDefaultCamera.class &&
                mVideoPublishState == YYPUBLISH_VIDEO_STATE_ENCODE) {
            //这里说明attach过,且当前attach是摄像头, 并处于开播状态这时候直接开播
            ThunderLog.info("ThunderVideoEngineImp",
                    "startPreview attach camera SO publish:" + playType + ":" + publishMode);
            startEncodeVideo(false, false, playType, publishMode);
        }

        return 0;
    }

    public void setOriginFrameToEncode(final byte[] data, final int format, final int width, final int height,
                                       final int rotation, final long timestamp) {
        if (mPublisher != null) {
            mPublisher.setOriginFrameToEncode(data, format, width, height, rotation, timestamp);
        }
    }

    public int stopPreview() {
        if (mVideoPreviewState != YYPUBLISH_VIDEO_STATE_PREVIEW) {
            ThunderLog.info("ThunderVideoEngineImp", "stopPreview previewState wrong:" + mVideoPublishState);
        }
        mVideoPreviewState = YYPUBLISH_VIDEO_STATE_NONE;
        return mPublisher.stopPreview();
    }

    /**
     * 从配置中心提取配置开播
     *
     * @param bMirrorFrontCamera 镜像
     * @param bLowLatency        低延时
     * @param playType           玩法
     * @param mode               模式
     * @return 实际使用的编码参数
     */
    public YVideoPublishVideoConfig startEncodeVideo(
            boolean bMirrorFrontCamera,
            boolean bLowLatency,
            int playType,
            int mode) {
        //以playtype为主
//        if(mCapture != null && mCapture.getClass() == ThunderScreenCapture.class){
//            ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig change playType from %d :%d", playType, VideoLiveConfig.Type.SCREEN_CAPTURE);
//            playType = VideoLiveConfig.Type.SCREEN_CAPTURE;
//        }

        VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);
        List<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<>();
        if (mCapture != null && mCapture.getClass() == ThunderScreenCapture.class &&
                ((ThunderScreenCapture) mCapture).isLandscap()) {
            int mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;

            copyResolutionModifyConfigReverse(resolutionModifyConfigs);
        } else if ((mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) &&
                ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera()
                        .getCaptureConfig()).captureOrientation ==
                        ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
            //横屏模式
            int mid = newEncoderConfig.mEncodeWidth;
            newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
            newEncoderConfig.mEncodeHeight = mid;

            copyResolutionModifyConfigReverse(resolutionModifyConfigs);
        } else {
            copyResolutionModifyConfig(resolutionModifyConfigs);
        }

        if (mIsEnableWebSdkCompatibility) {
            newEncoderConfig.mLowDelay = true;
        } else {
            newEncoderConfig.mLowDelay = checkLowDelayByType(playType);
        }

        ThunderLog.info("ThunderVideoEngineImp", "startPublishVideo %dx%d %d %d %s %b %b",
                newEncoderConfig.mEncodeWidth, newEncoderConfig.mEncodeHeight, newEncoderConfig.mFrameRate,
                newEncoderConfig.mBitRate,
                newEncoderConfig.mEncodeType.name(), bMirrorFrontCamera, newEncoderConfig.mLowDelay);


        if (mCapture != null && mCapture.getClass() == ThunderScreenCapture.class && mScreenCaptureInited == false) {
            // 录屏
            ThunderScreenCapture thunderScreenCapture = (ThunderScreenCapture) mCapture;
            mPublisher.initScreenLiveSession(thunderScreenCapture.getMediaProjection(), this,
                    thunderScreenCapture.isLandscap());
            mScreenCaptureInited = true;
        }

        //设置动态分辨率
        mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs, mVideoConfigManager.getCurrentIntervalSecs());
        int ret = -1;
        if (mCapture != null && mCapture instanceof ThunderScreenCapture) {
            ret = mPublisher.startPublishScreenVideo("general", null, newEncoderConfig);
        } else {
            ret = mPublisher.startPublishLiveVideo("general", null, newEncoderConfig);
        }


        if (ret == 0) {
            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }

            int videoLevel = mVideoConfigManager.getCurrentVideoLevel();

            if (mCurrentVideoConfig == null) {
                mCurrentVideoConfig =
                        new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate, newEncoderConfig.mBitRate / 1000,
                                newEncoderConfig.mEncodeWidth,
                                newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }

            mCurrentVideoConfig.bLowLatency = newEncoderConfig.mLowDelay;
            mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
            mCurrentVideoConfig.playType = playType;
            mCurrentVideoConfig.mode = videoLevel;
            mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            mCurrentVideoConfig.bHardwareEncoder = hard;
            mCurrentVideoConfig.encodeType = encodeType;

            mCurrentVideoConfig.orientation =
                    mCurrentVideoConfig.encodeResolutionWidth > mCurrentVideoConfig.encodeResolutionHeight ?
                            ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE :
                            ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_PORTRAIT;
        }

        if (mVideoPublishState != YYPUBLISH_VIDEO_STATE_PREVIEW) {
            ThunderLog.info("ThunderVideoEngineImp", "startPublishVideo videoState wrong:" + mVideoPublishState);
        }
        mVideoPublishState = YYPUBLISH_VIDEO_STATE_ENCODE;
        return mCurrentVideoConfig;
    }

    public int stopEncodeVideo() {
        ThunderLog.info("ThunderVideoEngineImp", "stopEncodeVideo ....");

        if (mVideoPublishState != YYPUBLISH_VIDEO_STATE_ENCODE) {
            ThunderLog.info("ThunderVideoEngineImp", "stopEncodeVideo videoState wrong:" + mVideoPublishState);
        }
        mVideoPublishState = YYPUBLISH_VIDEO_STATE_NONE;
        mPublisher.stopPublishVideo();

        if (mOriginYuvCaptureInited) {
            mPublisher.stopOriginDataCapture();
            mCapture.stopCapture();
            mOriginYuvCaptureInited = false;
        }

        if (mScreenCaptureInited) {
            mPublisher.deInitScreenLiveSession();
            mScreenCaptureInited = false;
        }
        return 0;
    }

    public void changeScreenLiveMode(boolean pictureMode, Object bitmap) {
        mPublisher.changeScreenLiveMode(pictureMode, (Bitmap) bitmap);
    }

    public int startPlayVideoStream(final String streamKey,
                                    final Object toView,
                                    final boolean bSoftDecode,
                                    final int scaleMode) {
        ThunderLog.info("ThunderVideoEngineImp",
                        "startPlayVideoStream streamKey:" + streamKey +
                         " toView:" + toView +
                         " bSoftDecode:" + bSoftDecode +
                         " scaleMode:" + scaleMode);

        if (Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()) {
            startPlayVideoStreamUI(streamKey, toView, bSoftDecode, scaleMode);
        } else {
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    startPlayVideoStreamUI(streamKey, toView, bSoftDecode, scaleMode);
                }
            });
        }

        return 0;
    }

    public int stopPlayVideoStream(String streamKey) {
        ThunderLog.info("ThunderVideoEngineImp", "stopPlayVideoStream streamKey:" + streamKey);

        if (Thread.currentThread().getId() == mUiHandler.getLooper().getThread().getId()) {
            stopPlayVideoStreamUI(streamKey);
        } else {
            final String f_streamKey = streamKey;
            mUiHandler.post(new Runnable() {
                @Override
                public void run() {
                    stopPlayVideoStreamUI(f_streamKey);
                }
            });
        }
        return 0;
    }

    public void setPlayVideoViewScaleMode(Object toView, int scaleMode) {
        String streamKey = null;
        if (toView == null) {
            return;
        }
        Set<Map.Entry<String, ThunderPlayerView>> entrySet = mVideoViewMap.entrySet();
        Iterator<Map.Entry<String, ThunderPlayerView>> it = entrySet.iterator();
        while (it.hasNext()) {
            Map.Entry<String, ThunderPlayerView> me = it.next();
            if (toView.equals(me.getValue())) {
                streamKey = me.getKey();
                mVideoScaleModeMap.put(streamKey, scaleMode);
                me.getValue().setScaleMode(scaleMode);
                return;
            }
        }
        ThunderLog.warn("ThunderVideoEngineImp",
          "setPlayVideoViewScaleMode toView is not found! view:" + toView);
        return;
    }

    public void setVideoFrameObserver(String uid, Object observer) {

        if (observer == null) {
            ThunderLog.info("ThunderVideoEngineImp", "setVideoFrameObserver remove " + uid + " ->" + observer);
            mVideoFrameObserverMap.remove(uid);
            mVideoFrameObserverEnableMap.remove(uid);
        } else {
            ThunderLog.info("ThunderVideoEngineImp", "setVideoFrameObserver " + uid + " ->" + observer);
            mVideoFrameObserverMap.put(uid, (IVideoDecodeObserver) observer);
        }
    }

    public boolean updatePlayVideoView(String streamKey, Object toView, int scaleMode) {
        if (toView == null || streamKey == null || streamKey.isEmpty()) {
            return false;
        }

        ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            return false;
        }

        if (!view.equals(toView)) {
            ThunderLog.warn("ThunderVideoEngineImp", "may toView is change!");
            return false;
        }
        mVideoScaleModeMap.put(streamKey, scaleMode);
        ThunderLog.debug("ThunderVideoEngineImp", "update play scale mode: " + scaleMode);
        return view.setScaleMode(scaleMode);
    }

    private void copyResolutionModifyConfig(List<ResolutionModifyConfig> dst) {
        if (mVideoConfigManager.getCurrentModifyConfig() != null &&
                mVideoConfigManager.getCurrentModifyConfig().size() > 0) {
            for (int i = 0; i < mVideoConfigManager.getCurrentModifyConfig().size(); i++) {
                ResolutionModifyConfig tmp =
                        new ResolutionModifyConfig(mVideoConfigManager.getCurrentModifyConfig().get(i).width,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).height,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).minCodeRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).maxCodeRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).minFrameRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).maxFrameRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).videoEncoderType,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).encoderParams);
                dst.add(tmp);
            }
        }
    }

    private void copyResolutionModifyConfigReverse(List<ResolutionModifyConfig> dst) {
        if (mVideoConfigManager.getCurrentModifyConfig() != null &&
                mVideoConfigManager.getCurrentModifyConfig().size() > 0) {
            for (int i = 0; i < mVideoConfigManager.getCurrentModifyConfig().size(); i++) {
                ResolutionModifyConfig tmp =
                        new ResolutionModifyConfig(mVideoConfigManager.getCurrentModifyConfig().get(i).height,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).width,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).minCodeRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).maxCodeRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).minFrameRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).maxFrameRate,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).videoEncoderType,
                                mVideoConfigManager.getCurrentModifyConfig().get(i).encoderParams);
                dst.add(tmp);
            }
        }
    }

    /**
     * *  更新预览和开播参数,从配置中心中依据playType 和 mode 匹配详细的参数值
     *
     * @param bMirrorFrontCamera 镜像开启
     * @param bLowLatency        低延时
     * @param playType           玩法{@link com.thunder.livesdk.video.serviceConfig.VideoLiveConfig.Type}
     * @param mode               模式{@link com.thunder.livesdk.video.serviceConfig.VideoLiveConfig.Level}
     * @return 实际使用的编码参数 {@link YVideoPublishVideoConfig}
     */
    public YVideoPublishVideoConfig updatePublishVideoConfig(
            boolean bMirrorFrontCamera,
            boolean bLowLatency,
            int playType,
            int mode) {
        if (mCurrentVideoConfig == null || playType != mCurrentVideoConfig.playType ||
                mode != mCurrentVideoConfig.mode) {
            VideoEncoderConfig newEncoderConfig = getVideoEncoderConfigByType(playType, mode);

            List<ResolutionModifyConfig> resolutionModifyConfigs = new ArrayList<>();
            if (mCapture != null && mCapture.getClass() == ThunderScreenCapture.class &&
                    ((ThunderScreenCapture) mCapture).isLandscap()) {
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else if ((mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) &&
                    ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera()
                            .getCaptureConfig()).captureOrientation ==
                            ThunderPublishOrientation.THUNDERPUBLISH_VIDEO_ORIENTATION_LANDSCAPE) {
                //横屏模式
                int mid = newEncoderConfig.mEncodeWidth;
                newEncoderConfig.mEncodeWidth = newEncoderConfig.mEncodeHeight;
                newEncoderConfig.mEncodeHeight = mid;

                copyResolutionModifyConfigReverse(resolutionModifyConfigs);
            } else {
                copyResolutionModifyConfig(resolutionModifyConfigs);
            }

            PublishVideoConfig videoConfig = new PublishVideoConfig();
            videoConfig.assign(newEncoderConfig);

            if (mIsEnableWebSdkCompatibility) {
                videoConfig.mLowDelay = true;
            } else {
                videoConfig.mLowDelay = checkLowDelayByType(playType);
            }

            if (videoConfig.mLowDelay != bLowLatency) {
                ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig %b :%d", bLowLatency, playType);
            }

            //设置动态分辨率
            mPublisher.setResolutionModifyConfigs(resolutionModifyConfigs,
                    mVideoConfigManager.getCurrentIntervalSecs());
            mPublisher.stopPublishVideo();

            if (mCapture != null && mCapture.getClass() == ThunderScreenCapture.class) {
                mPublisher.startPublishScreenVideo("general", null, videoConfig);
            } else if (mCapture != null && mCapture.getClass() == ExternalVideoSource.class) {
                mPublisher.updateOriginPublishVideoConfig(videoConfig);
            } else {
                mPublisher.updateLivePublishVideoConfig(videoConfig);
            }

            int encodeType = 0;
            boolean hard = false;
            if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H264) {
                hard = true;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_X264) {
                hard = false;
                encodeType = 0;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.SOFT_ENCODER_H265) {
                hard = false;
                encodeType = 1;
            } else if (newEncoderConfig.mEncodeType == VideoEncoderType.HARD_ENCODER_H265) {
                hard = true;
                encodeType = 1;
            }

            int videoLevel = mVideoConfigManager.getCurrentVideoLevel();

            if (mCurrentVideoConfig == null) {
                mCurrentVideoConfig = new YVideoPublishVideoConfig(newEncoderConfig.mFrameRate,
                        newEncoderConfig.mBitRate / 1000,
                        newEncoderConfig.mEncodeWidth,
                        newEncoderConfig.mEncodeHeight, encodeType, hard, videoLevel);
            }

            mCurrentVideoConfig.playType = playType;
            mCurrentVideoConfig.mode = videoLevel;
            mCurrentVideoConfig.encodeFrameRate = newEncoderConfig.mFrameRate;
            mCurrentVideoConfig.encodeBitrate = newEncoderConfig.mBitRate / 1000;
            mCurrentVideoConfig.encodeResolutionWidth = newEncoderConfig.mEncodeWidth;
            mCurrentVideoConfig.encodeResolutionHeight = newEncoderConfig.mEncodeHeight;
            mCurrentVideoConfig.bHardwareEncoder = hard;
            mCurrentVideoConfig.encodeType = encodeType;
            if (mCapture == null || mCapture.getClass() == ThunderDefaultCamera.class) {
                mCurrentVideoConfig.orientation =
                        ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera()
                                .getCaptureConfig()).captureOrientation;
            } else {
                mCurrentVideoConfig.orientation = 0;
            }

            mCurrentVideoConfig.bLowLatency = videoConfig.mLowDelay;
        }

//		if(bLowLatency != mCurrentVideoConfig.bLowLatency){
//			mPublisher.setLowDelayMode(bLowLatency);
//			mCurrentVideoConfig.bLowLatency = bLowLatency;
//		}

        if (bMirrorFrontCamera != mCurrentVideoConfig.bMirrorFrontCamera) {
            mPublisher.enableMirror(bMirrorFrontCamera);
            mCurrentVideoConfig.bMirrorFrontCamera = bMirrorFrontCamera;
        }
        if (YYPUBLISH_VIDEO_STATE_ENCODE != mVideoPublishState) {
            mVideoPublishState = YYPUBLISH_VIDEO_STATE_ENCODE;
            ThunderLog.info("ThunderVideoEngineImp", "updatePublishVideoConfig state:" + YYPUBLISH_VIDEO_STATE_ENCODE);
        }
        return mCurrentVideoConfig;
    }

    public boolean setCameraPosition(int position) {
        ((ThunderPreviewConfig) ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera()
                .getCaptureConfig()).cameraPosition = position;
        return mPublisher.setCameraPosition(position);
    }

    public int setPubWatermark(float x, float y, Object image) {
        return mPublisher.setWatermark((Bitmap) image, (int) x, (int) y);
    }

    public int setPubFaceBeautyLevel(float level) {
//		mPublisher.setBeautyParam(level);
        if (mOrangeFilterWrapper != null) {
            mOrangeFilterWrapper.setBeautyParam(level);
        }
        return 0;
    }

    private String getVideoViewStreamKey(long streamId) {
        String StreamKey = null;
        for (Map.Entry<String, Long> entry: mVideoViewStreamKeyAndIdMap.entrySet()) {
            if (entry.getValue() == streamId) {
                StreamKey = entry.getKey();
            }
        }
        return StreamKey;
    }

    /**
     * 判断大小流匹配关系，匹配成功，则大流切到小流，大小流只是逻辑关系，不表示大流一定是分辨率高的流
     *
     * @param streamKey 新来的流的streamKey (小流)
     * @param streamId  新来的流的流ID      (小流)
     * @param linkedStreamId  当前view已链接的流ID (大流),
     * @return
     */
    private boolean isSubStream(String streamKey, long streamId, long linkedStreamId) {
        // 大小流 UID 是否相同
        String lowStreamUid = UidMap.getStringUid(streamId >> 32);
        String highStreamUid = UidMap.getStringUid(linkedStreamId >> 32);

        ThunderLog.info("ThunderVideoEngineImp",
          "isSubStream from:" + linkedStreamId + " to:" + streamId);

        if (!lowStreamUid.equals(highStreamUid)) {
            ThunderLog.warn("ThunderVideoEngineImp",
                    "isSubStream: HighLow stream UID un-match: L(%s) - H(%s)",
                    lowStreamUid, highStreamUid);
            return false;
        }

        // 当前是否正在播放大流
        String linkedStreamKey = getVideoViewStreamKey(linkedStreamId);
        if (linkedStreamKey == null || linkedStreamKey.isEmpty()) {
            ThunderLog.warn("ThunderVideoEngineImp", "isSubStream: get Linked streamKey failed. "
                    + linkedStreamId + ": " + linkedStreamKey);
            return false;
        }
        boolean isHighStreamOk = ThunderAPI.sharedInstance().getPlayer().isHighStream(linkedStreamKey);
        boolean isLowStreamOk = ThunderAPI.sharedInstance().getPlayer().isLowStream(streamKey);

        ThunderLog.info("ThunderVideoEngineImp",
          "isSubStream from:" + linkedStreamKey + " to:" + streamKey);
        return isHighStreamOk && isLowStreamOk;
    }

    public int onVideoStreamArrive(String streamKey, long streamId) {
        ThunderPlayerView view = mVideoViewMap.get(streamKey);
        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp",
                    "onVideoStreamArrive: cannot find video view for stream:%s",
                    streamKey);
            return -1;
        }

        ThunderLog.info("ThunderVideoEngineImp", "onVideoStreamArrive:%s, %d", streamKey, streamId);
        long linkedStreamId = view.getLinkedStream();

        ThunderLog.warn("ThunderVideoEngineImp",
          "onVideoStreamArrive: view:" +
          view);

        if (isSubStream(streamKey, streamId, linkedStreamId)) {
            view.linkToSubStream(streamId);
            // 保存大小流对应的流ID, KEY:大流  VALUE:小流
            HighLowStreamInfo info = new HighLowStreamInfo();
            info.highStreamId = linkedStreamId;
            info.lowStreamId = streamId;
            info.highStreamKey = getVideoViewStreamKey(linkedStreamId);
            info.lowStreamKey = streamKey;
            info.highStreamName = ThunderAPI.sharedInstance().getPlayer().getHighStreamName(info.highStreamKey);
            info.lowStreamName = ThunderAPI.sharedInstance().getPlayer().getLowStreamName(info.lowStreamKey);
            mHighLowStreamMap.put(UidMap.getStringUid(streamId >> 32), info);
            // 通知小流到达通知，开始超时计时
            ThunderAPI.sharedInstance().getPlayer().notifyLowStreamArrive();
            ThunderLog.info("ThunderVideoEngineImp", "link high low stream: %s", info);
        } else {
            view.linkToStream(streamId);
        }
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(mThunderVideoPlayListener);
        }
        mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
        mVideoFrameObserverEnableMap.put(UidMap.getStringUid(streamId >> 32), true);
        return 0;
    }

    public int onVideoStreamStop(String streamKey, long streamId) {
        ThunderPlayerView view = mVideoViewMap.get(streamKey);
        ThunderPlayerView tmpView = null;
        if (view != null) {
            tmpView = mRecoverVideoViewMap.put(streamKey, view);
            if (tmpView != null && (!tmpView.equals(view))) {
                //说明用户快速调用了startPlayVideoStream 和stop
                tmpView.unLinkFromStream();
                mRecoverVideoViewMap.remove(streamKey);
                ThunderLog.info("ThunderVideoEngineImp", "recover unlink stream:%s-%d", streamKey, streamId);
                return 0;
            }
        }

        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp",
                    "onVideoStreamStop: cann't find video view for stream:%s",
                    streamKey);
            return -1;
        }
        ThunderLog.info("ThunderVideoEngineImp", "unlink stream:%s-%d", streamKey, streamId);

        // 大小流切换完成后，清理相关状态
        if (ThunderAPI.sharedInstance().getPlayer().isHighStream(streamKey)) {
            String uid = UidMap.getStringUid(streamId >> 32);
            HighLowStreamInfo info = mHighLowStreamMap.get(uid);
            if (info != null && info.highStreamId == streamId) {
                view.unLinkFromSubStream(info.lowStreamId);
            }
            mHighLowStreamMap.clear();
            mVideoViewMap.remove(streamKey);
            ThunderAPI.sharedInstance().getPlayer().clearHighLowStream();
            ThunderLog.info("ThunderVideoEngineImp", " onVideoStreamStop stop High stream success. ");
        } else {
            view.unLinkFromStream(streamId);
        }
        mVideoFrameObserverEnableMap.put(UidMap.getStringUid(streamId >> 32), false);
        mRecoverVideoViewMap.remove(streamKey);
        if (view != null && view.getYspVideoView() != null) {
            view.getYspVideoView().setVideoInfoCallback(null);
        }
        return 0;
    }

    public int onRequestIFrame() {
        mPublisher.requestEncodeIFrame();
        return 0;
    }

    //弱网
    public int onDynamicBitrate(long bitrate) {
        // 传输回调回来的比特率数值单位是 kbps
        mPublisher.setNetworkBitrateSuggest((int) bitrate * 1000);
        return 0;
    }

    /**
     * 获取海度统计数据
     */
    public String getAnchorHiidoStatInfo(long streamId) {
        String anchorStat = "";
        if (mThunderVideoHiidoUtil != null) {
            anchorStat = mThunderVideoHiidoUtil.getAnchorStatInfo();
        }
        return VideoDataStat.getInstance().getAnchorVideoData(streamId) + anchorStat;
    }

    public String getAudienceHiidoStatInfo(long streamId) {
        String audienceStat = "";
        if (mThunderVideoHiidoUtil != null) {
            audienceStat = mThunderVideoHiidoUtil.getAudienceStatInfo();
        }
        return VideoPlayerDataStat.getInstance().getAudienceVideoData(streamId) + audienceStat;
    }

    /**
     * 获取视频实时统计数据
     */
    public int getPublishRuntimeInfo(int type) {
        switch (type) {
            case VIDEO_STAT_FPS:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.FRAME);
            case VIDEO_STAT_BITRATE:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.BITRATE);
            case VIDEO_STATE_RESOLUTION:
                return mPublisher.getVideoPublishInfo(VideoPublish.VideoPublishInfoEnum.RESOLUTION);
        }
        return 0;
    }

    public long getPlayRuntimeInfo(long streamId, int type) {
        switch (type) {
            case VIDEO_STAT_FPS:
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.FRAME);
            case VIDEO_STAT_BITRATE:
                break; // 播放不统计码率
            case VIDEO_STATE_RESOLUTION:
                return VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
        }
        return 0;
    }

    /**
     * 后台配置下发的主播端采集时间戳校正值
     *
     * @param adjustVal
     * @return
     */
    public int setPublisherPtsAdjustVal(int adjustVal) {
        if (mPublisher != null) {
            ThunderLog.debug("ThunderVideoEngineImp", "setPublisherPtsAdjustVal " + adjustVal);
            mPublisher.setDeltaYYPtsMillions(adjustVal);
        }
        return 0;
    }

    /**
     * 视频数据回调函数，传回的是编码后的数据
     */
    @Override
    public void onEncodeFrameData(byte[] data,
                                  int len,
                                  long pts,
                                  long dts,
                                  int frameType,
                                  VideoEncoderType encoderType,
                                  int svcTid,
                                  int svcSid) {
        int encodeType = ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
        boolean bHardware = false;

        switch (encoderType) {
            case SOFT_ENCODER_X264:
                bHardware = false;
                encodeType = ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                break;
            case HARD_ENCODER_H264:
                bHardware = true;
                encodeType = ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264;
                break;
            case SOFT_ENCODER_H265:
                bHardware = false;
                encodeType = ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                break;
            case HARD_ENCODER_H265:
                bHardware = true;
                encodeType = ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265;
                break;
            case DEFAULT:
            case ERROR:
                ThunderLog.warn(ThunderLog.kLogTagVideo, "unknown encoder type" + encoderType.toString());
        }

        if (mCallBackPtr != 0) {
            onVideoEncodedFrame(mCallBackPtr, data, len, pts, dts, frameType, encodeType, bHardware, svcTid, svcSid);
        }
    }

    /**
     * 采集回调
     */
    @Override
    public int onTextureCallback(int textureId, int width, int height) {
//		ThunderLog.info("ThunderVideoEngineImp", "onTextureCallback %d %dx%d",
//				textureId, width, height);
        if (!isUsingDefaultCamera()) {
            return textureId;
        }
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        if (camera.getCameraDataCallback() == null) {
            return textureId;
        }
        return camera.getCameraDataCallback().onTextureCallback(textureId, width, height);
    }

    void onVideoRenderNotify(final ArrayList<VideoRenderNotify> notifications) {
        if (mCallBackPtr != 0) {
            ThunderNative.onVideoRenderEvent(mCallBackPtr, notifications);
        }
    }

    /**
     *  run on yyvideoplayer event call back thread
     *
     * @param streamId
     * @param pts
     */
    private void checkAndChangeHighLowStream(long streamId, long pts) {
        // 是否存在大小流需要切换
        if (!ThunderAPI.sharedInstance().getPlayer().isNeedHighLowStreamChange()) {
            return;
        }
        // 当前 streamID是否为大小流中的一个
        // 频繁调用ThunderEngine.changeRemoteVideoStreamType切换时，永远判断最新的大小流，如果上次切换未完成，忽略。
        String streamKey = getVideoViewStreamKey(streamId);
        if (streamKey == null) {
            return;
        }
        if (!ThunderAPI.sharedInstance().getPlayer().isHighStream(streamKey) &&
                !ThunderAPI.sharedInstance().getPlayer().isLowStream(streamKey)) {
            return;
        }

        // 保存大小流PTS
        mStreamIdAndDecoderPtsMap.put(streamId, pts);

        // 获取大小流信息
        String uid = UidMap.getStringUid(streamId >> 32);
        HighLowStreamInfo info = mHighLowStreamMap.get(uid);
        if (info == null) {
            return;
        }

        if (!mStreamIdAndDecoderPtsMap.containsKey(info.highStreamId) ||
             !mStreamIdAndDecoderPtsMap.containsKey(info.lowStreamId)) {
            return;
        }

        // 从收到小流到现在已经超过超时时间，强制切换
        boolean isForceSwitch = ThunderAPI.sharedInstance().getPlayer().forceSwitch();

        // 切换大小流
        long highStreamPts = mStreamIdAndDecoderPtsMap.get(info.highStreamId);
        long lowStreamPts = mStreamIdAndDecoderPtsMap.get(info.lowStreamId);
        if (lowStreamPts > highStreamPts || Math.abs(highStreamPts - lowStreamPts) <= 100 || isForceSwitch) {
            ThunderPlayerView view = mVideoViewMap.get(streamKey);
            if (view == null) {
                ThunderLog.warn("ThunderVideoEngineImp",
                        "onUpdateDecoderPts: cannot find video view for stream:%s", streamKey);
                return ;
            }
            view.switchToSubStream(info.lowStreamId);
            onHighLowStreamChangeSuccess(info);
        }
    }

    private void onHighLowStreamChangeSuccess(HighLowStreamInfo info) {
        mStreamIdAndDecoderPtsMap.clear();
        ThunderAPI.sharedInstance().getPlayer().onHighLowStreamChangeFinish(info.highStreamName, info.lowStreamName);
        ThunderLog.info("ThunderVideoEngineImp", " onHighLowStreamChangeSuccess :" + info);
    }

    void onUpdateDecoderPts(long streamId, long pts) {
        checkAndChangeHighLowStream(streamId, pts);
    }

    void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        ThunderLog.info("ThunderVideoEngineImp", "onHardwareDecodeErrorNotify %d",
                errorType);
//		if (errorType < 4) { //0 reset_error 1 init_error 2 decoding_error 3 stop_block_error
        ThunderNative
                .enableHardwareDecoder(false, ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H264);
        ThunderNative
                .enableHardwareDecoder(false, ThunderVideoEncodeType.THUNDERVIDEO_ENCODE_TYPE_H265);
        if (mVideoConfigManager != null) {
            mVideoConfigManager.disableHardDecode(true);
        }
//		}
    }

    public boolean queryOnlyDecoded(int uid) {
        IVideoDecodeObserver observer = mVideoFrameObserverMap.get(UidMap.getStringUid(uid));
        if (observer == null) {
            return false;
        }
        return true;
    }

    public void onDecodedFrameData(long uid, int w, int h, byte[] data, int dateLen, long renderTimeMs) {
        IVideoDecodeObserver observer = mVideoFrameObserverMap.get(UidMap.getStringUid(uid));
        if (observer == null) {
            ThunderLog.info("ThunderVideoEngineImp", "onVideoDecodedFrame not found uid " + uid);
            return;
        }

        if (mVideoFrameObserverEnableMap.get(UidMap.getStringUid(uid)) != null &&
                mVideoFrameObserverEnableMap.get(UidMap.getStringUid(uid)) == true) {
            observer.onVideoDecodeFrame(UidMap.getStringUid(uid), w, h, data, dateLen, renderTimeMs);
        }
    }

    private native void onVideoEncodedFrame(long callback,
                                            byte[] data,
                                            int len,
                                            long pts,
                                            long dts,
                                            int frameType,
                                            int encodeType,
                                            boolean bHardware,
                                            int svcTid,
                                            int svcSid);

    /**
     * 返回给Jni层当前实际使用的配置
     */
    private static class YVideoPublishVideoConfig {
        int encodeFrameRate;
        int encodeBitrate;
        int encodeResolutionWidth;
        int encodeResolutionHeight;
        int encodeType;
        boolean bHardwareEncoder;
        int mode;
        boolean bMirrorFrontCamera;
        boolean bLowLatency;
        int playType;
        int orientation;

        public YVideoPublishVideoConfig(int encodeFrameRate, int encodeBitrate, int encodeResolutionWidth,
                                        int encodeResolutionHeight, int encodeType, boolean bHardwareEncoder,
                                        int mode) {
            this.encodeFrameRate = encodeFrameRate;
            this.encodeBitrate = encodeBitrate;
            this.encodeResolutionWidth = encodeResolutionWidth;
            this.encodeResolutionHeight = encodeResolutionHeight;
            this.encodeType = encodeType;
            this.bHardwareEncoder = bHardwareEncoder;
            this.mode = mode;
        }

        @Override
        public String toString() {
            String tmp = "" + this.encodeResolutionWidth +
                    "x" + this.encodeResolutionHeight +
                    "@" + this.encodeFrameRate +
                    " " + this.encodeBitrate +
                    " hard:" + this.bHardwareEncoder +
                    " mode:" + this.mode;
            return tmp;
        }
    }

    private class HighLowStreamInfo {
        public long highStreamId;
        public long lowStreamId;
        public String highStreamKey;
        public String lowStreamKey;
        public String highStreamName;
        public String lowStreamName;

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder();

            b.append(" high stream :");
            b.append(highStreamKey);
            b.append(" id :");
            b.append(highStreamId);

            b.append(" low stream :");
            b.append(lowStreamKey);
            b.append(" id :");
            b.append(lowStreamId);
            return b.toString();
        }
    }

    public void stopAndRecoverVideoEncode(boolean stop) {
        if (mPublisher != null && mVideoPublishState != YYPUBLISH_VIDEO_STATE_NONE) {
            mPublisher.stopAndRecoverStream(stop);
        }
    }

    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond,
                                         long firstFrameToRenderInMilliSec, int eatenFrames) {
        ThunderNative.onFirstFrameRenderNotify(userGroupId,
                streamId, currentSystemMilliSecond,
                firstFrameToRenderInMilliSec, eatenFrames);
    }

    public void onUpdateVideoSizeChanged(long streamId, int width, int height) {
        ThunderNative.onUpdateVideoSizeChanged(streamId, width, height);
    }

    public void setWebSdkCompatibility(boolean enable) {
        mIsEnableWebSdkCompatibility = enable;
        setLowDelayMode(enable);
        ThunderNative.enableLowLatency(enable);
    }

    public int setLocalVideoMirrorMode(int mode) {
        if (mPublisher == null) {
            return -1;
        }

        switch (mode) {
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR:
                mPublisher.enablePreviewMirror(true);
                mPublisher.enableMirror(false);
                break;
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_MIRROR:
                mPublisher.enablePreviewMirror(true);
                mPublisher.enableMirror(true);
                break;
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_PUBLISH_BOTH_NO_MIRROR:
                mPublisher.enablePreviewMirror(false);
                mPublisher.enableMirror(false);
                break;
            case THUNDER_VIDEO_MIRROR_MODE_PREVIEW_NO_MIRROR_PUBLISH_MIRROR:
                mPublisher.enablePreviewMirror(false);
                mPublisher.enableMirror(true);
                break;
            default:
                ThunderLog.info(ThunderLog.kLogTagCall, "invalid mirror mode");
                return -1;
        }

        return 0;
    }

    private int startPlayVideoStreamUI(String streamKey,
                                       Object toView,
                                       boolean bSoftDecode,
                                       int scaleMode) {
        if (streamKey == null || streamKey.isEmpty()) {
            return -1;
        }
        ThunderPlayerView view = (ThunderPlayerView) toView;

        // 提前准备视图，updatePlayVideoStream判断是否切换再重新准备视图
        boolean isSoftDecode = mVideoViewDecodeType.get(streamKey) == null ?
          bSoftDecode : mVideoViewDecodeType.get(streamKey);
        int decoderType = isSoftDecode ? VideoConstant.DecoderType.SOFT_DEOCDER : VideoConstant.DecoderType.ANDROID_HARD_DECODER1;
        long oldStreamId =
          mVideoViewStreamKeyAndIdMap.get(streamKey) == null ? -1 : mVideoViewStreamKeyAndIdMap.get(streamKey);
        ThunderPlayerView existedView = mVideoViewMap.get(streamKey);

        if (view != null) {
            if (existedView != null) {
                // 之前streamKey存在视图的话，可能需要切换视图
                if (!view.equals(existedView)) {
                    existedView.unLinkFromStream();
                    existedView.unPrepareView();
                } else {
                    // 设置的视图相同时需要判断是否切换了软解、硬解
                    if (bSoftDecode && existedView.getViewType() != 0) {
                        existedView.unLinkFromStream();
                        existedView.unPrepareView();
                    }
                }

                // 删掉map中旧的view，在后面mVideoViewMap中放入新的
                mVideoViewMap.remove(streamKey);
            }

            if (!view.isPrepared()) {
                view.unLinkFromStream();
                view.prepareView(decoderType);
                if (oldStreamId != -1) {
                    view.linkToStream(oldStreamId);
                }
            }

            mVideoViewMap.put(streamKey, view);
        }

        ThunderLog.info("ThunderVideoEngineImp",
          "startPlayVideoStream " + streamKey +
            " toView:" + toView +
            " bSoftDecode:" + bSoftDecode +
            " scaleMode:" + scaleMode +
            " streamId:" + oldStreamId);

        mVideoScaleModeMap.put(streamKey, scaleMode);

        return 0;
    }

    private int updatePlayVideoStreamUI(String streamKey,
                                        long streamId,
                                        int streamType,
                                        boolean bSoftDecode) {
        ThunderLog
          .info("ThunderVideoEngineImp", "updatePlayVideoStream bSoftDecode ==" + Boolean.toString(bSoftDecode) + " streamId  " + streamId);

        int result = -1;
        String UID = UidMap.getStringUid(streamId >> 32);
        long highLowStreamUid = ThunderAPI.sharedInstance().getPlayer().getHighLowStreamUid();
        if (ThunderAPI.sharedInstance().getPlayer().isNeedHighLowStreamChange() &&
          UID != null && UID.equals(UidMap.getStringUid(highLowStreamUid))) {
            return 0;
        }

        //先拆掉前面的流程,releaseDecoder是传输拆掉，view是在setDecodeType里面拆掉重建
        final ThunderPlayerView view = mVideoViewMap.get(streamKey);

        if (view == null) {
            ThunderLog.warn("ThunderVideoEngineImp",
              "updatePlayVideoStream: cann't find video view for stream:%s",
              streamKey);
        } else {
            mRecoverVideoViewMap.put(streamKey, view);
        }

        if (view != null) {
            if (!view.isPrepared()) {
                int decoderType = bSoftDecode ? VideoConstant.DecoderType.SOFT_DEOCDER : VideoConstant.DecoderType.ANDROID_HARD_DECODER1;
                prepareView(view, decoderType);
                view.linkToStream(streamId);

                int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
                if (scaleMode != -1) {
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream setScaleMode " + scaleMode + " streamKey " + streamKey);
                    view.setScaleMode(scaleMode);
                } else {
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream scaleMode == -1, streamKey " + streamKey);
                }
                return -1;
            }

            long oldStreamId =
              mVideoViewStreamKeyAndIdMap.get(streamKey) == null ? -1 : mVideoViewStreamKeyAndIdMap.get(streamKey);

            if ((bSoftDecode == true && view.getViewType() != 0)) {
                //连麦切换到软解view不是软解的View，新建软解View
                ThunderLog.info("ThunderVideoEngineImp",
                  "updatePlayVideoStream bSoftDecode == true, view == hard,need change");
                if (oldStreamId != -1) {
                    view.unLinkFromStream();
                }

                view.prepareView(VideoConstant.DecoderType.SOFT_DEOCDER);
                view.linkToStream(streamId);
                mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
                ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream link stream:%s, %d", streamKey, streamId);

            } else if (bSoftDecode == true && view.getViewType() == 0) {
                //连麦切换到软解view是软解的View，可能更改streamID
                if (oldStreamId != streamId) {
                    view.unLinkFromStream();
                    view.linkToStream(streamId);
                    mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream overrid stream:%s, %d ->%d", streamKey,
                      oldStreamId, streamId);
                } else {
                    view.unLinkFromStream();
                    view.linkToStream(streamId);
                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream same streamId stream:%s, %d", streamKey,
                      streamId);
                }

            } else if (bSoftDecode == false) {
                if (view.getViewType() == 1) {
                    view.unLinkFromStream();
                    view.linkToStream(streamId);
                    mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);

                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream override stream:%s, %d ->%d", streamKey,
                      oldStreamId, streamId);
                } else if (view.getViewType() != 1) {
                    view.prepareView(VideoConstant.DecoderType.ANDROID_HARD_DECODER1);
                    view.linkToStream(streamId);
                    mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);

                    ThunderLog.info("ThunderVideoEngineImp", "updatePlayVideoStream hard link stream:%s, %d", streamKey,
                      streamId);
                }
            } else {
                ThunderLog.info("ThunderVideoEngineImp",
                  "updatePlayVideoStream someThing wrong streamId stream:%s ,%d, type:%d", streamKey, streamId,
                  view.getViewType());
            }
        }

        mVideoViewStreamKeyAndIdMap.put(streamKey, streamId);
        mVideoFrameObserverEnableMap.put(UidMap.getStringUid(streamId >> 32), true);
        mVideoViewDecodeType.put(streamKey, bSoftDecode);

        int scaleMode = mVideoScaleModeMap.get(streamKey) == null ? -1 : mVideoScaleModeMap.get(streamKey);
        if (scaleMode == -1) {
            ThunderLog.error("ThunderVideoEngineImp",
              "updatePlayVideoStream mVideoScaleModeMap can't find scaleMode in map :" +
                mVideoScaleModeMap.size());
            if (view != null) {
                result = (view.getViewType() == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 ? 1 : 0);
            }
            return result;
        }
        if (view != null) {
            view.setScaleMode(scaleMode);
            result = (view.getViewType() == VideoConstant.DecoderType.ANDROID_HARD_DECODER1 ? 1 : 0);
        }

        return result;
    }

    private int stopPlayVideoStreamUI(String streamKey) {
        ThunderPlayerView view = mVideoViewMap.get(streamKey);

        ThunderLog.info("ThunderVideoEngineImp",
                        "stopPlayVideoStreamUI streamKey:" + streamKey +
                         " view:" + view);

        if (view == null) {
            return -1;
        }

        boolean isHighStream = ThunderAPI.sharedInstance().getPlayer().isHighStream(streamKey);

        if (!isHighStream) {
            view.unLinkFromStream();
            view.unPrepareView();

            mVideoViewMap.remove(streamKey);
        }

        mVideoViewStreamKeyAndIdMap.remove(streamKey);

        ThunderLog.info("ThunderVideoEngineImp",
             "stopPlayVideoStreamUI remain mVideoViewMap:" + mVideoViewMap.size() +
              " mVideoViewStreamKeyAndIdMap:" + mVideoViewStreamKeyAndIdMap.size());

        return 0;
    }
}
