package com.thunder.livesdk.video;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;

import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.glesunder43.EglCore;
import com.yy.videoplayer.glesunder43.WindowSurface;
import com.thunder.livesdk.helper.ThunderLog;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.microedition.khronos.egl.EGLSurface;

/**
 * Created by xiaojun on 2018/1/4.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class ThunderVideoConfig {

    private enum Support {
        SUPPORTED,
        UNSUPPORTED,
        UNCERTAIN
    }

    private static Support h264HwDecoderSupport = Support.SUPPORTED;
    private static Support h265HwDecoderSupport = Support.SUPPORTED;
    private static boolean bRooted = false;
    private static boolean bWindowSurfaceSupported = false;

    void AsyncLoad() {
        LoadThread lt = new LoadThread();
        Thread th = new Thread(lt, "YY_LoadVideoConfig_Thread");
        th.start();
    }

    private class LoadThread implements Runnable {
        @Override
        public void run() {
            try {

                bRooted = testRooted();

                bWindowSurfaceSupported = testWindowSurfaceCreation();

                ThunderLog.info(ThunderLog.kLogTagVideo, "load finish " +
                        "- build version:" + Build.VERSION.SDK_INT +
                        ", h264HwDecoderSupport:" + h264HwDecoderSupport.name() +
                        ", h265HwDecoderSupport:" + h265HwDecoderSupport.name() +
                        ", isRooted:" + bRooted +
                        ", isWindowSurfaceSupported:" + bWindowSurfaceSupported);
            } catch (Exception e) {
                ThunderLog.error(ThunderLog.kLogTagVideo, "load error:" + e.getMessage());
            }
        }
    }

    private static final Object testWindowSurfaceLocker = new Object();

    private static class TestWindowSurfaceTask implements Runnable {
        private AtomicBoolean mResult = null;

        TestWindowSurfaceTask(AtomicBoolean waiter) {
            mResult = waiter;
        }

        @Override
        public void run() {
            if (mResult == null) {
                return;
            }

            try {
                mResult.set(false);
                EglCore eglCore = new EglCore();
                SurfaceTexture st = new SurfaceTexture(1);
                Surface surface = new Surface(st);
                EGLSurface envSurface = null;
                try {
                    WindowSurface videoWindowSurface = new WindowSurface(eglCore, surface, false);
                    videoWindowSurface.release();
                    envSurface = eglCore.createOffscreenSurface(320, 240);
                    eglCore.makeCurrent(envSurface);
                    eglCore.makeNothingCurrent();
                    mResult.set(true);
                } catch (Throwable t) {
                    mResult.set(false);
                    ThunderLog.error(ThunderLog.kLogTagVideo,
                            "test WindowSurface createEngine error:" + t.getMessage());
                } finally {
                    if (envSurface != null) {
                        eglCore.releaseSurface(envSurface);
                        envSurface = null;
                    }
                    surface.release();
                    st.release();
                    eglCore.release();
                    ThunderLog.info(ThunderLog.kLogTagVideo,
                            "test WindowSurface createEngine finish:" + mResult.get());
                }
            } catch (Throwable t) {
                ThunderLog.error(ThunderLog.kLogTagVideo,
                        "test WindowSurface init error:" + t.getMessage());
            }

            synchronized (testWindowSurfaceLocker) {
                testWindowSurfaceLocker.notifyAll();
            }
        }
    }

    private static boolean testWindowSurfaceCreation() {
        boolean ret;

        AtomicBoolean result = new AtomicBoolean(false);
        TestWindowSurfaceTask task = new TestWindowSurfaceTask(result);
        Thread thread = new Thread(task, "YY_TestWindowSurface_Thread");

        synchronized (testWindowSurfaceLocker) {
            try {
                thread.start();
                testWindowSurfaceLocker.wait(500);
                ret = result.get();
            } catch (Exception e) {
                ret = false;
            }
        }

        ThunderLog.info(ThunderLog.kLogTagVideo, "testWindowSurfaceCreation ret:" + ret);

        return ret;
    }

    private boolean testRooted() {
        String binPath = "/system/bin/su";
        String xBinPath = "/system/xbin/su";

        boolean isRooted;
        try {
            isRooted = new File(binPath).exists() && testFileExecutable(binPath)
                    || new File(xBinPath).exists() && testFileExecutable(xBinPath);
        } catch (Throwable e) {
            isRooted = false;
        }

        ThunderLog.info(ThunderLog.kLogTagVideo, "testRooted: " + isRooted);

        return isRooted;
    }

    private boolean testFileExecutable(String filePath) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("ls -l " + filePath);
            // 获取返回内容
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String str = in.readLine();
            ThunderLog.info(ThunderLog.kLogTagVideo, "testFileExecutable " + str);
            if (str != null && str.length() >= 4) {
                char flag = str.charAt(3);
                if (flag == 's' || flag == 'x') {
                    return true;
                }
            }
        } catch (IOException e) {
            ThunderLog.info(ThunderLog.kLogTagVideo, "testFileExecutable failed:" + e.getMessage());
        } finally {
            if (p != null) {
                p.destroy();
            }
        }
        return false;
    }

    public static boolean isRooted() {
        return bRooted;
    }

    public static boolean isWindowSurfaceSupport() {
        return bWindowSurfaceSupported;
    }

    public static boolean isHw264DecodeEnabled() {
        return (h264HwDecoderSupport != Support.UNSUPPORTED) && H264DecRender.IsAvailable();
    }

    public static boolean isHw265DecodeEnabled() {
        return (h265HwDecoderSupport != Support.UNSUPPORTED) && H265DecRender.IsAvailable();
    }
}
