package com.thunder.livesdk.audio;

import java.nio.ByteBuffer;

public interface IAudioFrameObserver {

    /**
     * 采集原始数据回调
     *
     * @param samples        该帧的采样数据
     * @param numOfSamples   采样数
     * @param bytesPerSample 每个样本的字节数：对于 PCM 来说，一般使用 16 bit，即两个字节
     * @param channels       频道数量（如果是立体声，数据是交叉的）；1：单声道，2：双声道
     * @param samplesPerSec  采样率，SamplesPerCall = (int)(SampleRate × sampleInterval)，其中：sample ≥ 0.01，单位为秒
     * @return
     */
    boolean onRecordFrame(ByteBuffer samples, int numOfSamples, int bytesPerSample, int channels, int samplesPerSec);

    /**
     * 播放原始数据回调
     *
     * @param samples        该帧的采样数据
     * @param numOfSamples   采样数
     * @param bytesPerSample 每个样本的字节数：对于 PCM 来说，一般使用 16 bit，即两个字节
     * @param channels       频道数量（如果是立体声，数据是交叉的）；1：单声道，2：双声道
     * @param samplesPerSec  采样率，SamplesPerCall = (int)(SampleRate × sampleInterval)，其中：sample ≥ 0.01，单位为秒
     * @return
     */
    boolean onPlaybackFrame(ByteBuffer samples, int numOfSamples, int bytesPerSample, int channels, int samplesPerSec);
}
