package com.thunder.livesdk;

public interface ThunderVideoFrameConsumer {

    /**
     * 接收 ByteArray 类型的视频帧
     *
     * @param data      Byte Array 型的数据数据
     * @param format    像素格式：
     *                  RGBA:  public static final int THUNDER_PIXEL_FORMAT_RGBA = 0;
     *                  I420:  public static final int THUNDER_PIXEL_FORMAT_I420 = 1;
     *                  NV21   public static final int THUNDER_PIXEL_FORMAT_NV21 = 2;
     * @param width     视频帧的宽度
     * @param height    视频帧的高度
     * @param rotation  视频帧顺时针旋转的角度。如果设置了旋转角度，媒体引擎会对图像进行旋转。
     *                  你可以根据需要将角度值设为 0 度、90 度、180 度和 270 度，如果设置为其他数字，系统会自动忽略
     * @param timestamp 传入的视频帧的时间戳。开发者必须为每一个视频帧设置一个时间戳
     */
    void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation, long timestamp);
}