package com.thunder.livesdk;

import android.media.projection.MediaProjection;

import com.thunder.livesdk.helper.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;

/**
 * Created by jping on 2018/6/14.
 */
public class ThunderScreenCapture extends ThunderDefaultCamera {

    private MediaProjection mediaProjection;
    private boolean islandScape;

    public ThunderScreenCapture(MediaProjection mediaProjection, boolean islandScape) {
        this.mediaProjection = mediaProjection;
        this.islandScape = islandScape;
    }

    public MediaProjection getMediaProjection() {
        return mediaProjection;
    }

    public boolean isLandscap() {
        return islandScape;
    }

    public void setIslandScape(boolean islandScape) {
        this.islandScape = islandScape;
    }

    /**
     * 切换录屏的状态到picture模式
     *
     * @param bPicMode true:进入picture模式 带上bitmap， false：通话结束，不带bitmap
     * @param bitmap   图片对象
     */
    public void changeScreenLiveMode(boolean bPicMode, Object bitmap) {
        ThunderLog.info(ThunderLog.kLogTagCall, "changeScreenLiveMode %b", bPicMode);
        ThunderNative.changeScreenLiveMode(bPicMode, bitmap);
    }

    @Override
    public void startCapture(ThunderPublisher.IVideoPublisher publisher) {
        super.startCapture(publisher);
    }

    @Override
    public void stopCapture() {
        super.stopCapture();
    }

    @Override
    public ThunderVideoCaptureConfig getCaptureConfig() {
        return super.getCaptureConfig();
    }
}
