package com.thunder.livesdk;

/**
 * Created by xiongxiong on 2017/11/1.
 */

public class ThunderPublishAudioConfig {
    /**
     * for communication usage, steady low delay setting, special for app which is very sensitive to mobile data flow
     */
    public static final int YYPUBLISH_AUDIO_MODE_LOWDELAY_LOWFLOW_SUPERLOWQUALITY_VOIP = 0;
    /**
     * for communication usage, steady low delay setting, special for app which is sensitive to mobile data flow
     */
    public static final int YYPUBLISH_AUDIO_MODE_LOWDELAY_LOWFLOW_LOWQUALITY_VOIP = 1;
    /**
     * for communication usage, steady low delay setting, typicial for VOIP app
     */
    public static final int YYPUBLISH_AUDIO_MODE_LOWDELAY_NORMALFLOW_MEDIUMQUALITY_VOIP = 2;
    /**
     * some voip app, don't want default VOIP before open mic, can use this mode for viewer first
     */
    public static final int YYPUBLISH_AUDIO_MODE_LOWDELAY_NORMALFLOW_MEDIUMQUALITY_COMMON = 3;
    /**
     * default mode, no special config.
     */
    public static final int YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_MEDIUMQUALITY_COMMON = 4;
    /**
     * for broadcast usage, typical for high quality broadcast
     */
    public static final int YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_HIGHQUALITY_BROADCAST = 5;
    /**
     * for broadcast usage, special for high quality music broadcast
     */
    public static final int YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_HIGHQUALITY_MUSIC_BROADCAST = 6;
    /**
     * for communication usage, steady low delay setting, special for some VOIP app which is both sensitive to mobile data flow and need high quality
     */
    public static final int YYPUBLISH_AUDIO_MODE_LOWDELAY_LOWFLOW_HIGHQUALITY_HDVOIP = 7;
    /**
     * for communication usage, steady low delay setting, special for some VOIP app need high quality
     */
    public static final int YYPUBLISH_AUDIO_MODE_LOWDELAY_NORMALFLOW_HIGHQUALITY_HDVOIP = 8;
    /**
     * for broadcast usage, special for super high quality broadcast
     */
    public static final int YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_SUPERHIGHQUALITY_BROADCAST = 9;

    /**
     * 开播模式
     */
    public int mode;

    /**
     * 是否同时开播到流名称，默认为false
     * <br> true - 开播到群组的同时也开播到流名称
     * <br> false - 开播时填了群组则只开播到群组不开播到流名称
     */
    public boolean pubToGroupAndName;
    //使用新的音频模式
    public boolean bUseAudioProfile;

    public int roomConfig;
    public int audioConfig;
    public int commutMode;
    public int scenarioMode;

    /**
     * Audio PreProcess Mode
     * 0 default
     * 1 communication
     * 2 live
     * 3 game
     * 4 multiroom
     */
//	public int preProcMode;

    /**
     * 使用模式初始化各配置项的值
     * <br>
     * sdk会根据模式设置合适的配置项，若sdk给的配置项不能很好的满足需求可以自己修改配置项
     *
     * @param mode 开播模式
     *             {@link ThunderPublishAudioConfig#YYPUBLISH_AUDIO_MODE_NORMALDELAY_NORMALFLOW_MEDIUMQUALITY_COMMON} etc.
     */
    public ThunderPublishAudioConfig(int mode) {
        this.mode = mode;
        this.pubToGroupAndName = false;
        this.bUseAudioProfile = false;
        this.roomConfig = 0;
        this.audioConfig = 0;
        this.commutMode = 0;
        this.scenarioMode = 0;
    }

    /**
     * 输出字符串形式的配置信息
     *
     * @return 返回字符串形式的配置信息，用于日志输出
     */
    public String toString() {
        return "{mode=" + this.mode +
                " pubToGroupAndName=" + this.pubToGroupAndName +
                "}";
    }
}
