package com.thunder.livesdk;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.widget.FrameLayout;

/**
 * Created by xiaojun on 2018/4/17.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */
public class ThunderPreviewView extends FrameLayout {

    private SurfaceView mSurfaceView;

    public ThunderPreviewView(Context context) {
        super(context);
        initData();
    }

    public ThunderPreviewView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initData();
    }

    public ThunderPreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initData();
    }

    public SurfaceView getSurfaceView() {
        return mSurfaceView;
    }

    private void initData() {
        if (mSurfaceView == null) {
            mSurfaceView = new SurfaceView(this.getContext().getApplicationContext());
            LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
            mSurfaceView.setLayoutParams(params);
            addView(mSurfaceView);
        }
    }

    public void clearViews() {
        this.removeAllViews();
    }

    public void addViews(SurfaceView newView) {
        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        newView.setLayoutParams(params);
        this.addView(newView);
    }
}
