package com.thunder.livesdk;

/**
 * Created by zhangfei on 2018/06/20.
 */

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.SurfaceView;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import com.yy.mediaframework.facedetection.IFaceDetection;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.thunder.livesdk.audio.IAudioFrameObserver;
import com.thunder.livesdk.helper.ThunderHttpsRequestHandler;
import com.thunder.livesdk.helper.ThunderLog;
import com.thunder.livesdk.helper.ThunderNative;
import com.thunder.livesdk.helper.UidMap;
import com.thunder.livesdk.system.ThunderNetStateService;
import com.thunder.livesdk.video.IVideoCaptureObserver;
import com.thunder.livesdk.video.IVideoDecodeObserver;
import com.thunder.livesdk.helper.CpuTool;

import org.json.JSONObject;


import static com.thunder.livesdk.ThunderNotification.PublishStatusInfo.THUNDER_PUBLISHSTATUS_PUBLISH_SUCCESS;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderConnectionStatus.THUNDER_CONNECTION_STATUS_CONNECTED;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderConnectionStatus.THUNDER_CONNECTION_STATUS_DISCONNECTED;
import static com.thunder.livesdk.ThunderRtcConstant.ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR;
import static com.thunder.livesdk.ThunderRtcConstant.*;

/**
 * YY音频简易接入SDK
 * 所有接口，int型返回值，未做特殊说明，0表示成功，<0 error
 */

public class ThunderEngine {
    private final static String TAG = "RtcEngine";
    private static boolean mIsInited = false;

    public static final class ThunderAreaType {
        /**
         * 默认值(国内)
         */
        public static final int THUNDERAREA_DEFAULT = 0;
        /**
         * 俄罗斯
         */
        public static final int THUNDERAREA_RUSSIA = 1;
        /**
         * 马来西亚
         */
        public static final int THUNDERAREA_MALAYSIA = 2;
        /**
         * 国外
         */
        public static final int THUNDERAREA_FOREIGN = 100;
        /**
         * yy-reserved
         */
        public static final int THUNDERAREA_RESERVED = 101;
    }


    private static class NotificationHandler extends Handler {
        private final WeakReference<ThunderEngine> mThunderEngine;

        public NotificationHandler(ThunderEngine rtc) {
            mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        public NotificationHandler(ThunderEngine rtc, Looper loop) {
            super(loop);
            mThunderEngine = new WeakReference<ThunderEngine>(rtc);
        }

        @Override
        public void handleMessage(Message msg) {

            ThunderEngine thunderEngine = mThunderEngine.get();
            if (thunderEngine == null || mRtcEventHandler == null) {
                return;
            }

            try {
                switch (msg.what) {
                    case ThunderNotification.kThunderAPINotification_PublishStatus: {
                        ThunderNotification.PublishStatusInfo info = (ThunderNotification.PublishStatusInfo) msg.obj;
                        if (info.getStatus() == THUNDER_PUBLISHSTATUS_PUBLISH_SUCCESS) {
                            int elapsed = (int) (System.currentTimeMillis() - thunderEngine.joinStart);
                            if (info.isVideo()) {
                                mRtcEventHandler.onFirstLocalVideoFrameSent(elapsed);
                            } else {
                                mRtcEventHandler.onFirstLocalAudioFrameSent(elapsed);
                            }
                        }

                        ThunderLog.release(TAG, "ThunderNotification.PublishStatusInfo stream=%s status=%d",
                                info.getStreamName(), info.getStatus());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_PublishRunTimeInfo: {
                        ThunderNotification.PublishRunTimeInfo info = (ThunderNotification.PublishRunTimeInfo) msg.obj;
                        ThunderLog.info(TAG, "ThunderNotification.PublishRunTimeInfo stream=%s fps=%d " +
                                        "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStreamName(),
                                info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
                                info.getInfo().getWidth(), info.getInfo().getHeight());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_PlayStatus: {
                        ThunderNotification.PlayStatusInfo info = (ThunderNotification.PlayStatusInfo) msg.obj;
                        ThunderLog.release(TAG, "ThunderNotification.PlayStatusInfo stream=%s status=%d",
                                info.getStream().streamName, info.getStatus());
                        switch (info.getStatus()) {
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_PARAM_ERROR: {

                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_SUBSCRIBE_SUCCUSS: {
                                if (thunderEngine.getIsThunder() && thunderEngine.needNotify) {
                                    thunderEngine.isJoinRoom = true;
                                    thunderEngine.needNotify = false;
                                    thunderEngine.joinEnd = System.currentTimeMillis();
                                    int elapsed = (int) (thunderEngine.joinEnd - thunderEngine.joinStart);
                                    mRtcEventHandler.onJoinRoomSuccess(thunderEngine.getRoomName(),
                                            thunderEngine.getMyUid(), elapsed);
                                }
                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_SUBSCRIBE_FAILED: {

                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_SUBSCRIBE_CANCEL: {
                                if (thunderEngine.isLeaveRoomByUser && thunderEngine.getIsThunder()) {
                                    thunderEngine.mRoomStats.duration =
                                            (int)((System.currentTimeMillis() - thunderEngine.joinEnd) / 1000);
                                    mRtcEventHandler.onLeaveRoom(thunderEngine.mRoomStats);
                                }
                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_STREAM_ARRIVE: {

                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_STREAM_RENDERED: {
                                long renderTime = System.currentTimeMillis();
                                ThunderStream playStream = info.getStream();
                                ThunderStream findStream = ThunderAPI.sharedInstance()
                                        .getPlayer()
                                        .getSubscribeStreamByUid(playStream.speakerUid);
                                if (findStream != null) {
                                    int elapseTime = (int) (renderTime - findStream.startSubscribeTime);
                                    mRtcEventHandler.onRemoteVideoPlay(UidMap.getStringUid(findStream.speakerUid),
                                            findStream.width, findStream.height, elapseTime);
                                }
                            }
                            break;
                            case ThunderNotification.PlayStatusInfo.THUNDER_PLAYSTATUS_STREAM_STOP: {

                            }
                            break;
                        }
                        ThunderLog.release(TAG, " mThunderEngine = " + thunderEngine);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_PlayRunTimeInfo: {
                        //                    ThunderNotification.PlayRunTimeInfo info = (ThunderNotification.PlayRunTimeInfo) msg.obj;
                        //                    ThunderLog.info(TAG, String.format("ThunderNotification.PlayRunTimeInfo stream=%s fps=%d " +
                        //                                    "bitrate=%d audioBitrate=%d resolution=%dx%d", info.getStream().streamName,
                        //                            info.getInfo().getFps(), info.getInfo().getBitrate(), info.getInfo().getAudioBitrate(),
                        //                            info.getInfo().getWidth(), info.getInfo().getHeight()));
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioCaptureVolume: {
                        ThunderNotification.ThunderAudioCaptureVolume info =
                                (ThunderNotification.ThunderAudioCaptureVolume) msg.obj;

                        mRtcEventHandler.onCaptureVolumeIndication(info.mVolume, (int) info.mCpt, info.mMicVolume);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioPlayVolume: {
                        ThunderNotification.AudioVolumeInfo info = (ThunderNotification.AudioVolumeInfo) msg.obj;
                        if (info.getVolumeInfos() != null) {
                            int maxVol = 0;
                            int index = 0;
                            ArrayList<ThunderEventHandler.AudioVolumeInfo> volInfos = new ArrayList<>();
                            for (Map.Entry<Long, ThunderNotification.ThunderVolumeInfo> entry : info.getVolumeInfos()
                                    .entrySet()) {
                                if (entry.getValue().mActualSpeakerUidList == null ||
                                        entry.getValue().mActualSpeakerUidList.isEmpty()) {
                                    continue;
                                }
                                for (long uid : entry.getValue().mActualSpeakerUidList) {
                                    ThunderEventHandler.AudioVolumeInfo volInfo =
                                            new ThunderEventHandler.AudioVolumeInfo();
                                    volInfo.uid = UidMap.getStringUidFromMap(uid);
                                    if (volInfo.uid == null || volInfo.uid.isEmpty()) {
                                        continue;
                                    }
                                    volInfo.volume = entry.getValue().mVolume;
                                    volInfo.pts = (int) entry.getValue().mPts;
                                    if (maxVol < volInfo.volume) {
                                        maxVol = volInfo.volume;
                                    }
                                    ++index;
                                    volInfos.add(volInfo);
                                    if ((s_playVolumeNotifyCount % 200) == 0) {
                                        ThunderLog.release(TAG,
                                                "ThunderNotification.AudioPlayVolume, [%d] uid %s, volume %d",
                                                index, volInfo.uid.toString(), volInfo.volume);
                                    }
                                }
                            }

                            int volSize = volInfos.size();
                            if (volSize > 0) {
                                ThunderEventHandler.AudioVolumeInfo[] volList =
                                        new ThunderEventHandler.AudioVolumeInfo[volSize];
                                for (int i = 0; i < volSize; ++i) {
                                    volList[i] = volInfos.get(i);
                                }
                                mRtcEventHandler.onPlayVolumeIndication(volList, maxVol);
                                ++s_playVolumeNotifyCount;
                            }
                        }

                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_BizAuthRes: {
                        ThunderNotification.BizAuthResult result = (ThunderNotification.BizAuthResult) msg.obj;
                        ThunderLog.release(TAG,
                                "ThunderNotification.BizAuthResult stream=%s group=%s result=%d",
                                result.getAuthStream() != null ? result.getAuthStream().streamName : "null",
                                result.getAuthGroup() != null ? result.getAuthGroup().groupName : "null",
                                result.getBizAuthResult());

                        mRtcEventHandler.onBizAuthResult(result.isPublishAuth(), result.getBizAuthResult());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_SdkAuthRes: {
                        ThunderNotification.SdkAuthResult result = (ThunderNotification.SdkAuthResult) msg.obj;
                        ThunderLog.release(TAG,
                                "ThunderNotification.SdkAuthResult appId=%d uid=%d result=%d",
                                result.getAppId(), result.getUid(), result.getSdkAuthResult());

                        int authResult = result.getSdkAuthResult();
                        switch (authResult) {
                            case 0: //success
                                if (thunderEngine.mIsUserBanned) {
                                    thunderEngine.mIsUserBanned = false;
                                    mRtcEventHandler.onUserBanned(false);
                                }
                                break;
                            case 10005: //token expire
                                mRtcEventHandler.onTokenRequested();
                                break;
                            case 10007: //token will expire
                                mRtcEventHandler.onTokenWillExpire(thunderEngine.mToken);
                                break;
                            case 10008: //band
                                thunderEngine.mIsUserBanned = true;
                                mRtcEventHandler.onUserBanned(true);
                                break;
                        }

                        mRtcEventHandler.onSdkAuthResult(authResult);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotifioation_StringUid: {
                        ThunderNotification.UidInt2String result = (ThunderNotification.UidInt2String) msg.obj;
                        if (result.getIsAdd()) {
                            thunderEngine.addUid2String(result.getUidInt(), result.getUidString());
                        } else {
                            UidMap.removeUid2String(result.getUidInt());
                        }
                        ThunderLog.release(TAG, "ThunderNotification.UidInt2String uid=%d str=%s isAdd=%b",
                                result.getUidInt(), result.getUidString(), result.getIsAdd());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioPlayData: {
                        ThunderNotification.AudioDataInfo result = (ThunderNotification.AudioDataInfo) msg.obj;

                        long uid = result.getUid();
                        String strUid = UidMap.getStringUid(uid);
                        if (!thunderEngine.mIs32bitUid) {
                            if (strUid == null || strUid.isEmpty()) {
                                return;
                            }
                        }

                        int duration = result.getDuration();
                        int cpt = result.getCpt();
                        int pts = result.getPts();
                        byte[] data = result.getData();
                        int len = 0;
                        if (null != data) {
                            len = data.length;
                        }

                        if ((s_playDataNotifyCount % 500) == 0) {
                            ThunderLog.release(TAG,
                                    "ThunderNotification.AudioPlayData,cpt:%d,pts:%d, len:%d",
                                    cpt, pts, len);
                        }
                        ++s_playDataNotifyCount;

                        mRtcEventHandler.onAudioPlayData(data, cpt, pts, strUid, duration);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioPlaySpectrumData: {
                        ThunderNotification.AudioPlaySpectrumData result =
                                (ThunderNotification.AudioPlaySpectrumData) msg.obj;
                        mRtcEventHandler.onAudioPlaySpectrumData(result.getData());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioCapturePcmData: {
                        ThunderNotification.AudioCapturePcmData result =
                                (ThunderNotification.AudioCapturePcmData) msg.obj;
                        mRtcEventHandler.onAudioCapturePcmData(result.getData(), result.getDataSize(),
                                result.getSampleRate(), result.getChannel());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioRenderPcmData: {
                        ThunderNotification.AudioRenderPcmData result =
                                (ThunderNotification.AudioRenderPcmData) msg.obj;
                        //duration = (result.getDataSize() * 1000) /  (result.getSampleRate() * result.getChannel() * 2) 单位：ms
                        mRtcEventHandler.onAudioRenderPcmData(result.getData(),
                                result.getDataSize(), result.getDuration(),
                                result.getSampleRate(), result.getChannel());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_UserAppMsgData: {
                        ThunderNotification.UserAppMsgData result = (ThunderNotification.UserAppMsgData) msg.obj;
                        //ThunderLog.info(TAG, String.format("ThunderNotification.UserAppMsgData uid %s msgSize %d",
                        //        strUid, result.getData().length));
                        mRtcEventHandler.onRecvUserAppMsgData(result.getData(), result.getUid());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AppMsgDataFailedStatus: {
                        ThunderNotification.AppMsgDataFailedStatus result =
                                (ThunderNotification.AppMsgDataFailedStatus) msg.obj;
                        ThunderLog.info(TAG, "ThunderNotification.AppMsgDataFailedStatus status=%d",
                                result.getFailedStatus());

                        mRtcEventHandler.onSendAppMsgDataFailedStatus(result.getFailedStatus());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_AudioExtraInfo: {
                        ThunderNotification.AudioExtraInfo result = (ThunderNotification.AudioExtraInfo) msg.obj;
                        ByteBuffer extraInfo = ByteBuffer.wrap(result.getInfo());
                        if (mThunderMediaExtraInfoCallback != null) {
                            String strUid = UidMap.getStringUid(result.getUid());
                            mThunderMediaExtraInfoCallback.onRecvMediaExtraInfo(strUid,
                                    extraInfo,
                                    extraInfo.remaining());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_SendAudioExtraInfoFailedStatus: {
                        ThunderNotification.SendAudioExtraInfoFailedStatus result =
                                (ThunderNotification.SendAudioExtraInfoFailedStatus) msg.obj;
                        ThunderLog.info(TAG,
                                "ThunderNotification.kThunderAPINotification_SendAudioExtraInfoFailedStatus" +
                                        " status=%d",
                                result.getFailedStatus());
                        if (mThunderMediaExtraInfoCallback != null) {
                            mThunderMediaExtraInfoCallback.onSendMediaExtraInfoFailedStatus(result.getFailedStatus());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_InitiateHttpsRequest: {
                        ThunderNotification.InitiateHttpsRequest result =
                                (ThunderNotification.InitiateHttpsRequest) msg.obj;
                        String reqUrl = result.getReqUrl();
                        int target = result.getTarget();
                        ThunderLog.info(TAG, "ThunderNotification.InitiateHttpsRequest " +
                                "reqUrl=%s target=%d", reqUrl, target);
                        if (mHttpsRequestHandler != null) {
                            mHttpsRequestHandler.send(reqUrl, target);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_PublishChannelStreamInfo: {
                        ThunderNotification.PublishRoomStreamInfo info =
                                (ThunderNotification.PublishRoomStreamInfo) msg.obj;
                        ThunderLog.info(TAG,
                                "*************** (Not deal in thunderbolt)PublishRoomStreamInfo ***************");
                        ThunderLog.info(TAG,
                                "ThunderNotification.PublishRoomStreamInfo roomID:" + info.getRoomId() + " streams:" +
                                        info.getStreams().size());
                        for (ThunderStream oneStream : info.getStreams()) {
                            ThunderLog.info(TAG,
                                    "ThunderNotification.PublishRoomStreamInfo stream name:%s speak id:%d appid:%d",
                                    oneStream.streamName, oneStream.speakerUid, oneStream.appId);
                        }
                        ThunderLog.info(TAG,
                                "*************** *********************************************** ***************");
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_StreamsNotify: {
                        ThunderNotification.StreamsNotify info = (ThunderNotification.StreamsNotify) msg.obj;
                        ThunderLog.info(TAG, "*************** kThunderAPINotification_StreamsNotify ***************");
                        ThunderLog.info(TAG,
                                "ThunderNotification.StreamsNotify roomID:" + info.getRoomId() + " streams:" +
                                        info.getStreams().size());
                        for (ThunderStream oneStream : info.getStreams()) {
                            ThunderLog.info(TAG,
                                    "ThunderNotification.StreamsNotify stream name:%s speak id:%d appid:%d",
                                    oneStream.streamName, oneStream.speakerUid, oneStream.appId);
                        }
                        ThunderLog.info(TAG,
                                "*************** *********************************************** ***************");
                        thunderEngine.onStreamsNotify(info);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_ResolutionChangeInfo: {
                        ThunderNotification.ResolutionChangeInfo info =
                                (ThunderNotification.ResolutionChangeInfo) msg.obj;
                        ThunderAPI.sharedInstance().getPlayer().setSubscribeStreamWHByUid(
                                info.getStream().speakerUid, info.getWidth(), info.getHeight());
                        mRtcEventHandler.onVideoSizeChanged(UidMap.getStringUid(info.getStream().speakerUid),
                                info.getWidth(), info.getHeight(), 0);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_UserMuteAudio: {
                        ThunderNotification.UserMuteAudio result = (ThunderNotification.UserMuteAudio) msg.obj;
                        if (thunderEngine.getIsThunder()) {
                            mRtcEventHandler.onRemoteAudioStopped(result.getUid(), result.isMuted());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_UserJoined: {
                        ThunderNotification.UserJoined result = (ThunderNotification.UserJoined) msg.obj;
                        if (thunderEngine.getIsThunder()) {
                            int elapsed = (int) (System.currentTimeMillis() - thunderEngine.joinStart);
                            mRtcEventHandler.onUserJoined(result.getUid(), elapsed);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_UserOffline: {
                        ThunderNotification.UserOffline result = (ThunderNotification.UserOffline) msg.obj;
                        if (thunderEngine.getIsThunder()) {
                            mRtcEventHandler.onUserOffline(result.getUid(), result.getReason());
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_NetworkQuality: {
                        ThunderNotification.NetworkQuality result = (ThunderNotification.NetworkQuality) msg.obj;
                        mRtcEventHandler.onNetworkQuality(result.getUid(),
                                result.getTxQuality(), result.getRxQuality());
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_RoomStats: {
                        ThunderNotification.RoomStatsEx roomStatsEx = (ThunderNotification.RoomStatsEx) msg.obj;
                        thunderEngine.mRoomStats.txBytes = roomStatsEx.txTotalBytes;
                        thunderEngine.mRoomStats.rxBytes = roomStatsEx.rxTotalBytes;
                        thunderEngine.mRoomStats.txKBitRate = roomStatsEx.txBitrate / 1024;
                        thunderEngine.mRoomStats.rxKBitRate = roomStatsEx.rxBitrate / 1024;
                        thunderEngine.mRoomStats.txAudioKBitRate = roomStatsEx.txAudioBitrate / 1024;
                        thunderEngine.mRoomStats.rxAudioKBitRate = roomStatsEx.rxAudioBitrate / 1024;
                        thunderEngine.mRoomStats.txVideoKBitRate = roomStatsEx.txVideoBitrate / 1024;
                        thunderEngine.mRoomStats.rxVideoKBitRate = roomStatsEx.rxVideoBitrate / 1024;
                        if (CpuTool.OS_VERSION.compareTo("8.0") >= 0) {
                            thunderEngine.mRoomStats.cpuAppUsage = CpuTool.getAppCpuRateAverage();
                        }
                        else{
                            thunderEngine.mRoomStats.cpuAppUsage = roomStatsEx.cpuAppUsage;
                        }
                        thunderEngine.mRoomStats.cpuTotalUsage = roomStatsEx.cpuTotalUsage;

                        ThunderNotification.RoomStats roomStats = new ThunderNotification.RoomStats(roomStatsEx.txBitrate,
                                roomStatsEx.rxBitrate, roomStatsEx.txAudioBitrate, roomStatsEx.rxAudioBitrate,
                                roomStatsEx.txVideoBitrate, roomStatsEx.rxVideoBitrate);
                        mRtcEventHandler.onRoomStats(roomStats);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_RtmpStreamNotify2Service: {
                        ThunderNotification.RtmpStreamNotify2Service result =
                                (ThunderNotification.RtmpStreamNotify2Service) msg.obj;
                        int errorCode = result.getAction();
                        Integer status = thunderEngine.mRtmpStatusMap.get(result.getUrl());
                        if (status != null && errorCode != status.intValue()) {
                            thunderEngine.mRtmpStatusMap.put(result.getUrl(), errorCode);
                            mRtcEventHandler.onPublishStreamToCDNStatus(result.getUrl(), errorCode);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_TransLinkStatus: {
                        //joinRoom后才会收到该消息
                        ThunderNotification.TransLinkStatus result = (ThunderNotification.TransLinkStatus) msg.obj;
                        mTransLinkStatus = result.getStatus();

                        checkDisconnectedStatus(thunderEngine.getIsThunder());
                        if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                            removeMessages(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus);
                        }

                        if (thunderEngine.getIsThunder()) {
                            mRtcEventHandler.onConnectionStatus(result.getStatus());
                        } else {
                            if (mTransLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                    mRtcEventHandler.onConnectionStatus(result.getStatus());
                                }
                            } else {
                                mRtcEventHandler.onConnectionStatus(result.getStatus());
                            }
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_ServiceLinkStatus: {
                        ThunderNotification.ServiceLinkStatus result = (ThunderNotification.ServiceLinkStatus) msg.obj;
                        mServiceLinkStatus = result.getStatus();

                        checkDisconnectedStatus(thunderEngine.getIsThunder());
                        if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                            removeMessages(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus);
                        }

                        if (thunderEngine.isJoinRoom) {
                            if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                if (mTransLinkStatus == THUNDER_CONNECTION_STATUS_CONNECTED) {
                                    mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                                }
                            } else {
                                mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                            }
                        } else {
                            mRtcEventHandler.onConnectionStatus(mServiceLinkStatus);
                        }
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus: {
                        mRtcEventHandler.onConnectionLost();
                        break;
                    }
					case ThunderNotification.kThunderAPINotification_RemoteVideoStats: {
						ThunderNotification.RemoteVideoStats result = (ThunderNotification.RemoteVideoStats) msg.obj;
						ThunderEventHandler.RemoteVideoStats videoStats = new ThunderEventHandler.RemoteVideoStats();
						String strUid = UidMap.getStringUid(result.uid);
  						int streamType = 0;
						if (thunderEngine.mSubscribeRemoteUidToVideoType.containsKey(strUid)) {
							streamType = thunderEngine.mSubscribeRemoteUidToVideoType.get(strUid);
						}
						videoStats.delay = result.delay;
						videoStats.width = result.width;
						videoStats.height = result.height;
						videoStats.receivedBitrate = result.receivedBitrate;
						videoStats.decoderOutputFrameRate = result.decoderFrameRate;
						videoStats.rendererOutputFrameRate = result.renderFrameRate;
						videoStats.packetLossRate = result.packetLossRate;
						videoStats.rxStreamType = streamType;
						videoStats.totalFrozenTime = result.frozenTime;
						videoStats.frozenRate = result.frozenRate;
						mRtcEventHandler.onRemoteVideoStatsOfUid(strUid, videoStats);
						break;
					}
                    case ThunderNotification.kThunderAPINotification_RemoteAudioTransStats: {
                        ThunderNotification.RemoteAudioTransStats result = (ThunderNotification.RemoteAudioTransStats) msg.obj;
                        String strUid = mThunderEngine.get().getIsThunder() ?
                                UidMap.getStringUidFromMap(result.uid) : UidMap.getStringUid(result.uid);
                        if (strUid == null || strUid.isEmpty()) {
                            break;
                        }
                        mRtcEventHandler.onRemoteAudioTransStatsOfUid(strUid, result.delay, result.lost, result.rxKBitRate);
                        break;
                    }
                    case ThunderNotification.kThunderAPINotification_RemoteVideoTransStats: {
                        ThunderNotification.RemoteVideoTransStats result = (ThunderNotification.RemoteVideoTransStats) msg.obj;
                        String strUid = UidMap.getStringUid(result.uid);
                        mRtcEventHandler.onRemoteVideoTransStatsOfUid(strUid, result.delay, result.lost, result.rxKBitRate);
                        break;
                    }
                    default:
                        break;
                }
            } catch (Exception exc) {
                ThunderLog.error(TAG, "handleMessage err=%s", exc.toString());
            }
        }

        /**
         * 检查与 service/avp 的连接是否已断开（如果已经断开，每10秒发送一次
         * ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus 消息
         *
         * @return true:连接已断开 false:连接没断开
         */
        public boolean checkDisconnectedStatus(boolean isThunder) {
            if (isThunder) {
                if (mTransLinkStatus == THUNDER_CONNECTION_STATUS_DISCONNECTED) {
                    removeMessages(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus);
                    sendEmptyMessageDelayed(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus,
                            10 * 1000);
                    return true;
                }
            } else if (mServiceLinkStatus == THUNDER_CONNECTION_STATUS_DISCONNECTED ||
                    mTransLinkStatus == THUNDER_CONNECTION_STATUS_DISCONNECTED) {
                removeMessages(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus);
                sendEmptyMessageDelayed(ThunderNotification.kThunderAPINotification_CheckLinkConnectionStatus,
                        10 * 1000);
                return true;
            }
            return false;
        }

    }

    // param type define

    /**
     * 混响参数
     */
    public static final class ReverbExParameter {
        /**
         * 房间大小; 范围: [0~100]
         */
        public float mRoomSize = 0;
        /**
         * 预延时; 范围: [0~200]
         */
        public float mPreDelay = 0;
        /**
         * 混响度; 范围: [0~100]
         */
        public float mReverberance = 0;
        /**
         * 高频因子; 范围: [0~100]
         */
        public float mHfDamping = 0;
        /**
         * 低频量; 范围: [0~100]
         */
        public float mToneLow = 0;
        /**
         * 高频量; 范围: [0~100]
         */
        public float mToneHigh = 0;
        /**
         * 湿增益; 范围: [-20~10]
         */
        public float mWetGain = 0;
        /**
         * 干增益; 范围: [-20~10]
         */
        public float mDryGain = 0;
        /**
         * 立体声宽度; 范围: [0~100]
         */
        public float mStereoWidth = 0;
    }

    /**
     * 压缩参数
     */
    public static final class CompressorParam {
        /**
         * 阈值; 范围: [-40~0]
         */
        public int mThreshold = 0;
        /**
         * 增益
         */
        public int mMakeupGain = 0;
        /**
         * 比例
         */
        public int mRatio = 0;
        /**
         * 斜率
         */
        public int mKnee = 0;
        /**
         * 释放时间; 范围: 大于0
         */
        public int mReleaseTime = 0;
        /**
         * 启动时间; 范围: 大于0
         */
        public int mAttackTime = 0;
    }

    /**
     * 限制器参数
     */
    public static final class LimterParam {
        /*
         *  -30 ~ 0
         */
        public float fCeiling = 0;
        /*
         *  -10 ~ 0
         */
        public float fThreshold = 0;
        /*
         *   0 ~ 30
         */
        public float fPreGain = 0;
        /*
         *  0 ~ 1000
         */
        public float fRelease = 0;
        /*
         *  0 ~ 1000
         */
        public float fAttack = 0;
        /*
         *   0 ~ 8
         */
        public float fLookahead = 0;
        /*
         * 0.5 ~ 2
         */
        public float fLookaheadRatio = 0;
        /*
         * 0 ~ 100
         */
        public float fRMS = 0;
        /*
         * 0 ~ 1
         */
        public float fStLink = 0;
    }

    //static info
    private static int sMyAppId = 0;
    private static long sMySceneId = 0;

    private static ThunderEventHandler mRtcEventHandler;

    // https request handler
    private static ThunderHttpsRequestHandler mHttpsRequestHandler;

    private static int mServiceLinkStatus = THUNDER_CONNECTION_STATUS_DISCONNECTED;   // service 连接状态
    private static int mTransLinkStatus = THUNDER_CONNECTION_STATUS_DISCONNECTED;     // avp 连接状态

    //my info
    private long mMyUid = 0;
    private boolean mIs32bitUid = false;
    private String mMyStrUid = "";

    //sdk auth info
    private boolean mIsUserBanned = false;
    private byte[] mToken;

    //log info
    private static String mLogPath = "";
    private static int mLogLevel = ThunderRtcConstant.LogLevel.THUNDER_LOG_LEVEL_TRACE;
    private static IThunderLogCallback mYyLogCallback = null;
    private static IThunderMediaExtraInfoCallback mThunderMediaExtraInfoCallback = null;

    //audio srbscribe
    private boolean mBGroupSubscribe = false;
    private boolean mBAudioPublish = false;
    private boolean mBVideoPublish = false;
    private String mStringName = "";
    private String mVideoStringName = "";

    //room info
    private int mRoomAppId = 0;
    private String mRoomName = "";

    //room profile
    private int mRoomConfig = RoomConfig.THUNDER_ROOMCONFIG_LIVE;
    //audio profile
    private int mAudioConfig = AudioConfig.THUNDER_AUDIO_CONFIG_DEFAULT;
    private int mCommutMode = CommutMode.THUNDER_COMMUT_MODE_DEFAULT;
    private int mScenarioMode = ScenarioMode.THUNDER_SCENARIO_MODE_DEFAULT;

    private boolean mBEnablePlayDataIndication = false;
    private static int s_playVolumeNotifyCount = 0;
    private static int s_playDataNotifyCount = 0;
    private static NotificationHandler mHandler = null;

    // Equalizer
    private int[] mEqGains = new int[11];
    private boolean mBEnableEqualizer = false;
    private boolean mBEnableCompressor = false;
    private boolean mBEnableLimiter = false;
    private boolean mBEnableReverbEx = false;
    private ReverbExParameter mReverbExGains = new ReverbExParameter();
    private CompressorParam mCompressorGains = new CompressorParam();
    private LimterParam mLimiterGins = new LimterParam();

    //Video
    private boolean mBOnlyReleaseCamera = false;

    // audioFilePlayer
    private Set<ThunderAudioFilePlayer> mAudioFilePlayerSet = new TreeSet<ThunderAudioFilePlayer>();

    public String getRoomName() {
        return mRoomName;
    }

    public String getMyUid() {
        return mMyStrUid;
    }

    // param for thunder bolt
    private Boolean isJoinRoom = false;
    //退频道后，还会收到一次service的异步回调，将 isJoinBlot 被置位为true，导致后面进频道失败
    private Boolean isLeaveRoomByUser = false;
    private Boolean isThunder = false;
    private Boolean isBoltJoin = false;

    private Boolean isEnableAudio = true;
    private Boolean isEnableVideo = true;
    private Boolean isStopAllVideo = false;
    private Boolean isStopAllAudio = false;
    private Boolean isStopLocalVideo = false;
    private Boolean isPreview = false;
    private Boolean isOtherSource = false;
    private Boolean needNotify = false;
    private int accompanyType = -1;

    private static Context appContext = null;
    private SurfaceView rtcSurfaceView = null;

    private long joinStart = 0;
    private long joinEnd = 0;

    //    private ThunderVideoCanvas localCanvas = null;
    private static ThunderPreviewView mLocalPreviewView = null;
    //    private ThunderVideoCanvas remoteCanvas = null;
    private ArrayList<ThunderVideoCanvas> remoteCanvas = new ArrayList<ThunderVideoCanvas>(0);
    private int thunderBoltProfile = ThunderRtcProfile.THUNDER_PROFILE_DEFAULT;
    private int playType = ThunderPublishPlayType.THUNDERPUBLISH_PLAY_SINGLE;
    private int resolutionMode = -1;
    private ThunderVideoEncoderConfiguration mThunderVideoEncoderConfiguration = new ThunderVideoEncoderConfiguration();
    private ArrayList<ThunderStream> anchorStreams = new ArrayList<ThunderStream>(0);
    private ArrayList<ThunderStream> wholeStreams = new ArrayList<ThunderStream>(0);
    private Map<String, ArrayList<ThunderStream>> channelStreamsList = new HashMap<>();  // 支持跨频道
    // 远端strUid所包含视频大小流的信息<uid,streamsInfo>
    private Map<String, ArrayList<ThunderStream>> mRemoteUidToVideoDualStreamInfo = new HashMap<>();
    //订阅远端视频大小流类型0-大流 1-小流,<strUid,type>
    private Map<String, Integer> mSubscribeRemoteUidToVideoType = new HashMap<>();
    // 进频道前用户设置默认订阅的视频流类型，默认大流，针对所有视频流
    private int mDefauleRemoteVideoStreamType = 0;

    private Map<String, Set<String>> subscribeStreamMap = new HashMap<>(); // 跨频道的流
    private Map<String, Boolean> uidMuteVideoList = new HashMap<>();
    private Map<String, Boolean> uidMuteAudioList = new HashMap<>();
    private final Object streamLock = new Object();

    // external data
    private ExternalAudioSource mAudioSource = null;

    //ThunderBolt订阅和开播到群组
    private boolean mTbSubscribeGroup = false;
    private boolean mTbPublishGroup = false;

    //64uid
    private boolean mRecv64UidMap = false;

    private boolean mIsFrontCamera = true;

    private HashMap<String, Integer> mRtmpStatusMap = new HashMap<>();

    private ThunderEventHandler.RoomStats mRoomStats = new ThunderEventHandler.RoomStats();

    // End of Para

    private ThunderEngine() {
        // SDK不支持视频时，默认为thunder模式
        if (!BuildConfig.__YY_VIDEO_SUPPORT__) {
            isThunder = true;
        }
    }

    private static class SingleonHolder {
        private static ThunderEngine INSTANCE = new ThunderEngine();
    }

    private static synchronized ThunderEngine createRtcEngine(Context context,
                                                              String appId,
                                                              long sceneId,
                                                              ThunderEventHandler handler) {
        if (SingleonHolder.INSTANCE == null) {
            SingleonHolder.INSTANCE = new ThunderEngine();
        }

        if (mHandler == null) {
            mHandler = new NotificationHandler(SingleonHolder.INSTANCE);
        }

        // 如果已经被创建过，就不再初始化x
        if (!mIsInited) {
            mRtcEventHandler = handler;
            mHttpsRequestHandler = new ThunderHttpsRequestHandler();

            sMyAppId = Integer.parseInt(appId);
            sMySceneId = sceneId;

            if (BuildConfig.__YY_VIDEO_SUPPORT__) {
                // 部分机型需要手动先于yyvideoplayer库加载ffmpeg 和 ittiam .
                try {
                    System.loadLibrary("ffmpeg-neon");
                    System.loadLibrary("Ittiamhevcdec");
                } catch (Throwable e) {
                    e.printStackTrace();
                    //ThunderLog.error(ThunderLog.kLogTagCall, "load ffmpeg-neon & Ittiamhevcdec failed!");
                }
            }

            ThunderAPI.sharedInstance().initWithAppId(sMyAppId, sMySceneId, context, mHandler);
            mIsInited = true;
        }

        return SingleonHolder.INSTANCE;
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId   接入app的唯一标识
     * @param handler ThunderEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件\
     * @return YYLiveRtcEngine对象
     * @sceneId 场景Id
     */
    public static synchronized ThunderEngine createEngine(Context context,
                                                          String appId,
                                                          long sceneId,
                                                          ThunderEventHandler handler) {

        ThunderEngine rtcEngine = createRtcEngine(context, appId, sceneId, handler);
        appContext = context;

        return rtcEngine;
    }

    public void onStreamsNotify(ThunderNotification.StreamsNotify streamInfo) {
        if (isLeaveRoomByUser) {
            return;
        }

        ArrayList<ThunderStream> curChannelStreams = streamInfo.getStreams();
        if (curChannelStreams == null) {
            return;
        }

        //同频道和跨频道连麦情况都需要处理
        ThunderAPI.sharedInstance().handleTrancodingQuerySubscribeStream(streamInfo);

        ArrayList<ThunderStream> addStreams = new ArrayList<ThunderStream>();             // 需要增加订阅的流
        ArrayList<ThunderStream> removeStreams = new ArrayList<ThunderStream>();          // 需要退订的流
        // 新的流通知来需要更新大小流映射
        mRemoteUidToVideoDualStreamInfo.clear();

        //filter self
        synchronized (streamLock) {
            Iterator<ThunderStream> it = curChannelStreams.iterator();
            while (it.hasNext()) {
                ThunderStream stream = it.next();
                //检查uid是否冲突
                if (!stream.strUid.equals(mMyStrUid) && stream.speakerUid == mMyUid) {
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onStreamsNotify: duplicated uid="
                            + stream.speakerUid + " speakerStrUid=" + stream.strUid + " myStrUid=" + mMyStrUid);
                    ThunderNative.duplicatedUid(stream.speakerUid, stream.strUid);
                    return;
                }
                if (stream.strUid.length() > 0) {
                    addUid2String(stream.speakerUid, stream.strUid);
                }

                //过滤自己的
                String strUid = UidMap.getStringUid(stream.speakerUid);
                if (mMyStrUid.equals(strUid)) {
                    it.remove();
                } else {

                    /**
                     * 跨频道流通知过滤, 需要过滤掉没有通过{@link addSubscribe}接口进行跨频道订阅的uid
                     * 1、当只设置了混画任务 但是没有订阅时 subscribeStreamMap为null，但是有流通知此时也应该过滤掉
                     * 2、当跨频道订阅时 需要过滤掉同一个频道离没有订阅的spkUid
                     */
                    if (!streamInfo.getRoomId().equals(mRoomName)) {
                        Set<String> streamSet = subscribeStreamMap.get(streamInfo.getRoomId());
                        if ((streamSet == null || streamSet.isEmpty()) ||
                                (streamSet != null && !streamSet.contains(strUid))) {
                            it.remove();
                        }
                    }
                }

                if (stream.bVideo)
                {
                    // save 大小流信息
                    ArrayList<ThunderStream> dualStreamInfo = mRemoteUidToVideoDualStreamInfo.get(stream.strUid);
                    if (null == dualStreamInfo)
                    {
                        dualStreamInfo = new ArrayList<>();
                    }
                    dualStreamInfo.add(stream);
                    mRemoteUidToVideoDualStreamInfo.put(stream.strUid, dualStreamInfo);
                }
            }

            ArrayList<ThunderStream> oldStreamsInChannel = channelStreamsList.get(streamInfo.getRoomId());
            if (oldStreamsInChannel != null) {
                // 对比查找需要增加订阅的流
                for (ThunderStream newStream : curChannelStreams) {
                    boolean isFind = false;
                    for (ThunderStream oldStream : oldStreamsInChannel) {
                        if (newStream.streamName.equals(oldStream.streamName)) {
                            isFind = true;
                        }
                    }
                    if (!isFind) {
                        addStreams.add(newStream);
                    }
                }
                // 对比查找需要退订的流
                for (ThunderStream oldStream : oldStreamsInChannel) {
                    boolean isFind = false;
                    for (ThunderStream newStream : curChannelStreams) {
                        if (newStream.streamName.equals(oldStream.streamName)) {
                            isFind = true;
                        }
                    }
                    if (!isFind) {
                        removeStreams.add(oldStream);
                        // 如果之前已经订阅，则删除
                        if (anchorStreams.contains(oldStream)) {
                            anchorStreams.remove(oldStream);
                        }
                    }
                }
            } else {
                addStreams.addAll(curChannelStreams);
            }

            if (!isJoinRoom) {
                isJoinRoom = true;
            }
            notifyJoinSuccess();

            /**
             * 在视频双流情况下回调需要特殊处理:
             * 1、如果已经订阅了同样的struid的另一条视频流，那么streams里删除的同样uid的视频流就暂时不需要回调给业务
             * 2、当同一个Uid有多个视频流同时取消，这个时候根据uid回调一次就够了
             **/
             Map<String, Boolean> callBackVideoUidMap = new HashMap<String, Boolean>();
            // Notify stream change
            for (ThunderStream stream : removeStreams) {
                if (stream.bVideo)
                {
                    boolean bFinded = false;
                    for (ThunderStream exitStream : anchorStreams)
                    {
                        if (exitStream.bVideo && exitStream.strUid.equals(stream.strUid))
                        {
                            bFinded = true;
                            break;
                        }
                    }

                    // 判断当前的strUid上一次是否处理过
                    boolean isHandled = false;
                    if (callBackVideoUidMap.containsKey(stream.strUid))
                    {
                        isHandled = true;
                    }else
                        {
                            callBackVideoUidMap.put(stream.strUid, true);
                        }
                    if (!bFinded && !isHandled)
                    {
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "onRemoteVideoStopped id:" + stream.speakerUid + " isStop:" + true);
                        mRtcEventHandler.onRemoteVideoStopped(UidMap.getStringUid(stream.speakerUid), true);
                    }
                } else {
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                            "onRemoteAudioStopped id:" + stream.speakerUid + " isStop:" + true);
                    mRtcEventHandler.onRemoteAudioStopped(UidMap.getStringUid(stream.speakerUid), true);
                }
            }

            /**
             * 在视频双流情况下回调需要特殊处理:
             * 1、如果已经订阅了同样的struid的另一条视频流，那么streams里新增同样uid的视频流就暂时不需要回调给业务
             * 2、当同一个Uid有多个视频流同时来，这个时候根据uid回调一次就够了
             */
            callBackVideoUidMap.clear();
            for (ThunderStream stream : addStreams) {
                if (stream.bVideo)
                {
                    boolean bFinded = false;
                    for (ThunderStream exitStream : anchorStreams)
                    {
                        if (exitStream.bVideo && exitStream.strUid.equals(stream.strUid))
                        {
                            bFinded = true;
                            break;
                        }
                    }

                    // 判断当前的strUid上一次是否处理过
                    boolean isHandled = false;
                    if (callBackVideoUidMap.containsKey(stream.strUid))
                    {
                        isHandled = true;
                    }else
                    {
                        callBackVideoUidMap.put(stream.strUid, true);
                    }
                    if (!bFinded && !isHandled)
                    {
                        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                                "onRemoteVideoStopped id:" + stream.speakerUid + " isStop:" + false);
                        mRtcEventHandler.onRemoteVideoStopped(UidMap.getStringUid(stream.speakerUid), false);
                    }
                } else {
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                            "onRemoteAudioStopped id:" + stream.speakerUid + " isStop:" + false);
                    mRtcEventHandler.onRemoteAudioStopped(UidMap.getStringUid(stream.speakerUid), false);
                }
            }

            // 去除黑名单音视频流
            it = addStreams.iterator();
            while (it.hasNext()) {
                boolean isMute;
                ThunderStream stream = it.next();
                if (stream.bVideo) {
                    isMute = isMuteVideoStreamWithUid(stream.speakerUid);
                } else {
                    isMute = isMuteAudioStreamWithUid(stream.speakerUid);
                }

                if (isMute) {
                    it.remove();
                } else if (stream.bVideo && remoteCanvas != null) {
                    // 订阅前需要重新绑定 YRVideoCanvas（如果之前有设置的话）
                    for (ThunderVideoCanvas canvas : remoteCanvas) {
                        if ((UidMap.getLongUid(canvas.mUid) == stream.speakerUid)) {
                            stream.toView = canvas.mView;
                            stream.scaleMode = canvas.mRenderMode;
                        }
                    }
                }
            }

            wholeStreams.clear();
            channelStreamsList.put(streamInfo.getRoomId(), curChannelStreams);
            for (Map.Entry<String, ArrayList<ThunderStream>> entry : channelStreamsList.entrySet()) {
                wholeStreams.addAll(entry.getValue());
            }
            // 这里暂时不更新anchorStreams，大小流场景一个uid有多个视频，先在tryStartSubscribe过滤
            // anchorStreams.addAll(addStreams);

            if (removeStreams.size() > 0) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(removeStreams, null);
            }

            if (addStreams.size() > 0) {
                tryStartSubscribe(addStreams);
            }
        }
    }

private void onHighLowStreamSwitch(String fromStreamName, String toStreamName)
{
    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onHighLowStreamSwitch: fromStream:" + fromStreamName
            + " toStream:" + toStreamName);
    // 切换成功取消订阅fromStreamName
    ArrayList<ThunderStream> stopSubscribeStream = new ArrayList<>();

    synchronized (streamLock) {
        Iterator<ThunderStream> iter = anchorStreams.iterator();
        while (iter.hasNext()) {
            ThunderStream stream = iter.next();
            if (stream.streamName.equals(fromStreamName)) {
                stopSubscribeStream.add(stream);
            }
        }

        for (ThunderStream oneStream : stopSubscribeStream) {
            anchorStreams.remove(oneStream);
        }
    }

    if(0 < stopSubscribeStream.size()) {
        ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopSubscribeStream, null);
    }
}

    private void notifyJoinSuccess() {
        if (isJoinRoom && needNotify && mRecv64UidMap) {
            joinEnd = System.currentTimeMillis();
            needNotify = false;

            int timeElapse = (int) (joinEnd - joinStart);
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "onJoinRoomSuccess:" + mMyStrUid
                    + "-" + UidMap.getLongUid(mMyStrUid) + "," + timeElapse);

            tbGroupSubscribe(); //进入频道成功才订阅群组，对应离开频道的退订逻辑；
            mRtcEventHandler.onJoinRoomSuccess(mRoomName, mMyStrUid, timeElapse);
        }
    }

    /**
     * 创建RtcEngine对象
     * <br>仅支持一个实例
     * <br>在yylivesdk.yy.com上创建app后，系统会分配唯一appId，初始化后appId不能修改
     *
     * @param context Andoird APP 的上下文
     * @param appId   接入app的唯一标识
     * @param handler ThunderEventHandler 是一个提供了缺省实现的抽象类，SDK 通过该抽象类向应用程序报告 SDK 运行时的各种事件
     * @return YYLiveRtcEngine对象
     * @sceneId 场景Id
     * @loop 回调执行线程
     */
    public static synchronized ThunderEngine createWithLoop(Context context,
                                                            String appId,
                                                            long sceneId,
                                                            ThunderEventHandler handler,
                                                            Looper loop) {
        ThunderEngine rtcEngine = createRtcEngine(context, appId, sceneId, handler);

        if (mHandler == null) {
            mHandler = new NotificationHandler(rtcEngine, loop);
        }

        return rtcEngine;
    }

    /**
     * 销毁RtcEngine对象
     */
    public static synchronized void destroyEngine() {
        // 如果已经被销毁，就不再卸载
        if (mIsInited) {
            SingleonHolder.INSTANCE.leaveRoom();
            SingleonHolder.INSTANCE.setVideoWatermark(null);
            SingleonHolder.INSTANCE.setLocalVideoMirrorMode(THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR);
            ThunderAPI.sharedInstance().deInit();
            mIsInited = false;
            SingleonHolder.INSTANCE.resetRtcEngine();
            SingleonHolder.INSTANCE = null;
        }
    }

    /**
     * sdk版本号
     *
     * @return sdk版本号，非空
     */
    public static String getVersion() {
        return ThunderAPI.sharedInstance().getVersion();
    }

    /**
     * 设置日志文件路径（打开日志）
     *
     * @param filePath 日志文件路径（路径为空表示关闭日志）
     * @return
     */
    public static int setLogFilePath(String filePath) {
        mLogPath = filePath;
        if (filePath == null || filePath.isEmpty()) {
            ThunderAPI.enableLog(false, mLogLevel, mLogPath, null);
        } else {
            ThunderAPI.enableLog(true, mLogLevel, mLogPath, null);
        }
        return 0;
    }

    /**
     * 设置日志回调
     *
     * @praam IThunderLogCallback 日志回调(callback = null 表示关闭日志）
     * 设置了日志回调，则setLogFile无效；
     */
    public static int setLogCallback(IThunderLogCallback callback) {
        mYyLogCallback = callback;

        if (mYyLogCallback != null) {
            ThunderAPI.enableLog(true, mLogLevel, "", mYyLogCallback);
        } else {
            ThunderAPI.enableLog(false, mLogLevel, "", mYyLogCallback);
        }

        return 0;
    }

    /**
     * 设置日志级别
     *
     * @param filter ThunderRtcConstant.LogLevel
     * @return
     */
    public static int setLogLevel(int filter) {
        mLogLevel = filter;
        return 0;
    }

    public int setParameters(String options) {
        try {
            JSONObject obj = new JSONObject(options);
            mTbSubscribeGroup = obj.getBoolean("JoinWithSubscribeGroup");
            mTbPublishGroup = obj.getBoolean("PublishAudioToGroup");
            ThunderNative.tbPublishGroup(mTbPublishGroup);

            ThunderLog.release(TAG, "[tbg] setParameters JoinWithSubscribeGroup=%b PublishAudioToGroup=%b",
                    mTbSubscribeGroup, mTbPublishGroup);

        } catch (Exception exc) {
            ThunderLog.release(TAG, "setParameters err=%s", exc.toString());

            return -1;
        }

        return 0;
    }

    private void tbGroupSubscribe() {
        ThunderLog.release(TAG, "tbGroupSubscribe");

        if (!mTbSubscribeGroup) {
            return;
        }

        if (mBGroupSubscribe) {
            return;
        }

        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();

        oneGroup.appId = mRoomAppId;
        oneGroup.groupName = "g_" + mRoomName;
        audioGroup.add(oneGroup);

        ThunderLog.release(TAG, "[tbg] tbGroupSubscribe");
        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);

        mBGroupSubscribe = true;
    }

    private void tbStopGroupSubscribe() {
        ThunderLog.release(TAG, "[tbg] tbStopGroupSubscribe");

        if (!mTbSubscribeGroup) {
            return;
        }

        if (mBGroupSubscribe) {
            ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
            ThunderGroup oneGroup = new ThunderGroup();
            oneGroup.appId = mRoomAppId;
            oneGroup.groupName = "g_" + mRoomName;
            audioGroup.add(oneGroup);

            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);

            mBGroupSubscribe = false;
        }
    }

    /**
     * 设置场景Id
     *
     * @param sceneId 自定义场景Id
     */
    public void setSceneId(long sceneId) {
        sMySceneId = sceneId;
        ThunderAPI.sharedInstance().setSceneId(sceneId);
    }

    /**
     * 功能1：进入频道前调用有效，可选择进入纯音频频道或者音视频频道；（默认为音视频） 功能2：设置频道属性；
     *
     * @param config            默认0：音视频模式 1：音视频模式 2：纯音频模式
     * @param roomConfig={@link ThunderRtcConstant.RoomConfig
     *                          THUNDER_ROOMCONFIG_LIVE = 直播模式（流畅）
     *                          THUNDER_ROOMCONFIG_COMMUNICATION = 通话模式（延时低）
     *                          THUNDER_ROOMCONFIG_GAME = 游戏（省流量、延时低）}
     * @return 成功或失败
     */
    public int setRoomConfig(int config, int roomConfig) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRoomConfig: config=%d roomConfig:%d", config, roomConfig);

        //调用joinChannel后，就应该设置不生效
        if (joinStart != 0) {
            return -1;
        }

        if (isJoinRoom) {
            return -2;
        }

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setChannelProfile: working");

        if (config == ThunderRtcProfile.THUNDER_PROFILE_ONLY_AUDIO) {
            isThunder = true;
        } else {
            // SDK支持视频时，才能修改
            if (BuildConfig.__YY_VIDEO_SUPPORT__) {
                isThunder = false;
            }
        }

        mRoomConfig = roomConfig;

        boolean bLowLatency = false;

        switch (mRoomConfig) {
            case RoomConfig.THUNDER_ROOMCONFIG_LIVE: {
                bLowLatency = false;
            }
            break;
            case RoomConfig.THUNDER_ROOMCONFIG_COMMUNICATION:
            case RoomConfig.THUNDER_ROOMCONFIG_GAME: {
                bLowLatency = true;
            }
            break;
            case RoomConfig.THUNDER_ROOMCONFIG_MULTIAUDIOROOM: {
                bLowLatency = true;
            }
            break;
            default:
                break;
        }
        ThunderAPI.sharedInstance().setRoomConfig(mRoomConfig);
        ThunderAPI.sharedInstance().enableLowLatency(bLowLatency);
        return config;
    }

    /**
     * 设置区域（国外用户必须调用此接口）
     *
     * @param area 取值范围YYLiveRtcConstant.AreaType
     * @return
     */
    public int setArea(int area) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setArea: area=%d", area);

        int iResult = 0;
        int transSdkArea = ThunderAreaType.THUNDERAREA_DEFAULT; //domestic;
        switch (area) {
            case AreaType.THUNDER_AREA_DEFAULT:
                transSdkArea = ThunderAreaType.THUNDERAREA_DEFAULT; //default-domestic;
                break;
            case AreaType.THUNDER_AREA_FOREIGN:
                transSdkArea = ThunderAreaType.THUNDERAREA_FOREIGN; //foreign;
                break;
            case AreaType.THUNDER_AREA_RESERVED:
                transSdkArea = ThunderAreaType.THUNDERAREA_RESERVED;
                break;
            default:
                iResult = -1;
                break;
        }

        ThunderAPI.sharedInstance().setAreaType(transSdkArea);
        return iResult;
    }

    /**
     * 开启跟websdk兼容后内部禁止编码B帧，因为websdk不能正常解码B帧(要求开播前调用，跟进退频道无关)
     *
     * @param enabled 是否开启兼容，默认关闭
     * @return
     */
    public int enableWebSdkCompatibility(boolean enabled) {
        if (isThunder) {
            return -2;
        }

        ThunderNative.enableWebSdkCompatibility(enabled);
        return 0;
    }

    /**
     * 指定是否使用64位uid，要求进频道前调用
     *
     * @param is64bitUid 默认值:true
     *                   为true时，支持[A,Z],[a,z],[0,9],-,_等字符的排列组合，且长度不能超过64个字节
     *                   为false时，只支持[0,9]，且数值不大于32位无符号整型
     * @return
     */
    public int setUse64bitUid(boolean is64bitUid) {
        mIs32bitUid = !is64bitUid;
        ThunderAPI.sharedInstance().set32BitUid(mIs32bitUid);
        return 0;
    }

    /**
     * 加入频道，在同一个频道内的用户可以互相通话，多个用户加入同一个频道，可以群聊。不同appId不互通
     *
     * @param token    参见renewToken {@link ThunderEngine##updateToken(byte[])}
     * @param roomName 频道名称(需保证一个AppId内唯一)，只支持[A,Z],[a,z],[0,9],-,_等字符的排列组合，且长度不能超过64个字节
     * @param uid      用户id，需要保证唯一，只支持[A,Z],[a,z],[0,9],-,_等字符的排列组合，且长度不能超过64个字节
     * @return 成功或失败
     */

    public int joinRoom(byte[] token, String roomName, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "joinRoom: roomName=%s, uid=%s, is32bitUid=%b, token=%s",
                getPrintString(roomName),
                getPrintString(uid),
                mIs32bitUid,
                getPrintString(token));

        if (!isValidRoomStream(roomName)) {
            return -1;
        }

        if (!isValidUid(uid)) {
            return -2;
        }

        if (isJoinRoom) {
            return 0;
        }

        mMyStrUid = uid;
        if (mIs32bitUid) {
            try {
                mMyUid = Long.parseLong(uid);
                mRecv64UidMap = true;
            } catch (NumberFormatException exception) {
                return -4;
            }
        }

        mRoomName = roomName;
        mRoomAppId = sMyAppId;

        if (isThunder) {
            //voice only sdk
            ThunderNative.setVoiceOnlySdk(true);
        } else {
            ThunderNative.setVoiceOnlySdk(false);
        }

        //token
        ThunderAPI.sharedInstance().updateToken(token);

        ThunderNative.setChannelName(mRoomName);

        //token
        mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);

        if (mIs32bitUid) {
            ThunderNative.setUserInfo(mMyUid, 0);
        } 

        //user role
        ThunderAPI.sharedInstance().setUserRole(ThunderUserRole.THUNDERUSER_ROLE_ANCHOR);

        //subscribe
        if (isThunder) {
            //join
            if (mIs32bitUid) {
                ThunderAPI.sharedInstance().joinMedia(mMyUid);
             } else {
                ThunderAPI.sharedInstance().joinMedia(mMyStrUid, 0, 0);
             }
            joinRoomThunder();
        } else {
            joinRoomThunderBolt();
        }

        joinStart = System.currentTimeMillis();
        needNotify = true;
        isLeaveRoomByUser = false;

        return 0;
    }

    private boolean joinRoomThunder() {

        if (mBGroupSubscribe) {
            return false;
        }

        ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
        ThunderGroup oneGroup = new ThunderGroup();

        oneGroup.appId = mRoomAppId;
        oneGroup.groupName = "g_" + mRoomName;
        audioGroup.add(oneGroup);

        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(null, audioGroup);

        mBGroupSubscribe = true;
        needNotify = false;
        return true;

    }

    private boolean joinRoomThunderBolt() {
        boolean res = ThunderAPI.sharedInstance().joinRoom(mRoomName,
                mMyStrUid, ThunderUserRole.THUNDERUSER_ROLE_ANCHOR, mIs32bitUid);

        if (res) {
            isBoltJoin = true;
        }

        return true;
    }

    private boolean isValidRoomStream(String roomName) {
        if (roomName == null || roomName.isEmpty()) {
            return false;
        }

        int length = roomName.length();
        if (length > 64) {
            return false;
        }
        int codePoint;
        int validCharCount = 0;
        for (int i = 0; i < length; i++) {
            codePoint = Character.codePointAt(roomName, i);
            if (codePoint == 45 || codePoint == 95         // - _
                    || (codePoint >= 48 && codePoint <= 57)    // [0,9]
                    || (codePoint >= 65 && codePoint <= 90)    // [A,Z]
                    || (codePoint >= 97 && codePoint <= 122))  // [a,z]
            {
                validCharCount += 1;
            }
        }
        if (validCharCount == length) {
            return true;
        }
        ThunderLog.error(ThunderLog.kLogTagRtcEngine, "found invalid char in roomName!");
        return false;
    }

    private boolean isValidUid(String uid) {
        if (uid == null || uid.isEmpty()) {
            return false;
        }

        if (mIs32bitUid) {
            if (!UidMap.isNumeric(uid)) {
                ThunderLog.error(ThunderLog.kLogTagRtcEngine, "isValidUid, uid32 has invalid character");
                return false;
            }

            try {
                long iUid = Long.parseLong(uid, 10);
                if (iUid <= 0x00000000ffffffffL) {
                    return true;
                }
            } catch (NumberFormatException exception) {
                return false;
            }
        } else {
            int length = uid.length();
            if (length > 64) {
                ThunderLog.error(ThunderLog.kLogTagRtcEngine, "isValidUid, StrUid more than 64 character");
                return false;
            }
            int codePoint;
            int validCharCount = 0;
            for (int i = 0; i < length; i++) {
                codePoint = Character.codePointAt(uid, i);
                if (codePoint == 45 || codePoint == 95         // - _
                        || (codePoint >= 48 && codePoint <= 57)    // [0,9]
                        || (codePoint >= 65 && codePoint <= 90)    // [A,Z]
                        || (codePoint >= 97 && codePoint <= 122))  // [a,z]
                {
                    validCharCount += 1;
                }
            }
            if (validCharCount == length) {
                return true;
            }
            ThunderLog.error(ThunderLog.kLogTagRtcEngine, "found invalid character in StrUid");
            return false;
        }

        return false;
    }

    /**
     * 离开频道
     *
     * @return
     */
    public int leaveRoom() {
        //unregisterNotificationHandler会导致收不到离开频道消息
        //unregister notification
        //ThunderAPI.sharedInstance().unregisterNotificationHandler(mHandler);

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "leaveRoom");
        isLeaveRoomByUser = true;

        cleanAllAudioFilePlayer();

        if (isThunder) {
            leaveRoomThunder();
        } else {
            if (!isJoinRoom) {
                return -2;
            }
            leaveRoomThunderBolt();
        }

        //clear uids
        UidMap.removeAllUid2String();

        isBoltJoin = false;
        isEnableAudio = true;
        isEnableVideo = true;

        isJoinRoom = false;
        isStopLocalVideo = false;
        isStopAllVideo = false;
        isStopAllAudio = false;

        joinStart = 0;
        accompanyType = -1;

        mRoomName = "";
        mRtmpStatusMap.clear();
        mDefauleRemoteVideoStreamType = 0;

        synchronized (streamLock) {
            wholeStreams.clear();
            anchorStreams.clear();
            channelStreamsList.clear();
            //Todo remove views
            remoteCanvas.clear();
            subscribeStreamMap.clear();
            mRemoteUidToVideoDualStreamInfo.clear();
            mSubscribeRemoteUidToVideoType.clear();
        }

        return 0;
    }

    private int leaveRoomThunder() {
        if (!mBGroupSubscribe) {
            return -1;
        }

        tryStopPublish();
        tryStopSubscribe();
        ThunderAPI.sharedInstance().leaveMedia();
        mBGroupSubscribe = false;
        return 0;
    }

    private int leaveRoomThunderBolt() {
        tbStopGroupSubscribe();
        tryStopPublish();
        tryStopSubscribe();
        tryStopVideoSubscribe();
        tryStopVideoPublish();

        ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(
                ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());

        tryStopVideoPreview();

        ThunderAPI.sharedInstance().leaveRoom();

        mRoomStats.duration = (int)((System.currentTimeMillis() - joinEnd) / 1000);
        mRtcEventHandler.onLeaveRoom(mRoomStats);
        return 0;
    }

    /**
     * 更新token，用于appid和业务功能鉴权
     * <br> token 格式
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | TokenLen(uint16)    | AppId(uint32)        | uid (uint64)          | Timestamp(uint64)(ms)    |
     * <br> -------------------------------------------------------------------------------------------------
     * <br> | ValidTime(uint32)(s)| BizExtInfoLen(uint16)| BizExtInfoData(nBytes)| DigitalSignature(20Bytes)|
     * <br> -------------------------------------------------------------------------------------------------
     * <br> 1. 多字节整数使用网络字节序
     * <br> 2. TokenLen：整个token长度，包括自身2字节和摘要
     * <br> 3. 过期时间=Timestamp+ValidTime*1000, UTC时间距离1970的毫秒数
     * <br> 4. BizExtInfoData: 业务鉴权可能需要的扩展信息，透传
     * <br> 5. DigitalSignature：采用hmac-sha1算法对DigitalSignature前的所有数据运算得出[TokenLen,BizExtInfoData], 秘钥使用申请appId时分配的appSecret
     * <br> 6. 整个token 进行 url安全的 base64编码
     *
     * @param token 业务服务器生成的token，需要url base64编码
     *              <p>
     *              通过监听通知 kThunderAPINotification_BizAuthRes, kThunderAPINotification_SdkAuthRes获取鉴权结果
     *              {@link ThunderNotification#kThunderAPINotification_BizAuthRes}
     *              {@link ThunderNotification#kThunderAPINotification_SdkAuthRes}
     */
    public int updateToken(byte[] token) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "updateToken: %s ", getPrintString(token));

        mToken = token;
        ThunderAPI.sharedInstance().updateToken(token);
        return 0;
    }

    /**
     * 打开音频采集，并开播到频道
     *
     * @return
     */
    public int enableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAudioEngine isThunder:" + isThunder);

        isEnableAudio = true;

        if (isThunder) {
            //必须在joinRoom之后调用
            if (!mBGroupSubscribe) {
                return -1;
            }

            if (mBAudioPublish) {
                return -2;
            }

            mStringName = "a_" + mMyStrUid + "_" + mRoomName;
            String groupName = "g_" + mRoomName;

            ArrayList<String> groupList = new ArrayList<String>();
            groupList.add(groupName);
            ThunderPublishAudioConfig config = new ThunderPublishAudioConfig(
                    ThunderPublishAudioConfig.YYPUBLISH_AUDIO_MODE_LOWDELAY_NORMALFLOW_MEDIUMQUALITY_VOIP);

            config.bUseAudioProfile = true;
            config.roomConfig = mRoomConfig;
            config.audioConfig = mAudioConfig;
            config.commutMode = mCommutMode;
            config.scenarioMode = mScenarioMode;

            mBAudioPublish = true;

            ThunderAPI.sharedInstance().getPublisher().startPublishAudio(mStringName, groupList, config);
        } else {

            if (mBAudioPublish) {
                return -2;
            }

            if (isJoinRoom) {
                tbGroupSubscribe();//进频道后才能订阅群组
                // 重新订阅音频流
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : wholeStreams) {
                        boolean isMute;
                        if (!oneStream.bVideo && !anchorStreams.contains(oneStream)) {
                            isMute = isMuteAudioStreamWithUid(oneStream.speakerUid);
                            if (!isMute) {
                                startStreams.add(oneStream);
                                anchorStreams.add(oneStream);
                            }
                        }
                    }
                }
                if (startStreams.size() > 0) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }

                // 重新开播音频
                if (!mBAudioPublish) {
                    ThunderAPI.sharedInstance().getPublishRoom().updateProfile(mRoomConfig, mAudioConfig,
                            mCommutMode, mScenarioMode);

                    ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(true);

                    if (accompanyType >= 0) {
                        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(accompanyType);
                    }
                    mBAudioPublish = true;
                }
            } else {
                ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableAudioEngine fail, should joinRoom first");
                return -3;
            }

        }

        return 0;
    }

    /**
     * 关闭音频采集，停止开播到频道
     * <p>
     * ps：目前thunder下仅停播但还有订阅，thunderbolt下不仅停播还停止订阅；
     * 若在2.2以后版本统一thunder和thunderbolt逻辑后请更新该方法注释；
     *
     * @return
     */
    public int disableAudioEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "disableAudioEngine isThunder:" + isThunder);
        if (isThunder) {
            tryStopPublish();
        } else {
            if (isEnableAudio) {
                tbStopGroupSubscribe();

                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            stopStreams.add(oneStream);
                        }
                    }
                }
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);

                tryStopPublish();

                ArrayList<ThunderStream> audioStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            audioStreams.add(oneStream);
                        }
                    }
                    for (ThunderStream oneStream : audioStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }
                audioStreams.clear();

                isEnableAudio = false;
            }
        }
        setAudioSourceType(ThunderRtcConstant.SourceType.THUNDER_PUBLISH_MODE_MIC);
        return 0;
    }

    /**
     * 设置音频属性，参数待定
     *
     * @param profile      ThunderRtcConstant.AudioConfig
     * @param commutMode   ThunderRtcConstant.CommutMode
     * @param scenarioMode ThunderRtcConstant.ScenarioMode
     * @return
     */
    public int setAudioConfig(int profile,
                              int commutMode,
                              int scenarioMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioConfig: profile=%d, commutMode=%d, " +
                "scenarioMode=%d", profile, commutMode, scenarioMode);

        mAudioConfig = profile;
        mCommutMode = commutMode;
        mScenarioMode = scenarioMode;
        return 0;
    }

    /**
     * 开启/关闭远端用户的语音立体声，请确保在调用 joinRoom 方法前调用该方法
     *
     * @param enable
     * @return 0：成功  非0：失败
     */
    public int enableVoicePosition(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableVoicePosition: enable=%b", enable);

        //joinRoom，就应该设置不生效
        if (joinStart != 0) {
            return -1;
        }

        if (isJoinRoom) {
            return -2;
        }

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableVoicePosition: working");
        ThunderAPI.sharedInstance().enableVoicePosition(enable);
        return 0;
    }

    /**
     *打开/关闭 测试手机延时功能
     * @param enable
     *  @return 0：成功  非0：失败
     */
    public int enableDebugLoopDelay(boolean enable){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableDebugLoopDelay: enable=%b", enable);
        ThunderAPI.sharedInstance().enableDebugLoopDelay(enable);
        return 0;
    }

    /**设置混音补偿值
     * @param value
     *  @return 0：成功  非0：失败
     */
    public int setPlayerMixerCompValue(int value){
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setPlayerMixerCompValue: value=%d", value);
        ThunderAPI.sharedInstance().setPlayerMixerCompValue(value);
        return  0;
    }


    /**
     * 设置是否外放
     *
     * @param enabled
     * @return
     */
    public int enableLoudspeaker(boolean enabled) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLoudspeaker: %b", enabled);

        ThunderAPI.sharedInstance().getPlayer().enableLoudSpeaker(enabled);
        return 0;
    }

    /**
     * 是否是扬声器状态
     *
     * @return
     */
    public boolean isLoudspeakerEnabled() {
        return ThunderAPI.sharedInstance().getPlayer().getLoudSpeakerEnabled();
    }

    /**
     * 打开用户音量回调
     *
     * @param interval    <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth      平滑系数，未实现
     * @return
     */
    public int setAudioVolumeIndication(int interval,
                                        int moreThanThd,
                                        int lessThanThd,
                                        int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setAudioVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        ThunderAPI.sharedInstance().setPlayVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    /**
     * 打开采集音量回调
     *
     * @param interval    <=0: 禁用音量提示功能 >0: 回调间隔，单位为毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth      未实现
     * @return
     */
    public int enableCaptureVolumeIndication(int interval,
                                             int moreThanThd,
                                             int lessThanThd,
                                             int smooth) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableCaptureVolumeIndication: interval=%d," +
                "moreThanThd=%d, lessThanThd=%d, smooth=%d", interval, moreThanThd, lessThanThd, smooth);

        ThunderAPI.sharedInstance().setCaptureVolumeInterval(interval, moreThanThd, lessThanThd);
        return 0;
    }

    /**
     * 开始将音频数据保存成aac格式的文件
     *
     * @param fileName  文件保存路径,必须是完整路径，包括文件名，文件名的后缀必须是.aac。其中保存文件的文件夹必须是已经创建好的，该接口不提供创建文件夹的功能。例如：/sdcard/helloworld.aac
     * @param saverMode =ThunderRtcConstant.AudioSaverMode.
     *                  THUNDER_AUDIO_SAVER_ONLY_CAPTURE = 只保存频道内所有的上行的音频数据。上行的音频数据指的是：无论是主播的音频数据还是是伴奏的音频数据，只有被设置成上行，才被保存
     *                  THUNDER_AUDIO_SAVER_ONLY_RENDER = 保存频道内除主播以外的音频数据，例如：伴奏的音频数据和观众端的音频数据
     *                  THUNDER_AUDIO_SAVER_BOTH = 保存频道内所有的音频数据
     * @param fileMode  = ThunderRtcConstant.AudioSaverWfMode.
     *                  THUNDER_AUDIO_SAVER_FILE_APPEND = 追加打开一个文本文件，并在文件末尾写数据
     *                  THUNDER_AUDIO_SAVER_FILE_OVERRIDE = 打开一个文本文件，写入的数据会覆盖文件本身的内容
     * @return true:成功 false:失败
     */
    public boolean startAudioSaver(String fileName, int saverMode, int fileMode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startAudioSaver: fileName=%s," +
                "saverMode=%d, fileMode=%d", getPrintString(fileName), saverMode, fileMode);

        if (fileName.isEmpty()) {
            return false;
        }
        return ThunderAPI.sharedInstance().startAudioSaver(fileName, saverMode, fileMode);
    }

    /**
     * 停止将音频数据保存成aac格式的文件
     *
     * @return true:成功 false:失败
     */
    public boolean stopAudioSaver() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopAudioSaver");

        return ThunderAPI.sharedInstance().stopAudioSaver();
    }

    /**
     * 设置不同的音效模式
     *
     * @param mode =ThunderRtcConstant.SoundEffectMode.
     *             THUNDER_SOUND_EFFECT_MODE_NONE               = 关闭模式
     *             THUNDER_SOUND_EFFECT_MODE_VALLEY             = VALLEY模式
     *             THUNDER_SOUND_EFFECT_MODE_RANDB              = R&B模式
     *             THUNDER_SOUND_EFFECT_MODE_KTV                = KTV模式
     *             THUNDER_SOUND_EFFECT_MODE_CHARMING           = CHARMING模式
     *             THUNDER_SOUND_EFFECT_MODE_POP                = 流行模式
     *             THUNDER_SOUND_EFFECT_MODE_HIPHOP             = 嘻哈模式
     *             THUNDER_SOUND_EFFECT_MODE_ROCK               = 摇滚模式
     *             THUNDER_SOUND_EFFECT_MODE_CONCERT            = 演唱会模式
     *             THUNDER_SOUND_EFFECT_MODE_STUDIO             = 录音棚模式
     */
    public void setSoundEffect(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setSoundEffect %d", mode);

        ThunderAPI.sharedInstance().getPublisher().setSoundEffect(mode);
    }

    /**
     * 设置变声模式
     *
     * @param mode =ThunderRtcConstant.VoiceChangerMode.
     *             THUNDER_VOICE_CHANGER_NONE                = 关闭模式
     *             THUNDER_VOICE_CHANGER_ETHEREAL            = 空灵
     *             THUNDER_VOICE_CHANGER_THRILLER            = 惊悚
     *             THUNDER_VOICE_CHANGER_LUBAN               = 鲁班
     *             THUNDER_VOICE_CHANGER_LORIE               = 萝莉
     *             THUNDER_VOICE_CHANGER_UNCLE               = 大叔
     *             THUNDER_VOICE_CHANGER_DIEFAT              = 死肥仔
     *             THUNDER_VOICE_CHANGER_BADBOY              = 熊孩子
     *             THUNDER_VOICE_CHANGER_WRACRAFT            = 魔兽农民
     *             THUNDER_VOICE_CHANGER_HEAVYMETAL          = 重金属
     *             THUNDER_VOICE_CHANGER_COLD                = 感冒
     *             THUNDER_VOICE_CHANGER_HEAVYMECHINERY      = 重机械
     *             THUNDER_VOICE_CHANGER_TRAPPEDBEAST        = 困兽
     *             THUNDER_VOICE_CHANGER_POWERCURRENT        = 强电流
     */
    public void setVoiceChanger(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "ThunderEngine::setVoiceChanger %d", mode);
        ThunderAPI.sharedInstance().getPublisher().setVoiceChanger(mode);
    }

    /**
     * 是否静音自己
     *
     * @param stop
     * @return
     */
    public int stopLocalAudioStream(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "stopLocalAudioStream: %b isThunder:%b", stop, isThunder);

        if (isThunder) {
            int volume = 80;
            if (stop) {
                volume = 0;
            }
            ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        } else {
            //Todo isJoinroom
            if (stop) {
                if (mBAudioPublish) {
                    ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(false);
                    mBAudioPublish = false;
                }
            } else {
                if (!mBAudioPublish && isJoinRoom) {
                    ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(true);
                    if (accompanyType >= 0) {
                        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(accompanyType);
                    }

                    mBAudioPublish = true;
                }
            }
        }

        return 0;
    }

    /**
     * 是否静音所有播放声音
     *
     * @param stop
     * @return
     */
    public int stopAllRemoteAudioStreams(boolean stop) {

        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "stopAllRemoteAudioStreams: %b isThunder:%b isEnableAudio:%b isJoinRoom:%b", stop, isThunder,
                isEnableAudio, isJoinRoom);

        if (isThunder || mTbSubscribeGroup) {
            ThunderAPI.sharedInstance().getPlayer().enableAllMute(stop);
        }

        if (!isThunder) {

            //isStopAllAudio变量影响点全部在于thunderbolt中
            //该逻辑不应该影响thunder或则群组订阅时的功能 否则会导致thunder原有的stopAll总播放开播失效。
            //if (isStopAllAudio == stop) {
            //    return 0;
            //}

            isStopAllAudio = stop;

            //isEnableAudio 不会影响到thunder中的逻辑
            //所以isEnableAudio变量在该接口中，只能在thunderbolt的条件下才能有作用
            if (!isEnableAudio) {
                return -2;
            }

            uidMuteAudioList.clear();

            if (stop) {
                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if (!oneStream.bVideo) {
                            stopStreams.add(oneStream);
                        }
                    }
                    for (ThunderStream oneStream : stopStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }
                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : wholeStreams) {
                        boolean isPlaying = false;
                        if (!oneStream.bVideo) {
                            for (ThunderStream anStream : anchorStreams) {
                                if (anStream.speakerUid == oneStream.speakerUid && !anStream.bVideo) {
                                    isPlaying = true;
                                    break;
                                }
                            }
                            if (isPlaying) {
                                continue;
                            }

                            startStreams.add(oneStream);
                            anchorStreams.add(oneStream);
                        }
                    }
                }
                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    /**
     * 是否静音某个用户的声音
     *
     * @param uid
     * @param stop
     * @return
     */
    public int stopRemoteAudioStream(String uid, boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "stopRemoteAudioStream: uid=%s, %b isThunder:%b isEnableAudio:%b isJoinRoom:%b", getPrintString(uid),
                stop, isThunder, isEnableAudio, isJoinRoom);

        if (isThunder || mTbSubscribeGroup) {
            ThunderStream stream = new ThunderStream();
            stream.speakerUid = UidMap.getLongUid(uid);
            if (!mIs32bitUid) {
                if (uid == null) {
                    return -2;
                }

                ThunderAPI.sharedInstance().getPlayer().enableMute(stop, uid);

                if (stream.speakerUid == 0) {
                    return 0;
                }
            }
            ThunderAPI.sharedInstance().getPlayer().enableMute(stop, stream);
        }

        if (!isThunder) {
            if (!isEnableAudio) {
                return -2;
            }

            uidMuteAudioList.put(uid, stop);

            long lUid = UidMap.getLongUid(uid);
            if (stop) {
                ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
                synchronized (streamLock) {
                    for (ThunderStream oneStream : anchorStreams) {
                        if ((lUid == oneStream.speakerUid) && !oneStream.bVideo) {
                            stopStreams.add(oneStream);
                        }
                    }
                    for (ThunderStream oneStream : stopStreams) {
                        anchorStreams.remove(oneStream);
                    }
                }

                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
                }
            } else {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                ThunderStream newStream = null;
                boolean alreadyPlay = false;

                synchronized (streamLock) {
                    for (ThunderStream oneStream : wholeStreams) {
                        if ((lUid == oneStream.speakerUid) && !oneStream.bVideo) {
                            newStream = oneStream;
                            break;
                        }
                    }

                    if (newStream == null) {
                        return 0;
                    }

                    for (ThunderStream oneStream : anchorStreams) {
                        if ((lUid == oneStream.speakerUid) && !oneStream.bVideo) {
                            alreadyPlay = true;
                            break;
                        }
                    }

                    if (!alreadyPlay) {
                        startStreams.add(newStream);
                        anchorStreams.add(newStream);
                    }
                }

                if (isJoinRoom) {
                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                }
            }
        }
        return 0;
    }

    /**
     * 该方法设定外放(扬声器)音量。
     *
     * @param volume
     * @return
     */
    public int setLoudSpeakerVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setSpeakerphoneVolume: %d", volume);

        boolean bResult = ThunderAPI.sharedInstance().getPlayer().setSpeakerVolume(volume);
        if (bResult) {
            return 0;
        } else {
            return -1;
        }
    }

    /**
     * 设置麦克风音量
     *
     * @param volume
     * @return
     */
    public int setMicVolume(int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setMicVolume: %d", volume);

        boolean bResult = ThunderAPI.sharedInstance().getPublisher().setMicVolume(volume);
        if (bResult) {
            return 0;
        } else {
            return -1;
        }
    }

    /**
     * @param uid
     * @param volume
     * @return
     */
    public int setRemoteAudioStreamsVolume(String uid, int volume) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteAudioStreamsVolume: uid=%s, volume=%d",
                getPrintString(uid), volume);

        if (isThunder) {
            if (!mBGroupSubscribe) {
                return -1;
            }
        }

        ThunderStream stream = new ThunderStream();
        stream.speakerUid = UidMap.getLongUid(uid);
        if (!mIs32bitUid) {
            if (stream.speakerUid == 0) {
                return -2;
            }
        }
        if (ThunderAPI.sharedInstance().getPlayer().setPlayVolume(volume, stream)) {
            return 0;
        }
        return -4;

    }

    /**
     * 设置远端用户声音的空间位置和音量
     *
     * @param uid     远端uid
     * @param azimuth 设置远端用户声音出现的位置，取值范围[-90,90]， 0：（默认）声音出现在正前方, -90：声音出现在左边, 90：声音出现在右边
     * @param gain    设置远端用户声音的音量，取值范围[0,100], 默认值为 100.0，表示该用户的原始音量。取值越小，则音量越低
     * @return 成功or失败
     */
    public int setRemoteUidVoicePosition(String uid, int azimuth, int gain) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setRemoteUidVoicePosition: uid=%s, azimuth=%d, gain=%d",
                getPrintString(uid), azimuth, gain);

        if (isThunder) {
            if (!mBGroupSubscribe) {
                return -1;
            }
        }

        ThunderStream stream = new ThunderStream();
        stream.speakerUid = UidMap.getLongUid(uid);
        if (!mIs32bitUid) {
            if (stream.speakerUid == 0) {
                return -2;
            }
        }
        if (ThunderAPI.sharedInstance().getPlayer().setRemoteUidVoicePosition(azimuth, gain, stream)) {
            return 0;
        }
        return -4;

    }

    /**
     * 创建文件播放对象
     *
     * @return 播放器对象
     */
    public ThunderAudioFilePlayer createAudioFilePlayer() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "createAudioFilePlayer");

        ThunderAudioFilePlayer audioFilePlayer = new ThunderAudioFilePlayer();
        mAudioFilePlayerSet.add(audioFilePlayer);
        return audioFilePlayer;
    }

    /**
     * 销毁文件播放对象
     *
     * @param audioFilePlayer
     */
    public void destroyAudioFilePlayer(ThunderAudioFilePlayer audioFilePlayer) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "destroyAudioFilePlayer: %s", getPrintString(audioFilePlayer));

        if (audioFilePlayer == null) {
            return;
        }
        audioFilePlayer.destroyAudioFilePlayer();
        mAudioFilePlayerSet.remove(audioFilePlayer);
    }

    /**
     * 使能均衡器
     *
     * @param enabled
     * @return
     */
    public int setEnableEqualizer(boolean enabled) {
        mBEnableEqualizer = enabled;

        ThunderAPI.sharedInstance().getPublisher().EnableEqualizer(enabled);
        return 0;
    }

    /**
     * 设置均衡器参数
     *
     * @param gains -12 <= gains[i] <= 12, 0<=i<=10
     * @return
     */
    public int setEqGains(final int[] gains) {
        if (gains == null) {
            return -1;
        }

        if (gains.length < 11) {
            return -2;
        }

        for (int i = 0; i <= 10; ++i) {
            if (gains[i] < -12 || gains[i] > 12) {
                return -3;
            }
        }

        mEqGains = gains;
        ThunderAPI.sharedInstance().getPublisher().SetGqGains(gains);
        return 0;
    }

    /**
     * 使能混响
     *
     * @param enabled
     * @return
     */
    public int setEnableReverb(boolean enabled) {
        mBEnableReverbEx = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableReverb(enabled);
        return 0;
    }

    /**
     * 设置混响参数
     *
     * @param param
     * @return
     * @see ReverbExParameter
     */
    public int setReverbExParameter(ReverbExParameter param) {
        if (param == null) {
            return -1;
        }

        if ((param.mRoomSize < 0.0 || param.mRoomSize > 100.0) ||
                (param.mPreDelay < 0.0 || param.mPreDelay > 200.0) ||
                (param.mReverberance < 0.0 || param.mReverberance > 100.0) ||
                (param.mHfDamping < 0.0 || param.mHfDamping > 100.0) ||
                (param.mToneLow < 0.0 || param.mToneLow > 100.0) ||
                (param.mToneHigh < 0.0 || param.mToneHigh > 100.0) ||
                (param.mWetGain < -20.0 || param.mWetGain > 10.0) ||
                (param.mDryGain < -20.0 || param.mDryGain > 10.0) ||
                (param.mStereoWidth < 0.0 || param.mStereoWidth > 100.0)
                ) {
            return -2;
        }

        mReverbExGains = param;
        ThunderAPI.sharedInstance().getPublisher().setReverbExParameter(
                param.mRoomSize,
                param.mPreDelay,
                param.mReverberance,
                param.mHfDamping,
                param.mToneLow,
                param.mToneHigh,
                param.mWetGain,
                param.mDryGain,
                param.mStereoWidth);
        return 0;
    }

    /**
     * 使能压缩器
     *
     * @param enabled
     * @return
     */
    public int setEnableCompressor(boolean enabled) {
        mBEnableCompressor = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableCompressor(enabled);
        return 0;
    }

    /**
     * 设置压缩器参数
     *
     * @param param
     * @return
     * @see CompressorParam
     */
    public int setCompressorParam(CompressorParam param) {
        if (param == null) {
            return -1;
        }

        if ((param.mThreshold < -40 || param.mThreshold > 0) ||
                (param.mReleaseTime <= 0) || (param.mAttackTime <= 0)) {
            return -2;
        }

        mCompressorGains = param;
        ThunderAPI.sharedInstance().getPublisher().SetCompressorParam(
                param.mThreshold,
                param.mMakeupGain,
                param.mRatio,
                param.mKnee,
                param.mReleaseTime,
                param.mAttackTime);
        return 0;
    }

    /**
     * 使能压限器
     *
     * @param enabled
     * @return
     */
    public int setEnableLimiter(boolean enabled) {
        mBEnableLimiter = enabled;
        ThunderAPI.sharedInstance().getPublisher().EnableLimiter(enabled);
        return 0;
    }

    /**
     * 设置压限器参数
     *
     * @param param
     * @return
     * @see LimterParam
     */
    public int setLimiterParam(LimterParam param) {
        if (param == null) {
            return -1;
        }

        mLimiterGins = param;
        ThunderAPI.sharedInstance().getPublisher().SetLimiterParam(
                param.fCeiling,
                param.fThreshold,
                param.fPreGain,
                param.fRelease,
                param.fAttack,
                param.fLookahead,
                param.fLookaheadRatio,
                param.fRMS,
                param.fStLink);
        return 0;
    }

    /**
     * 设置外部音频处理器
     *
     * @param eap, eap是个C 函数指针数组，长度为6，每个函数的类型为：
     *             typedef void (*OnCaptureStartFun)(void*obj);
     *             typedef void (*OnCaptureDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnCaptureStopFun)(void*obj);
     *             typedef void (*OnRenderStartFun)(void*obj);
     *             typedef void (*OnRenderDataFun)(void*obj, void* pData, uint32_t len, uint32_t sampleRate, uint32_t channelCount, uint32_t bitPerSample);
     *             typedef void (*OnRenderStopFun)(void*obj);
     */
    public void setExternalAudioProcessor(long eap) {
        ThunderAPI.sharedInstance().setExternalAudioProcessor(eap);
    }

    /**
     * 打开关闭音频播放频谱数据回调
     * 如果打开了，会收到{@link ThunderEventHandler#onAudioPlaySpectrumData} 回调
     */
    public void enableAudioPlaySpectrum(boolean enable) {
        ThunderAPI.sharedInstance().enableAudioPlaySpectrum(enable);
    }

    /**
     * 设置音频播放频谱数据回调信息
     *
     * @param spectrumLen      频谱数据的长度 [12 - 256]，默认是256
     * @param notifyIntervalMS 频谱回调的间隔，必须是10的倍数，默认是30MS
     */
    public void setAudioPlaySpectrumInfo(int spectrumLen, int notifyIntervalMS) {
        ThunderAPI.sharedInstance().setAudioPlaySpectrumInfo(spectrumLen, notifyIntervalMS);
    }

    /**
     * 用户发送透传消息
     *
     * @param msgData 发送的消息
     *                <br> 调用此接口条件:
     *                1、用户在频道内
     *                2、开麦成功后调用(纯观众和开播鉴权失败都不能发)
     *                3、调用该接口的频率每秒不能超过2次,msgData的大小不能超过200Byte
     *                <br> 不满足以上条件msg都会被丢弃
     *                <br> 通过监听ThunderEventHandler中的onRecvUserAppMsgData接收其他透传的消息
     *                <br> 通过监听ThunderEventHandler中的onSendAppMsgDataFailedStatus获得发送该msg发送失败的原因
     */
    public int sendUserAppMsgData(byte[] msgData) {
        ThunderAPI.sharedInstance().sendUserAppMsgData(msgData);
        return 0;
    }

    /**
     * 发送媒体次要信息（目前仅支持用音频通道发送次要信息，后期如果要同时支持视频通道发送次要信息，
     * 当有视频上行的时候就只用视频通道发送，否则用音频通道）
     *
     * @param data    媒体次要信息
     * @param dataLen 次要信息长度
     *                <br> 调用此接口条件:
     *                1、必须进入房间，音频开播成功之后调用
     *                2、调用频率最快为100ms一次
     *                3、媒体次要信息大小不超过200字节
     *                4、可能存在丢失情况
     *                <br> 通过监听IThunderMediaExtraInfoCallback中的onRecvMediaExtraInfo接收其他透传的数据
     *                <br> 通过监听ThunderEventHandler中的onSendMediaExtraInfoFailedStatus获得发送信息失败的原因
     * @return 0=成功，-1=data为空，-2=data长度不正确；更详细的错误可通过onSendMediaExtraInfoFailedStatus获取
     */
    public int sendMediaExtraInfo(java.nio.ByteBuffer data, int dataLen) {
        if (data == null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "sendMediaExtraInfo: data is null");
            return -1;
        }
        if (data.remaining() < dataLen) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "sendMediaExtraInfo: dataLen large than data.remaining()");
            return -2;
        }

        byte[] extraInfo = new byte[dataLen];
        data.get(extraInfo, 0, extraInfo.length);
        ThunderNative.sendAudioExtraInfo(extraInfo);
        return 0;
    }

    /**
     * 设置媒体次要信息的回调监听
     *
     * @param callback 实现了IThunderMediaExtraInfoCallback接口的对象实例
     * @return 成功返回0，失败返回<0
     * 当不需要接收次要信息时，调用setMediaExtraInfoCallback(null)去除回调监听
     */
    public int setMediaExtraInfoCallback(IThunderMediaExtraInfoCallback callback) {
        mThunderMediaExtraInfoCallback = callback;
        return 0;
    }

    /**
     * 打开关闭音频数据回调
     *
     * @param enablePlay 打开播放数据回调
     */
    public void enableAudioDataIndication(boolean enablePlay) {
        mBEnablePlayDataIndication = enablePlay;

        ThunderAPI.sharedInstance().enableAudioDataIndication(enablePlay);
    }

    /**
     * 打开关闭音频采集回调
     *
     * @param enable     打开采集数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param channel    设置需要回调数据的声道数，取值范围[-1,1,2]
     *                   <br> 只要sampleRate和channel其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public void enableCapturePcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderAPI.sharedInstance().enableCapturePcmDataCallBack(enable, sampleRate, channel);
    }

    /**
     * 打开关闭渲染音频数据回调
     *
     * @param enable     打开渲染音频数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param channel    设置需要回调数据的声道数，取值范围[-1,1,2]
     *                   <br> 只要sampleRate和channel其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     */
    public boolean enableRenderPcmDataCallBack(boolean enable, int sampleRate, int channel) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "enableRenderPcmDataCallBack enable = %b sampleRate: %d, channel = %d ", enable, sampleRate, channel);

        return ThunderAPI.sharedInstance().enableRenderPcmDataCallBack(enable, sampleRate, channel);

    }

    /**
     * 是否将当前播放的文件作为直播伴奏使用(可替代enablePublish)
     * <br>
     *
     * @param sourceType {@link ThunderRtcConstant.SourceType }
     *                   THUNDER_PUBLISH_MODE_MIC   = 0; //麦克风
     *                   THUNDER_PUBLISH_MODE_FILE  = 1; //文件
     *                   THUNDER_PUBLISH_MODE_MIX   = 2; //文件+麦克风
     *                   THUNDER_PUBLISH_MODE_NONE  = 10, //停止所有音频数据上行
     */
    public void setAudioSourceType(int sourceType) {
        ThunderLog.release(ThunderLog.kLogTagCall, "setAudioSourceType: mode=%d", sourceType);

        ThunderAPI.sharedInstance().getPublisher().setAudioSourceType(sourceType);

        accompanyType = sourceType;
    }

    /**
     * 打开关闭耳返
     *
     * @param enable true=打开，false=关闭；默认为关闭状态
     * @return
     */
    public int setEnableInEarMonitor(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagCall, "setEnableInEarMonitor: %b", enable);

        if (ThunderAPI.sharedInstance().getPublisher().enableInEarMonitor(enable)) {
            return 0;
        } else {
            return -1;
        }
    }

    public Object CreateRendererView(Context context, int type) {
        Object view = null;
        if (BuildConfig.__YY_VIDEO_SUPPORT__) {
            switch (type) {
                case ThunderVideoViewType.THUNDERVIDEO_VIEW_PLAYVIEW:
                    view = new ThunderPlayerView(context);
                    break;
                case ThunderVideoViewType.THUNDERVIDEO_VIEW_PREVIEW:
                    view = new ThunderPreviewView(context);
                    break;
            }
        }
        return view;
    }

    /**
     * joinroom之前调用：设置视频开，不触发任何实际操作；
     * joinroom之后调用：前置条件满足的情况下，开播视频；
     */
    public int enableVideoEngine() {

        if (isThunder) {
            return -2;
        }

        isEnableVideo = true;

//        if(isEnableVideo) {
//            return -1;
//        }

        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableVideoEngine " + "," + isOtherSource);

//        //Todo judge start preview
//        if(localCanvas != null) {
//            startVideoPreview();
//        }

        // 重新订阅视频流,大小流需要调用tryStartSubscribe处理
        if (isJoinRoom) {
            synchronized (streamLock) {
                ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
                for (ThunderStream stream : wholeStreams) {
                    if (stream.bVideo) {
                        boolean isMute = isMuteVideoStreamWithUid(stream.speakerUid);
                        if (!isMute) {
                            // 订阅前需要重新绑定 YRVideoCanvas（如果之前有设置的话）
                            for (ThunderVideoCanvas canvas : remoteCanvas) {
                                if ((UidMap.getLongUid(canvas.mUid) == stream.speakerUid)) {
                                    stream.toView = canvas.mView;
                                    stream.scaleMode = canvas.mRenderMode;
                                }
                            }
                            startStreams.add(stream);
                            // 暂时不更新用户整体订阅的信息，大小流场景一个用户有多个视频，先在tryStartSubscribe过滤
                            //anchorStreams.add(stream);
                        }
                    }
                }
                if (startStreams.size() > 0) {
                    tryStartSubscribe(startStreams);
                }
            }
        }


        if (isJoinRoom && (isPreview || isOtherSource) && !mBVideoPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(true);
            mBVideoPublish = true;
        }

        return 0;
    }

    /**
     * 流程1：
     * joinRoom：加入频道，自动订阅频道内的视频流；
     * disableVideoEngine：退订频道内的视频流；如果打开预览，则关闭预览；
     * 流程2：
     * joinRoom：加入频道，自动订阅频道内的视频流；
     * enableVideoEngine：（参见enableVideo）
     * disableVideoEngine：退订频道内的视频流；如果打开预览，则关闭预览；如果已开播，则停播；
     */
    public int disableVideoEngine() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "disableVideoEngine ");
        if (!isEnableVideo || isThunder) {
            return -1;
        }

        tryStopVideoSubscribe();
        tryStopVideoPublish();

        //恢复摄像头，镜像，前后置摄像头默认值

        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        if (camera != null) {
            ThunderPreviewConfig config = (ThunderPreviewConfig) camera.getCaptureConfig();

            config.cameraPosition = ThunderCameraPosition.THUNDERCAMERA_POSITION_FRONT;
            config.captureOrientation = ThunderVideoCaptureOrientation.THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT;
        }

        if (isPreview) {
            setLocalVideoMirrorMode(ThunderVideoMirrorMode.THUNDER_VIDEO_MIRROR_MODE_PREVIEW_MIRROR_PUBLISH_NO_MIRROR);
        }

        // 重置水印，避免下次启动视频时还有水印
        setVideoWatermark(null);

        ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(
                ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());

        tryStopVideoPreview();

        mLocalPreviewView = null;
        isEnableVideo = false;
        isOtherSource = false;

        return 0;
    }

    /**
     * 根据参数从Argo获取视频开播参数；
     * 如果已经预览，则在预览中生效；
     * 如果已经开播，则更新开播参数，本地预览和远端订阅会看到变化后的效果；
     */
    public int setVideoEncoderConfig(ThunderVideoEncoderConfiguration yyVideoConfig) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "setVideoEncoderConfig ");
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        int result = 0;
        if (yyVideoConfig != null) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "setVideoEncoderConfig playtype:"
                    + yyVideoConfig.playType
                    + " publishmode:"
                    + yyVideoConfig.publishMode
                    + " isEnableVideo:" + isEnableVideo);

            if (isEnableVideo && !isThunder) {
                result = ThunderAPI.sharedInstance().getPublishRoom().updatePlayTypeAndPublishMode(
                    yyVideoConfig.playType,
                    yyVideoConfig.publishMode);

                if (result == 0) {
                    mThunderVideoEncoderConfiguration = yyVideoConfig;
                }
            } else {
                result = -3;
            }
        } else {
            result = -2;
        }

        ThunderLog.error(ThunderLog.kLogTagRtcEngine, "setVideoEncoderConfig result=%d", result);
        return result;
    }

    /**
     * 功能：设置本地视图，即预览的窗口；
     */
    public int setLocalVideoCanvas(ThunderVideoCanvas local) {
        if (isEnableVideo && !isThunder) {
            if (local != null && local.mView != null) {
                if (isPreview) {
                    ThunderAPI.sharedInstance().getPublishRoom().setLocalVideoView((ThunderPreviewView) local.mView);
                }
                mLocalPreviewView = (ThunderPreviewView) local.mView;
                ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                        "setLocalVideoCanvas view:" + local.mView + " isEnableVideo:" + isEnableVideo);
            }
        } else {
            ThunderLog.error(ThunderLog.kLogTagRtcEngine,
                    "setLocalVideoCanvas local is %s", (local == null) ? "null" : "not null");
        }
        return 0;
    }

    /**
     * 功能：设置远端用户视图
     * 不设置此窗口，也可以订阅；
     * 设置此窗口，则可以看到远端订阅的对应uid的流的画面；
     */
    public int setRemoteVideoCanvas(ThunderVideoCanvas remote) {
        int result = 0;
        if (!isEnableVideo || isThunder) {
            result = -2;
        }

        if (remote == null) {
            result = -1;
        }

        if (result < 0) {
            ThunderLog.error(ThunderLog.kLogTagRtcEngine, "setRemoteVideoCanvas fail reason:%d",
                    result);
            return result;
        }

        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "setRemoteVideoCanvas view:" + remote.mView + "uid:" + remote.mUid + " isEnableVideo:" + isEnableVideo);

        boolean isFind = false;
        ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);

        if (remote.mView != null) {
            synchronized (streamLock) {
                //first check view &
                for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                    if (oneCanvas.mView == remote.mView) {
                        // 如果设置的视图已经在remoteCanvas中，但是之前绑定了的uid不一样，先修改之前的绑定
                        if (!oneCanvas.mUid.equals(remote.mUid)) {
                            Long lUid = UidMap.getLongUid(oneCanvas.mUid);
                            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);

                            for (ThunderStream oneStream : anchorStreams) {
                                if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                                    oneStream.toView = null;
                                    oneStream.scaleMode = 1;
                                    stopStreams.add(oneStream);

                                    ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams,null);
                                    ThunderAPI.sharedInstance().getPlayer().startPlayStreams(stopStreams, null);
                                    /*
                                    * 大小流场景同一个uid存在多个视频流，有可能当前处于大小流切换的过渡存在同事拉同一个uid多条流
                                    * 所以不能找到一个就break
                                    * */
                                    //break;
                                }
                            }

                            for (ThunderStream oneStream : wholeStreams) {
                                if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                                    oneStream.toView = null;
                                    oneStream.scaleMode = 1;
                                    //break;
                                }
                            }
                        }

                        isFind = true;
                        oneCanvas.mUid = remote.mUid;
                        oneCanvas.mRenderMode = remote.mRenderMode;
                        break;
                    } else {
                        if (oneCanvas.mUid.equals(remote.mUid)) {
                            // uid相等时需要判断view是否有更新，有更新的情况下需要修改remoteCanvas
                            isFind = true;
                            oneCanvas.mView = remote.mView;
                            oneCanvas.mRenderMode = remote.mRenderMode;
                        }
                    }
                }

                if (!isFind) {
                    remoteCanvas.add(remote);
                }

                Long lUid = UidMap.getLongUid(remote.mUid);
                for (ThunderStream oneStream : anchorStreams) {
                    if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                        // 如果设置的视图绑定的uid已经开播，不需要重新开播
                        if (oneStream.toView != remote.mView) {
                            oneStream.toView = remote.mView;
                            oneStream.scaleMode = remote.mRenderMode;
                            startStreams.add(oneStream);
                        }
                        //break;
                    }
                }

                if (startStreams.size() > 0) {
                    // 在设置预览视图前调用了切换了大小流接口 changeRemoteVideoStreamType
                    long highLowStreamUid = ThunderAPI.sharedInstance().getPlayer().getHighLowStreamUid();
                    if (ThunderAPI.sharedInstance().getPlayer().isNeedHighLowStreamChange() && lUid == highLowStreamUid) {
                        ArrayList<ThunderStream> targetStartStreams = new ArrayList<ThunderStream>(0);
                        for (ThunderStream onStream:startStreams) {
                            if (onStream.dualVideoStreamType == mSubscribeRemoteUidToVideoType.get(onStream.strUid)) {
                                targetStartStreams.add(onStream);
                            } else {
                                anchorStreams.remove(onStream);
                            }
                        }
                        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(targetStartStreams, null);
                        ThunderAPI.sharedInstance().getPlayer().clearHighLowStream();

                    } else {
                        ThunderAPI.sharedInstance().getPlayer().startPlayStreams(startStreams, null);
                    }

                    startStreams.clear();
                }

                for (ThunderStream oneStream : wholeStreams) {
                    if (oneStream.bVideo && (lUid == oneStream.speakerUid)) {
                        oneStream.toView = remote.mView;
                        oneStream.scaleMode = remote.mRenderMode;
                        //break;
                    }
                }
            }
        }
        return result;
    }

    /**
     * 设置本地视图显示模式
     * THUNDER_RENDER_MODE_FILL(0)：铺满窗口，如果比例不适应的，会拉伸以铺满窗口；
     * THUNDER_RENDER_MODE_ASPECT_FIT(1)：适应窗口，如果比例不适应，会留黑边；
     * THUNDER_RENDER_MODE_CLIP_TO_BOUNDS(2)：铺满窗口，如果比例不适应，会截取;
     */
    public int setLocalCanvasScaleMode(int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "setLocalCanvasScaleMode mode:" + mode + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        ThunderAPI.sharedInstance().setPreviewRenderMode(mode);
        return 0;
    }

    /**
     * 设置远端视图显示模式
     * THUNDER_RENDER_MODE_FILL(0)：铺满窗口，如果比例不适应的，会拉伸以铺满窗口；
     * THUNDER_RENDER_MODE_ASPECT_FIT(1)：适应窗口，如果比例不适应，会留黑边；
     * THUNDER_RENDER_MODE_CLIP_TO_BOUNDS(2)：铺满窗口，如果比例不适应，会截取;
     */
    public int setRemoteCanvasScaleMode(String uid, int mode) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "setRemoteCanvasScaleMode Uid:" + uid + " mode:" + mode + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        synchronized (streamLock) {
            for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                if (uid.equals(oneCanvas.mUid)) {
                    ThunderPlayerView remote = (ThunderPlayerView) oneCanvas.mView;
                    oneCanvas.mRenderMode = mode;
//                remote.setScaleMode(mode);
                    ThunderNative.setPlayViewScaleMode(remote, mode);
                }
            }
        }

        return 0;
    }

    /**
     * 开启视频预览
     *
     * @return
     */
    public int startVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "startVideoPreview " + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder || isStopLocalVideo) {
            return -2;
        }

        if (isPreview && !mBOnlyReleaseCamera) {
            return 0;
        }

        if (mBVideoPublish && !isOtherSource && mBOnlyReleaseCamera) {
            ThunderNative.stopAndRecoverVideoEncode(false);
            mBOnlyReleaseCamera = false;
        } else {
            ThunderAPI.sharedInstance().getPublishRoom().startVideoPreview(
                    mThunderVideoEncoderConfiguration.playType,
                    mThunderVideoEncoderConfiguration.publishMode);
            ThunderAPI.sharedInstance().getPublishRoom().setLocalVideoView(mLocalPreviewView);
        }
        isPreview = true;

        return 0;
    }

    /**
     * 停止视频预览
     *
     * @return
     */
    public int stopVideoPreview() {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "stopVideoPreview " + " isEnableVideo:" + isEnableVideo + " isPreview " + isPreview
                        + " mBVideoPublish " + mBVideoPublish);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        if (isPreview) {

            if (mBVideoPublish && mBOnlyReleaseCamera) {
                ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                        "stopVideoPreview " + " isEnableVideo:" + isEnableVideo + " isPreview " + isPreview
                                + " mBVideoPublish " + mBVideoPublish + " mBOnlyReleaseCamera " + mBOnlyReleaseCamera);
                return 0;
            }

            if (mBVideoPublish && !isOtherSource && !mBOnlyReleaseCamera) {
                ThunderNative.stopAndRecoverVideoEncode(true);
                mBOnlyReleaseCamera = true;
            } else {
                ThunderAPI.sharedInstance().getPublishRoom().stopVideoPreview();
                isPreview = false;
            }
        }

        return 0;
    }

    /**
     * 开关本地视频采集
     *
     * @return
     */
    public int enableLocalVideoCapture(boolean enable) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "enableLocalVideoCapture " + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        if (enable == false) {
            tryStopVideoPublish();
            tryStopVideoPreview();
            isStopLocalVideo = true;
        } else {
            isStopLocalVideo = false;
        }
        return 0;
    }

    /**
     * 开关本地视频发送
     *
     * @return
     */
    public int stopLocalVideoStream(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "stopVideoPreview stopLocalVideoStream:" + stop + " isEnableVideo:" + isEnableVideo + ",isOtherSource" +
                        isOtherSource
                        + " isMuteLocalVideo " + isStopLocalVideo + " isPreview " + isPreview);
        if (!isEnableVideo || isThunder || isStopLocalVideo) {
            return -2;
        }

        if (stop) {
            if (mBVideoPublish) {
                ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(false);

                mBVideoPublish = false;
                mVideoStringName = "";
            }
        } else {
            if (isJoinRoom && !mBVideoPublish && (isPreview || isOtherSource)) {
                ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(true);

                mBVideoPublish = true;
            }

        }
        return 0;
    }

    /**
     * 接收/停止接收指定视频流
     *
     * @return
     */
    public int stopRemoteVideoStream(String uid, boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "stopRemoteVideoStream Uid:" + uid + " stop:" + stop + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        uidMuteVideoList.put(uid, stop);

        long lUid = UidMap.getLongUid(uid);
        if (stop) {
            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
            synchronized (streamLock) {
                for (ThunderStream oneStream : anchorStreams) {
                    if ((lUid == oneStream.speakerUid) && oneStream.bVideo) {
                        stopStreams.add(oneStream);
                    }
                }
                for (ThunderStream oneStream : stopStreams) {
                    anchorStreams.remove(oneStream);
                }
            }

            if (isJoinRoom) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
            ThunderStream newStream = null;
            boolean alreadyPlay = false;

            synchronized (streamLock) {
                for (ThunderStream oneStream : wholeStreams) {
                    if ((lUid == oneStream.speakerUid) && oneStream.bVideo) {
                        newStream = oneStream;
                        break;
                    }
                }
                //可以在进频道前设置
                if (newStream == null) {
                    return 0;
                }

                for (ThunderStream oneStream : anchorStreams) {
                    if ((lUid == oneStream.speakerUid) && oneStream.bVideo) {
                        alreadyPlay = true;
                        break;
                    }
                }

                if (!alreadyPlay) {
                    if (remoteCanvas != null) {
                        for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                            if ((UidMap.getLongUid(oneCanvas.mUid) == newStream.speakerUid)) {
                                newStream.toView = oneCanvas.mView;
                                newStream.scaleMode = oneCanvas.mRenderMode;
                            }
                        }
                    }
                    startStreams.add(newStream);
                    // 暂时不更新用户整体的订阅情况，大小流场景一个uid有多个视频，先在tryStartSubscribe过滤
                    // anchorStreams.add(newStream);
                }
            }

            if (isJoinRoom) {
                tryStartSubscribe(startStreams);
            }
        }

        return 0;
    }

    /**
     * 接收/停止接收所有视频流
     *
     * @return
     */
    public int stopAllRemoteVideoStreams(boolean stop) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "stopAllRemoteVideoStreams  stop:" + stop + " isEnableVideo:" + isEnableVideo);
        if (!isEnableVideo || isThunder) {
            return -2;
        }
        //if (isStopAllVideo == stop) {
        //    return 0;
        //}

        isStopAllVideo = stop;
        uidMuteVideoList.clear();

        if (stop) {
            ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
            synchronized (streamLock) {
                for (ThunderStream oneStream : anchorStreams) {
                    if (oneStream.bVideo) {
                        stopStreams.add(oneStream);
                    }
                }
                for (ThunderStream oneStream : stopStreams) {
                    anchorStreams.remove(oneStream);
                }
            }
            if (isJoinRoom) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }
        } else {
            ArrayList<ThunderStream> startStreams = new ArrayList<ThunderStream>(0);
            synchronized (streamLock) {
                for (ThunderStream oneStream : wholeStreams) {
                    boolean isPlaying = false;
                    if (oneStream.bVideo) {

                        for (ThunderStream anStream : anchorStreams) {
                            if (anStream.speakerUid == oneStream.speakerUid && anStream.bVideo) {
                                isPlaying = true;
                                break;
                            }
                        }
                        if (isPlaying) {
                            continue;
                        }

                        if (remoteCanvas != null) {
                            for (ThunderVideoCanvas oneCanvas : remoteCanvas) {
                                if ((UidMap.getLongUid(oneCanvas.mUid) == oneStream.speakerUid)) {
                                    oneStream.toView = oneCanvas.mView;
                                    oneStream.scaleMode = oneCanvas.mRenderMode;
                                }
                            }
                        }

                        startStreams.add(oneStream);
                        // 先不更新到已经订阅流，大小流场景会有问题，放在tryStartSubscribe做过滤之后再更新
                        //anchorStreams.add(oneStream);
                    }
                }
            }
            if (isJoinRoom) {
                tryStartSubscribe(startStreams);
            }
        }

        return 0;
    }

    private ThunderPlayer.IHighLowStreamChangeObserver highLowStreamChangeObserver = new ThunderPlayer.IHighLowStreamChangeObserver() {
        @Override
        public void onHighLowStreamChangeFinish(String highStreamName, String lowStreamName) {
            ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                    "ThunderEngine onHighLowStreamChangeFinish: highStreamName:" + highStreamName + " lowStreamName:" + lowStreamName);
            onHighLowStreamSwitch(highStreamName, lowStreamName);
        }
    };

    /**
     * 设置默认远端视频流类型
     *
     * @param type 流类型{@link ThunderRtcConstant.ThunderVideoStreamType}，默认使用大流
     * @return 成功返回0，失败返回<0
     */
    public int setDefaultRemoteVideoStreamType(int type)
    {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "ThunderEngine setDefaultRemoteVideoStreamType  type:" + type);

        if (isBoltJoin)
        {
          return -2;
        }
        if (isThunder)
        {
            return -4;
        }

        if (!isEnableVideo)
        {
            return -1;
        }

        int defaultStreamType = 0;
        switch(type)
        {
            case ThunderVideoStreamType.THUNDER_VIDEO_STREAM_TYPE_HIGH: {
                defaultStreamType = 0;
                break;
            }
            case ThunderVideoStreamType.THUNDER_VIDEO_STREAM_TYPE_LOW:
            {
                defaultStreamType = 1;
            }
            default:
                break;
        }
        mDefauleRemoteVideoStreamType = defaultStreamType;
        return 0;
    }

    /**
     * 设置远端视频大小流
     *
     * @param uid 远端用户/主播uid
     * @param type 流类型{@link ThunderRtcConstant.ThunderVideoStreamType}，默认使用大流
     * @return 成功返回0，失败返回<0
     */
    public int changeRemoteVideoStreamType(String uid, int type) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "changeRemoteVideoStreamType: UID:" + uid + " type:" + type);

        // call the function must in channel
        if (!isBoltJoin)
        {
           return -2;
        }

        if (isThunder)
        {
            return -4;
        }

        if (!isEnableVideo)
        {
            return -1;
        }

        if (uid.isEmpty())
        {
            return -3;
        }

        if (type != ThunderVideoStreamType.THUNDER_VIDEO_STREAM_TYPE_LOW &&
            type != ThunderVideoStreamType.THUNDER_VIDEO_STREAM_TYPE_HIGH)  {
            return -3;
        }

//        // 连续调多次同样的切换操作，忽略
//        if (mSubscribeRemoteUidToVideoType.containsKey(uid) && type == mSubscribeRemoteUidToVideoType.get(uid)) {
//            return 0;
//        }

        synchronized (streamLock) {

            // get the stream of this type from anchor streams
            boolean bFindedStream = false;
            ArrayList<ThunderStream> toStreams = new ArrayList<>();
            for (ThunderStream oneStream : wholeStreams) {
                if (oneStream.bVideo && oneStream.dualVideoStreamType == type
                && oneStream.strUid.equals(uid)) {
                    bFindedStream = true;

                    // 订阅前需要重新绑定 YRVideoCanvas（如果之前有设置的话）
                    if(remoteCanvas != null)
                    {
                        for(ThunderVideoCanvas canvas : remoteCanvas)
                        {
                            if ((UidMap.getLongUid(canvas.mUid) == oneStream.speakerUid)) {
                                oneStream.toView = canvas.mView;
                                oneStream.scaleMode = canvas.mRenderMode;
                            }
                        }
                    }
                    toStreams.add(oneStream);
                }
            }

            if (!bFindedStream)
            {
                return -5;
            }

            //record the remove video stream type
            mSubscribeRemoteUidToVideoType.put(uid, type);

            //find another playing video of the same uid
            ArrayList<ThunderStream> fromStreams = new ArrayList<>();
            for (ThunderStream oneStream : anchorStreams)
            {
                if (oneStream.bVideo && oneStream.strUid.equals(uid))
                {
                    //如果已经订阅了同样的流，则忽略
                    if (oneStream.dualVideoStreamType == type)
                    {
                        return 0;
                    }
                    else
                        {
                        fromStreams.add(oneStream);
                    }
                }

            }

            if (toStreams.size() > 0 && fromStreams.size() > 0)
            {
                ThunderAPI.sharedInstance().getPlayer().setHighLowStream(fromStreams, toStreams);
                ThunderAPI.sharedInstance().getPlayer().setHighLowStreamChangeObserver(highLowStreamChangeObserver);
                // 开始订阅
                tryStartSubscribe(toStreams);
                return 0;
            }

            if (fromStreams.size() <= 0 || toStreams.size() <=  0) {
                ThunderLog.error(ThunderLog.kLogTagRtcEngine,
                        " changeRemoteVideoStreamType Error: fromStreams size :"
                                + fromStreams.size() + " toStreams size:" + toStreams.size());
                return -4;
            }
        }

        return -1;
    }

    /**
     * {@link IFaceDetection} 接口对象实例；如果传入 null，则取消注册
     *
     * @param faceDetection 用于设置第三方人脸到sdk，非必须,仅仅用于需要sdk拿到人脸数据
     * @return <0 返回异常 0正常
     */
    public int registerFaceDetection(IFaceDetection faceDetection) {
        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPublisher().setMobileFaceDetection(faceDetection);
            return 0;
        }
        return -2;
    }

    /**
     * {@link IGPUProcess} 接口对象实例；如果传入 null，则取消注册
     *
     * @param observer 用于设置获取处理每一帧video渲染纹理的实例
     * @return <0 返回异常 0正常
     */
    public int registerVideoCaptureTextureObserver(IGPUProcess observer) {
        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPublisher().setVideoCaptureTexture(observer);
            return 0;
        }
        return -2;
    }

    /**
     * {@link IVideoCaptureObserver} 接口对象实例；如果传入 null，则取消注册
     *
     * @param observer 用于设置分别获取video camera yuv采集和video渲染数据的实例
     * @return <0 返回异常 0正常
     */

    public int registerVideoCaptureFrameObserver(IVideoCaptureObserver observer) {

        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPublisher().setVideoCaptureFrame(observer);
            return 0;
        }
        return -2;
    }

    public int registerVideoDecodeFrameObserver(String uid, IVideoDecodeObserver observer) {

        if (isEnableVideo && !isThunder) {
            ThunderAPI.sharedInstance().getPlayer().setVideoFrameObserver(uid, observer);
            return 0;
        }
        return -2;
    }

    /**
     * {@link IAudioFrameObserver} 接口对象实例；如果传入 null，则取消注册
     *
     * @param observer
     * @return
     */
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        return ThunderAPI.sharedInstance().registerAudioFrameObserver(observer);
    }

    /**
     * 设置回调采集数据的格式
     *
     * @param sampleRate     指定 onRecordFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param room           指定 onRecordFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode           指定 onRecordFrame 的使用模式:{@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onRecordFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setRecordingAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {

        return ThunderAPI.sharedInstance().setRecordingAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }

    /**
     * 设置回调播放数据的格式
     *
     * @param sampleRate     指定 onPlaybackFrame 中返回数据的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param room           指定 onPlaybackFrame 中返回数据的通道数，可设置为 1（单声道） 或 2（双声道）
     * @param mode           指定 onPlaybackFrame 的使用模式:{@link ThunderRtcConstant.ThunderAudioRawFrameOperationMode}
     * @param samplesPerCall 指定 onPlaybackFrame 中返回数据的采样点数，如 RTMP 推流应用中通常为 1024。
     * @return
     */
    public int setPlaybackAudioFrameParameters(int sampleRate, int room, int mode, int samplesPerCall) {
        return ThunderAPI.sharedInstance().setPlaybackAudioFrameParameters(sampleRate, room, mode, samplesPerCall);
    }


    ///////////////////

    /**
     * 添加本地视频水印 该方法将一张PNG图片你作为水印添加到本地视频上，通过本地视频一起发布出去
     * 如果待添加的 PNG 图片的尺寸与你该方法中设置的尺寸不一致，SDK 会对 PNG 图片进行裁剪，以与设置相符。
     * 当前只支持在直播视频流中添加一个水印，后添加的水印会替换掉之前添加的水印。
     * 取消设置水印接口传null即可。
     * 屏幕旋转时，水印会跟着画面一起旋转。
     *
     * @param watermark 待添加在本地直播推流中的水印图片，详细定义见{@link ThunderBoltImage}
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int setVideoWatermark(ThunderBoltImage watermark) {
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        Bitmap bitmap = null;
        int x = 0;
        int y = 0;
        if (watermark != null) {
            if (watermark.width == 0 || watermark.height == 0) {
                return -1;
            }
            x = watermark.x;
            y = watermark.y;
            Bitmap tmpBitmap = BitmapFactory.decodeFile(watermark.url);

            int w = tmpBitmap.getWidth();
            int h = tmpBitmap.getHeight();

            Matrix matrix = new Matrix();
            float scaleW = ((float) watermark.width) / w;
            float scaleH = ((float) watermark.height) / h;
            matrix.postScale(scaleW, scaleH);
            bitmap = Bitmap.createBitmap(tmpBitmap, 0, 0, w, h, matrix, true);


        }
        return ThunderAPI.sharedInstance().getPublishRoom().setWatermark(x, y, bitmap);
    }

    /**
     * 设置外部音频采集参数 需要在开播音频前调用该接口 确定外部推流后再开播
     *
     * @param enabled    true：开启外部音频采集  false：关闭外部音频采集（默认）
     * @param sampleRate 外部音频源的采样率，可设置为 8000，16000，32000，44100 或 48000
     * @param channel    外部音频源的通道数（最多支持两个声道)
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int setCustomAudioSource(boolean enabled, int sampleRate, int channel) {

        if (enabled) {
            if (mAudioSource == null) {
                mAudioSource = new ExternalAudioSource(sampleRate, channel);
            }
        } else {
            mAudioSource = null;
        }

        ThunderAPI.sharedInstance().getPublishRoom().attachAudioCapture(mAudioSource);
        return 0;
    }

    /**
     * 推送外部音频帧 需要先调用{@link ExternalAudioSource}
     *
     * @param data      外部音频数据
     * @param timeStamp 外部音频帧的时间戳，用于和外部视频源同步
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int pushCustomAudioFrame(byte[] data, long timeStamp) {

        if (mAudioSource != null) {
            mAudioSource.pushCustomAudioFrame(data, timeStamp);
        } else {
            ThunderLog.info(ThunderLog.kLogTagRtcEngine, "ExternalAudioSource is null");
            return -1;
        }
        return 0;
    }

    /**
     * 设置自定义视频源
     *
     * @param videoSource 自定义视频源 用户需要实现{@link ThunderCustomVideoSource}接口，监听相应的方法，通过onInitialize
     *                    获得外部推流{@link ThunderVideoFrameConsumer}接口对象，然后通过consumeByteArrayFrame方法进行推流
     * @return 0：方法调用成功  < 0：方法调用失败
     */
    public int setCustomVideoSource(ThunderCustomVideoSource videoSource) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine,
                "setCustomVideoSource  isThunder:" + isThunder + " isEnableVideo:" + isEnableVideo +
                        "videoSource == null ?" + (videoSource == null ? true : false));
        if (!isEnableVideo || isThunder) {
            return -2;
        }

        if (videoSource == null) {
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(
                    ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera());

            isOtherSource = false;
        } else if (videoSource instanceof ScreenRecordSource) {
            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(
                    ((ScreenRecordSource) videoSource).mScreenCapture);

            isOtherSource = true;
        } else {
            ExternalVideoSource externalVideoSource = new ExternalVideoSource(videoSource);

            ThunderAPI.sharedInstance().getPublishRoom().attachVideoCapture(externalVideoSource);

            isOtherSource = true;
        }
        return 0;
    }

    /**
     * 添加源流推流地址。该方法每次只能增加一路推流地址。若需推送多路流，则需多次调用该方法。
     * 推流地址不支持中文等特殊字符
     *
     * @param url 推流地址，格式为 RTMP
     * @return 0：添加成功  < 0: 添加用失败
     */
    public int addPublishOriginStreamUrl(String url) {
        if (!mRtmpStatusMap.containsKey(url)) {
            mRtmpStatusMap.put(url, -1);
        }
        return ThunderAPI.sharedInstance().updateSrcStreamUrlSet(true, url);
    }

    /**
     * 删除源流推流地址，该方法每次只能删除一路推流地址。若需删除多路流，则需多次调用该方法
     * 推流地址不支持中文等特殊字符
     *
     * @param url
     * @return 0：删除成功  < 0: 删除失败
     */
    public int removePublishOriginStreamUrl(String url) {
        mRtmpStatusMap.remove(url);
        return ThunderAPI.sharedInstance().updateSrcStreamUrlSet(false, url);
    }

    /**
     * 添加转码流的推流地址，为指定转码任务添加推流地址，该方法每次只能增加一路推流地址，若需推送多路流，则需多次调用该方法
     * 确保在调用 setLiveTransCoding 接口后再调用该接口
     *
     * @param taskId 转码任务id，表示为该taskId的转码任务添加推流地址
     * @param url    推流地址，，格式为 RTMP
     * @return 0：添加成功  < 0: 添加失败
     */
    public int addPublishTranscodingStreamUrl(String taskId, String url) {
        if (!mRtmpStatusMap.containsKey(url)) {
            mRtmpStatusMap.put(url, -1);
        }
        return ThunderAPI.sharedInstance().updateTranscodingStreamUrlMap(taskId, true, url);
    }

    /**
     * 删除转码推流地址，该方法每次只能删除一路推流地址。若需删除多路流，则需多次调用该方法
     *
     * @param taskId 转码任务id
     * @param url
     * @return 0：删除成功  < 0: 删除失败
     */
    public int removePublishTranscodingStreamUrl(String taskId, String url) {
        mRtmpStatusMap.remove(url);
        return ThunderAPI.sharedInstance().updateTranscodingStreamUrlMap(taskId, false, url);
    }

    /**
     * 添加or更新转码任务
     * 先调用该方法，再调用 addPublishTranscodingStreamUrl
     *
     * @param taskId      转码任务标示，由用户管理，保证同一任务taskId在频道内唯一；
     *                    不同的taskId标示不同的混画任务，用户更新转码任务时需要指定taskId；
     *                    同一频道sdk最大支持同时启动5个转码任务；
     * @param transcoding 混画布局
     * @return 0：方法调用成功  < 0: 方法调用失败
     */
    public int setLiveTranscodingTask(String taskId, LiveTranscoding transcoding) {
        return ThunderAPI.sharedInstance().updateTranscodingMap(taskId, false, transcoding);
    }

    /**
     * 删除转码任务
     *
     * @param taskId 转码任务标示 由用户管理，0-9 a-z A-Z
     * @return 0：方法调用成功  < 0: 方法调用失败
     */
    public int removeLiveTranscodingTask(String taskId) {
        return ThunderAPI.sharedInstance().updateTranscodingMap(taskId, true, null);
    }

    /**
     * 订阅用户
     *
     * @param roomId 频道号
     * @param uid    用户uid
     * @return 方法调用成功返回 0，失败返回 < 0
     */
    public int addSubscribe(String roomId, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "addSubscribe roomId %s, uid %s", roomId, uid);
        if (TextUtils.isEmpty(roomId) || TextUtils.isEmpty(uid) || mRoomName.equals(roomId)) {
            return -1;
        }

        synchronized (streamLock) {
            Set<String> streamSet = subscribeStreamMap.get(roomId);
            if (streamSet == null) {
                streamSet = new HashSet<>();
            }
            streamSet.add(uid); //这里只能保存原始的uid，因为还没有映射关系
            subscribeStreamMap.put(roomId, streamSet);
        }

        return ThunderAPI.sharedInstance().addSubscribe(roomId, uid);
    }

    /**
     * 删除订阅
     *
     * @param roomId 频道号
     * @param uid    用户uid
     * @return
     */
    public int removeSubscribe(String roomId, String uid) {
        ThunderLog.release(ThunderLog.kLogTagRtcEngine, "removeSubscribe roomId %s, uid %s", roomId, uid);
        if (TextUtils.isEmpty(roomId) || TextUtils.isEmpty(uid) || mRoomName.equals(roomId)) {
            return -1;
        }

        if (subscribeStreamMap.get(roomId) == null) {
            return -1;
        }

        Long lUid = UidMap.getLongUid(uid);
        ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);

        //FIXME 目前跨频道连麦, 同一个频道里面只能与一个主播连麦
        synchronized (streamLock) {
            // 需要退订视频流和音频流
            Iterator<ThunderStream> it = anchorStreams.iterator();
            while (it.hasNext()) {
                ThunderStream stream = it.next();
                if (stream != null && lUid == stream.speakerUid) {
                    stopStreams.add(stream);
                    it.remove();
                }
            }

            it = wholeStreams.iterator();
            while (it.hasNext()) {
                ThunderStream stream = it.next();
                if (stream != null && lUid == stream.speakerUid) {
                    it.remove();
                }
            }

            if (stopStreams.size() > 0) {
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);
            }

            Set<String> streamSet = subscribeStreamMap.get(roomId);
            if (streamSet != null && streamSet.contains(uid)) {
                streamSet.remove(uid);
                if (streamSet.size() == 0) {
                    subscribeStreamMap.remove(roomId);
                    channelStreamsList.remove(roomId);
                    return ThunderAPI.sharedInstance().removeSubscribe(roomId, uid);
                }
            }
        }

        return 0;
    }

    /**
     * 切到前/后置摄像头，
     * 需要在开启预览后{@linkstartPreview}调用不调用该方法时引擎默认启动前置摄像头
     *
     * @param bFront true：前置摄像头  false：后置摄像头
     * @return 方法调用成功返回 0，失败返回 < 0
     */
    public int switchFrontCamera(boolean bFront) {
        boolean ret = false;
        mIsFrontCamera = bFront;
        //isThunder模式下，不允许调用
        if (isThunder) {
            return -2;
        }
        if (bFront) {
            ret = ThunderAPI.sharedInstance().getPublishRoom().setCameraPosition(
                    ThunderCameraPosition.THUNDERCAMERA_POSITION_FRONT);
        } else {
            ret = ThunderAPI.sharedInstance().getPublishRoom().setCameraPosition(
                    ThunderCameraPosition.THUNDERCAMERA_POSITION_BACK);
        }
        return ret ? 0 : -1;

    }

    /**
     * 设置摄像头开播角度（横屏/竖屏）
     *
     * @param orientation 0:竖屏 1:横屏
     *                    {@link ThunderRtcConstant.ThunderVideoCaptureOrientation}
     */
    public int setVideoCaptureOrientation(int orientation) {
        if (!isEnableVideo || isThunder) {
            return -2;
        }
        ThunderNative.setOrientation(orientation);
        return 0;
    }

    /**
     * 设置摄像头镜像(只对前置摄像头生效，后置摄像头不生效，后置摄像头固定预览推流都不镜像,
     * 前置摄像头默认预览镜像推流不镜像)
     *
     * @param mode 参加{@link ThunderRtcConstant.ThunderVideoMirrorMode}
     * @return
     */
    public int setLocalVideoMirrorMode(int mode) {
        ThunderLog.info(ThunderLog.kLogTagCall, "setLocalVideoMirrorMode %d", mode);
        if (!isEnableVideo || isThunder) {
            return -2;
        }
        if (!mIsFrontCamera) {
            return -1;
        }

        return ThunderNative.setLocalVideoMirrorMode(mode);
    }

    public boolean getIsThunder() {
        return isThunder;
    }

    // 视频订阅：ThunderBolt模式 && 打开视频
    private void tryStartSubscribe(ArrayList<ThunderStream> streams)
    {
        if(0 < streams.size())
        {
            //暂时存储用户订阅远端视频的值
            Map<String, Integer> subscribeRemoteUidToVideoType = new HashMap<>();
            subscribeRemoteUidToVideoType.putAll(mSubscribeRemoteUidToVideoType);
            ArrayList<ThunderStream> actualSubscribeStreams = new ArrayList<>();
            Iterator<ThunderStream> iter = streams.iterator();
            while (iter.hasNext())
            {
                ThunderStream stream = iter.next();
                if(stream.bVideo)
                {
                    // 先判断用户整体的默认设置
                    if (0 == subscribeRemoteUidToVideoType.size())
                    {
                        ArrayList<ThunderStream> dualStreamInfos = mRemoteUidToVideoDualStreamInfo.get(stream.strUid);
                        if (null != dualStreamInfos)
                        {
                            Integer subscribeVideoStreamType = mDefauleRemoteVideoStreamType;
                            boolean bFindedDefaultStream = false;
                            Iterator<ThunderStream> dualIter = dualStreamInfos.iterator();
                            while(dualIter.hasNext())
                            {
                                ThunderStream dualStream = dualIter.next();
                                if (mDefauleRemoteVideoStreamType == dualStream.dualVideoStreamType)
                                {
                                    // 找到默认流
                                    bFindedDefaultStream = true;
                                    if (!actualSubscribeStreams.contains(dualStream))
                                    {
                                        actualSubscribeStreams.add(dualStream);
                                    }
                                    subscribeVideoStreamType = mDefauleRemoteVideoStreamType;
                                }
                            }

                            if (!bFindedDefaultStream)
                            {
                                // 找不到默认流
                                if (!actualSubscribeStreams.contains(stream))
                                {
                                    actualSubscribeStreams.add(stream);
                                }
                                subscribeVideoStreamType = stream.dualVideoStreamType;
                            }

                            //must record subscribe the remote video stream type
                            mSubscribeRemoteUidToVideoType.put(stream.strUid, subscribeVideoStreamType);

                        }else {
                            ThunderLog.release(ThunderLog.kLogTagRtcEngine, "try subscribe default stream, but not find in videoDualSteramInfo"
                                    + " Uid" + stream.strUid + " type:" + stream.dualVideoStreamType + " name:" + stream.streamName);

                            }

                    }else {
                        //已经记录了当前用户设定，按照下面处理
                        Integer videoStreamType = mSubscribeRemoteUidToVideoType.get(stream.strUid);
                        if(null == videoStreamType)
                        {
                            //用户没有设定订阅哪种流，默认订阅大流，大流不存在则订阅小流
                            ArrayList<ThunderStream> dualStreamInfos = mRemoteUidToVideoDualStreamInfo.get(stream.strUid);
                            if (null != dualStreamInfos)
                            {
                                Integer subscribeVideoStreamType = 0;
                                boolean bFindedHighStream = false;
                                Iterator<ThunderStream> dualIter = dualStreamInfos.iterator();
                                while(dualIter.hasNext())
                                {
                                    ThunderStream dualStream = dualIter.next();
                                    if (0 == dualStream.dualVideoStreamType)
                                    {
                                        // 找到大流
                                        bFindedHighStream = true;
                                        if (!actualSubscribeStreams.contains(dualStream))
                                        {
                                            actualSubscribeStreams.add(dualStream);
                                        }
                                        subscribeVideoStreamType = 0;
                                    }
                                }

                                if (!bFindedHighStream)
                                {
                                    // 找不到大流
                                    if (!actualSubscribeStreams.contains(stream))
                                    {
                                        actualSubscribeStreams.add(stream);
                                    }
                                    subscribeVideoStreamType = 1;
                                }

                                // must record subscribe the remote video stream type
                                mSubscribeRemoteUidToVideoType.put(stream.strUid, subscribeVideoStreamType);

                            }else {
                                ThunderLog.release(ThunderLog.kLogTagRtcEngine, "try subscribe default stream, but not find in videoDualSteramInfo"
                                        + " Uid" + stream.strUid + " type:" + stream.dualVideoStreamType + " name:" + stream.streamName);

                            }

                        }else {
                            // 订阅流和用户设定的一样
                            if(stream.dualVideoStreamType == videoStreamType)
                            {
                                if (!actualSubscribeStreams.contains(stream))
                                {
                                    actualSubscribeStreams.add(stream);
                                }
                            }
                            else {
                                // 来的流和用户设定的不一样，判断在映射里能否找到用户设定的流，找不到就订阅当前流
                                ArrayList<ThunderStream> dualStreamInfos = mRemoteUidToVideoDualStreamInfo.get(stream.strUid);
                                if (null != dualStreamInfos)
                                {
                                    Integer subscribeVideoStreamType = videoStreamType;
                                    boolean bFindedStream = false;
                                    Iterator<ThunderStream> dualIter = dualStreamInfos.iterator();
                                    while(dualIter.hasNext())
                                    {
                                        ThunderStream dualStream = dualIter.next();
                                        if (videoStreamType == dualStream.dualVideoStreamType)
                                        {
                                            // 找到用户设定的流
                                            bFindedStream = true;
                                            if (!actualSubscribeStreams.contains(dualStream))
                                            {
                                                actualSubscribeStreams.add(dualStream);
                                            }
                                            subscribeVideoStreamType = videoStreamType;
                                        }
                                    }

                                    if (!bFindedStream)
                                    {
                                        // 找不到用户设定的流
                                        if (!actualSubscribeStreams.contains(stream)) {
                                            actualSubscribeStreams.add(stream);
                                        }
                                        subscribeVideoStreamType = stream.dualVideoStreamType;
                                    }

                                    // must record subscribe the remote video stream type
                                    mSubscribeRemoteUidToVideoType.put(stream.strUid, subscribeVideoStreamType);

                                }else {
                                    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "try subscribe stream of given type, but not find in videoDualSteramInfo"
                                            + " Uid" + stream.strUid + " type:" + stream.dualVideoStreamType + " name:" + stream.streamName);

                                }
                                }
                            }

                        }
                }else
                    {
                        // 存放音频
                        actualSubscribeStreams.add(stream);
                    }
            }

           // 更新订阅的list
            Iterator<ThunderStream> actualInter = actualSubscribeStreams.iterator();
            while (actualInter.hasNext())
            {
                ThunderStream stream = actualInter.next();
                boolean bExisted = false;
                for(ThunderStream subscribedStreams : anchorStreams)
                {
                    if(stream.appId == subscribedStreams.appId &&
                            stream.streamName.equals(subscribedStreams.streamName))
                    {
                        bExisted = true;
                        break;
                    }
                }

                if (!bExisted)
                {
                    anchorStreams.add(stream);
                    ThunderLog.release(ThunderLog.kLogTagRtcEngine, "update subscribeInfo list:"
                            + " Uid" + stream.strUid + " type:" + stream.dualVideoStreamType + " name:" + stream.streamName);
                }
            }

           ThunderAPI.sharedInstance().getPlayer().startPlayStreams(actualSubscribeStreams, null);
        }
    }

    private void tryStopPublish() {
        if (isThunder) {
            if (mBAudioPublish) {
                ThunderAPI.sharedInstance().getPublisher().stopPublishAudio();

                mBAudioPublish = false;
                mStringName = "";
            }
        } else {
            if (mBAudioPublish) {
                ThunderAPI.sharedInstance().getPublishRoom().setAudioEnable(false);

                mBAudioPublish = false;
                mStringName = "";
            }
        }
    }

    private void tryStopVideoPublish() {
        if (mBVideoPublish) {
            ThunderAPI.sharedInstance().getPublishRoom().setVideoEnable(false);

            mBVideoPublish = false;
            mVideoStringName = "";
        }
    }

    private void tryStopSubscribe() {
        if (isThunder) {
            if (mBGroupSubscribe) {
                ArrayList<ThunderGroup> audioGroup = new ArrayList<ThunderGroup>(0);
                ThunderGroup oneGroup = new ThunderGroup();
                oneGroup.appId = mRoomAppId;
                oneGroup.groupName = "g_" + mRoomName;
                audioGroup.add(oneGroup);

                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(null, audioGroup);

                mBGroupSubscribe = false;
            }
        } else {
            ArrayList<ThunderStream> stopSteams = new ArrayList<ThunderStream>(0);
            for (ThunderStream oneStream : anchorStreams) {
                if (!oneStream.bVideo) {
                    stopSteams.add(oneStream);
                }
            }
            if (stopSteams.size() > 0) {
                for (ThunderStream oneStream : stopSteams) {
                    anchorStreams.remove(oneStream.streamName);
                }
                ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopSteams, null);
            }
        }
    }

    private void tryStopVideoSubscribe() {
        ArrayList<ThunderStream> stopStreams = new ArrayList<ThunderStream>(0);
        synchronized (streamLock) {
            for (ThunderStream oneStream : anchorStreams) {
                if (oneStream.bVideo) {
                    stopStreams.add(oneStream);
                }
            }

            ThunderAPI.sharedInstance().getPlayer().stopPlayStreams(stopStreams, null);

            for (ThunderStream oneStream : stopStreams) {
                anchorStreams.remove(oneStream);
            }
        }
    }

    private void tryStopVideoPreview() {
        if (isPreview) {
            stopVideoPreview();
            isPreview = false;
        }
    }

    private void addUid2String(long iUid, String strUid) {
        if (strUid.equals(mMyStrUid)) {
            mRecv64UidMap = true;
            mMyUid = iUid;
            ThunderNative.setUserInfo(iUid, 0);
            notifyJoinSuccess();
        }

        UidMap.addUid2String(iUid, strUid);
    }

    private void resetRtcEngine() {
        //static info
        mHandler = null;
        sMyAppId = 0;
        sMySceneId = 0;

        mRtcEventHandler = null;
        mHttpsRequestHandler = null;

        //my info
        mMyUid = 0;
        mIs32bitUid = false;
        mMyStrUid = "";
        UidMap.removeAllUid2String();

        //log info
        mLogLevel = ThunderLogLevel.THUNDERLOG_LEVEL_TRACE;
        mLogPath = "";
        mYyLogCallback = null;

        //audio srbscribe
        mBGroupSubscribe = false;
        mBAudioPublish = false;

        //room info
        mRoomAppId = 0;

        //room profile
        mRoomConfig = RoomConfig.THUNDER_ROOMCONFIG_LIVE;
        //audio profile
        mAudioConfig = AudioConfig.THUNDER_AUDIO_CONFIG_DEFAULT;
        mCommutMode = CommutMode.THUNDER_COMMUT_MODE_DEFAULT;
        mScenarioMode = ScenarioMode.THUNDER_SCENARIO_MODE_DEFAULT;

        //switch
        s_playVolumeNotifyCount = 0;
        s_playDataNotifyCount = 0;
        mBEnablePlayDataIndication = false;

        // Equalizer
        mEqGains = new int[11];
        mBEnableEqualizer = false;
        mBEnableCompressor = false;
        mBEnableLimiter = false;
        mBEnableReverbEx = false;
        mReverbExGains = new ReverbExParameter();
        mCompressorGains = new CompressorParam();
        mLimiterGins = new LimterParam();

        // audioFilePlayer
        cleanAllAudioFilePlayer();

        //video
        ThunderDefaultCamera camera = ThunderAPI.sharedInstance().getPublisher().getDefaluteCamera();
        if (camera != null) {
            ThunderPreviewConfig config = (ThunderPreviewConfig) camera.getCaptureConfig();

            config.cameraPosition = ThunderCameraPosition.THUNDERCAMERA_POSITION_FRONT;
            config.captureOrientation = ThunderVideoCaptureOrientation.THUNDER_VIDEO_CAPTURE_ORIENTATION_PORTRAIT;
        }

        accompanyType = -1;

        mLocalPreviewView = null;
        mThunderMediaExtraInfoCallback = null;
        isPreview = false;
        isStopLocalVideo = false;
        isLeaveRoomByUser = false;
    }

    private void cleanAllAudioFilePlayer() {
        for (ThunderAudioFilePlayer audioFilePlayer : mAudioFilePlayerSet) {
            audioFilePlayer.destroyAudioFilePlayer();
        }
        mAudioFilePlayerSet.clear();
    }

    private String getPrintString(String str) {
        String result = "";
        if (str != null) {
            result = str;
        }

        return result;
    }

    private String getPrintString(byte[] data) {
        String result = "";
        if (data != null) {
            result = data.toString();
        }

        return result;
    }

    private String getPrintString(Object obj) {
        String result = "";
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    /**
     * 1. 如果视频模块总开关是关闭状态，则不能订阅任何流，需要取消订阅所有流；
     * 2. 如果视频模块总开关是开启的，则先根据用户设置黑白名单mutelist来决定是否可以进行订阅操作，
     * false表示需要订阅，true表示取消订阅；其中mutelist列表只可以通过用户调用moteRemote接
     * 口设置，内部不可以修改；
     * 3. 如果视频模块总开关是开启的，但是uid不在用户设置的黑白名单mutelist里，则根据用户设置的默
     * 认值muteAll执行，true false表示需要订阅，true表示取消订阅；
     *
     * @param uid
     * @return
     */
    private boolean isMuteVideoStreamWithUid(long uid) {
        if (!isEnableVideo) {
            return true;
        }

        Boolean result = uidMuteVideoList.get(UidMap.getStringUid(uid));
        if (result != null) {
            return result;
        }

        return isStopAllVideo;
    }

    /**
     * 同isMuteVideoStreamWithUid
     *
     * @param uid
     * @return
     */
    private boolean isMuteAudioStreamWithUid(long uid) {
        if (!isEnableAudio) {
            return true;
        }

        Boolean result = uidMuteAudioList.get(UidMap.getStringUid(uid));
        if (result != null) {
            return result;
        }

        return isStopAllAudio;
    }

    public static void notifyNetworkTypeChanged(int netState) {
        if (mRtcEventHandler != null) {
            int type;
            switch (netState) {
                case ThunderNetStateService.NetState.SYSNET_WIFI:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_WIFI;
                    break;
                case ThunderNetStateService.NetState.SYSNET_MOBILE:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE;
                    break;
                case ThunderNetStateService.NetState.SYSNET_DISCONNECT:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_DISCONNECTED;
                    break;
                case ThunderNetStateService.NetState.SYSNET_2G:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE_2G;
                    break;
                case ThunderNetStateService.NetState.SYSNET_3G:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE_3G;
                    break;
                case ThunderNetStateService.NetState.SYSNET_4G:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_MOBILE_4G;
                    break;
                case ThunderNetStateService.NetState.SYSNET_UNKNOWN:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_UNKNOWN;
                    break;
                default:
                    type = ThunderNetworkType.THUNDER_NETWORK_TYPE_UNKNOWN;
                    break;
            }
            mRtcEventHandler.onNetworkTypeChanged(type);
        }
    }

}

