package com.thunder.livesdk;

import android.view.MotionEvent;

import com.yy.mediaframework.VideoPublish;
import com.yy.mediaframework.YYCamera;
import com.yy.mediaframework.facedetection.IFaceDetection;
import com.yy.mediaframework.facedetection.PreviewFrameCallback;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;

/**
 * Created by jping on 2019/1/22.
 * <p>
 * 该类用于直接访问算法库中的方法
 */

public class ThunderBridgeLib {

    private ThunderBridgeLib() {

    }

    private static class SingletonHolder {
        private static final ThunderBridgeLib INSTANCE = new ThunderBridgeLib();
    }

    public static ThunderBridgeLib getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /**
     * 获取美颜接口
     *
     * @return
     */
    public OrangeFilterWrapper getBeautyFilter() {
        return VideoPublish.getInstance().getOrangeFilterWrapperObject();
    }

    /**
     * 判断当前打开的摄像头是否支持zoom功能
     *
     * @return
     */
    public boolean isCameraZoomSupport() {
        return YYCamera.getInstance().isZoomSupport();
    }

    /**
     * 获取当前打开摄像头的最大zoom参数
     *
     * @return
     */
    public int getCameraMaxZoom() {
        return YYCamera.getInstance().getMaxZoom();
    }

    /**
     * 设置当前摄像头的zoom参数
     *
     * @param zoom 目标zoom参数
     * @return 设置后 实际的zoom参数
     */
    public float setCameraZoom(final int zoom) {

        return YYCamera.getInstance().setZoom(zoom);
    }

    /**
     * 聚焦以及测光
     *
     * @param event
     */
    public void handleFocusMetering(final MotionEvent event) {
        YYCamera.getInstance().handleFocusMetering(event);
    }

    /**
     * 设置客户端实现的人脸识别库到sdk，具体用法参照FaceDetectionDemo
     *
     * @param faceDetection 业务端实现的人脸识别库实例
     */
    public void setMobileFaceDetection(IFaceDetection faceDetection) {
        VideoPublish.getInstance().setMobileFaceDetection(faceDetection);
    }

    /**
     * 设置客户端实现的美颜库到sdk,具体用法参照FaceBeautyDemo
     *
     * @param gpuImageBeauty 用于获取yuv数据的回调PreviewFrameCallback实例，即人脸识别库识别代码实现实例
     */
    public void setGPUImageProcessFilter(IGPUProcess gpuImageBeauty) {
        VideoPublish.getInstance().setGPUImageBeautyFilter(gpuImageBeauty);
    }

    /**
     * 注册获取camera yuv数据回调client，开播库分发camera数据给人脸识别库（NV21,图像方向以android手机坐标系0度）
     *
     * @param callback 用于获取yuv数据的回调PreviewFrameCallback实例，即人脸识别库识别代码实现实例
     */
    public void addPreviewFrameCallback(PreviewFrameCallback callback) {
        VideoPublish.getInstance().addPreviewFrameCallback(callback);
    }

    /**
     * 取消注册获取camera yuv数据回调client
     *
     * @param callback 用于获取yuv数据的回调PreviewFrameCallback实例，即人脸识别库识别代码实现实例
     */
    public void removePreviewFrameCallback(PreviewFrameCallback callback) {
        VideoPublish.getInstance().removePreviewFrameCallback(callback);
    }
}
