package com.thunder.livesdk;

import java.util.ArrayList;
import java.util.Iterator;

public class LiveTranscoding {

    //转码混画档位，混画档位由配置中心通过sdk接口给出，sdk通过mTransCodingMode获得配置中心配置的转码混画输出编码参数
    private int mTransCodingMode;

    //混画中所有的用户
    private ArrayList<TranscodingUser> mUserList = new ArrayList<>();

    /**
     * 添加一个用户到混画布局中
     *
     * @param user
     * @return
     */
    public int addUser(TranscodingUser user) {
        if (mUserList != null) {
            mUserList.add(user);
        }
        return 0;
    }

    /**
     * 批量设置用户混画布局
     * 该方法用户设置参与合图的全部用户。该方法会使用新的 User 数据替换原有的数据。
     *
     * @param users 频道内所有的混画用户
     */
    public void setUsers(ArrayList<TranscodingUser> users) {
        mUserList.clear();
        mUserList.addAll(users);
    }

    /**
     * 获取当前用户位置信息
     *
     * @return 获取频道内所有用户在混画画布中的信息
     */
    public final ArrayList<TranscodingUser> getUsers() {
        return mUserList;
    }

    /**
     * 删除参与混画的用户
     *
     * @param uid 待删除的用户 ID
     * @return
     */
    public int removeUser(String uid) {
        Iterator<TranscodingUser> itor = mUserList.iterator();
        while (itor.hasNext()) {
            TranscodingUser tmp = itor.next();
            if (uid.equals(tmp.uid)) {
                itor.remove();
            }
        }
        return 0;
    }

    /**
     * 删除该频道的混画，即用户不再使用混画
     *
     * @return
     */
    public int removeAllUser() {
        mUserList.clear();
        return 0;
    }

    /**
     * 获取参与混画的人数
     *
     * @return
     */
    public int getUserCount() {
        if (mUserList == null || mUserList.isEmpty()) {
            return 0;
        } else {
            return mUserList.size();
        }
    }

    /**
     * 设置输出的混画的档位
     *
     * @param transCodingMode
     */
    public void setTransCodingMode(int transCodingMode) {
        this.mTransCodingMode = transCodingMode;
    }

    /**
     * 获得输出的混画的档位
     *
     * @return
     */
    public int getTransCodingMode() {
        return mTransCodingMode;
    }

    public static class TranscodingUser {

        public String uid;
        public String roomId;
        public boolean bStandard;//是否基准流用户
        public int layoutX;        //用户在混画画布中的位置 x
        public int layoutY;        //用户在混画画布中的位置 y
        public int layoutW;        //用户在混画画布中的位置 w
        public int layoutH;        //用户在混画画布中的位置 h
        public int zOrder;      //直播视频上用户视频帧的图层编号，取值范围为 [0, 100] 中的整型，最小值为 0（默认值），表示该区域图像位于最下层
        public boolean bCrop;   //混画服务将源流放到画布中位置时对源流的裁剪方式（0：补黑边 1：裁剪）
        public int cropX;      //裁剪区域x坐标
        public int cropY;      //裁剪区域Y坐标
        public int cropW;      //裁剪区域宽度
        public int cropH;      //裁剪区域高度
        public float alpha;      //直播视频上用户视频的透明度。取值范围为 [0.0, 1.0]。0.0 表示该区域图像完全透明，而 1.0 表示该区域图像完全不透明。默认值为 1.0
        public int audioRoom;//暂未实现

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TranscodingUser)) {
                return false;
            }

            TranscodingUser p = (TranscodingUser) obj;
            if (this.uid.equals(p.uid) && this.roomId.equals(p.roomId)) {
                return true;
            } else {
                return false;
            }
        }

        @Override
        public int hashCode() {
            String hash = uid + roomId;
            return hash.hashCode();
        }
    }

}
