package com.thunder.livesdk;

public interface IThunderMediaExtraInfoCallback {

    /**
     * 发送媒体次要信息失败状态回调
     *
     * @param status 失败错误码 {@link ThunderRtcConstant.ThunderSendMediaExtraInfoFailedStatus}
     */
    void onSendMediaExtraInfoFailedStatus(int status);

    /**
     * 接收媒体次要信息
     *
     * @param uid     主播的uid
     * @param data    接收到的媒体次要信息
     * @param dataLen 媒体次要信息长度
     */
    void onRecvMediaExtraInfo(java.lang.String uid,
                              java.nio.ByteBuffer data,
                              int dataLen);

}
