package com.thunder.livesdk;

import com.thunder.livesdk.helper.ThunderLog;

public class ExternalVideoSource extends ThunderVideoCapture {

    ThunderCustomVideoSource mVideoSource = null;
    ThunderPublisher.IVideoPublisher mPublisher = null;

    public ExternalVideoSource(ThunderCustomVideoSource videoSource) {
        mVideoSource = videoSource;
    }

    @Override
    public void startCapture(ThunderPublisher.IVideoPublisher proxy) {
        mPublisher = proxy;
        if (mVideoSource != null) {

            mVideoSource.onInitialize(new ThunderVideoFrameConsumer() {
                @Override
                public void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation,
                                                  long timestamp) {
                    if (mPublisher != null) {
                        mPublisher.pushVideoData(data, format, width, height, rotation, timestamp);
                    }
                }
            });

            mVideoSource.onStart();
        } else {
            ThunderLog.info(ThunderLog.kLogTagRtcEngine, "warning,  need set videoSource...");
        }
    }

    @Override
    public void stopCapture() {
        if (mVideoSource != null) {
            mVideoSource.onStop();
            mVideoSource.onDispose();
        } else {
            ThunderLog.info(ThunderLog.kLogTagRtcEngine, "warning,  need set videoSource...");
        }
    }

    @Override
    public ThunderVideoCaptureConfig getCaptureConfig() {
        return null;
    }
}
