package com.thunder.livesdk;

import com.thunder.livesdk.helper.ThunderLog;

public class ExternalAudioSource extends ThunderAudioCapture {

    private int mSampleRate = 0;
    private int mChannels = 0;
    private int mSampleBitDepth = 0;
    private ThunderPublisher.IAudioPublisher mPublisher = null;

    public ExternalAudioSource(int sampleRate, int channels) {
        this.mSampleRate = sampleRate;
        this.mChannels = channels;
        mSampleBitDepth = 16;   //默认的采集只支持16bit的采样位深
    }

    public void pushCustomAudioFrame(byte[] samples, long timeStamp) {
        if (mPublisher != null) {
            mPublisher.pushAudioData(samples, timeStamp);
        }
    }

    @Override
    public void startCapture(ThunderPublisher.IAudioPublisher publisher) {
        mPublisher = publisher;
    }

    @Override
    public void stopCapture() {
        ThunderLog.info(ThunderLog.kLogTagRtcEngine, "stop push external audio.");
    }

    @Override
    public int getSampleRate() {
        return mSampleRate;
    }

    @Override
    public int getChannels() {
        return mChannels;
    }

    @Override
    public int getBitDepth() {
        return mSampleBitDepth;
    }
}
