/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.util;

import java.util.HashMap;
import java.util.LinkedList;

public final class LruCache<K, V> {
    private LinkedList<K> list = new LinkedList();
    private HashMap<K, V> map = new HashMap();
    private int size;

    public LruCache() {
        this(256);
    }

    public LruCache(int size) {
        this.size = size;
    }

    public LruCache put(K k, V v) {
        if (this.list.size() == this.size) {
            K old = this.list.pollLast();
            this.map.remove(old);
        }
        this.map.put(k, v);
        this.list.push(k);
        return this;
    }

    public LruCache delete(K k) {
        this.list.remove(k);
        this.map.remove(k);
        return this;
    }

    public V get(K k) {
        V v = this.map.get(k);
        this.list.remove(k);
        this.list.push(k);
        return v;
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }
}

