/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.local;

import com.qiniu.android.dns.DnsException;
import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.local.DnsMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;

public final class Resolver
implements IResolver {
    private static final Random random = new Random();
    final InetAddress address;

    public Resolver(InetAddress address) {
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
        int id;
        Random random = Resolver.random;
        synchronized (random) {
            id = Resolver.random.nextInt() & 0xFF;
        }
        byte[] query = DnsMessage.buildQuery(domain.domain, id);
        byte[] answer = this.udpCommunicate(query);
        if (answer == null) {
            throw new DnsException(domain.domain, "cant get answer");
        }
        return DnsMessage.parseResponse(answer, id, domain.domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] udpCommunicate(byte[] question) throws IOException {
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            DatagramPacket packet = new DatagramPacket(question, question.length, this.address, 53);
            socket.setSoTimeout(10000);
            socket.send(packet);
            packet = new DatagramPacket(new byte[1500], 1500);
            socket.receive(packet);
            byte[] byArray = packet.getData();
            return byArray;
        }
    }
}

