/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.local;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.local.DnshijackingException;
import com.qiniu.android.dns.local.HijackingDetectWrapper;
import com.qiniu.android.dns.local.Resolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AndroidDnsServer {
    public static InetAddress[] getByCommand() {
        try {
            Process process = Runtime.getRuntime().exec("getprop");
            InputStream inputStream = process.getInputStream();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inputStream));
            String line = null;
            ArrayList<InetAddress> servers = new ArrayList<InetAddress>(5);
            while ((line = lnr.readLine()) != null) {
                InetAddress ip;
                int split = line.indexOf("]: [");
                if (split == -1) continue;
                String property = line.substring(1, split);
                String value = line.substring(split + 4, line.length() - 1);
                if (!property.endsWith(".dns") && !property.endsWith(".dns1") && !property.endsWith(".dns2") && !property.endsWith(".dns3") && !property.endsWith(".dns4") || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0) continue;
                servers.add(ip);
            }
            if (servers.size() > 0) {
                return servers.toArray(new InetAddress[servers.size()]);
            }
        }
        catch (IOException e) {
            Logger.getLogger("AndroidDnsServer").log(Level.WARNING, "Exception in findDNSByExec", e);
        }
        return null;
    }

    public static InetAddress[] getByReflection() {
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            ArrayList<InetAddress> servers = new ArrayList<InetAddress>(5);
            for (String propKey : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
                InetAddress ip;
                String value = (String)method.invoke(null, propKey);
                if (value == null || value.length() == 0 || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0 || servers.contains(ip)) continue;
                servers.add(ip);
            }
            if (servers.size() > 0) {
                return servers.toArray(new InetAddress[servers.size()]);
            }
        }
        catch (Exception e) {
            Logger.getLogger("AndroidDnsServer").log(Level.WARNING, "Exception in findDNSByReflection", e);
        }
        return null;
    }

    public static IResolver defaultResolver() {
        return new IResolver(){

            @Override
            public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
                InetAddress[] addresses = AndroidDnsServer.getByReflection();
                if (addresses == null) {
                    addresses = AndroidDnsServer.getByCommand();
                }
                if (addresses == null) {
                    throw new IOException("cant get local dns server");
                }
                HijackingDetectWrapper resolver = new HijackingDetectWrapper(new Resolver(addresses[0]));
                Record[] records = resolver.resolve(domain, info);
                if (domain.hasCname) {
                    boolean cname = false;
                    Record[] recordArray = records;
                    int n = recordArray.length;
                    for (int i = 0; i < n; ++i) {
                        Record r = recordArray[i];
                        if (!r.isCname()) continue;
                        cname = true;
                        break;
                    }
                    if (!cname) {
                        throw new DnshijackingException(domain.domain, addresses[0].getHostAddress());
                    }
                }
                if (domain.maxTtl != 0) {
                    for (Record r : records) {
                        if (r.isCname() || r.ttl <= domain.maxTtl) continue;
                        throw new DnshijackingException(domain.domain, addresses[0].getHostAddress(), r.ttl);
                    }
                }
                return records;
            }
        };
    }
}

