/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns.http;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.util.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class DnspodEnterprise
implements IResolver {
    private final String id;
    private final String ip;
    private final SecretKeySpec key;

    public DnspodEnterprise(String id, String key, String ip) {
        this.id = id;
        this.ip = ip;
        byte[] k = new byte[]{};
        try {
            k = key.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        this.key = new SecretKeySpec(k, "DES");
    }

    public DnspodEnterprise(String id, String key) {
        this(id, key, "119.29.29.29");
    }

    @Override
    public Record[] resolve(Domain domain, NetworkInfo info) throws IOException {
        int ttl;
        URL url = new URL("http://" + this.ip + "/d?ttl=1&dn=" + this.encrypt(domain.domain) + "&id=" + this.id);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setConnectTimeout(3000);
        httpConn.setReadTimeout(6000);
        int responseCode = httpConn.getResponseCode();
        if (responseCode != 200) {
            return null;
        }
        int length = httpConn.getContentLength();
        if (length <= 0 || length > 1024) {
            return null;
        }
        InputStream is = httpConn.getInputStream();
        byte[] data = new byte[length];
        int read = is.read(data);
        is.close();
        if (read <= 0) {
            return null;
        }
        String response = new String(data, 0, read);
        String result = this.decrypt(response);
        String[] r1 = result.split(",");
        if (r1.length != 2) {
            return null;
        }
        try {
            ttl = Integer.parseInt(r1[1]);
        }
        catch (Exception e) {
            return null;
        }
        String[] ips = r1[0].split(";");
        if (ips.length == 0) {
            return null;
        }
        Record[] records = new Record[ips.length];
        long time = System.currentTimeMillis() / 1000L;
        for (int i = 0; i < ips.length; ++i) {
            records[i] = new Record(ips[i], 1, ttl, time);
        }
        return records;
    }

    private String encrypt(String domain) {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(1, this.key);
            byte[] encryptedString = cipher.doFinal(domain.getBytes("utf-8"));
            return Hex.encodeHexString(encryptedString) + "&id=" + this.id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String decrypt(String data) {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(2, this.key);
            byte[] decrypted = cipher.doFinal(Hex.decodeHex(data.toCharArray()));
            return new String(decrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

