/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.dns;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.IpSorter;
import com.qiniu.android.dns.Network;
import com.qiniu.android.dns.NetworkInfo;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.http.DomainNotOwn;
import com.qiniu.android.dns.local.Hosts;
import com.qiniu.android.dns.util.LruCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class DnsManager {
    private final IResolver[] resolvers;
    private final LruCache<String, Record[]> cache;
    private final Hosts hosts = new Hosts();
    private final IpSorter sorter;
    private volatile NetworkInfo info = null;
    private volatile int index = 0;

    public DnsManager(NetworkInfo info, IResolver[] resolvers) {
        this(info, resolvers, null);
    }

    public DnsManager(NetworkInfo info, IResolver[] resolvers, IpSorter sorter) {
        this.info = info == null ? NetworkInfo.normal : info;
        this.resolvers = (IResolver[])resolvers.clone();
        this.cache = new LruCache();
        this.sorter = sorter == null ? new ShuffleIps() : sorter;
    }

    private static Record[] trimCname(Record[] records) {
        ArrayList<Record> a = new ArrayList<Record>(records.length);
        for (Record r : records) {
            if (r == null || r.type != 1) continue;
            a.add(r);
        }
        return a.toArray(new Record[a.size()]);
    }

    private static String[] records2Ip(Record[] records) {
        if (records == null || records.length == 0) {
            return null;
        }
        ArrayList<String> a = new ArrayList<String>(records.length);
        for (Record r : records) {
            a.add(r.value);
        }
        if (a.size() == 0) {
            return null;
        }
        return a.toArray(new String[a.size()]);
    }

    public static boolean validIP(String ip) {
        if (ip == null || ip.length() < 7 || ip.length() > 15) {
            return false;
        }
        if (ip.contains("-")) {
            return false;
        }
        try {
            int x = 0;
            int y = ip.indexOf(46);
            if (y != -1 && Integer.parseInt(ip.substring(x, y)) > 255) {
                return false;
            }
            if ((x = ip.indexOf(46, ++y)) != -1 && Integer.parseInt(ip.substring(y, x)) > 255) {
                return false;
            }
            return (y = ip.indexOf(46, ++x)) == -1 || Integer.parseInt(ip.substring(x, y)) <= 255 || Integer.parseInt(ip.substring(++y, ip.length() - 1)) <= 255 || ip.charAt(ip.length() - 1) == '.';
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String[] query(String domain) throws IOException {
        return this.query(new Domain(domain));
    }

    public String[] query(Domain domain) throws IOException {
        if (domain == null) {
            throw new IOException("null domain");
        }
        if (domain.domain == null || domain.domain.trim().length() == 0) {
            throw new IOException("empty domain " + domain.domain);
        }
        if (DnsManager.validIP(domain.domain)) {
            return new String[]{domain.domain};
        }
        String[] r = this.queryInternal(domain);
        if (r == null || r.length <= 1) {
            return r;
        }
        return this.sorter.sort(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String[] queryInternal(Domain domain) throws IOException {
        String[] ret;
        Record[] records = null;
        if (domain.hostsFirst && (ret = this.hosts.query(domain, this.info)) != null && ret.length != 0) {
            return ret;
        }
        ret = this.cache;
        // MONITORENTER : this.cache
        if (this.info.equals(NetworkInfo.normal) && Network.isNetworkChanged()) {
            this.cache.clear();
            IResolver[] iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            this.index = 0;
            // MONITOREXIT : iResolverArray
        } else {
            records = this.cache.get(domain.domain);
            if (records != null && records.length != 0) {
                if (!records[0].isExpired()) {
                    // MONITOREXIT : ret
                    return DnsManager.records2Ip(records);
                }
                records = null;
            }
        }
        // MONITOREXIT : ret
        IOException lastE = null;
        int firstOk = this.index;
        for (int i = 0; i < this.resolvers.length; ++i) {
            int pos = (firstOk + i) % this.resolvers.length;
            NetworkInfo before = this.info;
            String ip = Network.getIp();
            try {
                records = this.resolvers[pos].resolve(domain, this.info);
            }
            catch (DomainNotOwn e) {
                continue;
            }
            catch (IOException e) {
                lastE = e;
                e.printStackTrace();
            }
            String ip2 = Network.getIp();
            if (this.info != before || records != null && records.length != 0 || !ip.equals(ip2)) break;
            IResolver[] iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            if (this.index == firstOk) {
                ++this.index;
                if (this.index == this.resolvers.length) {
                    this.index = 0;
                }
            }
            // MONITOREXIT : iResolverArray
        }
        if (records == null || records.length == 0) {
            String[] rs;
            if (!domain.hostsFirst && (rs = this.hosts.query(domain, this.info)) != null && rs.length != 0) {
                return rs;
            }
            if (lastE == null) throw new UnknownHostException(domain.domain);
            throw lastE;
        }
        if ((records = DnsManager.trimCname(records)).length == 0) {
            throw new UnknownHostException("no A records");
        }
        LruCache<String, Record[]> lruCache = this.cache;
        // MONITORENTER : lruCache
        this.cache.put(domain.domain, records);
        // MONITOREXIT : lruCache
        return DnsManager.records2Ip(records);
    }

    public InetAddress[] queryInetAdress(Domain domain) throws IOException {
        String[] ips = this.query(domain);
        InetAddress[] addresses = new InetAddress[ips.length];
        for (int i = 0; i < ips.length; ++i) {
            addresses[i] = InetAddress.getByName(ips[i]);
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNetworkChange(NetworkInfo info) {
        this.clearCache();
        this.info = info == null ? NetworkInfo.normal : info;
        IResolver[] iResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            this.index = 0;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        LruCache<String, Record[]> lruCache = this.cache;
        synchronized (lruCache) {
            this.cache.clear();
        }
    }

    public DnsManager putHosts(String domain, String ip, int provider) {
        this.hosts.put(domain, new Hosts.Value(ip, provider));
        return this;
    }

    public DnsManager putHosts(String domain, String ip) {
        this.hosts.put(domain, ip);
        return this;
    }

    private static class ShuffleIps
    implements IpSorter {
        private AtomicInteger pos = new AtomicInteger();

        private ShuffleIps() {
        }

        @Override
        public String[] sort(String[] ips) {
            if (ips == null || ips.length <= 1) {
                return ips;
            }
            int x = this.pos.getAndIncrement() & 0xFF;
            String[] ret = new String[ips.length];
            for (int i = 0; i < ips.length; ++i) {
                ret[i] = ips[(i + x) % ips.length];
            }
            return ret;
        }
    }
}

