/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.file.IFileAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAnnotation
implements IFileAnnotation {
    private int upper = 0;
    private int lower = 0;
    private String depotPath = null;
    private String line = null;
    private IClientSummary.ClientLineEnd lineEnd = null;
    private boolean hadLineEnd = false;
    private static final String localLineEndStr = System.getProperty("line.separator", "\n");
    private List<IFileAnnotation> contributingSources = null;
    private int ordering = -1;

    public FileAnnotation(int upper, int lower, String depotPath, String line, IClientSummary.ClientLineEnd lineEnd) {
        this.upper = upper;
        this.lower = lower;
        this.depotPath = depotPath;
        this.line = line;
        this.lineEnd = lineEnd;
        this.handleLineEnding();
    }

    private void handleLineEnding() {
        if (this.line != null) {
            if (this.line.endsWith("\r\n")) {
                this.line = this.line.substring(0, this.line.length() - 2);
                this.hadLineEnd = true;
            } else if (this.line.endsWith("\n")) {
                this.line = this.line.substring(0, this.line.length() - 1);
                this.hadLineEnd = true;
            }
        }
    }

    public FileAnnotation(Map<String, Object> map, String depotPath, IClientSummary.ClientLineEnd lineEnd) {
        if (map != null) {
            try {
                this.lower = new Integer((String)map.get("lower"));
                this.upper = new Integer((String)map.get("upper"));
                this.lineEnd = lineEnd;
                this.line = (String)map.get("data");
                this.handleLineEnding();
            }
            catch (Throwable thr) {
                Log.warn("bad conversion in FileAnnotation constructor; map: " + map);
                Log.exception(thr);
            }
        }
        this.depotPath = depotPath;
    }

    public FileAnnotation(int order, String depotPath, int upper, int lower) {
        this.ordering = order;
        this.depotPath = depotPath;
        this.upper = upper;
        this.lower = lower;
    }

    public void addIntegrationAnnotation(IFileAnnotation annotation) {
        if (annotation != null) {
            if (this.contributingSources == null) {
                this.contributingSources = new ArrayList<IFileAnnotation>();
            }
            this.contributingSources.add(annotation);
        }
    }

    @Override
    public String getDepotPath() {
        return this.depotPath;
    }

    @Override
    public String getLine() {
        return this.line;
    }

    @Override
    public String getLine(boolean processLineEndings) {
        if (processLineEndings && this.line != null && this.hadLineEnd) {
            if (this.lineEnd != null) {
                switch (this.lineEnd) {
                    case UNIX: 
                    case SHARE: {
                        return this.line + "\n";
                    }
                    case MAC: {
                        return this.line + "\r";
                    }
                    case WIN: {
                        return this.line + "\r\n";
                    }
                }
                return this.line + localLineEndStr;
            }
            return this.line + localLineEndStr;
        }
        return this.line;
    }

    @Override
    public List<IFileAnnotation> getAllIntegrations() {
        return this.contributingSources;
    }

    @Override
    public int getLower() {
        return this.lower;
    }

    @Override
    public int getUpper() {
        return this.upper;
    }

    public void setUpper(int upper) {
        this.upper = upper;
    }

    public void setLower(int lower) {
        this.lower = lower;
    }

    public void setDepotPath(String depotPath) {
        this.depotPath = depotPath;
    }

    public void setLine(String line) {
        this.line = line;
    }

    public IClientSummary.ClientLineEnd getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(IClientSummary.ClientLineEnd lineEnd) {
        this.lineEnd = lineEnd;
    }

    @Override
    public int getOrdering() {
        return this.ordering;
    }

    public FileAnnotation setOrdering(int ordering) {
        this.ordering = ordering;
        return this;
    }
}

