/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core.file;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSpecBuilder {
    public static List<IFileSpec> makeFileSpecList(List<String> pathList) {
        ArrayList<FileSpec> specList = null;
        if (pathList != null) {
            specList = new ArrayList<FileSpec>();
            for (String path : pathList) {
                if (path == null) continue;
                specList.add(new FileSpec(path));
            }
        }
        return specList;
    }

    public static List<IFileSpec> makeFileSpecList(String[] pathArray) {
        ArrayList<FileSpec> specList = null;
        if (pathArray != null) {
            specList = new ArrayList<FileSpec>();
            for (String path : pathArray) {
                if (path == null) continue;
                specList.add(new FileSpec(path));
            }
        }
        return specList;
    }

    public static List<IFileSpec> makeFileSpecList(String path) {
        return FileSpecBuilder.makeFileSpecList(new String[]{path});
    }

    public static List<IFileSpec> getValidFileSpecs(List<IFileSpec> fileSpecs) {
        ArrayList<IFileSpec> validList = new ArrayList<IFileSpec>();
        if (fileSpecs != null) {
            for (IFileSpec fSpec : fileSpecs) {
                if (fSpec == null || fSpec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                validList.add(fSpec);
            }
        }
        return validList;
    }

    public static List<IFileSpec> getInvalidFileSpecs(List<IFileSpec> fileSpecs) {
        ArrayList<IFileSpec> invalidList = new ArrayList<IFileSpec>();
        if (fileSpecs != null) {
            for (IFileSpec fSpec : fileSpecs) {
                if (fSpec == null || fSpec.getOpStatus() == FileSpecOpStatus.VALID) continue;
                invalidList.add(fSpec);
            }
        }
        return invalidList;
    }
}

