/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.base.Splitter;
import com.palantir.gradle.junit.CheckstyleReportHandler;
import com.palantir.gradle.junit.JavacFailuresSupplier;
import com.palantir.gradle.junit.JunitReportsExtension;
import com.palantir.gradle.junit.JunitReportsFinalizer;
import com.palantir.gradle.junit.JunitTaskResultExtension;
import com.palantir.gradle.junit.XmlReportFailuresSupplier;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;

public final class JunitReportsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        JunitReportsExtension rootExt = (JunitReportsExtension)project.getRootProject().getExtensions().getByType(JunitReportsExtension.class);
        JunitTaskResultExtension ext = JunitTaskResultExtension.register(project);
        project.getTasks().withType(Test.class, test -> {
            test.getReports().getJunitXml().getRequired().set((Object)true);
            test.getReports().getJunitXml().setDestination(JunitReportsPlugin.junitPath(rootExt.getReportsDirectory(), test.getPath()));
        });
        project.getTasks().withType(Checkstyle.class, checkstyle -> ext.registerTask(checkstyle.getName(), XmlReportFailuresSupplier.create(checkstyle, new CheckstyleReportHandler())));
        project.getTasks().withType(JavaCompile.class, javac -> ext.registerTask(javac.getName(), JavacFailuresSupplier.create(javac)));
        ext.getTaskEntries().configureEach(entry -> JunitReportsFinalizer.registerFinalizer(project, entry.name(), rootExt.getTaskTimer(), entry.failuresSupplier(), (Provider<Directory>)rootExt.getReportsDirectory()));
    }

    private static Provider<File> junitPath(DirectoryProperty basePath, String testPath) {
        return basePath.map(dir -> dir.dir("junit")).map(dir -> dir.file(String.join((CharSequence)File.separator, Splitter.on((char)':').splitToList((CharSequence)testPath.substring(1))))).map(RegularFile::getAsFile);
    }
}

