/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.Failure;
import com.palantir.gradle.junit.FailuresReportGenerator;
import com.palantir.gradle.junit.FailuresSupplier;
import com.palantir.gradle.junit.JunitReportCreator;
import com.palantir.gradle.junit.TaskTimer;
import com.palantir.gradle.junit.XmlUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GUtil;
import org.w3c.dom.Document;

public abstract class JunitReportsFinalizer
extends DefaultTask {
    private FailuresSupplier failuresSupplier;

    public static void registerFinalizer(Project project, String taskName, TaskTimer taskTimer, FailuresSupplier failuresSupplier, Provider<Directory> reportDir) {
        TaskProvider wrappedTask = project.getTasks().named(taskName);
        TaskProvider finalizer = project.getTasks().register(GUtil.toLowerCamelCase((CharSequence)(taskName + " junitReportsFinalizer")), JunitReportsFinalizer.class, task -> {
            task.getWrappedDidWork().set(project.provider(() -> ((Task)wrappedTask.get()).getDidWork()));
            task.getWrappedTaskName().set((Object)taskName);
            task.getDurationNanos().set(project.provider(() -> taskTimer.getTaskTimeNanos((Task)wrappedTask.get())));
            task.setFailuresSupplier(failuresSupplier);
            task.getTargetFile().set(reportDir.map(dir -> dir.file(project.getName() + "-" + taskName + ".xml")));
            task.getReportDir().set(reportDir);
        });
        wrappedTask.configure(task -> task.finalizedBy(new Object[]{finalizer}));
    }

    @Input
    public abstract Property<Boolean> getWrappedDidWork();

    @Input
    abstract Property<String> getWrappedTaskName();

    @Internal
    public final FailuresSupplier getFailuresSupplier() {
        return this.failuresSupplier;
    }

    public final void setFailuresSupplier(FailuresSupplier failuresSupplier) {
        this.failuresSupplier = failuresSupplier;
    }

    @Internal
    public abstract Property<Long> getDurationNanos();

    @OutputFile
    public abstract RegularFileProperty getTargetFile();

    @Internal
    public abstract DirectoryProperty getReportDir();

    @TaskAction
    public final void createCircleReport() throws IOException, TransformerException {
        if (!((Boolean)this.getWrappedDidWork().get()).booleanValue()) {
            this.setDidWork(false);
            return;
        }
        try {
            File rootDir = this.getProject().getRootProject().getProjectDir();
            String projectName = this.getProject().getName();
            List<Failure> failures = this.failuresSupplier.getFailures();
            long taskTimeNanos = (Long)this.getDurationNanos().get();
            Document report = JunitReportCreator.reportToXml(FailuresReportGenerator.failuresReport(rootDir, projectName, (String)this.getWrappedTaskName().get(), taskTimeNanos, failures));
            File target = (File)this.getTargetFile().getAsFile().get();
            Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(target.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                XmlUtils.write(writer, report);
            }
        }
        catch (RuntimeException e) {
            RuntimeException modified;
            try {
                modified = this.failuresSupplier.handleInternalFailure(((File)this.getReportDir().getAsFile().get()).toPath(), e);
            }
            catch (RuntimeException x) {
                e.addSuppressed(x);
                throw e;
            }
            throw modified;
        }
    }
}

