/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.DefaultTaskTimer;
import com.palantir.gradle.junit.TaskTimer;
import java.util.function.Predicate;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;

public class JunitReportsExtension {
    private static final String EXT_JUNIT_REPORTS = "junitReports";
    private final DirectoryProperty reportsDirectory;
    private final TaskTimer taskTimer;

    static JunitReportsExtension register(Project project, Predicate<Task> isTaskRegistered) {
        DefaultTaskTimer timer = new DefaultTaskTimer(isTaskRegistered);
        project.getGradle().addListener((Object)timer);
        return (JunitReportsExtension)project.getExtensions().create(EXT_JUNIT_REPORTS, JunitReportsExtension.class, new Object[]{project, timer});
    }

    public JunitReportsExtension(Project project, TaskTimer taskTimer) {
        this.reportsDirectory = project.getObjects().directoryProperty().value(project.getLayout().getBuildDirectory().dir("junit-reports"));
        this.taskTimer = taskTimer;
    }

    public final DirectoryProperty getReportsDirectory() {
        return this.reportsDirectory;
    }

    public final TaskTimer getTaskTimer() {
        return this.taskTimer;
    }
}

