/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.base.Splitter;
import com.palantir.gradle.junit.Failure;
import com.palantir.gradle.junit.FailuresSupplier;
import com.palantir.gradle.junit.ImmutableFailure;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.tasks.compile.JavaCompile;

public final class JavacFailuresSupplier
implements FailuresSupplier {
    private static final Pattern ERROR_LINE = Pattern.compile("([^ ].*):(\\d+): error: (.*)");
    private final StringBuilder errorStream;

    public static JavacFailuresSupplier create(JavaCompile javac) {
        StringBuilder errorStream = new StringBuilder();
        javac.getLogging().addStandardErrorListener(errorStream::append);
        return new JavacFailuresSupplier(errorStream);
    }

    JavacFailuresSupplier(StringBuilder errorStream) {
        this.errorStream = errorStream;
    }

    @Override
    public List<Failure> getFailures() {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        ImmutableFailure.Builder failureBuilder = null;
        StringBuilder details = null;
        for (String line : Splitter.on((String)"\n").split((CharSequence)this.errorStream.toString())) {
            Matcher matcher;
            if (failureBuilder != null) {
                if (line.startsWith(" ")) {
                    details.append("\n").append(line);
                    continue;
                }
                failures.add(failureBuilder.details(details.toString()).build());
                failureBuilder = null;
                details = null;
            }
            if (!(matcher = ERROR_LINE.matcher(line)).matches()) continue;
            failureBuilder = Failure.builder().file(new File(matcher.group(1))).line(Integer.parseInt(matcher.group(2))).severity("ERROR").message(matcher.group(3));
            details = new StringBuilder();
        }
        if (failureBuilder != null) {
            failures.add(failureBuilder.details(details.toString()).build());
        }
        return failures;
    }

    @Override
    public RuntimeException handleInternalFailure(Path reportDir, RuntimeException ex) {
        return ex;
    }
}

