/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableSet;
import com.palantir.baseline.plugins.BaselineExactDependencies;
import com.palantir.baseline.tasks.CheckJUnitDependencies;
import com.palantir.baseline.tasks.CheckUnusedDependenciesTask;
import java.util.Objects;
import java.util.Optional;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaselineTesting
implements Plugin<Project> {
    private static final Logger log = LoggerFactory.getLogger(BaselineTesting.class);

    public void apply(Project project) {
        project.getTasks().withType(Test.class).configureEach(task -> {
            task.jvmArgs(new Object[]{"-XX:+HeapDumpOnOutOfMemoryError", "-XX:+CrashOnOutOfMemoryError"});
            if (!Objects.equals("true", project.findProperty("com.palantir.baseline.restore-test-cache"))) {
                task.getOutputs().cacheIf(t -> false);
            }
            boolean shouldRecreate = Boolean.getBoolean("recreate");
            task.systemProperty("recreate", (Object)Boolean.toString(shouldRecreate));
            if (shouldRecreate) {
                task.getOutputs().upToDateWhen(t -> false);
            }
        });
        project.getPlugins().withType(JavaPlugin.class, unusedPlugin -> {
            project.afterEvaluate(proj -> ((JavaPluginConvention)proj.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().matching(ss -> BaselineTesting.hasCompileDependenciesMatching(proj, ss, (Spec<Dependency>)((Spec)BaselineTesting::isJunitJupiter))).forEach(ss -> {
                Optional<Test> maybeTestTask = BaselineTesting.getTestTaskForSourceSet(proj, ss);
                if (!maybeTestTask.isPresent()) {
                    log.warn("Detected 'org:junit.jupiter:junit-jupiter', but unable to find test task");
                    return;
                }
                log.info("Detected 'org:junit.jupiter:junit-jupiter', enabling useJUnitPlatform() on {}", (Object)maybeTestTask.get().getName());
                BaselineTesting.enableJunit5ForTestTask(maybeTestTask.get());
                project.getPlugins().withType(BaselineExactDependencies.class, exactDeps -> {
                    TaskContainer tasks = project.getTasks();
                    tasks.named(BaselineExactDependencies.checkUnusedDependenciesNameForSourceSet(ss), CheckUnusedDependenciesTask.class, task -> task.ignore("org.junit.jupiter", "junit-jupiter"));
                });
            }));
            TaskProvider task = project.getTasks().register("checkJUnitDependencies", CheckJUnitDependencies.class);
            ((Task)project.getTasks().findByName("test")).dependsOn(new Object[]{task});
        });
    }

    public static Optional<Test> getTestTaskForSourceSet(Project proj, SourceSet ss) {
        String testTaskName = ss.getTaskName(null, "test");
        Task task1 = (Task)proj.getTasks().findByName(testTaskName);
        if (task1 instanceof Test) {
            return Optional.of((Test)task1);
        }
        Task task2 = (Task)proj.getTasks().findByName(ss.getName());
        if (task2 instanceof Test) {
            return Optional.of((Test)task2);
        }
        return Optional.empty();
    }

    private static boolean hasCompileDependenciesMatching(Project project, SourceSet sourceSet, Spec<Dependency> spec) {
        return project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()).getAllDependencies().matching(spec).stream().findAny().isPresent();
    }

    private static boolean isJunitJupiter(Dependency dep) {
        return Objects.equals(dep.getGroup(), "org.junit.jupiter") && dep.getName().equals("junit-jupiter");
    }

    private static void enableJunit5ForTestTask(Test task) {
        if (!BaselineTesting.useJUnitPlatformEnabled(task)) {
            task.useJUnitPlatform();
        }
        task.systemProperty("junit.platform.output.capture.stdout", (Object)"true");
        task.systemProperty("junit.platform.output.capture.stderr", (Object)"true");
        task.systemProperty("junit.jupiter.execution.parallel.enabled", (Object)"true");
        task.systemProperty("junit.jupiter.execution.parallel.config.strategy", (Object)"dynamic");
        task.getTestLogging().getEvents().add(TestLogEvent.FAILED);
        if (!task.getName().equals("test") && "true".equals(System.getenv("CI"))) {
            task.getTestLogging().getEvents().addAll(ImmutableSet.of((Object)TestLogEvent.STARTED, (Object)TestLogEvent.PASSED, (Object)TestLogEvent.SKIPPED));
        }
    }

    public static boolean useJUnitPlatformEnabled(Test task) {
        return task.getOptions() instanceof JUnitPlatformOptions;
    }
}

