/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.palantir.baseline.tasks.CheckExplicitSourceCompatibilityTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public final class BaselineReproducibility
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().withType(AbstractArchiveTask.class).configureEach(t -> {
            t.setPreserveFileTimestamps(false);
            t.setReproducibleFileOrder(true);
            t.setDuplicatesStrategy(DuplicatesStrategy.WARN);
        });
        project.getPluginManager().withPlugin("nebula.info", plugin -> project.getLogger().warn("Please remove the 'nebula.info' plugin from {} as it breaks reproducibility of jars by adding a 'Build-Date' entry to the MANIFEST.MF", (Object)project));
        project.getPlugins().withType(JavaBasePlugin.class, _plugin -> {
            TaskProvider checkExplicitSourceCompatibility = project.getTasks().register("checkExplicitSourceCompatibility", CheckExplicitSourceCompatibilityTask.class);
            project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{checkExplicitSourceCompatibility}));
        });
    }
}

