/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.palantir.gradle.junit.JunitReportsExtension;
import com.palantir.gradle.junit.JunitReportsRootPlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.testing.Test;

public final class BaselineCircleCi
implements Plugin<Project> {
    private static final FileAttribute<Set<PosixFilePermission>> PERMS_ATTRIBUTE = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));

    public void apply(Project project) {
        project.getPluginManager().apply(JunitReportsRootPlugin.class);
        this.configurePluginsForReports(project);
        this.configurePluginsForArtifacts(project);
        Preconditions.checkState((!project.getName().equals("project") ? 1 : 0) != 0, (Object)"Please specify rootProject.name in your settings.gradle, otherwise CircleCI'scheckout dir ('project') will be used instead.");
    }

    private void configurePluginsForArtifacts(Project project) {
        String circleArtifactsDir = System.getenv("CIRCLE_ARTIFACTS");
        if (circleArtifactsDir == null) {
            project.getLogger().info("$CIRCLE_ARTIFACTS variable is not set, not configuring junit/profiling reports");
            return;
        }
        try {
            Files.createDirectories(Paths.get(circleArtifactsDir, new String[0]), PERMS_ATTRIBUTE);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create CIRCLE_ARTIFACTS directory", e);
        }
        project.getRootProject().allprojects(proj -> proj.getTasks().withType(Test.class, test -> {
            test.getReports().getHtml().setEnabled(true);
            test.getReports().getHtml().setDestination(BaselineCircleCi.junitPath(circleArtifactsDir, test.getPath()));
        }));
    }

    private void configurePluginsForReports(Project project) {
        String circleReportsDir = System.getenv("CIRCLE_TEST_REPORTS");
        if (circleReportsDir == null) {
            return;
        }
        try {
            Files.createDirectories(Paths.get(circleReportsDir, new String[0]), PERMS_ATTRIBUTE);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create CIRCLE_TEST_REPORTS directory", e);
        }
        project.getExtensions().configure(JunitReportsExtension.class, junitReports -> junitReports.getReportsDirectory().set(new File(circleReportsDir)));
    }

    private static File junitPath(String basePath, String testPath) {
        Path junitReportsDir = Paths.get(basePath, "junit");
        for (String component : Splitter.on((String)":").split((CharSequence)testPath.substring(1))) {
            junitReportsDir = junitReportsDir.resolve(component);
        }
        return junitReportsDir.toFile();
    }
}

