/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.palantir.baseline.plugins.BaselineExactDependencies;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class CheckImplicitDependenciesTask
extends DefaultTask {
    private final ListProperty<Configuration> dependenciesConfigurations;
    private final Property<FileCollection> sourceClasses;
    private final SetProperty<String> ignore;

    public CheckImplicitDependenciesTask() {
        this.setGroup("Verification");
        this.setDescription("Ensures all dependencies are explicitly declared, not just transitively provided");
        this.dependenciesConfigurations = this.getProject().getObjects().listProperty(Configuration.class);
        this.dependenciesConfigurations.set(Collections.emptyList());
        this.sourceClasses = this.getProject().getObjects().property(FileCollection.class);
        this.ignore = this.getProject().getObjects().setProperty(String.class);
        this.ignore.set(Collections.emptySet());
    }

    @TaskAction
    public final void checkImplicitDependencies() {
        Set<ResolvedDependency> declaredDependencies = ((List)this.dependenciesConfigurations.get()).stream().map(Configuration::getResolvedConfiguration).flatMap(resolved -> resolved.getFirstLevelModuleDependencies().stream()).collect(Collectors.toSet());
        BaselineExactDependencies.INDEXES.populateIndexes(declaredDependencies);
        Set necessaryArtifacts = this.referencedClasses().stream().map(BaselineExactDependencies.INDEXES::classToDependency).filter(Optional::isPresent).map(Optional::get).filter(x -> !this.isArtifactFromCurrentProject((ResolvedArtifact)x)).collect(Collectors.toSet());
        Set declaredArtifacts = declaredDependencies.stream().flatMap(dependency -> dependency.getModuleArtifacts().stream()).collect(Collectors.toSet());
        List usedButUndeclared = Sets.difference(necessaryArtifacts, declaredArtifacts).stream().sorted(Comparator.comparing(artifact -> artifact.getId().getDisplayName())).filter(artifact -> !this.shouldIgnore((ResolvedArtifact)artifact)).collect(Collectors.toList());
        if (!usedButUndeclared.isEmpty()) {
            String suggestion = usedButUndeclared.stream().map(artifact -> this.getSuggestionString((ResolvedArtifact)artifact)).sorted().collect(Collectors.joining("\n", "    dependencies {\n", "\n    }"));
            throw new GradleException(String.format("Found %d implicit dependencies - consider adding the following explicit dependencies to '%s', or avoid using classes from these jars:\n%s", usedButUndeclared.size(), this.buildFile(), suggestion));
        }
    }

    private String getSuggestionString(ResolvedArtifact artifact) {
        String artifactNameString = this.isProjectArtifact(artifact) ? String.format("project('%s')", ((ProjectComponentIdentifier)artifact.getId().getComponentIdentifier()).getProjectPath()) : String.format("'%s:%s'", artifact.getModuleVersion().getId().getGroup(), artifact.getModuleVersion().getId().getName());
        return String.format("        %s", artifactNameString);
    }

    private boolean isProjectArtifact(ResolvedArtifact artifact) {
        return artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier;
    }

    private boolean isArtifactFromCurrentProject(ResolvedArtifact artifact) {
        if (!this.isProjectArtifact(artifact)) {
            return false;
        }
        return ((ProjectComponentIdentifier)artifact.getId().getComponentIdentifier()).getProjectPath().equals(this.getProject().getPath());
    }

    private Set<String> referencedClasses() {
        return Streams.stream((Iterator)((FileCollection)this.sourceClasses.get()).iterator()).flatMap(BaselineExactDependencies::referencedClasses).collect(Collectors.toSet());
    }

    private Path buildFile() {
        return this.getProject().getRootDir().toPath().relativize(this.getProject().getBuildFile().toPath());
    }

    private boolean shouldIgnore(ResolvedArtifact artifact) {
        return ((Set)this.ignore.get()).contains(BaselineExactDependencies.asString(artifact));
    }

    @Classpath
    public final Provider<List<Configuration>> getDependenciesConfigurations() {
        return this.dependenciesConfigurations;
    }

    public final void dependenciesConfiguration(Configuration dependenciesConfiguration) {
        this.dependenciesConfigurations.add((Object)Objects.requireNonNull(dependenciesConfiguration));
    }

    @Classpath
    public final Provider<FileCollection> getSourceClasses() {
        return this.sourceClasses;
    }

    public final void setSourceClasses(FileCollection newClasses) {
        this.sourceClasses.set((Object)this.getProject().files(new Object[]{newClasses}));
    }

    public final void ignore(Provider<Set<String>> value) {
        this.ignore.set(value);
    }

    public final void ignore(String group, String name) {
        this.ignore.add((Object)BaselineExactDependencies.ignoreCoordinate(group, name));
    }

    @Input
    public final Provider<Set<String>> getIgnored() {
        return this.ignore;
    }
}

